/*
 * Decompiled with CFR 0.152.
 */
package androidx.activity;

import android.app.Activity;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleOwner;
import java.lang.reflect.Field;

@RequiresApi(value=19)
final class ImmLeaksCleaner
implements LifecycleEventObserver {
    private static final int NOT_INITIALIAZED = 0;
    private static final int INIT_SUCCESS = 1;
    private static final int INIT_FAILED = 2;
    private static int sReflectedFieldsInitialized = 0;
    private static Field sHField;
    private static Field sServedViewField;
    private static Field sNextServedViewField;
    private Activity mActivity;

    ImmLeaksCleaner(Activity activity) {
        this.mActivity = activity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStateChanged(@NonNull LifecycleOwner source, @NonNull Lifecycle.Event event) {
        if (event != Lifecycle.Event.ON_DESTROY) {
            return;
        }
        if (sReflectedFieldsInitialized == 0) {
            ImmLeaksCleaner.initializeReflectiveFields();
        }
        if (sReflectedFieldsInitialized == 1) {
            Object lock;
            InputMethodManager inputMethodManager = (InputMethodManager)this.mActivity.getSystemService("input_method");
            try {
                lock = sHField.get(inputMethodManager);
            }
            catch (IllegalAccessException e) {
                return;
            }
            if (lock == null) {
                return;
            }
            Object object = lock;
            synchronized (object) {
                View servedView;
                try {
                    servedView = (View)sServedViewField.get(inputMethodManager);
                }
                catch (IllegalAccessException e) {
                    return;
                }
                catch (ClassCastException e) {
                    return;
                }
                if (servedView == null) {
                    return;
                }
                if (servedView.isAttachedToWindow()) {
                    return;
                }
                try {
                    sNextServedViewField.set(inputMethodManager, null);
                }
                catch (IllegalAccessException e) {
                    return;
                }
            }
            inputMethodManager.isActive();
        }
    }

    @MainThread
    private static void initializeReflectiveFields() {
        try {
            sReflectedFieldsInitialized = 2;
            sServedViewField = InputMethodManager.class.getDeclaredField("mServedView");
            sServedViewField.setAccessible(true);
            sNextServedViewField = InputMethodManager.class.getDeclaredField("mNextServedView");
            sNextServedViewField.setAccessible(true);
            sHField = InputMethodManager.class.getDeclaredField("mH");
            sHField.setAccessible(true);
            sReflectedFieldsInitialized = 1;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }
}

