/*
 * Decompiled with CFR 0.152.
 */
package androidx.fragment.app;

import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentState;
import androidx.fragment.app.FragmentStateManager;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

class FragmentStore {
    private static final String TAG = "FragmentManager";
    private final ArrayList<Fragment> mAdded = new ArrayList();
    private final HashMap<String, FragmentStateManager> mActive = new HashMap();

    FragmentStore() {
    }

    void resetActiveFragments() {
        this.mActive.clear();
    }

    void restoreAddedFragments(@Nullable List<String> added) {
        this.mAdded.clear();
        if (added != null) {
            for (String who : added) {
                Fragment f = this.findActiveFragment(who);
                if (f == null) {
                    throw new IllegalStateException("No instantiated fragment for (" + who + ")");
                }
                if (FragmentManager.isLoggingEnabled(2)) {
                    Log.v((String)TAG, (String)("restoreSaveState: added (" + who + "): " + f));
                }
                this.addFragment(f);
            }
        }
    }

    void makeActive(@NonNull FragmentStateManager newlyActive) {
        this.mActive.put(newlyActive.getFragment().mWho, newlyActive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFragment(@NonNull Fragment fragment) {
        if (this.mAdded.contains(fragment)) {
            throw new IllegalStateException("Fragment already added: " + fragment);
        }
        ArrayList<Fragment> arrayList = this.mAdded;
        synchronized (arrayList) {
            this.mAdded.add(fragment);
        }
        fragment.mAdded = true;
    }

    void dispatchStateChange(int state) {
        for (Fragment f : this.mAdded) {
            FragmentStateManager fragmentStateManager = this.mActive.get(f.mWho);
            if (fragmentStateManager == null) continue;
            fragmentStateManager.setFragmentManagerState(state);
        }
        for (FragmentStateManager fragmentStateManager : this.mActive.values()) {
            if (fragmentStateManager == null) continue;
            fragmentStateManager.setFragmentManagerState(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFragment(@NonNull Fragment fragment) {
        ArrayList<Fragment> arrayList = this.mAdded;
        synchronized (arrayList) {
            this.mAdded.remove(fragment);
        }
        fragment.mAdded = false;
    }

    void makeInactive(@NonNull FragmentStateManager newlyInactive) {
        Fragment f = newlyInactive.getFragment();
        for (FragmentStateManager fragmentStateManager : this.mActive.values()) {
            if (fragmentStateManager == null) continue;
            Fragment fragment = fragmentStateManager.getFragment();
            if (!f.mWho.equals(fragment.mTargetWho)) continue;
            fragment.mTarget = f;
            fragment.mTargetWho = null;
        }
        this.mActive.put(f.mWho, null);
        if (f.mTargetWho != null) {
            f.mTarget = this.findActiveFragment(f.mTargetWho);
        }
    }

    void burpActive() {
        Collection<FragmentStateManager> values = this.mActive.values();
        values.removeAll(Collections.singleton(null));
    }

    @NonNull
    ArrayList<FragmentState> saveActiveFragments() {
        ArrayList<FragmentState> active = new ArrayList<FragmentState>(this.mActive.size());
        for (FragmentStateManager fragmentStateManager : this.mActive.values()) {
            if (fragmentStateManager == null) continue;
            Fragment f = fragmentStateManager.getFragment();
            FragmentState fs = fragmentStateManager.saveState();
            active.add(fs);
            if (!FragmentManager.isLoggingEnabled(2)) continue;
            Log.v((String)TAG, (String)("Saved state of " + f + ": " + fs.mSavedFragmentState));
        }
        return active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    ArrayList<String> saveAddedFragments() {
        ArrayList<Fragment> arrayList = this.mAdded;
        synchronized (arrayList) {
            if (this.mAdded.isEmpty()) {
                return null;
            }
            ArrayList<String> added = new ArrayList<String>(this.mAdded.size());
            for (Fragment f : this.mAdded) {
                added.add(f.mWho);
                if (!FragmentManager.isLoggingEnabled(2)) continue;
                Log.v((String)TAG, (String)("saveAllState: adding fragment (" + f.mWho + "): " + f));
            }
            return added;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    List<Fragment> getFragments() {
        if (this.mAdded.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Fragment> arrayList = this.mAdded;
        synchronized (arrayList) {
            return new ArrayList<Fragment>(this.mAdded);
        }
    }

    @NonNull
    List<Fragment> getActiveFragments() {
        ArrayList<Fragment> activeFragments = new ArrayList<Fragment>();
        for (FragmentStateManager fragmentStateManager : this.mActive.values()) {
            if (fragmentStateManager != null) {
                activeFragments.add(fragmentStateManager.getFragment());
                continue;
            }
            activeFragments.add(null);
        }
        return activeFragments;
    }

    int getActiveFragmentCount() {
        return this.mActive.size();
    }

    @Nullable
    Fragment findFragmentById(@IdRes int id2) {
        for (int i = this.mAdded.size() - 1; i >= 0; --i) {
            Fragment f = this.mAdded.get(i);
            if (f == null || f.mFragmentId != id2) continue;
            return f;
        }
        for (FragmentStateManager fragmentStateManager : this.mActive.values()) {
            if (fragmentStateManager == null) continue;
            Fragment f = fragmentStateManager.getFragment();
            if (f.mFragmentId != id2) continue;
            return f;
        }
        return null;
    }

    @Nullable
    Fragment findFragmentByTag(@Nullable String tag) {
        if (tag != null) {
            for (int i = this.mAdded.size() - 1; i >= 0; --i) {
                Fragment f = this.mAdded.get(i);
                if (f == null || !tag.equals(f.mTag)) continue;
                return f;
            }
        }
        if (tag != null) {
            for (FragmentStateManager fragmentStateManager : this.mActive.values()) {
                if (fragmentStateManager == null) continue;
                Fragment f = fragmentStateManager.getFragment();
                if (!tag.equals(f.mTag)) continue;
                return f;
            }
        }
        return null;
    }

    boolean containsActiveFragment(@NonNull String who) {
        return this.mActive.containsKey(who);
    }

    @Nullable
    FragmentStateManager getFragmentStateManager(@NonNull String who) {
        return this.mActive.get(who);
    }

    @Nullable
    Fragment findFragmentByWho(@NonNull String who) {
        for (FragmentStateManager fragmentStateManager : this.mActive.values()) {
            if (fragmentStateManager == null) continue;
            Fragment f = fragmentStateManager.getFragment();
            if ((f = f.findFragmentByWho(who)) == null) continue;
            return f;
        }
        return null;
    }

    @Nullable
    Fragment findActiveFragment(@NonNull String who) {
        FragmentStateManager fragmentStateManager = this.mActive.get(who);
        if (fragmentStateManager != null) {
            return fragmentStateManager.getFragment();
        }
        return null;
    }

    Fragment findFragmentUnder(@NonNull Fragment f) {
        ViewGroup container = f.mContainer;
        View view = f.mView;
        if (container == null || view == null) {
            return null;
        }
        int fragmentIndex = this.mAdded.indexOf(f);
        for (int i = fragmentIndex - 1; i >= 0; --i) {
            Fragment underFragment = this.mAdded.get(i);
            if (underFragment.mContainer != container || underFragment.mView == null) continue;
            return underFragment;
        }
        return null;
    }

    void dump(@NonNull String prefix, @Nullable FileDescriptor fd, @NonNull PrintWriter writer, @Nullable String[] args) {
        int count;
        Fragment f;
        String innerPrefix = prefix + "    ";
        if (!this.mActive.isEmpty()) {
            writer.print(prefix);
            writer.print("Active Fragments:");
            for (FragmentStateManager fragmentStateManager : this.mActive.values()) {
                writer.print(prefix);
                if (fragmentStateManager != null) {
                    f = fragmentStateManager.getFragment();
                    writer.println(f);
                    f.dump(innerPrefix, fd, writer, args);
                    continue;
                }
                writer.println("null");
            }
        }
        if ((count = this.mAdded.size()) > 0) {
            writer.print(prefix);
            writer.println("Added Fragments:");
            for (int i = 0; i < count; ++i) {
                f = this.mAdded.get(i);
                writer.print(prefix);
                writer.print("  #");
                writer.print(i);
                writer.print(": ");
                writer.println(f.toString());
            }
        }
    }
}

