/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.appcompat.R;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.appcompat.widget.AppCompatDrawableManager;
import androidx.appcompat.widget.DrawableUtils;
import androidx.appcompat.widget.TintInfo;
import androidx.appcompat.widget.TintTypedArray;
import androidx.core.view.ViewCompat;
import androidx.core.widget.ImageViewCompat;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public class AppCompatImageHelper {
    @NonNull
    private final ImageView mView;
    private TintInfo mInternalImageTint;
    private TintInfo mImageTint;
    private TintInfo mTmpInfo;

    public AppCompatImageHelper(@NonNull ImageView view) {
        this.mView = view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromAttributes(AttributeSet attrs, int defStyleAttr) {
        TintTypedArray a = TintTypedArray.obtainStyledAttributes(this.mView.getContext(), attrs, R.styleable.AppCompatImageView, defStyleAttr, 0);
        ViewCompat.saveAttributeDataForStyleable((View)this.mView, (Context)this.mView.getContext(), (int[])R.styleable.AppCompatImageView, (AttributeSet)attrs, (TypedArray)a.getWrappedTypeArray(), (int)defStyleAttr, (int)0);
        try {
            int id2;
            Drawable drawable = this.mView.getDrawable();
            if (drawable == null && (id2 = a.getResourceId(R.styleable.AppCompatImageView_srcCompat, -1)) != -1 && (drawable = AppCompatResources.getDrawable((Context)this.mView.getContext(), (int)id2)) != null) {
                this.mView.setImageDrawable(drawable);
            }
            if (drawable != null) {
                DrawableUtils.fixDrawable((Drawable)drawable);
            }
            if (a.hasValue(R.styleable.AppCompatImageView_tint)) {
                ImageViewCompat.setImageTintList((ImageView)this.mView, (ColorStateList)a.getColorStateList(R.styleable.AppCompatImageView_tint));
            }
            if (a.hasValue(R.styleable.AppCompatImageView_tintMode)) {
                ImageViewCompat.setImageTintMode((ImageView)this.mView, (PorterDuff.Mode)DrawableUtils.parseTintMode((int)a.getInt(R.styleable.AppCompatImageView_tintMode, -1), null));
            }
        }
        finally {
            a.recycle();
        }
    }

    public void setImageResource(int resId) {
        if (resId != 0) {
            Drawable d = AppCompatResources.getDrawable((Context)this.mView.getContext(), (int)resId);
            if (d != null) {
                DrawableUtils.fixDrawable((Drawable)d);
            }
            this.mView.setImageDrawable(d);
        } else {
            this.mView.setImageDrawable(null);
        }
        this.applySupportImageTint();
    }

    boolean hasOverlappingRendering() {
        Drawable background = this.mView.getBackground();
        return Build.VERSION.SDK_INT < 21 || !(background instanceof RippleDrawable);
    }

    void setSupportImageTintList(ColorStateList tint) {
        if (this.mImageTint == null) {
            this.mImageTint = new TintInfo();
        }
        this.mImageTint.mTintList = tint;
        this.mImageTint.mHasTintList = true;
        this.applySupportImageTint();
    }

    ColorStateList getSupportImageTintList() {
        return this.mImageTint != null ? this.mImageTint.mTintList : null;
    }

    void setSupportImageTintMode(PorterDuff.Mode tintMode) {
        if (this.mImageTint == null) {
            this.mImageTint = new TintInfo();
        }
        this.mImageTint.mTintMode = tintMode;
        this.mImageTint.mHasTintMode = true;
        this.applySupportImageTint();
    }

    PorterDuff.Mode getSupportImageTintMode() {
        return this.mImageTint != null ? this.mImageTint.mTintMode : null;
    }

    void applySupportImageTint() {
        Drawable imageViewDrawable = this.mView.getDrawable();
        if (imageViewDrawable != null) {
            DrawableUtils.fixDrawable((Drawable)imageViewDrawable);
        }
        if (imageViewDrawable != null) {
            if (this.shouldApplyFrameworkTintUsingColorFilter() && this.applyFrameworkTintUsingColorFilter(imageViewDrawable)) {
                return;
            }
            if (this.mImageTint != null) {
                AppCompatDrawableManager.tintDrawable(imageViewDrawable, this.mImageTint, this.mView.getDrawableState());
            } else if (this.mInternalImageTint != null) {
                AppCompatDrawableManager.tintDrawable(imageViewDrawable, this.mInternalImageTint, this.mView.getDrawableState());
            }
        }
    }

    void setInternalImageTint(ColorStateList tint) {
        if (tint != null) {
            if (this.mInternalImageTint == null) {
                this.mInternalImageTint = new TintInfo();
            }
            this.mInternalImageTint.mTintList = tint;
            this.mInternalImageTint.mHasTintList = true;
        } else {
            this.mInternalImageTint = null;
        }
        this.applySupportImageTint();
    }

    private boolean shouldApplyFrameworkTintUsingColorFilter() {
        int sdk = Build.VERSION.SDK_INT;
        if (sdk > 21) {
            return this.mInternalImageTint != null;
        }
        return sdk == 21;
    }

    private boolean applyFrameworkTintUsingColorFilter(@NonNull Drawable imageSource) {
        PorterDuff.Mode mode;
        if (this.mTmpInfo == null) {
            this.mTmpInfo = new TintInfo();
        }
        TintInfo info = this.mTmpInfo;
        info.clear();
        ColorStateList tintList = ImageViewCompat.getImageTintList((ImageView)this.mView);
        if (tintList != null) {
            info.mHasTintList = true;
            info.mTintList = tintList;
        }
        if ((mode = ImageViewCompat.getImageTintMode((ImageView)this.mView)) != null) {
            info.mHasTintMode = true;
            info.mTintMode = mode;
        }
        if (info.mHasTintList || info.mHasTintMode) {
            AppCompatDrawableManager.tintDrawable(imageSource, info, this.mView.getDrawableState());
            return true;
        }
        return false;
    }
}

