/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.bottomappbar;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Dimension;
import androidx.annotation.MenuRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.appcompat.widget.ActionMenuView;
import androidx.appcompat.widget.Toolbar;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.customview.view.AbsSavedState;
import com.google.android.material.R;
import com.google.android.material.animation.TransformationCallback;
import com.google.android.material.behavior.HideBottomViewOnScrollBehavior;
import com.google.android.material.bottomappbar.BottomAppBarTopEdgeTreatment;
import com.google.android.material.floatingactionbutton.ExtendedFloatingActionButton;
import com.google.android.material.floatingactionbutton.FloatingActionButton;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.internal.ViewUtils;
import com.google.android.material.resources.MaterialResources;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.MaterialShapeUtils;
import com.google.android.material.shape.ShapeAppearanceModel;
import com.google.android.material.theme.overlay.MaterialThemeOverlay;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class BottomAppBar
extends Toolbar
implements CoordinatorLayout.AttachedBehavior {
    private static final int DEF_STYLE_RES = R.style.Widget_MaterialComponents_BottomAppBar;
    private static final long ANIMATION_DURATION = 300L;
    public static final int FAB_ALIGNMENT_MODE_CENTER = 0;
    public static final int FAB_ALIGNMENT_MODE_END = 1;
    public static final int FAB_ANIMATION_MODE_SCALE = 0;
    public static final int FAB_ANIMATION_MODE_SLIDE = 1;
    private final int fabOffsetEndMode;
    private final MaterialShapeDrawable materialShapeDrawable = new MaterialShapeDrawable();
    @Nullable
    private Animator modeAnimator;
    @Nullable
    private Animator menuAnimator;
    private int fabAlignmentMode;
    private int fabAnimationMode;
    private boolean hideOnScroll;
    private final boolean paddingBottomSystemWindowInsets;
    private final boolean paddingLeftSystemWindowInsets;
    private final boolean paddingRightSystemWindowInsets;
    private int animatingModeChangeCounter = 0;
    private ArrayList<AnimationListener> animationListeners;
    private boolean fabAttached = true;
    private Behavior behavior;
    private int bottomInset;
    private int rightInset;
    private int leftInset;
    @NonNull
    AnimatorListenerAdapter fabAnimationListener = new AnimatorListenerAdapter(){

        public void onAnimationStart(Animator animation) {
            BottomAppBar.this.maybeAnimateMenuView(BottomAppBar.this.fabAlignmentMode, BottomAppBar.this.fabAttached);
        }
    };
    @NonNull
    TransformationCallback<FloatingActionButton> fabTransformationCallback = new TransformationCallback<FloatingActionButton>(){

        @Override
        public void onScaleChanged(@NonNull FloatingActionButton fab) {
            BottomAppBar.this.materialShapeDrawable.setInterpolation(fab.getVisibility() == 0 ? fab.getScaleY() : 0.0f);
        }

        @Override
        public void onTranslationChanged(@NonNull FloatingActionButton fab) {
            float horizontalOffset = fab.getTranslationX();
            if (BottomAppBar.this.getTopEdgeTreatment().getHorizontalOffset() != horizontalOffset) {
                BottomAppBar.this.getTopEdgeTreatment().setHorizontalOffset(horizontalOffset);
                BottomAppBar.this.materialShapeDrawable.invalidateSelf();
            }
            float verticalOffset = Math.max(0.0f, -fab.getTranslationY());
            if (BottomAppBar.this.getTopEdgeTreatment().getCradleVerticalOffset() != verticalOffset) {
                BottomAppBar.this.getTopEdgeTreatment().setCradleVerticalOffset(verticalOffset);
                BottomAppBar.this.materialShapeDrawable.invalidateSelf();
            }
            BottomAppBar.this.materialShapeDrawable.setInterpolation(fab.getVisibility() == 0 ? fab.getScaleY() : 0.0f);
        }
    };

    public BottomAppBar(@NonNull Context context) {
        this(context, null, 0);
    }

    public BottomAppBar(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.bottomAppBarStyle);
    }

    public BottomAppBar(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(MaterialThemeOverlay.wrap(context, attrs, defStyleAttr, DEF_STYLE_RES), attrs, defStyleAttr);
        context = this.getContext();
        TypedArray a = ThemeEnforcement.obtainStyledAttributes(context, attrs, R.styleable.BottomAppBar, defStyleAttr, DEF_STYLE_RES, new int[0]);
        ColorStateList backgroundTint = MaterialResources.getColorStateList(context, a, R.styleable.BottomAppBar_backgroundTint);
        int elevation = a.getDimensionPixelSize(R.styleable.BottomAppBar_elevation, 0);
        float fabCradleMargin = a.getDimensionPixelOffset(R.styleable.BottomAppBar_fabCradleMargin, 0);
        float fabCornerRadius = a.getDimensionPixelOffset(R.styleable.BottomAppBar_fabCradleRoundedCornerRadius, 0);
        float fabVerticalOffset = a.getDimensionPixelOffset(R.styleable.BottomAppBar_fabCradleVerticalOffset, 0);
        this.fabAlignmentMode = a.getInt(R.styleable.BottomAppBar_fabAlignmentMode, 0);
        this.fabAnimationMode = a.getInt(R.styleable.BottomAppBar_fabAnimationMode, 0);
        this.hideOnScroll = a.getBoolean(R.styleable.BottomAppBar_hideOnScroll, false);
        this.paddingBottomSystemWindowInsets = a.getBoolean(R.styleable.BottomAppBar_paddingBottomSystemWindowInsets, false);
        this.paddingLeftSystemWindowInsets = a.getBoolean(R.styleable.BottomAppBar_paddingLeftSystemWindowInsets, false);
        this.paddingRightSystemWindowInsets = a.getBoolean(R.styleable.BottomAppBar_paddingRightSystemWindowInsets, false);
        a.recycle();
        this.fabOffsetEndMode = this.getResources().getDimensionPixelOffset(R.dimen.mtrl_bottomappbar_fabOffsetEndMode);
        BottomAppBarTopEdgeTreatment topEdgeTreatment = new BottomAppBarTopEdgeTreatment(fabCradleMargin, fabCornerRadius, fabVerticalOffset);
        ShapeAppearanceModel shapeAppearanceModel = ShapeAppearanceModel.builder().setTopEdge(topEdgeTreatment).build();
        this.materialShapeDrawable.setShapeAppearanceModel(shapeAppearanceModel);
        this.materialShapeDrawable.setShadowCompatibilityMode(2);
        this.materialShapeDrawable.setPaintStyle(Paint.Style.FILL);
        this.materialShapeDrawable.initializeElevationOverlay(context);
        this.setElevation(elevation);
        DrawableCompat.setTintList((Drawable)this.materialShapeDrawable, (ColorStateList)backgroundTint);
        ViewCompat.setBackground((View)this, (Drawable)this.materialShapeDrawable);
        ViewUtils.doOnApplyWindowInsets((View)this, attrs, defStyleAttr, DEF_STYLE_RES, new ViewUtils.OnApplyWindowInsetsListener(){

            @Override
            @NonNull
            public WindowInsetsCompat onApplyWindowInsets(View view, @NonNull WindowInsetsCompat insets, @NonNull ViewUtils.RelativePadding initialPadding) {
                boolean leftInsetsChanged = false;
                boolean rightInsetsChanged = false;
                if (BottomAppBar.this.paddingBottomSystemWindowInsets) {
                    BottomAppBar.this.bottomInset = insets.getSystemWindowInsetBottom();
                }
                if (BottomAppBar.this.paddingLeftSystemWindowInsets) {
                    leftInsetsChanged = BottomAppBar.this.leftInset != insets.getSystemWindowInsetLeft();
                    BottomAppBar.this.leftInset = insets.getSystemWindowInsetLeft();
                }
                if (BottomAppBar.this.paddingRightSystemWindowInsets) {
                    rightInsetsChanged = BottomAppBar.this.rightInset != insets.getSystemWindowInsetRight();
                    BottomAppBar.this.rightInset = insets.getSystemWindowInsetRight();
                }
                if (leftInsetsChanged || rightInsetsChanged) {
                    BottomAppBar.this.cancelAnimations();
                    BottomAppBar.this.setCutoutState();
                    BottomAppBar.this.setActionMenuViewPosition();
                }
                return insets;
            }
        });
    }

    public int getFabAlignmentMode() {
        return this.fabAlignmentMode;
    }

    public void setFabAlignmentMode(int fabAlignmentMode) {
        this.maybeAnimateModeChange(fabAlignmentMode);
        this.maybeAnimateMenuView(fabAlignmentMode, this.fabAttached);
        this.fabAlignmentMode = fabAlignmentMode;
    }

    public int getFabAnimationMode() {
        return this.fabAnimationMode;
    }

    public void setFabAnimationMode(int fabAnimationMode) {
        this.fabAnimationMode = fabAnimationMode;
    }

    public void setBackgroundTint(@Nullable ColorStateList backgroundTint) {
        DrawableCompat.setTintList((Drawable)this.materialShapeDrawable, (ColorStateList)backgroundTint);
    }

    @Nullable
    public ColorStateList getBackgroundTint() {
        return this.materialShapeDrawable.getTintList();
    }

    public float getFabCradleMargin() {
        return this.getTopEdgeTreatment().getFabCradleMargin();
    }

    public void setFabCradleMargin(@Dimension float cradleMargin) {
        if (cradleMargin != this.getFabCradleMargin()) {
            this.getTopEdgeTreatment().setFabCradleMargin(cradleMargin);
            this.materialShapeDrawable.invalidateSelf();
        }
    }

    @Dimension
    public float getFabCradleRoundedCornerRadius() {
        return this.getTopEdgeTreatment().getFabCradleRoundedCornerRadius();
    }

    public void setFabCradleRoundedCornerRadius(@Dimension float roundedCornerRadius) {
        if (roundedCornerRadius != this.getFabCradleRoundedCornerRadius()) {
            this.getTopEdgeTreatment().setFabCradleRoundedCornerRadius(roundedCornerRadius);
            this.materialShapeDrawable.invalidateSelf();
        }
    }

    @Dimension
    public float getCradleVerticalOffset() {
        return this.getTopEdgeTreatment().getCradleVerticalOffset();
    }

    public void setCradleVerticalOffset(@Dimension float verticalOffset) {
        if (verticalOffset != this.getCradleVerticalOffset()) {
            this.getTopEdgeTreatment().setCradleVerticalOffset(verticalOffset);
            this.materialShapeDrawable.invalidateSelf();
            this.setCutoutState();
        }
    }

    public boolean getHideOnScroll() {
        return this.hideOnScroll;
    }

    public void setHideOnScroll(boolean hide) {
        this.hideOnScroll = hide;
    }

    public void performHide() {
        this.getBehavior().slideDown(this);
    }

    public void performShow() {
        this.getBehavior().slideUp(this);
    }

    public void setElevation(float elevation) {
        this.materialShapeDrawable.setElevation(elevation);
        int topShadowHeight = this.materialShapeDrawable.getShadowRadius() - this.materialShapeDrawable.getShadowOffsetY();
        this.getBehavior().setAdditionalHiddenOffsetY(this, topShadowHeight);
    }

    public void replaceMenu(@MenuRes int newMenu) {
        this.getMenu().clear();
        this.inflateMenu(newMenu);
    }

    void addAnimationListener(@NonNull AnimationListener listener) {
        if (this.animationListeners == null) {
            this.animationListeners = new ArrayList();
        }
        this.animationListeners.add(listener);
    }

    void removeAnimationListener(@NonNull AnimationListener listener) {
        if (this.animationListeners == null) {
            return;
        }
        this.animationListeners.remove(listener);
    }

    private void dispatchAnimationStart() {
        if (this.animatingModeChangeCounter++ == 0 && this.animationListeners != null) {
            for (AnimationListener listener : this.animationListeners) {
                listener.onAnimationStart(this);
            }
        }
    }

    private void dispatchAnimationEnd() {
        if (--this.animatingModeChangeCounter == 0 && this.animationListeners != null) {
            for (AnimationListener listener : this.animationListeners) {
                listener.onAnimationEnd(this);
            }
        }
    }

    boolean setFabDiameter(@Px int diameter) {
        if ((float)diameter != this.getTopEdgeTreatment().getFabDiameter()) {
            this.getTopEdgeTreatment().setFabDiameter(diameter);
            this.materialShapeDrawable.invalidateSelf();
            return true;
        }
        return false;
    }

    private void maybeAnimateModeChange(int targetMode) {
        if (this.fabAlignmentMode == targetMode || !ViewCompat.isLaidOut((View)this)) {
            return;
        }
        if (this.modeAnimator != null) {
            this.modeAnimator.cancel();
        }
        ArrayList<Animator> animators = new ArrayList<Animator>();
        if (this.fabAnimationMode == 1) {
            this.createFabTranslationXAnimation(targetMode, animators);
        } else {
            this.createFabDefaultXAnimation(targetMode, animators);
        }
        AnimatorSet set = new AnimatorSet();
        set.playTogether(animators);
        this.modeAnimator = set;
        this.modeAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                BottomAppBar.this.dispatchAnimationStart();
            }

            public void onAnimationEnd(Animator animation) {
                BottomAppBar.this.dispatchAnimationEnd();
            }
        });
        this.modeAnimator.start();
    }

    @Nullable
    private FloatingActionButton findDependentFab() {
        View view = this.findDependentView();
        return view instanceof FloatingActionButton ? (FloatingActionButton)view : null;
    }

    @Nullable
    private View findDependentView() {
        if (!(this.getParent() instanceof CoordinatorLayout)) {
            return null;
        }
        List dependents = ((CoordinatorLayout)this.getParent()).getDependents((View)this);
        for (View v : dependents) {
            if (!(v instanceof FloatingActionButton) && !(v instanceof ExtendedFloatingActionButton)) continue;
            return v;
        }
        return null;
    }

    private boolean isFabVisibleOrWillBeShown() {
        FloatingActionButton fab = this.findDependentFab();
        return fab != null && fab.isOrWillBeShown();
    }

    protected void createFabDefaultXAnimation(final int targetMode, List<Animator> animators) {
        FloatingActionButton fab = this.findDependentFab();
        if (fab == null || fab.isOrWillBeHidden()) {
            return;
        }
        this.dispatchAnimationStart();
        fab.hide(new FloatingActionButton.OnVisibilityChangedListener(){

            @Override
            public void onHidden(@NonNull FloatingActionButton fab) {
                fab.setTranslationX(BottomAppBar.this.getFabTranslationX(targetMode));
                fab.show(new FloatingActionButton.OnVisibilityChangedListener(){

                    @Override
                    public void onShown(FloatingActionButton fab) {
                        BottomAppBar.this.dispatchAnimationEnd();
                    }
                });
            }
        });
    }

    private void createFabTranslationXAnimation(int targetMode, @NonNull List<Animator> animators) {
        ObjectAnimator animator2 = ObjectAnimator.ofFloat((Object)this.findDependentFab(), (String)"translationX", (float[])new float[]{this.getFabTranslationX(targetMode)});
        animator2.setDuration(300L);
        animators.add((Animator)animator2);
    }

    private void maybeAnimateMenuView(int targetMode, boolean newFabAttached) {
        if (!ViewCompat.isLaidOut((View)this)) {
            return;
        }
        if (this.menuAnimator != null) {
            this.menuAnimator.cancel();
        }
        ArrayList<Animator> animators = new ArrayList<Animator>();
        if (!this.isFabVisibleOrWillBeShown()) {
            targetMode = 0;
            newFabAttached = false;
        }
        this.createMenuViewTranslationAnimation(targetMode, newFabAttached, animators);
        AnimatorSet set = new AnimatorSet();
        set.playTogether(animators);
        this.menuAnimator = set;
        this.menuAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                BottomAppBar.this.dispatchAnimationStart();
            }

            public void onAnimationEnd(Animator animation) {
                BottomAppBar.this.dispatchAnimationEnd();
                BottomAppBar.this.menuAnimator = null;
            }
        });
        this.menuAnimator.start();
    }

    private void createMenuViewTranslationAnimation(final int targetMode, final boolean targetAttached, @NonNull List<Animator> animators) {
        final ActionMenuView actionMenuView = this.getActionMenuView();
        if (actionMenuView == null) {
            return;
        }
        ObjectAnimator fadeIn = ObjectAnimator.ofFloat((Object)actionMenuView, (String)"alpha", (float[])new float[]{1.0f});
        float translationXDifference = actionMenuView.getTranslationX() - (float)this.getActionMenuViewTranslationX(actionMenuView, targetMode, targetAttached);
        if (Math.abs(translationXDifference) > 1.0f) {
            ObjectAnimator fadeOut = ObjectAnimator.ofFloat((Object)actionMenuView, (String)"alpha", (float[])new float[]{0.0f});
            fadeOut.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){
                public boolean cancelled;

                public void onAnimationCancel(Animator animation) {
                    this.cancelled = true;
                }

                public void onAnimationEnd(Animator animation) {
                    if (!this.cancelled) {
                        BottomAppBar.this.translateActionMenuView(actionMenuView, targetMode, targetAttached);
                    }
                }
            });
            AnimatorSet set = new AnimatorSet();
            set.setDuration(150L);
            set.playSequentially(new Animator[]{fadeOut, fadeIn});
            animators.add((Animator)set);
        } else if (actionMenuView.getAlpha() < 1.0f) {
            animators.add((Animator)fadeIn);
        }
    }

    private float getFabTranslationY() {
        return -this.getTopEdgeTreatment().getCradleVerticalOffset();
    }

    private float getFabTranslationX(int fabAlignmentMode) {
        boolean isRtl = ViewUtils.isLayoutRtl((View)this);
        if (fabAlignmentMode == 1) {
            int systemEndInset = isRtl ? this.leftInset : this.rightInset;
            int totalEndInset = this.fabOffsetEndMode + systemEndInset;
            return (this.getMeasuredWidth() / 2 - totalEndInset) * (isRtl ? -1 : 1);
        }
        return 0.0f;
    }

    private float getFabTranslationX() {
        return this.getFabTranslationX(this.fabAlignmentMode);
    }

    @Nullable
    private ActionMenuView getActionMenuView() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            View view = this.getChildAt(i);
            if (!(view instanceof ActionMenuView)) continue;
            return (ActionMenuView)view;
        }
        return null;
    }

    private void translateActionMenuView(@NonNull ActionMenuView actionMenuView, int fabAlignmentMode, boolean fabAttached) {
        actionMenuView.setTranslationX((float)this.getActionMenuViewTranslationX(actionMenuView, fabAlignmentMode, fabAttached));
    }

    protected int getActionMenuViewTranslationX(@NonNull ActionMenuView actionMenuView, int fabAlignmentMode, boolean fabAttached) {
        if (fabAlignmentMode != 1 || !fabAttached) {
            return 0;
        }
        boolean isRtl = ViewUtils.isLayoutRtl((View)this);
        int toolbarLeftContentEnd = isRtl ? this.getMeasuredWidth() : 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            boolean isAlignedToStart;
            View view = this.getChildAt(i);
            boolean bl = isAlignedToStart = view.getLayoutParams() instanceof Toolbar.LayoutParams && (((Toolbar.LayoutParams)view.getLayoutParams()).gravity & 0x800007) == 0x800003;
            if (!isAlignedToStart) continue;
            toolbarLeftContentEnd = isRtl ? Math.min(toolbarLeftContentEnd, view.getLeft()) : Math.max(toolbarLeftContentEnd, view.getRight());
        }
        int actionMenuViewStart = isRtl ? actionMenuView.getRight() : actionMenuView.getLeft();
        int systemStartInset = isRtl ? this.rightInset : -this.leftInset;
        int end = actionMenuViewStart + systemStartInset;
        return toolbarLeftContentEnd - end;
    }

    private void cancelAnimations() {
        if (this.menuAnimator != null) {
            this.menuAnimator.cancel();
        }
        if (this.modeAnimator != null) {
            this.modeAnimator.cancel();
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (changed) {
            this.cancelAnimations();
            this.setCutoutState();
        }
        this.setActionMenuViewPosition();
    }

    @NonNull
    private BottomAppBarTopEdgeTreatment getTopEdgeTreatment() {
        return (BottomAppBarTopEdgeTreatment)this.materialShapeDrawable.getShapeAppearanceModel().getTopEdge();
    }

    private void setCutoutState() {
        this.getTopEdgeTreatment().setHorizontalOffset(this.getFabTranslationX());
        View fab = this.findDependentView();
        this.materialShapeDrawable.setInterpolation(this.fabAttached && this.isFabVisibleOrWillBeShown() ? 1.0f : 0.0f);
        if (fab != null) {
            fab.setTranslationY(this.getFabTranslationY());
            fab.setTranslationX(this.getFabTranslationX());
        }
    }

    private void setActionMenuViewPosition() {
        ActionMenuView actionMenuView = this.getActionMenuView();
        if (actionMenuView != null) {
            actionMenuView.setAlpha(1.0f);
            if (!this.isFabVisibleOrWillBeShown()) {
                this.translateActionMenuView(actionMenuView, 0, false);
            } else {
                this.translateActionMenuView(actionMenuView, this.fabAlignmentMode, this.fabAttached);
            }
        }
    }

    private void addFabAnimationListeners(@NonNull FloatingActionButton fab) {
        fab.addOnHideAnimationListener((Animator.AnimatorListener)this.fabAnimationListener);
        fab.addOnShowAnimationListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                BottomAppBar.this.fabAnimationListener.onAnimationStart(animation);
                FloatingActionButton fab = BottomAppBar.this.findDependentFab();
                if (fab != null) {
                    fab.setTranslationX(BottomAppBar.this.getFabTranslationX());
                }
            }
        });
        fab.addTransformationCallback(this.fabTransformationCallback);
    }

    private int getBottomInset() {
        return this.bottomInset;
    }

    private int getRightInset() {
        return this.rightInset;
    }

    private int getLeftInset() {
        return this.leftInset;
    }

    public void setTitle(CharSequence title) {
    }

    public void setSubtitle(CharSequence subtitle) {
    }

    @NonNull
    public Behavior getBehavior() {
        if (this.behavior == null) {
            this.behavior = new Behavior();
        }
        return this.behavior;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        MaterialShapeUtils.setParentAbsoluteElevation((View)this, this.materialShapeDrawable);
        if (this.getParent() instanceof ViewGroup) {
            ((ViewGroup)this.getParent()).setClipChildren(false);
        }
    }

    @NonNull
    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState savedState = new SavedState(superState);
        savedState.fabAlignmentMode = this.fabAlignmentMode;
        savedState.fabAttached = this.fabAttached;
        return savedState;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.fabAlignmentMode = savedState.fabAlignmentMode;
        this.fabAttached = savedState.fabAttached;
    }

    static class SavedState
    extends AbsSavedState {
        int fabAlignmentMode;
        boolean fabAttached;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.ClassLoaderCreator<SavedState>(){

            @NonNull
            public SavedState createFromParcel(@NonNull Parcel in, ClassLoader loader) {
                return new SavedState(in, loader);
            }

            @Nullable
            public SavedState createFromParcel(@NonNull Parcel in) {
                return new SavedState(in, null);
            }

            @NonNull
            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable superState) {
            super(superState);
        }

        public SavedState(@NonNull Parcel in, ClassLoader loader) {
            super(in, loader);
            this.fabAlignmentMode = in.readInt();
            this.fabAttached = in.readInt() != 0;
        }

        public void writeToParcel(@NonNull Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.fabAlignmentMode);
            out.writeInt(this.fabAttached ? 1 : 0);
        }
    }

    public static class Behavior
    extends HideBottomViewOnScrollBehavior<BottomAppBar> {
        @NonNull
        private final Rect fabContentRect;
        private WeakReference<BottomAppBar> viewRef;
        private int originalBottomMargin;
        private final View.OnLayoutChangeListener fabLayoutListener = new View.OnLayoutChangeListener(){

            public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                BottomAppBar child = (BottomAppBar)((Object)Behavior.this.viewRef.get());
                if (child == null || !(v instanceof FloatingActionButton)) {
                    v.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
                    return;
                }
                FloatingActionButton fab = (FloatingActionButton)v;
                fab.getMeasuredContentRect(Behavior.this.fabContentRect);
                int height = Behavior.this.fabContentRect.height();
                child.setFabDiameter(height);
                CoordinatorLayout.LayoutParams fabLayoutParams = (CoordinatorLayout.LayoutParams)v.getLayoutParams();
                if (Behavior.this.originalBottomMargin == 0) {
                    int bottomShadowPadding = (fab.getMeasuredHeight() - height) / 2;
                    int bottomMargin = child.getResources().getDimensionPixelOffset(R.dimen.mtrl_bottomappbar_fab_bottom_margin);
                    int minBottomMargin = bottomMargin - bottomShadowPadding;
                    fabLayoutParams.bottomMargin = child.getBottomInset() + minBottomMargin;
                    fabLayoutParams.leftMargin = child.getLeftInset();
                    fabLayoutParams.rightMargin = child.getRightInset();
                    boolean isRtl = ViewUtils.isLayoutRtl((View)fab);
                    if (isRtl) {
                        fabLayoutParams.leftMargin += child.fabOffsetEndMode;
                    } else {
                        fabLayoutParams.rightMargin += child.fabOffsetEndMode;
                    }
                }
            }
        };

        public Behavior() {
            this.fabContentRect = new Rect();
        }

        public Behavior(Context context, AttributeSet attrs) {
            super(context, attrs);
            this.fabContentRect = new Rect();
        }

        @Override
        public boolean onLayoutChild(@NonNull CoordinatorLayout parent, @NonNull BottomAppBar child, int layoutDirection) {
            this.viewRef = new WeakReference<BottomAppBar>(child);
            View dependentView = child.findDependentView();
            if (dependentView != null && !ViewCompat.isLaidOut((View)dependentView)) {
                CoordinatorLayout.LayoutParams fabLayoutParams = (CoordinatorLayout.LayoutParams)dependentView.getLayoutParams();
                fabLayoutParams.anchorGravity = 49;
                this.originalBottomMargin = fabLayoutParams.bottomMargin;
                if (dependentView instanceof FloatingActionButton) {
                    FloatingActionButton fab = (FloatingActionButton)dependentView;
                    fab.addOnLayoutChangeListener(this.fabLayoutListener);
                    child.addFabAnimationListeners(fab);
                }
                child.setCutoutState();
            }
            parent.onLayoutChild((View)child, layoutDirection);
            return super.onLayoutChild(parent, child, layoutDirection);
        }

        @Override
        public boolean onStartNestedScroll(@NonNull CoordinatorLayout coordinatorLayout, @NonNull BottomAppBar child, @NonNull View directTargetChild, @NonNull View target, int axes, int type) {
            return child.getHideOnScroll() && super.onStartNestedScroll(coordinatorLayout, child, directTargetChild, target, axes, type);
        }
    }

    static interface AnimationListener {
        public void onAnimationStart(BottomAppBar var1);

        public void onAnimationEnd(BottomAppBar var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FabAnimationMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FabAlignmentMode {
    }
}

