/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.datepicker;

import android.annotation.TargetApi;
import android.content.res.Resources;
import android.icu.text.DateFormat;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.material.R;
import com.google.android.material.datepicker.TimeSource;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;

class UtcDates {
    static final String UTC = "UTC";
    static AtomicReference<TimeSource> timeSourceRef = new AtomicReference();

    static void setTimeSource(@Nullable TimeSource timeSource) {
        timeSourceRef.set(timeSource);
    }

    static TimeSource getTimeSource() {
        TimeSource timeSource = timeSourceRef.get();
        return timeSource == null ? TimeSource.system() : timeSource;
    }

    private UtcDates() {
    }

    private static TimeZone getTimeZone() {
        return TimeZone.getTimeZone(UTC);
    }

    @TargetApi(value=24)
    private static android.icu.util.TimeZone getUtcAndroidTimeZone() {
        return android.icu.util.TimeZone.getTimeZone((String)UTC);
    }

    static Calendar getTodayCalendar() {
        Calendar today = UtcDates.getTimeSource().now();
        today.set(11, 0);
        today.set(12, 0);
        today.set(13, 0);
        today.set(14, 0);
        today.setTimeZone(UtcDates.getTimeZone());
        return today;
    }

    static Calendar getUtcCalendar() {
        return UtcDates.getUtcCalendarOf(null);
    }

    static Calendar getUtcCalendarOf(@Nullable Calendar rawCalendar) {
        Calendar utc = Calendar.getInstance(UtcDates.getTimeZone());
        if (rawCalendar == null) {
            utc.clear();
        } else {
            utc.setTimeInMillis(rawCalendar.getTimeInMillis());
        }
        return utc;
    }

    static Calendar getDayCopy(Calendar rawCalendar) {
        Calendar rawCalendarInUtc = UtcDates.getUtcCalendarOf(rawCalendar);
        Calendar utcCalendar = UtcDates.getUtcCalendar();
        utcCalendar.set(rawCalendarInUtc.get(1), rawCalendarInUtc.get(2), rawCalendarInUtc.get(5));
        return utcCalendar;
    }

    static long canonicalYearMonthDay(long rawDate) {
        Calendar rawCalendar = UtcDates.getUtcCalendar();
        rawCalendar.setTimeInMillis(rawDate);
        Calendar sanitizedStartItem = UtcDates.getDayCopy(rawCalendar);
        return sanitizedStartItem.getTimeInMillis();
    }

    @TargetApi(value=24)
    private static DateFormat getAndroidFormat(String pattern, Locale locale) {
        DateFormat format = DateFormat.getInstanceForSkeleton((String)pattern, (Locale)locale);
        format.setTimeZone(UtcDates.getUtcAndroidTimeZone());
        return format;
    }

    private static java.text.DateFormat getFormat(int style2, Locale locale) {
        java.text.DateFormat format = java.text.DateFormat.getDateInstance(style2, locale);
        format.setTimeZone(UtcDates.getTimeZone());
        return format;
    }

    static SimpleDateFormat getTextInputFormat() {
        String pattern = ((SimpleDateFormat)java.text.DateFormat.getDateInstance(3, Locale.getDefault())).toLocalizedPattern().replaceAll("\\s+", "");
        SimpleDateFormat format = new SimpleDateFormat(pattern, Locale.getDefault());
        format.setTimeZone(UtcDates.getTimeZone());
        format.setLenient(false);
        return format;
    }

    static String getTextInputHint(Resources res, SimpleDateFormat format) {
        String formatHint = format.toLocalizedPattern();
        String yearChar = res.getString(R.string.mtrl_picker_text_input_year_abbr);
        String monthChar = res.getString(R.string.mtrl_picker_text_input_month_abbr);
        String dayChar = res.getString(R.string.mtrl_picker_text_input_day_abbr);
        return formatHint.replaceAll("d", dayChar).replaceAll("M", monthChar).replaceAll("y", yearChar);
    }

    static SimpleDateFormat getSimpleFormat(String pattern) {
        return UtcDates.getSimpleFormat(pattern, Locale.getDefault());
    }

    private static SimpleDateFormat getSimpleFormat(String pattern, Locale locale) {
        SimpleDateFormat format = new SimpleDateFormat(pattern, locale);
        format.setTimeZone(UtcDates.getTimeZone());
        return format;
    }

    @TargetApi(value=24)
    static DateFormat getYearAbbrMonthDayFormat(Locale locale) {
        return UtcDates.getAndroidFormat("yMMMd", locale);
    }

    @TargetApi(value=24)
    static DateFormat getAbbrMonthDayFormat(Locale locale) {
        return UtcDates.getAndroidFormat("MMMd", locale);
    }

    @TargetApi(value=24)
    static DateFormat getAbbrMonthWeekdayDayFormat(Locale locale) {
        return UtcDates.getAndroidFormat("MMMEd", locale);
    }

    @TargetApi(value=24)
    static DateFormat getYearAbbrMonthWeekdayDayFormat(Locale locale) {
        return UtcDates.getAndroidFormat("yMMMEd", locale);
    }

    static java.text.DateFormat getMediumFormat() {
        return UtcDates.getMediumFormat(Locale.getDefault());
    }

    static java.text.DateFormat getMediumFormat(Locale locale) {
        return UtcDates.getFormat(2, locale);
    }

    static java.text.DateFormat getMediumNoYear() {
        return UtcDates.getMediumNoYear(Locale.getDefault());
    }

    static java.text.DateFormat getMediumNoYear(Locale locale) {
        SimpleDateFormat format = (SimpleDateFormat)UtcDates.getMediumFormat(locale);
        format.applyPattern(UtcDates.removeYearFromDateFormatPattern(format.toPattern()));
        return format;
    }

    static java.text.DateFormat getFullFormat() {
        return UtcDates.getFullFormat(Locale.getDefault());
    }

    static java.text.DateFormat getFullFormat(Locale locale) {
        return UtcDates.getFormat(0, locale);
    }

    static SimpleDateFormat getYearMonthFormat() {
        return UtcDates.getYearMonthFormat(Locale.getDefault());
    }

    private static SimpleDateFormat getYearMonthFormat(Locale locale) {
        return UtcDates.getSimpleFormat("LLLL, yyyy", locale);
    }

    @NonNull
    private static String removeYearFromDateFormatPattern(@NonNull String pattern) {
        String yearCharacters = "yY";
        int yearPosition = UtcDates.findCharactersInDateFormatPattern(pattern, yearCharacters, 1, 0);
        if (yearPosition >= pattern.length()) {
            return pattern;
        }
        String monthDayCharacters = "EMd";
        int yearEndPosition = UtcDates.findCharactersInDateFormatPattern(pattern, monthDayCharacters, 1, yearPosition);
        if (yearEndPosition < pattern.length()) {
            monthDayCharacters = monthDayCharacters + ",";
        }
        int yearStartPosition = UtcDates.findCharactersInDateFormatPattern(pattern, monthDayCharacters, -1, yearPosition);
        String yearPattern = pattern.substring(++yearStartPosition, yearEndPosition);
        return pattern.replace(yearPattern, " ").trim();
    }

    private static int findCharactersInDateFormatPattern(@NonNull String pattern, @NonNull String characterSequence, int increment, int initialPosition) {
        int position;
        for (position = initialPosition; position >= 0 && position < pattern.length() && characterSequence.indexOf(pattern.charAt(position)) == -1; position += increment) {
            if (pattern.charAt(position) != '\'') continue;
            position += increment;
            while (position >= 0 && position < pattern.length() && pattern.charAt(position) != '\'') {
                position += increment;
            }
        }
        return position;
    }
}

