/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.floatingactionbutton;

import android.annotation.TargetApi;
import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.LinearGradient;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import androidx.annotation.ColorInt;
import androidx.annotation.Dimension;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.core.graphics.ColorUtils;
import com.google.android.material.shape.ShapeAppearanceModel;
import com.google.android.material.shape.ShapeAppearancePathProvider;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
class BorderDrawable
extends Drawable {
    private static final float DRAW_STROKE_WIDTH_MULTIPLE = 1.3333f;
    private final ShapeAppearancePathProvider pathProvider = new ShapeAppearancePathProvider();
    @NonNull
    private final Paint paint;
    private final Path shapePath = new Path();
    private final Rect rect = new Rect();
    private final RectF rectF = new RectF();
    private final RectF boundsRectF = new RectF();
    private final BorderState state = new BorderState();
    @Dimension
    float borderWidth;
    @ColorInt
    private int topOuterStrokeColor;
    @ColorInt
    private int topInnerStrokeColor;
    @ColorInt
    private int bottomOuterStrokeColor;
    @ColorInt
    private int bottomInnerStrokeColor;
    @ColorInt
    private int currentBorderTintColor;
    private boolean invalidateShader = true;
    private ShapeAppearanceModel shapeAppearanceModel;
    @Nullable
    private ColorStateList borderTint;

    BorderDrawable(ShapeAppearanceModel shapeAppearanceModel) {
        this.shapeAppearanceModel = shapeAppearanceModel;
        this.paint = new Paint(1);
        this.paint.setStyle(Paint.Style.STROKE);
    }

    public void setBorderWidth(@Dimension float width) {
        if (this.borderWidth != width) {
            this.borderWidth = width;
            this.paint.setStrokeWidth(width * 1.3333f);
            this.invalidateShader = true;
            this.invalidateSelf();
        }
    }

    void setBorderTint(@Nullable ColorStateList tint) {
        if (tint != null) {
            this.currentBorderTintColor = tint.getColorForState(this.getState(), this.currentBorderTintColor);
        }
        this.borderTint = tint;
        this.invalidateShader = true;
        this.invalidateSelf();
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.paint.setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    void setGradientColors(@ColorInt int topOuterStrokeColor, @ColorInt int topInnerStrokeColor, @ColorInt int bottomOuterStrokeColor, @ColorInt int bottomInnerStrokeColor) {
        this.topOuterStrokeColor = topOuterStrokeColor;
        this.topInnerStrokeColor = topInnerStrokeColor;
        this.bottomOuterStrokeColor = bottomOuterStrokeColor;
        this.bottomInnerStrokeColor = bottomInnerStrokeColor;
    }

    public void draw(@NonNull Canvas canvas) {
        if (this.invalidateShader) {
            this.paint.setShader(this.createGradientShader());
            this.invalidateShader = false;
        }
        float halfBorderWidth = this.paint.getStrokeWidth() / 2.0f;
        this.copyBounds(this.rect);
        this.rectF.set(this.rect);
        float cornerSize = this.shapeAppearanceModel.getTopLeftCornerSize().getCornerSize(this.getBoundsAsRectF());
        float radius = Math.min(cornerSize, this.rectF.width() / 2.0f);
        if (this.shapeAppearanceModel.isRoundRect(this.getBoundsAsRectF())) {
            this.rectF.inset(halfBorderWidth, halfBorderWidth);
            canvas.drawRoundRect(this.rectF, radius, radius, this.paint);
        }
    }

    @TargetApi(value=21)
    public void getOutline(@NonNull Outline outline) {
        if (this.shapeAppearanceModel.isRoundRect(this.getBoundsAsRectF())) {
            float radius = this.shapeAppearanceModel.getTopLeftCornerSize().getCornerSize(this.getBoundsAsRectF());
            outline.setRoundRect(this.getBounds(), radius);
            return;
        }
        this.copyBounds(this.rect);
        this.rectF.set(this.rect);
        this.pathProvider.calculatePath(this.shapeAppearanceModel, 1.0f, this.rectF, this.shapePath);
        if (this.shapePath.isConvex()) {
            outline.setConvexPath(this.shapePath);
        }
    }

    public boolean getPadding(@NonNull Rect padding) {
        if (this.shapeAppearanceModel.isRoundRect(this.getBoundsAsRectF())) {
            int borderWidth = Math.round(this.borderWidth);
            padding.set(borderWidth, borderWidth, borderWidth, borderWidth);
        }
        return true;
    }

    @NonNull
    protected RectF getBoundsAsRectF() {
        this.boundsRectF.set(this.getBounds());
        return this.boundsRectF;
    }

    public ShapeAppearanceModel getShapeAppearanceModel() {
        return this.shapeAppearanceModel;
    }

    public void setShapeAppearanceModel(ShapeAppearanceModel shapeAppearanceModel) {
        this.shapeAppearanceModel = shapeAppearanceModel;
        this.invalidateSelf();
    }

    public void setAlpha(@IntRange(from=0L, to=255L) int alpha) {
        this.paint.setAlpha(alpha);
        this.invalidateSelf();
    }

    public int getOpacity() {
        return this.borderWidth > 0.0f ? -3 : -2;
    }

    protected void onBoundsChange(Rect bounds) {
        this.invalidateShader = true;
    }

    public boolean isStateful() {
        return this.borderTint != null && this.borderTint.isStateful() || super.isStateful();
    }

    protected boolean onStateChange(int[] state) {
        int newColor;
        if (this.borderTint != null && (newColor = this.borderTint.getColorForState(state, this.currentBorderTintColor)) != this.currentBorderTintColor) {
            this.invalidateShader = true;
            this.currentBorderTintColor = newColor;
        }
        if (this.invalidateShader) {
            this.invalidateSelf();
        }
        return this.invalidateShader;
    }

    @NonNull
    private Shader createGradientShader() {
        Rect rect = this.rect;
        this.copyBounds(rect);
        float borderRatio = this.borderWidth / (float)rect.height();
        int[] colors = new int[]{ColorUtils.compositeColors((int)this.topOuterStrokeColor, (int)this.currentBorderTintColor), ColorUtils.compositeColors((int)this.topInnerStrokeColor, (int)this.currentBorderTintColor), ColorUtils.compositeColors((int)ColorUtils.setAlphaComponent((int)this.topInnerStrokeColor, (int)0), (int)this.currentBorderTintColor), ColorUtils.compositeColors((int)ColorUtils.setAlphaComponent((int)this.bottomInnerStrokeColor, (int)0), (int)this.currentBorderTintColor), ColorUtils.compositeColors((int)this.bottomInnerStrokeColor, (int)this.currentBorderTintColor), ColorUtils.compositeColors((int)this.bottomOuterStrokeColor, (int)this.currentBorderTintColor)};
        float[] positions = new float[]{0.0f, borderRatio, 0.5f, 0.5f, 1.0f - borderRatio, 1.0f};
        return new LinearGradient(0.0f, (float)rect.top, 0.0f, (float)rect.bottom, colors, positions, Shader.TileMode.CLAMP);
    }

    @Nullable
    public Drawable.ConstantState getConstantState() {
        return this.state;
    }

    private class BorderState
    extends Drawable.ConstantState {
        private BorderState() {
        }

        @NonNull
        public Drawable newDrawable() {
            return BorderDrawable.this;
        }

        public int getChangingConfigurations() {
            return 0;
        }
    }
}

