/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.shadow;

import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RadialGradient;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.Shader;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.core.graphics.ColorUtils;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class ShadowRenderer {
    private static final int COLOR_ALPHA_START = 68;
    private static final int COLOR_ALPHA_MIDDLE = 20;
    private static final int COLOR_ALPHA_END = 0;
    @NonNull
    private final Paint shadowPaint;
    @NonNull
    private final Paint cornerShadowPaint;
    @NonNull
    private final Paint edgeShadowPaint;
    private int shadowStartColor;
    private int shadowMiddleColor;
    private int shadowEndColor;
    private static final int[] edgeColors = new int[3];
    private static final float[] edgePositions = new float[]{0.0f, 0.5f, 1.0f};
    private static final int[] cornerColors = new int[4];
    private static final float[] cornerPositions = new float[]{0.0f, 0.0f, 0.5f, 1.0f};
    private final Path scratch = new Path();
    private Paint transparentPaint = new Paint();

    public ShadowRenderer() {
        this(-16777216);
    }

    public ShadowRenderer(int color2) {
        this.shadowPaint = new Paint();
        this.setShadowColor(color2);
        this.transparentPaint.setColor(0);
        this.cornerShadowPaint = new Paint(4);
        this.cornerShadowPaint.setStyle(Paint.Style.FILL);
        this.edgeShadowPaint = new Paint(this.cornerShadowPaint);
    }

    public void setShadowColor(int color2) {
        this.shadowStartColor = ColorUtils.setAlphaComponent((int)color2, (int)68);
        this.shadowMiddleColor = ColorUtils.setAlphaComponent((int)color2, (int)20);
        this.shadowEndColor = ColorUtils.setAlphaComponent((int)color2, (int)0);
        this.shadowPaint.setColor(this.shadowStartColor);
    }

    public void drawEdgeShadow(@NonNull Canvas canvas, @Nullable Matrix transform, @NonNull RectF bounds, int elevation) {
        bounds.bottom += (float)elevation;
        bounds.offset(0.0f, (float)(-elevation));
        ShadowRenderer.edgeColors[0] = this.shadowEndColor;
        ShadowRenderer.edgeColors[1] = this.shadowMiddleColor;
        ShadowRenderer.edgeColors[2] = this.shadowStartColor;
        this.edgeShadowPaint.setShader((Shader)new LinearGradient(bounds.left, bounds.top, bounds.left, bounds.bottom, edgeColors, edgePositions, Shader.TileMode.CLAMP));
        canvas.save();
        canvas.concat(transform);
        canvas.drawRect(bounds, this.edgeShadowPaint);
        canvas.restore();
    }

    public void drawCornerShadow(@NonNull Canvas canvas, @Nullable Matrix matrix, @NonNull RectF bounds, int elevation, float startAngle, float sweepAngle) {
        boolean drawShadowInsideBounds = sweepAngle < 0.0f;
        Path arcBounds = this.scratch;
        if (drawShadowInsideBounds) {
            ShadowRenderer.cornerColors[0] = 0;
            ShadowRenderer.cornerColors[1] = this.shadowEndColor;
            ShadowRenderer.cornerColors[2] = this.shadowMiddleColor;
            ShadowRenderer.cornerColors[3] = this.shadowStartColor;
        } else {
            arcBounds.rewind();
            arcBounds.moveTo(bounds.centerX(), bounds.centerY());
            arcBounds.arcTo(bounds, startAngle, sweepAngle);
            arcBounds.close();
            bounds.inset((float)(-elevation), (float)(-elevation));
            ShadowRenderer.cornerColors[0] = 0;
            ShadowRenderer.cornerColors[1] = this.shadowStartColor;
            ShadowRenderer.cornerColors[2] = this.shadowMiddleColor;
            ShadowRenderer.cornerColors[3] = this.shadowEndColor;
        }
        float radius = bounds.width() / 2.0f;
        if (radius <= 0.0f) {
            return;
        }
        float startRatio = 1.0f - (float)elevation / radius;
        float midRatio = startRatio + (1.0f - startRatio) / 2.0f;
        ShadowRenderer.cornerPositions[1] = startRatio;
        ShadowRenderer.cornerPositions[2] = midRatio;
        this.cornerShadowPaint.setShader((Shader)new RadialGradient(bounds.centerX(), bounds.centerY(), radius, cornerColors, cornerPositions, Shader.TileMode.CLAMP));
        canvas.save();
        canvas.concat(matrix);
        if (!drawShadowInsideBounds) {
            canvas.clipPath(arcBounds, Region.Op.DIFFERENCE);
            canvas.drawPath(arcBounds, this.transparentPaint);
        }
        canvas.drawArc(bounds, startAngle, sweepAngle, true, this.cornerShadowPaint);
        canvas.restore();
    }

    @NonNull
    public Paint getShadowPaint() {
        return this.shadowPaint;
    }
}

