/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.snackbar;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityManager;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.Dimension;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.StringRes;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import com.google.android.material.R;
import com.google.android.material.snackbar.BaseTransientBottomBar;
import com.google.android.material.snackbar.ContentViewCallback;
import com.google.android.material.snackbar.SnackbarContentLayout;

public class Snackbar
extends BaseTransientBottomBar<Snackbar> {
    @Nullable
    private final AccessibilityManager accessibilityManager;
    private boolean hasAction;
    private static final int[] SNACKBAR_BUTTON_STYLE_ATTR = new int[]{R.attr.snackbarButtonStyle};
    private static final int[] SNACKBAR_CONTENT_STYLE_ATTRS = new int[]{R.attr.snackbarButtonStyle, R.attr.snackbarTextViewStyle};
    @Nullable
    private BaseTransientBottomBar.BaseCallback<Snackbar> callback;

    private Snackbar(@NonNull ViewGroup parent, @NonNull View content, @NonNull ContentViewCallback contentViewCallback) {
        super(parent, content, contentViewCallback);
        this.accessibilityManager = (AccessibilityManager)parent.getContext().getSystemService("accessibility");
    }

    @Override
    public void show() {
        super.show();
    }

    @Override
    public void dismiss() {
        super.dismiss();
    }

    @Override
    public boolean isShown() {
        return super.isShown();
    }

    @NonNull
    public static Snackbar make(@NonNull View view, @NonNull CharSequence text, int duration) {
        ViewGroup parent = Snackbar.findSuitableParent(view);
        if (parent == null) {
            throw new IllegalArgumentException("No suitable parent found from the given view. Please provide a valid view.");
        }
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        SnackbarContentLayout content = (SnackbarContentLayout)inflater.inflate(Snackbar.hasSnackbarContentStyleAttrs(parent.getContext()) ? R.layout.mtrl_layout_snackbar_include : R.layout.design_layout_snackbar_include, parent, false);
        Snackbar snackbar = new Snackbar(parent, (View)content, content);
        snackbar.setText(text);
        snackbar.setDuration(duration);
        return snackbar;
    }

    @Deprecated
    protected static boolean hasSnackbarButtonStyleAttr(@NonNull Context context) {
        TypedArray a = context.obtainStyledAttributes(SNACKBAR_BUTTON_STYLE_ATTR);
        int snackbarButtonStyleResId = a.getResourceId(0, -1);
        a.recycle();
        return snackbarButtonStyleResId != -1;
    }

    private static boolean hasSnackbarContentStyleAttrs(@NonNull Context context) {
        TypedArray a = context.obtainStyledAttributes(SNACKBAR_CONTENT_STYLE_ATTRS);
        int snackbarButtonStyleResId = a.getResourceId(0, -1);
        int snackbarTextViewStyleResId = a.getResourceId(1, -1);
        a.recycle();
        return snackbarButtonStyleResId != -1 && snackbarTextViewStyleResId != -1;
    }

    @NonNull
    public static Snackbar make(@NonNull View view, @StringRes int resId, int duration) {
        return Snackbar.make(view, view.getResources().getText(resId), duration);
    }

    @Nullable
    private static ViewGroup findSuitableParent(View view) {
        ViewGroup fallback = null;
        do {
            if (view instanceof CoordinatorLayout) {
                return (ViewGroup)view;
            }
            if (view instanceof FrameLayout) {
                if (view.getId() == 0x1020002) {
                    return (ViewGroup)view;
                }
                fallback = (ViewGroup)view;
            }
            if (view == null) continue;
            ViewParent parent = view.getParent();
            View view2 = view = parent instanceof View ? (View)parent : null;
        } while (view != null);
        return fallback;
    }

    @NonNull
    public Snackbar setText(@NonNull CharSequence message) {
        SnackbarContentLayout contentLayout = (SnackbarContentLayout)this.view.getChildAt(0);
        TextView tv = contentLayout.getMessageView();
        tv.setText(message);
        return this;
    }

    @NonNull
    public Snackbar setText(@StringRes int resId) {
        return this.setText(this.getContext().getText(resId));
    }

    @NonNull
    public Snackbar setAction(@StringRes int resId, View.OnClickListener listener) {
        return this.setAction(this.getContext().getText(resId), listener);
    }

    @NonNull
    public Snackbar setAction(@Nullable CharSequence text, final @Nullable View.OnClickListener listener) {
        SnackbarContentLayout contentLayout = (SnackbarContentLayout)this.view.getChildAt(0);
        Button tv = contentLayout.getActionView();
        if (TextUtils.isEmpty((CharSequence)text) || listener == null) {
            tv.setVisibility(8);
            tv.setOnClickListener(null);
            this.hasAction = false;
        } else {
            this.hasAction = true;
            tv.setVisibility(0);
            tv.setText(text);
            tv.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    listener.onClick(view);
                    Snackbar.this.dispatchDismiss(1);
                }
            });
        }
        return this;
    }

    @Override
    public int getDuration() {
        int userSetDuration = super.getDuration();
        if (userSetDuration == -2) {
            return -2;
        }
        if (Build.VERSION.SDK_INT >= 29) {
            int controlsFlag = this.hasAction ? 4 : 0;
            return this.accessibilityManager.getRecommendedTimeoutMillis(userSetDuration, controlsFlag | 1 | 2);
        }
        return this.hasAction && this.accessibilityManager.isTouchExplorationEnabled() ? -2 : userSetDuration;
    }

    @NonNull
    public Snackbar setTextColor(ColorStateList colors) {
        SnackbarContentLayout contentLayout = (SnackbarContentLayout)this.view.getChildAt(0);
        TextView tv = contentLayout.getMessageView();
        tv.setTextColor(colors);
        return this;
    }

    @NonNull
    public Snackbar setTextColor(@ColorInt int color2) {
        SnackbarContentLayout contentLayout = (SnackbarContentLayout)this.view.getChildAt(0);
        TextView tv = contentLayout.getMessageView();
        tv.setTextColor(color2);
        return this;
    }

    @NonNull
    public Snackbar setActionTextColor(ColorStateList colors) {
        SnackbarContentLayout contentLayout = (SnackbarContentLayout)this.view.getChildAt(0);
        Button tv = contentLayout.getActionView();
        tv.setTextColor(colors);
        return this;
    }

    @NonNull
    public Snackbar setMaxInlineActionWidth(@Dimension int width) {
        SnackbarContentLayout contentLayout = (SnackbarContentLayout)this.view.getChildAt(0);
        contentLayout.setMaxInlineActionWidth(width);
        return this;
    }

    @NonNull
    public Snackbar setActionTextColor(@ColorInt int color2) {
        SnackbarContentLayout contentLayout = (SnackbarContentLayout)this.view.getChildAt(0);
        Button tv = contentLayout.getActionView();
        tv.setTextColor(color2);
        return this;
    }

    @NonNull
    public Snackbar setBackgroundTint(@ColorInt int color2) {
        return this.setBackgroundTintList(ColorStateList.valueOf((int)color2));
    }

    @NonNull
    public Snackbar setBackgroundTintList(@Nullable ColorStateList colorStateList) {
        this.view.setBackgroundTintList(colorStateList);
        return this;
    }

    @NonNull
    public Snackbar setBackgroundTintMode(@Nullable PorterDuff.Mode mode) {
        this.view.setBackgroundTintMode(mode);
        return this;
    }

    @Deprecated
    @NonNull
    public Snackbar setCallback(@Nullable Callback callback) {
        if (this.callback != null) {
            this.removeCallback(this.callback);
        }
        if (callback != null) {
            this.addCallback(callback);
        }
        this.callback = callback;
        return this;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class SnackbarLayout
    extends BaseTransientBottomBar.SnackbarBaseLayout {
        public SnackbarLayout(Context context) {
            super(context);
        }

        public SnackbarLayout(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            int childCount = this.getChildCount();
            int availableWidth = this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight();
            for (int i = 0; i < childCount; ++i) {
                View child = this.getChildAt(i);
                if (child.getLayoutParams().width != -1) continue;
                child.measure(View.MeasureSpec.makeMeasureSpec((int)availableWidth, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)child.getMeasuredHeight(), (int)0x40000000));
            }
        }
    }

    public static class Callback
    extends BaseTransientBottomBar.BaseCallback<Snackbar> {
        public static final int DISMISS_EVENT_SWIPE = 0;
        public static final int DISMISS_EVENT_ACTION = 1;
        public static final int DISMISS_EVENT_TIMEOUT = 2;
        public static final int DISMISS_EVENT_MANUAL = 3;
        public static final int DISMISS_EVENT_CONSECUTIVE = 4;

        @Override
        public void onShown(Snackbar sb) {
        }

        @Override
        public void onDismissed(Snackbar transientBottomBar, int event) {
        }
    }
}

