/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.tooltip;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.annotation.RestrictTo;
import androidx.annotation.StringRes;
import androidx.annotation.StyleRes;
import androidx.core.graphics.ColorUtils;
import com.google.android.material.R;
import com.google.android.material.color.MaterialColors;
import com.google.android.material.internal.TextDrawableHelper;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.resources.MaterialResources;
import com.google.android.material.resources.TextAppearance;
import com.google.android.material.shape.EdgeTreatment;
import com.google.android.material.shape.MarkerEdgeTreatment;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.OffsetEdgeTreatment;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class TooltipDrawable
extends MaterialShapeDrawable
implements TextDrawableHelper.TextDrawableDelegate {
    @StyleRes
    private static final int DEFAULT_STYLE = R.style.Widget_MaterialComponents_Tooltip;
    @AttrRes
    private static final int DEFAULT_THEME_ATTR = R.attr.tooltipStyle;
    @Nullable
    private CharSequence text;
    @NonNull
    private final Context context;
    @Nullable
    private final Paint.FontMetrics fontMetrics = new Paint.FontMetrics();
    @NonNull
    private final TextDrawableHelper textDrawableHelper = new TextDrawableHelper(this);
    @NonNull
    private final View.OnLayoutChangeListener attachedViewLayoutChangeListener = new View.OnLayoutChangeListener(){

        public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
            TooltipDrawable.this.updateLocationOnScreen(v);
        }
    };
    @NonNull
    private final Rect displayFrame = new Rect();
    private int padding;
    private int minWidth;
    private int minHeight;
    private int layoutMargin;
    private int arrowSize;
    private int locationOnScreenX;

    @NonNull
    public static TooltipDrawable createFromAttributes(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        TooltipDrawable tooltip = new TooltipDrawable(context, attrs, defStyleAttr, defStyleRes);
        tooltip.loadFromAttributes(attrs, defStyleAttr, defStyleRes);
        return tooltip;
    }

    @NonNull
    public static TooltipDrawable createFromAttributes(@NonNull Context context, @Nullable AttributeSet attrs) {
        return TooltipDrawable.createFromAttributes(context, attrs, DEFAULT_THEME_ATTR, DEFAULT_STYLE);
    }

    @NonNull
    public static TooltipDrawable create(@NonNull Context context) {
        return TooltipDrawable.createFromAttributes(context, null, DEFAULT_THEME_ATTR, DEFAULT_STYLE);
    }

    private TooltipDrawable(@NonNull Context context, AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.context = context;
        this.textDrawableHelper.getTextPaint().density = context.getResources().getDisplayMetrics().density;
        this.textDrawableHelper.getTextPaint().setTextAlign(Paint.Align.CENTER);
    }

    private void loadFromAttributes(@Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        TypedArray a = ThemeEnforcement.obtainStyledAttributes(this.context, attrs, R.styleable.Tooltip, defStyleAttr, defStyleRes, new int[0]);
        this.arrowSize = this.context.getResources().getDimensionPixelSize(R.dimen.mtrl_tooltip_arrowSize);
        this.setShapeAppearanceModel(this.getShapeAppearanceModel().toBuilder().setBottomEdge(this.createMarkerEdge()).build());
        this.setText(a.getText(R.styleable.Tooltip_android_text));
        this.setTextAppearance(MaterialResources.getTextAppearance(this.context, a, R.styleable.Tooltip_android_textAppearance));
        int onBackground = MaterialColors.getColor(this.context, R.attr.colorOnBackground, TooltipDrawable.class.getCanonicalName());
        int background = MaterialColors.getColor(this.context, 0x1010031, TooltipDrawable.class.getCanonicalName());
        int backgroundTintDefault = MaterialColors.layer(ColorUtils.setAlphaComponent((int)background, (int)229), ColorUtils.setAlphaComponent((int)onBackground, (int)153));
        this.setFillColor(ColorStateList.valueOf((int)a.getColor(R.styleable.Tooltip_backgroundTint, backgroundTintDefault)));
        this.setStrokeColor(ColorStateList.valueOf((int)MaterialColors.getColor(this.context, R.attr.colorSurface, TooltipDrawable.class.getCanonicalName())));
        this.padding = a.getDimensionPixelSize(R.styleable.Tooltip_android_padding, 0);
        this.minWidth = a.getDimensionPixelSize(R.styleable.Tooltip_android_minWidth, 0);
        this.minHeight = a.getDimensionPixelSize(R.styleable.Tooltip_android_minHeight, 0);
        this.layoutMargin = a.getDimensionPixelSize(R.styleable.Tooltip_android_layout_margin, 0);
        a.recycle();
    }

    @Nullable
    public CharSequence getText() {
        return this.text;
    }

    public void setTextResource(@StringRes int id2) {
        this.setText(this.context.getResources().getString(id2));
    }

    public void setText(@Nullable CharSequence text) {
        if (!TextUtils.equals((CharSequence)this.text, (CharSequence)text)) {
            this.text = text;
            this.textDrawableHelper.setTextWidthDirty(true);
            this.invalidateSelf();
        }
    }

    @Nullable
    public TextAppearance getTextAppearance() {
        return this.textDrawableHelper.getTextAppearance();
    }

    public void setTextAppearanceResource(@StyleRes int id2) {
        this.setTextAppearance(new TextAppearance(this.context, id2));
    }

    public void setTextAppearance(@Nullable TextAppearance textAppearance) {
        this.textDrawableHelper.setTextAppearance(textAppearance, this.context);
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public void setMinWidth(@Px int minWidth) {
        this.minWidth = minWidth;
        this.invalidateSelf();
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public void setMinHeight(@Px int minHeight) {
        this.minHeight = minHeight;
        this.invalidateSelf();
    }

    public int getTextPadding() {
        return this.padding;
    }

    public void setTextPadding(@Px int padding) {
        this.padding = padding;
        this.invalidateSelf();
    }

    public int getLayoutMargin() {
        return this.layoutMargin;
    }

    public void setLayoutMargin(@Px int layoutMargin) {
        this.layoutMargin = layoutMargin;
        this.invalidateSelf();
    }

    public void setRelativeToView(@Nullable View view) {
        if (view == null) {
            return;
        }
        this.updateLocationOnScreen(view);
        view.addOnLayoutChangeListener(this.attachedViewLayoutChangeListener);
    }

    public void detachView(@Nullable View view) {
        if (view == null) {
            return;
        }
        view.removeOnLayoutChangeListener(this.attachedViewLayoutChangeListener);
    }

    public int getIntrinsicWidth() {
        return (int)Math.max((float)(2 * this.padding) + this.getTextWidth(), (float)this.minWidth);
    }

    public int getIntrinsicHeight() {
        return (int)Math.max(this.textDrawableHelper.getTextPaint().getTextSize(), (float)this.minHeight);
    }

    @Override
    public void draw(@NonNull Canvas canvas) {
        canvas.save();
        float translateX = this.calculatePointerOffset();
        float translateY = (float)(-((double)this.arrowSize * Math.sqrt(2.0) - (double)this.arrowSize));
        canvas.translate(translateX, translateY);
        super.draw(canvas);
        this.drawText(canvas);
        canvas.restore();
    }

    @Override
    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.setShapeAppearanceModel(this.getShapeAppearanceModel().toBuilder().setBottomEdge(this.createMarkerEdge()).build());
    }

    @Override
    public boolean onStateChange(int[] state) {
        return super.onStateChange(state);
    }

    @Override
    public void onTextSizeChange() {
        this.invalidateSelf();
    }

    private void updateLocationOnScreen(@NonNull View v) {
        int[] locationOnScreen = new int[2];
        v.getLocationOnScreen(locationOnScreen);
        this.locationOnScreenX = locationOnScreen[0];
        v.getWindowVisibleDisplayFrame(this.displayFrame);
    }

    private float calculatePointerOffset() {
        float pointerOffset = 0.0f;
        if (this.displayFrame.right - this.getBounds().right - this.locationOnScreenX - this.layoutMargin < 0) {
            pointerOffset = this.displayFrame.right - this.getBounds().right - this.locationOnScreenX - this.layoutMargin;
        } else if (this.displayFrame.left - this.getBounds().left - this.locationOnScreenX + this.layoutMargin > 0) {
            pointerOffset = this.displayFrame.left - this.getBounds().left - this.locationOnScreenX + this.layoutMargin;
        }
        return pointerOffset;
    }

    private EdgeTreatment createMarkerEdge() {
        float offset = -this.calculatePointerOffset();
        float maxArrowOffset = (float)((double)this.getBounds().width() - (double)this.arrowSize * Math.sqrt(2.0)) / 2.0f;
        offset = Math.max(offset, -maxArrowOffset);
        offset = Math.min(offset, maxArrowOffset);
        return new OffsetEdgeTreatment(new MarkerEdgeTreatment(this.arrowSize), offset);
    }

    private void drawText(@NonNull Canvas canvas) {
        if (this.text == null) {
            return;
        }
        Rect bounds = this.getBounds();
        int y = (int)this.calculateTextOriginAndAlignment(bounds);
        if (this.textDrawableHelper.getTextAppearance() != null) {
            this.textDrawableHelper.getTextPaint().drawableState = this.getState();
            this.textDrawableHelper.updateTextPaintDrawState(this.context);
        }
        canvas.drawText(this.text, 0, this.text.length(), (float)bounds.centerX(), (float)y, (Paint)this.textDrawableHelper.getTextPaint());
    }

    private float getTextWidth() {
        if (this.text == null) {
            return 0.0f;
        }
        return this.textDrawableHelper.getTextWidth(this.text.toString());
    }

    private float calculateTextOriginAndAlignment(@NonNull Rect bounds) {
        return (float)bounds.centerY() - this.calculateTextCenterFromBaseline();
    }

    private float calculateTextCenterFromBaseline() {
        this.textDrawableHelper.getTextPaint().getFontMetrics(this.fontMetrics);
        return (this.fontMetrics.descent + this.fontMetrics.ascent) / 2.0f;
    }
}

