/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.transition;

import com.google.android.material.transition.FadeModeEvaluator;
import com.google.android.material.transition.FadeModeResult;
import com.google.android.material.transition.TransitionUtils;

class FadeModeEvaluators {
    private static final FadeModeEvaluator IN = new FadeModeEvaluator(){

        @Override
        public FadeModeResult evaluate(float progress, float fadeStartFraction, float fadeEndFraction) {
            int startAlpha = 255;
            int endAlpha = TransitionUtils.lerp(0, 255, fadeStartFraction, fadeEndFraction, progress);
            return FadeModeResult.endOnTop(startAlpha, endAlpha);
        }
    };
    private static final FadeModeEvaluator OUT = new FadeModeEvaluator(){

        @Override
        public FadeModeResult evaluate(float progress, float fadeStartFraction, float fadeEndFraction) {
            int startAlpha = TransitionUtils.lerp(255, 0, fadeStartFraction, fadeEndFraction, progress);
            int endAlpha = 255;
            return FadeModeResult.startOnTop(startAlpha, endAlpha);
        }
    };
    private static final FadeModeEvaluator CROSS = new FadeModeEvaluator(){

        @Override
        public FadeModeResult evaluate(float progress, float fadeStartFraction, float fadeEndFraction) {
            int startAlpha = TransitionUtils.lerp(255, 0, fadeStartFraction, fadeEndFraction, progress);
            int endAlpha = TransitionUtils.lerp(0, 255, fadeStartFraction, fadeEndFraction, progress);
            return FadeModeResult.startOnTop(startAlpha, endAlpha);
        }
    };
    private static final FadeModeEvaluator THROUGH = new FadeModeEvaluator(){

        @Override
        public FadeModeResult evaluate(float progress, float fadeStartFraction, float fadeEndFraction) {
            float fadeFractionDiff = fadeEndFraction - fadeStartFraction;
            float fadeFractionThreshold = fadeStartFraction + fadeFractionDiff * 0.35f;
            int startAlpha = TransitionUtils.lerp(255, 0, fadeStartFraction, fadeFractionThreshold, progress);
            int endAlpha = TransitionUtils.lerp(0, 255, fadeFractionThreshold, fadeEndFraction, progress);
            return FadeModeResult.startOnTop(startAlpha, endAlpha);
        }
    };

    static FadeModeEvaluator get(int fadeMode, boolean entering) {
        switch (fadeMode) {
            case 0: {
                return entering ? IN : OUT;
            }
            case 1: {
                return entering ? OUT : IN;
            }
            case 2: {
                return CROSS;
            }
            case 3: {
                return THROUGH;
            }
        }
        throw new IllegalArgumentException("Invalid fade mode: " + fadeMode);
    }

    private FadeModeEvaluators() {
    }
}

