/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.transition;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.material.transition.TransitionUtils;
import com.google.android.material.transition.VisibilityAnimatorProvider;

public final class FadeThroughProvider
implements VisibilityAnimatorProvider {
    static final float PROGRESS_THRESHOLD = 0.35f;

    @Override
    @Nullable
    public Animator createAppear(@NonNull ViewGroup sceneRoot, @NonNull View view) {
        return FadeThroughProvider.createFadeThroughAnimator(view, 0.0f, 1.0f, 0.35f, 1.0f);
    }

    @Override
    @Nullable
    public Animator createDisappear(@NonNull ViewGroup sceneRoot, @NonNull View view) {
        return FadeThroughProvider.createFadeThroughAnimator(view, 1.0f, 0.0f, 0.0f, 0.35f);
    }

    private static Animator createFadeThroughAnimator(final View view, final float startValue, final float endValue, final @FloatRange(from=0.0, to=1.0) float startFraction, final @FloatRange(from=0.0, to=1.0) float endFraction) {
        ValueAnimator animator2 = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        animator2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float progress = ((Float)animation.getAnimatedValue()).floatValue();
                view.setAlpha(TransitionUtils.lerp(startValue, endValue, startFraction, endFraction, progress));
            }
        });
        return animator2;
    }
}

