/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.transition;

import androidx.annotation.RestrictTo;
import com.google.android.material.transition.FadeThroughProvider;
import com.google.android.material.transition.MaterialVisibility;
import com.google.android.material.transition.ScaleProvider;
import com.google.android.material.transition.SlideDistanceProvider;
import com.google.android.material.transition.VisibilityAnimatorProvider;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class MaterialSharedAxis
extends MaterialVisibility<VisibilityAnimatorProvider> {
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = 2;
    private final int axis;
    private final boolean forward;

    public MaterialSharedAxis(int axis, boolean forward) {
        super(MaterialSharedAxis.createPrimaryAnimatorProvider(axis, forward), MaterialSharedAxis.createSecondaryAnimatorProvider());
        this.axis = axis;
        this.forward = forward;
    }

    public int getAxis() {
        return this.axis;
    }

    public boolean isForward() {
        return this.forward;
    }

    private static VisibilityAnimatorProvider createPrimaryAnimatorProvider(int axis, boolean forward) {
        switch (axis) {
            case 0: {
                return new SlideDistanceProvider(forward ? 0x800005 : 0x800003);
            }
            case 1: {
                return new SlideDistanceProvider(forward ? 80 : 48);
            }
            case 2: {
                return new ScaleProvider(forward);
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + axis);
    }

    private static VisibilityAnimatorProvider createSecondaryAnimatorProvider() {
        return new FadeThroughProvider();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface Axis {
    }
}

