/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.transition.platform;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.material.transition.platform.TransitionUtils;
import com.google.android.material.transition.platform.VisibilityAnimatorProvider;

@RequiresApi(value=21)
public final class FadeProvider
implements VisibilityAnimatorProvider {
    private float incomingEndThreshold = 1.0f;

    public float getIncomingEndThreshold() {
        return this.incomingEndThreshold;
    }

    public void setIncomingEndThreshold(float incomingEndThreshold) {
        this.incomingEndThreshold = incomingEndThreshold;
    }

    @Override
    @Nullable
    public Animator createAppear(@NonNull ViewGroup sceneRoot, @NonNull View view) {
        return FadeProvider.createFadeAnimator(view, 0.0f, 1.0f, 0.0f, this.incomingEndThreshold);
    }

    @Override
    @Nullable
    public Animator createDisappear(@NonNull ViewGroup sceneRoot, @NonNull View view) {
        return FadeProvider.createFadeAnimator(view, 1.0f, 0.0f, 0.0f, 1.0f);
    }

    private static Animator createFadeAnimator(final View view, final float startValue, final float endValue, final @FloatRange(from=0.0, to=1.0) float startFraction, final @FloatRange(from=0.0, to=1.0) float endFraction) {
        ValueAnimator animator2 = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        animator2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float progress = ((Float)animation.getAnimatedValue()).floatValue();
                view.setAlpha(TransitionUtils.lerp(startValue, endValue, startFraction, endFraction, progress));
            }
        });
        return animator2;
    }
}

