/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media;

import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.media.browse.MediaBrowser;
import android.os.BadParcelableException;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.support.v4.media.MediaDescriptionCompat;
import android.support.v4.media.session.IMediaSession;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v4.os.ResultReceiver;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.collection.ArrayMap;
import androidx.core.app.BundleCompat;
import androidx.media.MediaBrowserCompatUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class MediaBrowserCompat {
    static final String TAG = "MediaBrowserCompat";
    static final boolean DEBUG = Log.isLoggable((String)"MediaBrowserCompat", (int)3);
    public static final String EXTRA_PAGE = "android.media.browse.extra.PAGE";
    public static final String EXTRA_PAGE_SIZE = "android.media.browse.extra.PAGE_SIZE";
    public static final String EXTRA_MEDIA_ID = "android.media.browse.extra.MEDIA_ID";
    public static final String EXTRA_DOWNLOAD_PROGRESS = "android.media.browse.extra.DOWNLOAD_PROGRESS";
    public static final String CUSTOM_ACTION_DOWNLOAD = "android.support.v4.media.action.DOWNLOAD";
    public static final String CUSTOM_ACTION_REMOVE_DOWNLOADED_FILE = "android.support.v4.media.action.REMOVE_DOWNLOADED_FILE";
    private final MediaBrowserImpl mImpl;

    public MediaBrowserCompat(Context context, ComponentName serviceComponent, ConnectionCallback callback, Bundle rootHints) {
        this.mImpl = Build.VERSION.SDK_INT >= 26 ? new MediaBrowserImplApi26(context, serviceComponent, callback, rootHints) : (Build.VERSION.SDK_INT >= 23 ? new MediaBrowserImplApi23(context, serviceComponent, callback, rootHints) : (Build.VERSION.SDK_INT >= 21 ? new MediaBrowserImplApi21(context, serviceComponent, callback, rootHints) : new MediaBrowserImplBase(context, serviceComponent, callback, rootHints)));
    }

    public void connect() {
        Log.d((String)TAG, (String)"Connecting to a MediaBrowserService.");
        this.mImpl.connect();
    }

    public void disconnect() {
        this.mImpl.disconnect();
    }

    public boolean isConnected() {
        return this.mImpl.isConnected();
    }

    @NonNull
    public ComponentName getServiceComponent() {
        return this.mImpl.getServiceComponent();
    }

    @NonNull
    public String getRoot() {
        return this.mImpl.getRoot();
    }

    @Nullable
    public Bundle getExtras() {
        return this.mImpl.getExtras();
    }

    @NonNull
    public MediaSessionCompat.Token getSessionToken() {
        return this.mImpl.getSessionToken();
    }

    public void subscribe(@NonNull String parentId, @NonNull SubscriptionCallback callback) {
        if (TextUtils.isEmpty((CharSequence)parentId)) {
            throw new IllegalArgumentException("parentId is empty");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback is null");
        }
        this.mImpl.subscribe(parentId, null, callback);
    }

    public void subscribe(@NonNull String parentId, @NonNull Bundle options, @NonNull SubscriptionCallback callback) {
        if (TextUtils.isEmpty((CharSequence)parentId)) {
            throw new IllegalArgumentException("parentId is empty");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback is null");
        }
        if (options == null) {
            throw new IllegalArgumentException("options are null");
        }
        this.mImpl.subscribe(parentId, options, callback);
    }

    public void unsubscribe(@NonNull String parentId) {
        if (TextUtils.isEmpty((CharSequence)parentId)) {
            throw new IllegalArgumentException("parentId is empty");
        }
        this.mImpl.unsubscribe(parentId, null);
    }

    public void unsubscribe(@NonNull String parentId, @NonNull SubscriptionCallback callback) {
        if (TextUtils.isEmpty((CharSequence)parentId)) {
            throw new IllegalArgumentException("parentId is empty");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback is null");
        }
        this.mImpl.unsubscribe(parentId, callback);
    }

    public void getItem(@NonNull String mediaId, @NonNull ItemCallback cb) {
        this.mImpl.getItem(mediaId, cb);
    }

    public void search(@NonNull String query, Bundle extras, @NonNull SearchCallback callback) {
        if (TextUtils.isEmpty((CharSequence)query)) {
            throw new IllegalArgumentException("query cannot be empty");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        this.mImpl.search(query, extras, callback);
    }

    public void sendCustomAction(@NonNull String action, Bundle extras, @Nullable CustomActionCallback callback) {
        if (TextUtils.isEmpty((CharSequence)action)) {
            throw new IllegalArgumentException("action cannot be empty");
        }
        this.mImpl.sendCustomAction(action, extras, callback);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @Nullable
    public Bundle getNotifyChildrenChangedOptions() {
        return this.mImpl.getNotifyChildrenChangedOptions();
    }

    private static class CustomActionResultReceiver
    extends ResultReceiver {
        private final String mAction;
        private final Bundle mExtras;
        private final CustomActionCallback mCallback;

        CustomActionResultReceiver(String action, Bundle extras, CustomActionCallback callback, Handler handler) {
            super(handler);
            this.mAction = action;
            this.mExtras = extras;
            this.mCallback = callback;
        }

        protected void onReceiveResult(int resultCode, Bundle resultData) {
            if (this.mCallback == null) {
                return;
            }
            MediaSessionCompat.ensureClassLoader(resultData);
            switch (resultCode) {
                case 1: {
                    this.mCallback.onProgressUpdate(this.mAction, this.mExtras, resultData);
                    break;
                }
                case 0: {
                    this.mCallback.onResult(this.mAction, this.mExtras, resultData);
                    break;
                }
                case -1: {
                    this.mCallback.onError(this.mAction, this.mExtras, resultData);
                    break;
                }
                default: {
                    Log.w((String)MediaBrowserCompat.TAG, (String)("Unknown result code: " + resultCode + " (extras=" + this.mExtras + ", resultData=" + resultData + ")"));
                }
            }
        }
    }

    private static class SearchResultReceiver
    extends ResultReceiver {
        private final String mQuery;
        private final Bundle mExtras;
        private final SearchCallback mCallback;

        SearchResultReceiver(String query, Bundle extras, SearchCallback callback, Handler handler) {
            super(handler);
            this.mQuery = query;
            this.mExtras = extras;
            this.mCallback = callback;
        }

        protected void onReceiveResult(int resultCode, Bundle resultData) {
            if (resultData != null) {
                resultData = MediaSessionCompat.unparcelWithClassLoader(resultData);
            }
            if (resultCode != 0 || resultData == null || !resultData.containsKey("search_results")) {
                this.mCallback.onError(this.mQuery, this.mExtras);
                return;
            }
            Parcelable[] items = resultData.getParcelableArray("search_results");
            if (items != null) {
                ArrayList<MediaItem> results = new ArrayList<MediaItem>();
                for (Parcelable item : items) {
                    results.add((MediaItem)item);
                }
                this.mCallback.onSearchResult(this.mQuery, this.mExtras, results);
            } else {
                this.mCallback.onError(this.mQuery, this.mExtras);
            }
        }
    }

    private static class ItemReceiver
    extends ResultReceiver {
        private final String mMediaId;
        private final ItemCallback mCallback;

        ItemReceiver(String mediaId, ItemCallback callback, Handler handler) {
            super(handler);
            this.mMediaId = mediaId;
            this.mCallback = callback;
        }

        protected void onReceiveResult(int resultCode, Bundle resultData) {
            if (resultData != null) {
                resultData = MediaSessionCompat.unparcelWithClassLoader(resultData);
            }
            if (resultCode != 0 || resultData == null || !resultData.containsKey("media_item")) {
                this.mCallback.onError(this.mMediaId);
                return;
            }
            Parcelable item = resultData.getParcelable("media_item");
            if (item == null || item instanceof MediaItem) {
                this.mCallback.onItemLoaded((MediaItem)item);
            } else {
                this.mCallback.onError(this.mMediaId);
            }
        }
    }

    private static class ServiceBinderWrapper {
        private Messenger mMessenger;
        private Bundle mRootHints;

        public ServiceBinderWrapper(IBinder target, Bundle rootHints) {
            this.mMessenger = new Messenger(target);
            this.mRootHints = rootHints;
        }

        void connect(Context context, Messenger callbacksMessenger) throws RemoteException {
            Bundle data = new Bundle();
            data.putString("data_package_name", context.getPackageName());
            data.putInt("data_calling_pid", Process.myPid());
            data.putBundle("data_root_hints", this.mRootHints);
            this.sendRequest(1, data, callbacksMessenger);
        }

        void disconnect(Messenger callbacksMessenger) throws RemoteException {
            this.sendRequest(2, null, callbacksMessenger);
        }

        void addSubscription(String parentId, IBinder callbackToken, Bundle options, Messenger callbacksMessenger) throws RemoteException {
            Bundle data = new Bundle();
            data.putString("data_media_item_id", parentId);
            BundleCompat.putBinder((Bundle)data, (String)"data_callback_token", (IBinder)callbackToken);
            data.putBundle("data_options", options);
            this.sendRequest(3, data, callbacksMessenger);
        }

        void removeSubscription(String parentId, IBinder callbackToken, Messenger callbacksMessenger) throws RemoteException {
            Bundle data = new Bundle();
            data.putString("data_media_item_id", parentId);
            BundleCompat.putBinder((Bundle)data, (String)"data_callback_token", (IBinder)callbackToken);
            this.sendRequest(4, data, callbacksMessenger);
        }

        void getMediaItem(String mediaId, ResultReceiver receiver, Messenger callbacksMessenger) throws RemoteException {
            Bundle data = new Bundle();
            data.putString("data_media_item_id", mediaId);
            data.putParcelable("data_result_receiver", (Parcelable)receiver);
            this.sendRequest(5, data, callbacksMessenger);
        }

        void registerCallbackMessenger(Context context, Messenger callbackMessenger) throws RemoteException {
            Bundle data = new Bundle();
            data.putString("data_package_name", context.getPackageName());
            data.putInt("data_calling_pid", Process.myPid());
            data.putBundle("data_root_hints", this.mRootHints);
            this.sendRequest(6, data, callbackMessenger);
        }

        void unregisterCallbackMessenger(Messenger callbackMessenger) throws RemoteException {
            this.sendRequest(7, null, callbackMessenger);
        }

        void search(String query, Bundle extras, ResultReceiver receiver, Messenger callbacksMessenger) throws RemoteException {
            Bundle data = new Bundle();
            data.putString("data_search_query", query);
            data.putBundle("data_search_extras", extras);
            data.putParcelable("data_result_receiver", (Parcelable)receiver);
            this.sendRequest(8, data, callbacksMessenger);
        }

        void sendCustomAction(String action, Bundle extras, ResultReceiver receiver, Messenger callbacksMessenger) throws RemoteException {
            Bundle data = new Bundle();
            data.putString("data_custom_action", action);
            data.putBundle("data_custom_action_extras", extras);
            data.putParcelable("data_result_receiver", (Parcelable)receiver);
            this.sendRequest(9, data, callbacksMessenger);
        }

        private void sendRequest(int what, Bundle data, Messenger cbMessenger) throws RemoteException {
            Message msg = Message.obtain();
            msg.what = what;
            msg.arg1 = 1;
            msg.setData(data);
            msg.replyTo = cbMessenger;
            this.mMessenger.send(msg);
        }
    }

    private static class CallbackHandler
    extends Handler {
        private final WeakReference<MediaBrowserServiceCallbackImpl> mCallbackImplRef;
        private WeakReference<Messenger> mCallbacksMessengerRef;

        CallbackHandler(MediaBrowserServiceCallbackImpl callbackImpl) {
            this.mCallbackImplRef = new WeakReference<MediaBrowserServiceCallbackImpl>(callbackImpl);
        }

        public void handleMessage(@NonNull Message msg) {
            block8: {
                if (this.mCallbacksMessengerRef == null || this.mCallbacksMessengerRef.get() == null || this.mCallbackImplRef.get() == null) {
                    return;
                }
                Bundle data = msg.getData();
                MediaSessionCompat.ensureClassLoader(data);
                MediaBrowserServiceCallbackImpl serviceCallback = (MediaBrowserServiceCallbackImpl)this.mCallbackImplRef.get();
                Messenger callbacksMessenger = (Messenger)this.mCallbacksMessengerRef.get();
                try {
                    switch (msg.what) {
                        case 1: {
                            Bundle rootHints = data.getBundle("data_root_hints");
                            MediaSessionCompat.ensureClassLoader(rootHints);
                            serviceCallback.onServiceConnected(callbacksMessenger, data.getString("data_media_item_id"), (MediaSessionCompat.Token)data.getParcelable("data_media_session_token"), rootHints);
                            break;
                        }
                        case 2: {
                            serviceCallback.onConnectionFailed(callbacksMessenger);
                            break;
                        }
                        case 3: {
                            Bundle options = data.getBundle("data_options");
                            MediaSessionCompat.ensureClassLoader(options);
                            Bundle notifyChildrenChangedOptions = data.getBundle("data_notify_children_changed_options");
                            MediaSessionCompat.ensureClassLoader(notifyChildrenChangedOptions);
                            serviceCallback.onLoadChildren(callbacksMessenger, data.getString("data_media_item_id"), data.getParcelableArrayList("data_media_item_list"), options, notifyChildrenChangedOptions);
                            break;
                        }
                        default: {
                            Log.w((String)MediaBrowserCompat.TAG, (String)("Unhandled message: " + msg + "\n  Client version: " + 1 + "\n  Service version: " + msg.arg1));
                            break;
                        }
                    }
                }
                catch (BadParcelableException e) {
                    Log.e((String)MediaBrowserCompat.TAG, (String)"Could not unparcel the data.");
                    if (msg.what != 1) break block8;
                    serviceCallback.onConnectionFailed(callbacksMessenger);
                }
            }
        }

        void setCallbacksMessenger(Messenger callbacksMessenger) {
            this.mCallbacksMessengerRef = new WeakReference<Messenger>(callbacksMessenger);
        }
    }

    private static class Subscription {
        private final List<SubscriptionCallback> mCallbacks = new ArrayList<SubscriptionCallback>();
        private final List<Bundle> mOptionsList = new ArrayList<Bundle>();

        public boolean isEmpty() {
            return this.mCallbacks.isEmpty();
        }

        public List<Bundle> getOptionsList() {
            return this.mOptionsList;
        }

        public List<SubscriptionCallback> getCallbacks() {
            return this.mCallbacks;
        }

        public SubscriptionCallback getCallback(Bundle options) {
            for (int i = 0; i < this.mOptionsList.size(); ++i) {
                if (!MediaBrowserCompatUtils.areSameOptions(this.mOptionsList.get(i), options)) continue;
                return this.mCallbacks.get(i);
            }
            return null;
        }

        public void putCallback(Bundle options, SubscriptionCallback callback) {
            for (int i = 0; i < this.mOptionsList.size(); ++i) {
                if (!MediaBrowserCompatUtils.areSameOptions(this.mOptionsList.get(i), options)) continue;
                this.mCallbacks.set(i, callback);
                return;
            }
            this.mCallbacks.add(callback);
            this.mOptionsList.add(options);
        }
    }

    @RequiresApi(value=26)
    static class MediaBrowserImplApi26
    extends MediaBrowserImplApi23 {
        MediaBrowserImplApi26(Context context, ComponentName serviceComponent, ConnectionCallback callback, Bundle rootHints) {
            super(context, serviceComponent, callback, rootHints);
        }

        @Override
        public void subscribe(@NonNull String parentId, @Nullable Bundle options, @NonNull SubscriptionCallback callback) {
            if (this.mServiceBinderWrapper == null || this.mServiceVersion < 2) {
                if (options == null) {
                    this.mBrowserFwk.subscribe(parentId, callback.mSubscriptionCallbackFwk);
                } else {
                    this.mBrowserFwk.subscribe(parentId, options, callback.mSubscriptionCallbackFwk);
                }
            } else {
                super.subscribe(parentId, options, callback);
            }
        }

        @Override
        public void unsubscribe(@NonNull String parentId, SubscriptionCallback callback) {
            if (this.mServiceBinderWrapper == null || this.mServiceVersion < 2) {
                if (callback == null) {
                    this.mBrowserFwk.unsubscribe(parentId);
                } else {
                    this.mBrowserFwk.unsubscribe(parentId, callback.mSubscriptionCallbackFwk);
                }
            } else {
                super.unsubscribe(parentId, callback);
            }
        }
    }

    @RequiresApi(value=23)
    static class MediaBrowserImplApi23
    extends MediaBrowserImplApi21 {
        MediaBrowserImplApi23(Context context, ComponentName serviceComponent, ConnectionCallback callback, Bundle rootHints) {
            super(context, serviceComponent, callback, rootHints);
        }

        @Override
        public void getItem(@NonNull String mediaId, @NonNull ItemCallback cb) {
            if (this.mServiceBinderWrapper == null) {
                this.mBrowserFwk.getItem(mediaId, cb.mItemCallbackFwk);
            } else {
                super.getItem(mediaId, cb);
            }
        }
    }

    @RequiresApi(value=21)
    static class MediaBrowserImplApi21
    implements MediaBrowserImpl,
    MediaBrowserServiceCallbackImpl,
    ConnectionCallback.ConnectionCallbackInternal {
        final Context mContext;
        protected final MediaBrowser mBrowserFwk;
        protected final Bundle mRootHints;
        protected final CallbackHandler mHandler = new CallbackHandler(this);
        private final ArrayMap<String, Subscription> mSubscriptions = new ArrayMap();
        protected int mServiceVersion;
        protected ServiceBinderWrapper mServiceBinderWrapper;
        protected Messenger mCallbacksMessenger;
        private MediaSessionCompat.Token mMediaSessionToken;
        private Bundle mNotifyChildrenChangedOptions;

        MediaBrowserImplApi21(Context context, ComponentName serviceComponent, ConnectionCallback callback, Bundle rootHints) {
            this.mContext = context;
            this.mRootHints = rootHints != null ? new Bundle(rootHints) : new Bundle();
            this.mRootHints.putInt("extra_client_version", 1);
            this.mRootHints.putInt("extra_calling_pid", Process.myPid());
            callback.setInternalConnectionCallback(this);
            this.mBrowserFwk = new MediaBrowser(context, serviceComponent, callback.mConnectionCallbackFwk, this.mRootHints);
        }

        @Override
        public void connect() {
            this.mBrowserFwk.connect();
        }

        @Override
        public void disconnect() {
            if (this.mServiceBinderWrapper != null && this.mCallbacksMessenger != null) {
                try {
                    this.mServiceBinderWrapper.unregisterCallbackMessenger(this.mCallbacksMessenger);
                }
                catch (RemoteException e) {
                    Log.i((String)MediaBrowserCompat.TAG, (String)"Remote error unregistering client messenger.");
                }
            }
            this.mBrowserFwk.disconnect();
        }

        @Override
        public boolean isConnected() {
            return this.mBrowserFwk.isConnected();
        }

        @Override
        public ComponentName getServiceComponent() {
            return this.mBrowserFwk.getServiceComponent();
        }

        @Override
        @NonNull
        public String getRoot() {
            return this.mBrowserFwk.getRoot();
        }

        @Override
        @Nullable
        public Bundle getExtras() {
            return this.mBrowserFwk.getExtras();
        }

        @Override
        @NonNull
        public MediaSessionCompat.Token getSessionToken() {
            if (this.mMediaSessionToken == null) {
                this.mMediaSessionToken = MediaSessionCompat.Token.fromToken(this.mBrowserFwk.getSessionToken());
            }
            return this.mMediaSessionToken;
        }

        @Override
        public void subscribe(@NonNull String parentId, Bundle options, @NonNull SubscriptionCallback callback) {
            Subscription sub = (Subscription)this.mSubscriptions.get((Object)parentId);
            if (sub == null) {
                sub = new Subscription();
                this.mSubscriptions.put((Object)parentId, (Object)sub);
            }
            callback.setSubscription(sub);
            Bundle copiedOptions = options == null ? null : new Bundle(options);
            sub.putCallback(copiedOptions, callback);
            if (this.mServiceBinderWrapper == null) {
                this.mBrowserFwk.subscribe(parentId, callback.mSubscriptionCallbackFwk);
            } else {
                try {
                    this.mServiceBinderWrapper.addSubscription(parentId, callback.mToken, copiedOptions, this.mCallbacksMessenger);
                }
                catch (RemoteException e) {
                    Log.i((String)MediaBrowserCompat.TAG, (String)("Remote error subscribing media item: " + parentId));
                }
            }
        }

        @Override
        public void unsubscribe(@NonNull String parentId, SubscriptionCallback callback) {
            Subscription sub = (Subscription)this.mSubscriptions.get((Object)parentId);
            if (sub == null) {
                return;
            }
            if (this.mServiceBinderWrapper == null) {
                if (callback == null) {
                    this.mBrowserFwk.unsubscribe(parentId);
                } else {
                    List<SubscriptionCallback> callbacks = sub.getCallbacks();
                    List<Bundle> optionsList = sub.getOptionsList();
                    for (int i = callbacks.size() - 1; i >= 0; --i) {
                        if (callbacks.get(i) != callback) continue;
                        callbacks.remove(i);
                        optionsList.remove(i);
                    }
                    if (callbacks.size() == 0) {
                        this.mBrowserFwk.unsubscribe(parentId);
                    }
                }
            } else {
                try {
                    if (callback == null) {
                        this.mServiceBinderWrapper.removeSubscription(parentId, null, this.mCallbacksMessenger);
                    } else {
                        List<SubscriptionCallback> callbacks = sub.getCallbacks();
                        List<Bundle> optionsList = sub.getOptionsList();
                        for (int i = callbacks.size() - 1; i >= 0; --i) {
                            if (callbacks.get(i) != callback) continue;
                            this.mServiceBinderWrapper.removeSubscription(parentId, callback.mToken, this.mCallbacksMessenger);
                            callbacks.remove(i);
                            optionsList.remove(i);
                        }
                    }
                }
                catch (RemoteException ex) {
                    Log.d((String)MediaBrowserCompat.TAG, (String)("removeSubscription failed with RemoteException parentId=" + parentId));
                }
            }
            if (sub.isEmpty() || callback == null) {
                this.mSubscriptions.remove((Object)parentId);
            }
        }

        @Override
        public void getItem(final @NonNull String mediaId, final @NonNull ItemCallback cb) {
            if (TextUtils.isEmpty((CharSequence)mediaId)) {
                throw new IllegalArgumentException("mediaId is empty");
            }
            if (cb == null) {
                throw new IllegalArgumentException("cb is null");
            }
            if (!this.mBrowserFwk.isConnected()) {
                Log.i((String)MediaBrowserCompat.TAG, (String)"Not connected, unable to retrieve the MediaItem.");
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        cb.onError(mediaId);
                    }
                });
                return;
            }
            if (this.mServiceBinderWrapper == null) {
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        cb.onError(mediaId);
                    }
                });
                return;
            }
            ItemReceiver receiver = new ItemReceiver(mediaId, cb, this.mHandler);
            try {
                this.mServiceBinderWrapper.getMediaItem(mediaId, receiver, this.mCallbacksMessenger);
            }
            catch (RemoteException e) {
                Log.i((String)MediaBrowserCompat.TAG, (String)("Remote error getting media item: " + mediaId));
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        cb.onError(mediaId);
                    }
                });
            }
        }

        @Override
        public void search(final @NonNull String query, final Bundle extras, final @NonNull SearchCallback callback) {
            if (!this.isConnected()) {
                throw new IllegalStateException("search() called while not connected");
            }
            if (this.mServiceBinderWrapper == null) {
                Log.i((String)MediaBrowserCompat.TAG, (String)"The connected service doesn't support search.");
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onError(query, extras);
                    }
                });
                return;
            }
            SearchResultReceiver receiver = new SearchResultReceiver(query, extras, callback, this.mHandler);
            try {
                this.mServiceBinderWrapper.search(query, extras, receiver, this.mCallbacksMessenger);
            }
            catch (RemoteException e) {
                Log.i((String)MediaBrowserCompat.TAG, (String)("Remote error searching items with query: " + query), (Throwable)e);
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onError(query, extras);
                    }
                });
            }
        }

        @Override
        public void sendCustomAction(final @NonNull String action, final Bundle extras, final @Nullable CustomActionCallback callback) {
            block5: {
                if (!this.isConnected()) {
                    throw new IllegalStateException("Cannot send a custom action (" + action + ") with extras " + extras + " because the browser is not connected to the service.");
                }
                if (this.mServiceBinderWrapper == null) {
                    Log.i((String)MediaBrowserCompat.TAG, (String)"The connected service doesn't support sendCustomAction.");
                    if (callback != null) {
                        this.mHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                callback.onError(action, extras, null);
                            }
                        });
                    }
                }
                CustomActionResultReceiver receiver = new CustomActionResultReceiver(action, extras, callback, this.mHandler);
                try {
                    this.mServiceBinderWrapper.sendCustomAction(action, extras, receiver, this.mCallbacksMessenger);
                }
                catch (RemoteException e) {
                    Log.i((String)MediaBrowserCompat.TAG, (String)("Remote error sending a custom action: action=" + action + ", extras=" + extras), (Throwable)e);
                    if (callback == null) break block5;
                    this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onError(action, extras, null);
                        }
                    });
                }
            }
        }

        @Override
        public void onConnected() {
            IMediaSession sessionToken;
            Bundle extras;
            try {
                extras = this.mBrowserFwk.getExtras();
            }
            catch (IllegalStateException e) {
                Log.e((String)MediaBrowserCompat.TAG, (String)"Unexpected IllegalStateException", (Throwable)e);
                return;
            }
            if (extras == null) {
                return;
            }
            this.mServiceVersion = extras.getInt("extra_service_version", 0);
            IBinder serviceBinder = BundleCompat.getBinder((Bundle)extras, (String)"extra_messenger");
            if (serviceBinder != null) {
                this.mServiceBinderWrapper = new ServiceBinderWrapper(serviceBinder, this.mRootHints);
                this.mCallbacksMessenger = new Messenger((Handler)this.mHandler);
                this.mHandler.setCallbacksMessenger(this.mCallbacksMessenger);
                try {
                    this.mServiceBinderWrapper.registerCallbackMessenger(this.mContext, this.mCallbacksMessenger);
                }
                catch (RemoteException e) {
                    Log.i((String)MediaBrowserCompat.TAG, (String)"Remote error registering client messenger.");
                }
            }
            if ((sessionToken = IMediaSession.Stub.asInterface(BundleCompat.getBinder((Bundle)extras, (String)"extra_session_binder"))) != null) {
                this.mMediaSessionToken = MediaSessionCompat.Token.fromToken(this.mBrowserFwk.getSessionToken(), sessionToken);
            }
        }

        @Override
        public void onConnectionSuspended() {
            this.mServiceBinderWrapper = null;
            this.mCallbacksMessenger = null;
            this.mMediaSessionToken = null;
            this.mHandler.setCallbacksMessenger(null);
        }

        @Override
        public void onConnectionFailed() {
        }

        @Override
        public void onServiceConnected(Messenger callback, String root, MediaSessionCompat.Token session, Bundle extra) {
        }

        @Override
        public void onConnectionFailed(Messenger callback) {
        }

        @Override
        public void onLoadChildren(Messenger callback, String parentId, List<MediaItem> list, Bundle options, Bundle notifyChildrenChangedOptions) {
            if (this.mCallbacksMessenger != callback) {
                return;
            }
            Subscription subscription = (Subscription)this.mSubscriptions.get((Object)parentId);
            if (subscription == null) {
                if (DEBUG) {
                    Log.d((String)MediaBrowserCompat.TAG, (String)("onLoadChildren for id that isn't subscribed id=" + parentId));
                }
                return;
            }
            SubscriptionCallback subscriptionCallback = subscription.getCallback(options);
            if (subscriptionCallback != null) {
                if (options == null) {
                    if (list == null) {
                        subscriptionCallback.onError(parentId);
                    } else {
                        this.mNotifyChildrenChangedOptions = notifyChildrenChangedOptions;
                        subscriptionCallback.onChildrenLoaded(parentId, list);
                        this.mNotifyChildrenChangedOptions = null;
                    }
                } else if (list == null) {
                    subscriptionCallback.onError(parentId, options);
                } else {
                    this.mNotifyChildrenChangedOptions = notifyChildrenChangedOptions;
                    subscriptionCallback.onChildrenLoaded(parentId, list, options);
                    this.mNotifyChildrenChangedOptions = null;
                }
            }
        }

        @Override
        public Bundle getNotifyChildrenChangedOptions() {
            return this.mNotifyChildrenChangedOptions;
        }
    }

    static class MediaBrowserImplBase
    implements MediaBrowserImpl,
    MediaBrowserServiceCallbackImpl {
        static final int CONNECT_STATE_DISCONNECTING = 0;
        static final int CONNECT_STATE_DISCONNECTED = 1;
        static final int CONNECT_STATE_CONNECTING = 2;
        static final int CONNECT_STATE_CONNECTED = 3;
        static final int CONNECT_STATE_SUSPENDED = 4;
        final Context mContext;
        final ComponentName mServiceComponent;
        final ConnectionCallback mCallback;
        final Bundle mRootHints;
        final CallbackHandler mHandler = new CallbackHandler(this);
        private final ArrayMap<String, Subscription> mSubscriptions = new ArrayMap();
        int mState = 1;
        MediaServiceConnection mServiceConnection;
        ServiceBinderWrapper mServiceBinderWrapper;
        Messenger mCallbacksMessenger;
        private String mRootId;
        private MediaSessionCompat.Token mMediaSessionToken;
        private Bundle mExtras;
        private Bundle mNotifyChildrenChangedOptions;

        public MediaBrowserImplBase(Context context, ComponentName serviceComponent, ConnectionCallback callback, Bundle rootHints) {
            if (context == null) {
                throw new IllegalArgumentException("context must not be null");
            }
            if (serviceComponent == null) {
                throw new IllegalArgumentException("service component must not be null");
            }
            if (callback == null) {
                throw new IllegalArgumentException("connection callback must not be null");
            }
            this.mContext = context;
            this.mServiceComponent = serviceComponent;
            this.mCallback = callback;
            this.mRootHints = rootHints == null ? null : new Bundle(rootHints);
        }

        @Override
        public void connect() {
            if (this.mState != 0 && this.mState != 1) {
                throw new IllegalStateException("connect() called while neigther disconnecting nor disconnected (state=" + MediaBrowserImplBase.getStateLabel(this.mState) + ")");
            }
            this.mState = 2;
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (mState == 0) {
                        return;
                    }
                    mState = 2;
                    if (DEBUG && mServiceConnection != null) {
                        throw new RuntimeException("mServiceConnection should be null. Instead it is " + mServiceConnection);
                    }
                    if (mServiceBinderWrapper != null) {
                        throw new RuntimeException("mServiceBinderWrapper should be null. Instead it is " + mServiceBinderWrapper);
                    }
                    if (mCallbacksMessenger != null) {
                        throw new RuntimeException("mCallbacksMessenger should be null. Instead it is " + mCallbacksMessenger);
                    }
                    Intent intent = new Intent("android.media.browse.MediaBrowserService");
                    intent.setComponent(mServiceComponent);
                    mServiceConnection = new MediaServiceConnection();
                    boolean bound = false;
                    try {
                        bound = mContext.bindService(intent, (ServiceConnection)mServiceConnection, 1);
                    }
                    catch (Exception ex) {
                        Log.e((String)MediaBrowserCompat.TAG, (String)("Failed binding to service " + mServiceComponent));
                    }
                    if (!bound) {
                        this.forceCloseConnection();
                        mCallback.onConnectionFailed();
                    }
                    if (DEBUG) {
                        Log.d((String)MediaBrowserCompat.TAG, (String)"connect...");
                        this.dump();
                    }
                }
            });
        }

        @Override
        public void disconnect() {
            this.mState = 0;
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (mCallbacksMessenger != null) {
                        try {
                            mServiceBinderWrapper.disconnect(mCallbacksMessenger);
                        }
                        catch (RemoteException ex) {
                            Log.w((String)MediaBrowserCompat.TAG, (String)("RemoteException during connect for " + mServiceComponent));
                        }
                    }
                    int state = mState;
                    this.forceCloseConnection();
                    if (state != 0) {
                        mState = state;
                    }
                    if (DEBUG) {
                        Log.d((String)MediaBrowserCompat.TAG, (String)"disconnect...");
                        this.dump();
                    }
                }
            });
        }

        void forceCloseConnection() {
            if (this.mServiceConnection != null) {
                this.mContext.unbindService((ServiceConnection)this.mServiceConnection);
            }
            this.mState = 1;
            this.mServiceConnection = null;
            this.mServiceBinderWrapper = null;
            this.mCallbacksMessenger = null;
            this.mHandler.setCallbacksMessenger(null);
            this.mRootId = null;
            this.mMediaSessionToken = null;
        }

        @Override
        public boolean isConnected() {
            return this.mState == 3;
        }

        @Override
        @NonNull
        public ComponentName getServiceComponent() {
            if (!this.isConnected()) {
                throw new IllegalStateException("getServiceComponent() called while not connected (state=" + this.mState + ")");
            }
            return this.mServiceComponent;
        }

        @Override
        @NonNull
        public String getRoot() {
            if (!this.isConnected()) {
                throw new IllegalStateException("getRoot() called while not connected(state=" + MediaBrowserImplBase.getStateLabel(this.mState) + ")");
            }
            return this.mRootId;
        }

        @Override
        @Nullable
        public Bundle getExtras() {
            if (!this.isConnected()) {
                throw new IllegalStateException("getExtras() called while not connected (state=" + MediaBrowserImplBase.getStateLabel(this.mState) + ")");
            }
            return this.mExtras;
        }

        @Override
        @NonNull
        public MediaSessionCompat.Token getSessionToken() {
            if (!this.isConnected()) {
                throw new IllegalStateException("getSessionToken() called while not connected(state=" + this.mState + ")");
            }
            return this.mMediaSessionToken;
        }

        @Override
        public void subscribe(@NonNull String parentId, Bundle options, @NonNull SubscriptionCallback callback) {
            Subscription sub = (Subscription)this.mSubscriptions.get((Object)parentId);
            if (sub == null) {
                sub = new Subscription();
                this.mSubscriptions.put((Object)parentId, (Object)sub);
            }
            Bundle copiedOptions = options == null ? null : new Bundle(options);
            sub.putCallback(copiedOptions, callback);
            if (this.isConnected()) {
                try {
                    this.mServiceBinderWrapper.addSubscription(parentId, callback.mToken, copiedOptions, this.mCallbacksMessenger);
                }
                catch (RemoteException e) {
                    Log.d((String)MediaBrowserCompat.TAG, (String)("addSubscription failed with RemoteException parentId=" + parentId));
                }
            }
        }

        @Override
        public void unsubscribe(@NonNull String parentId, SubscriptionCallback callback) {
            Subscription sub = (Subscription)this.mSubscriptions.get((Object)parentId);
            if (sub == null) {
                return;
            }
            try {
                if (callback == null) {
                    if (this.isConnected()) {
                        this.mServiceBinderWrapper.removeSubscription(parentId, null, this.mCallbacksMessenger);
                    }
                } else {
                    List<SubscriptionCallback> callbacks = sub.getCallbacks();
                    List<Bundle> optionsList = sub.getOptionsList();
                    for (int i = callbacks.size() - 1; i >= 0; --i) {
                        if (callbacks.get(i) != callback) continue;
                        if (this.isConnected()) {
                            this.mServiceBinderWrapper.removeSubscription(parentId, callback.mToken, this.mCallbacksMessenger);
                        }
                        callbacks.remove(i);
                        optionsList.remove(i);
                    }
                }
            }
            catch (RemoteException ex) {
                Log.d((String)MediaBrowserCompat.TAG, (String)("removeSubscription failed with RemoteException parentId=" + parentId));
            }
            if (sub.isEmpty() || callback == null) {
                this.mSubscriptions.remove((Object)parentId);
            }
        }

        @Override
        public void getItem(final @NonNull String mediaId, final @NonNull ItemCallback cb) {
            if (TextUtils.isEmpty((CharSequence)mediaId)) {
                throw new IllegalArgumentException("mediaId is empty");
            }
            if (cb == null) {
                throw new IllegalArgumentException("cb is null");
            }
            if (!this.isConnected()) {
                Log.i((String)MediaBrowserCompat.TAG, (String)"Not connected, unable to retrieve the MediaItem.");
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        cb.onError(mediaId);
                    }
                });
                return;
            }
            ItemReceiver receiver = new ItemReceiver(mediaId, cb, this.mHandler);
            try {
                this.mServiceBinderWrapper.getMediaItem(mediaId, receiver, this.mCallbacksMessenger);
            }
            catch (RemoteException e) {
                Log.i((String)MediaBrowserCompat.TAG, (String)("Remote error getting media item: " + mediaId));
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        cb.onError(mediaId);
                    }
                });
            }
        }

        @Override
        public void search(final @NonNull String query, final Bundle extras, final @NonNull SearchCallback callback) {
            if (!this.isConnected()) {
                throw new IllegalStateException("search() called while not connected (state=" + MediaBrowserImplBase.getStateLabel(this.mState) + ")");
            }
            SearchResultReceiver receiver = new SearchResultReceiver(query, extras, callback, this.mHandler);
            try {
                this.mServiceBinderWrapper.search(query, extras, receiver, this.mCallbacksMessenger);
            }
            catch (RemoteException e) {
                Log.i((String)MediaBrowserCompat.TAG, (String)("Remote error searching items with query: " + query), (Throwable)e);
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onError(query, extras);
                    }
                });
            }
        }

        @Override
        public void sendCustomAction(final @NonNull String action, final Bundle extras, final @Nullable CustomActionCallback callback) {
            block3: {
                if (!this.isConnected()) {
                    throw new IllegalStateException("Cannot send a custom action (" + action + ") with extras " + extras + " because the browser is not connected to the service.");
                }
                CustomActionResultReceiver receiver = new CustomActionResultReceiver(action, extras, callback, this.mHandler);
                try {
                    this.mServiceBinderWrapper.sendCustomAction(action, extras, receiver, this.mCallbacksMessenger);
                }
                catch (RemoteException e) {
                    Log.i((String)MediaBrowserCompat.TAG, (String)("Remote error sending a custom action: action=" + action + ", extras=" + extras), (Throwable)e);
                    if (callback == null) break block3;
                    this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onError(action, extras, null);
                        }
                    });
                }
            }
        }

        @Override
        public void onServiceConnected(Messenger callback, String root, MediaSessionCompat.Token session, Bundle extra) {
            if (!this.isCurrent(callback, "onConnect")) {
                return;
            }
            if (this.mState != 2) {
                Log.w((String)MediaBrowserCompat.TAG, (String)("onConnect from service while mState=" + MediaBrowserImplBase.getStateLabel(this.mState) + "... ignoring"));
                return;
            }
            this.mRootId = root;
            this.mMediaSessionToken = session;
            this.mExtras = extra;
            this.mState = 3;
            if (DEBUG) {
                Log.d((String)MediaBrowserCompat.TAG, (String)"ServiceCallbacks.onConnect...");
                this.dump();
            }
            this.mCallback.onConnected();
            try {
                for (Map.Entry subscriptionEntry : this.mSubscriptions.entrySet()) {
                    String id2 = (String)subscriptionEntry.getKey();
                    Subscription sub = (Subscription)subscriptionEntry.getValue();
                    List<SubscriptionCallback> callbackList = sub.getCallbacks();
                    List<Bundle> optionsList = sub.getOptionsList();
                    for (int i = 0; i < callbackList.size(); ++i) {
                        this.mServiceBinderWrapper.addSubscription(id2, callbackList.get((int)i).mToken, optionsList.get(i), this.mCallbacksMessenger);
                    }
                }
            }
            catch (RemoteException ex) {
                Log.d((String)MediaBrowserCompat.TAG, (String)"addSubscription failed with RemoteException.");
            }
        }

        @Override
        public void onConnectionFailed(Messenger callback) {
            Log.e((String)MediaBrowserCompat.TAG, (String)("onConnectFailed for " + this.mServiceComponent));
            if (!this.isCurrent(callback, "onConnectFailed")) {
                return;
            }
            if (this.mState != 2) {
                Log.w((String)MediaBrowserCompat.TAG, (String)("onConnect from service while mState=" + MediaBrowserImplBase.getStateLabel(this.mState) + "... ignoring"));
                return;
            }
            this.forceCloseConnection();
            this.mCallback.onConnectionFailed();
        }

        @Override
        public void onLoadChildren(Messenger callback, String parentId, List<MediaItem> list, Bundle options, Bundle notifyChildrenChangedOptions) {
            Subscription subscription;
            if (!this.isCurrent(callback, "onLoadChildren")) {
                return;
            }
            if (DEBUG) {
                Log.d((String)MediaBrowserCompat.TAG, (String)("onLoadChildren for " + this.mServiceComponent + " id=" + parentId));
            }
            if ((subscription = (Subscription)this.mSubscriptions.get((Object)parentId)) == null) {
                if (DEBUG) {
                    Log.d((String)MediaBrowserCompat.TAG, (String)("onLoadChildren for id that isn't subscribed id=" + parentId));
                }
                return;
            }
            SubscriptionCallback subscriptionCallback = subscription.getCallback(options);
            if (subscriptionCallback != null) {
                if (options == null) {
                    if (list == null) {
                        subscriptionCallback.onError(parentId);
                    } else {
                        this.mNotifyChildrenChangedOptions = notifyChildrenChangedOptions;
                        subscriptionCallback.onChildrenLoaded(parentId, list);
                        this.mNotifyChildrenChangedOptions = null;
                    }
                } else if (list == null) {
                    subscriptionCallback.onError(parentId, options);
                } else {
                    this.mNotifyChildrenChangedOptions = notifyChildrenChangedOptions;
                    subscriptionCallback.onChildrenLoaded(parentId, list, options);
                    this.mNotifyChildrenChangedOptions = null;
                }
            }
        }

        @Override
        public Bundle getNotifyChildrenChangedOptions() {
            return this.mNotifyChildrenChangedOptions;
        }

        private static String getStateLabel(int state) {
            switch (state) {
                case 0: {
                    return "CONNECT_STATE_DISCONNECTING";
                }
                case 1: {
                    return "CONNECT_STATE_DISCONNECTED";
                }
                case 2: {
                    return "CONNECT_STATE_CONNECTING";
                }
                case 3: {
                    return "CONNECT_STATE_CONNECTED";
                }
                case 4: {
                    return "CONNECT_STATE_SUSPENDED";
                }
            }
            return "UNKNOWN/" + state;
        }

        private boolean isCurrent(Messenger callback, String funcName) {
            if (this.mCallbacksMessenger != callback || this.mState == 0 || this.mState == 1) {
                if (this.mState != 0 && this.mState != 1) {
                    Log.i((String)MediaBrowserCompat.TAG, (String)(funcName + " for " + this.mServiceComponent + " with mCallbacksMessenger=" + this.mCallbacksMessenger + " this=" + this));
                }
                return false;
            }
            return true;
        }

        void dump() {
            Log.d((String)MediaBrowserCompat.TAG, (String)"MediaBrowserCompat...");
            Log.d((String)MediaBrowserCompat.TAG, (String)("  mServiceComponent=" + this.mServiceComponent));
            Log.d((String)MediaBrowserCompat.TAG, (String)("  mCallback=" + this.mCallback));
            Log.d((String)MediaBrowserCompat.TAG, (String)("  mRootHints=" + this.mRootHints));
            Log.d((String)MediaBrowserCompat.TAG, (String)("  mState=" + MediaBrowserImplBase.getStateLabel(this.mState)));
            Log.d((String)MediaBrowserCompat.TAG, (String)("  mServiceConnection=" + this.mServiceConnection));
            Log.d((String)MediaBrowserCompat.TAG, (String)("  mServiceBinderWrapper=" + this.mServiceBinderWrapper));
            Log.d((String)MediaBrowserCompat.TAG, (String)("  mCallbacksMessenger=" + this.mCallbacksMessenger));
            Log.d((String)MediaBrowserCompat.TAG, (String)("  mRootId=" + this.mRootId));
            Log.d((String)MediaBrowserCompat.TAG, (String)("  mMediaSessionToken=" + this.mMediaSessionToken));
        }

        private class MediaServiceConnection
        implements ServiceConnection {
            MediaServiceConnection() {
            }

            public void onServiceConnected(final ComponentName name, final IBinder binder) {
                this.postOrRun(new Runnable(){

                    @Override
                    public void run() {
                        block5: {
                            if (DEBUG) {
                                Log.d((String)MediaBrowserCompat.TAG, (String)("MediaServiceConnection.onServiceConnected name=" + name + " binder=" + binder));
                                MediaBrowserImplBase.this.dump();
                            }
                            if (!MediaServiceConnection.this.isCurrent("onServiceConnected")) {
                                return;
                            }
                            MediaBrowserImplBase.this.mServiceBinderWrapper = new ServiceBinderWrapper(binder, MediaBrowserImplBase.this.mRootHints);
                            MediaBrowserImplBase.this.mCallbacksMessenger = new Messenger((Handler)MediaBrowserImplBase.this.mHandler);
                            MediaBrowserImplBase.this.mHandler.setCallbacksMessenger(MediaBrowserImplBase.this.mCallbacksMessenger);
                            MediaBrowserImplBase.this.mState = 2;
                            try {
                                if (DEBUG) {
                                    Log.d((String)MediaBrowserCompat.TAG, (String)"ServiceCallbacks.onConnect...");
                                    MediaBrowserImplBase.this.dump();
                                }
                                MediaBrowserImplBase.this.mServiceBinderWrapper.connect(MediaBrowserImplBase.this.mContext, MediaBrowserImplBase.this.mCallbacksMessenger);
                            }
                            catch (RemoteException ex) {
                                Log.w((String)MediaBrowserCompat.TAG, (String)("RemoteException during connect for " + MediaBrowserImplBase.this.mServiceComponent));
                                if (!DEBUG) break block5;
                                Log.d((String)MediaBrowserCompat.TAG, (String)"ServiceCallbacks.onConnect...");
                                MediaBrowserImplBase.this.dump();
                            }
                        }
                    }
                });
            }

            public void onServiceDisconnected(final ComponentName name) {
                this.postOrRun(new Runnable(){

                    @Override
                    public void run() {
                        if (DEBUG) {
                            Log.d((String)MediaBrowserCompat.TAG, (String)("MediaServiceConnection.onServiceDisconnected name=" + name + " this=" + this + " mServiceConnection=" + MediaBrowserImplBase.this.mServiceConnection));
                            MediaBrowserImplBase.this.dump();
                        }
                        if (!MediaServiceConnection.this.isCurrent("onServiceDisconnected")) {
                            return;
                        }
                        MediaBrowserImplBase.this.mServiceBinderWrapper = null;
                        MediaBrowserImplBase.this.mCallbacksMessenger = null;
                        MediaBrowserImplBase.this.mHandler.setCallbacksMessenger(null);
                        MediaBrowserImplBase.this.mState = 4;
                        MediaBrowserImplBase.this.mCallback.onConnectionSuspended();
                    }
                });
            }

            private void postOrRun(Runnable r) {
                if (Thread.currentThread() == MediaBrowserImplBase.this.mHandler.getLooper().getThread()) {
                    r.run();
                } else {
                    MediaBrowserImplBase.this.mHandler.post(r);
                }
            }

            boolean isCurrent(String funcName) {
                if (MediaBrowserImplBase.this.mServiceConnection != this || MediaBrowserImplBase.this.mState == 0 || MediaBrowserImplBase.this.mState == 1) {
                    if (MediaBrowserImplBase.this.mState != 0 && MediaBrowserImplBase.this.mState != 1) {
                        Log.i((String)MediaBrowserCompat.TAG, (String)(funcName + " for " + MediaBrowserImplBase.this.mServiceComponent + " with mServiceConnection=" + MediaBrowserImplBase.this.mServiceConnection + " this=" + this));
                    }
                    return false;
                }
                return true;
            }
        }
    }

    static interface MediaBrowserServiceCallbackImpl {
        public void onServiceConnected(Messenger var1, String var2, MediaSessionCompat.Token var3, Bundle var4);

        public void onConnectionFailed(Messenger var1);

        public void onLoadChildren(Messenger var1, String var2, List<MediaItem> var3, Bundle var4, Bundle var5);
    }

    static interface MediaBrowserImpl {
        public void connect();

        public void disconnect();

        public boolean isConnected();

        public ComponentName getServiceComponent();

        @NonNull
        public String getRoot();

        @Nullable
        public Bundle getExtras();

        @NonNull
        public MediaSessionCompat.Token getSessionToken();

        public void subscribe(@NonNull String var1, @Nullable Bundle var2, @NonNull SubscriptionCallback var3);

        public void unsubscribe(@NonNull String var1, SubscriptionCallback var2);

        public void getItem(@NonNull String var1, @NonNull ItemCallback var2);

        public void search(@NonNull String var1, Bundle var2, @NonNull SearchCallback var3);

        public void sendCustomAction(@NonNull String var1, Bundle var2, @Nullable CustomActionCallback var3);

        @Nullable
        public Bundle getNotifyChildrenChangedOptions();
    }

    public static abstract class CustomActionCallback {
        public void onProgressUpdate(String action, Bundle extras, Bundle data) {
        }

        public void onResult(String action, Bundle extras, Bundle resultData) {
        }

        public void onError(String action, Bundle extras, Bundle data) {
        }
    }

    public static abstract class SearchCallback {
        public void onSearchResult(@NonNull String query, Bundle extras, @NonNull List<MediaItem> items) {
        }

        public void onError(@NonNull String query, Bundle extras) {
        }
    }

    public static abstract class ItemCallback {
        final MediaBrowser.ItemCallback mItemCallbackFwk = Build.VERSION.SDK_INT >= 23 ? new ItemCallbackApi23() : null;

        public void onItemLoaded(MediaItem item) {
        }

        public void onError(@NonNull String itemId) {
        }

        @RequiresApi(value=23)
        private class ItemCallbackApi23
        extends MediaBrowser.ItemCallback {
            ItemCallbackApi23() {
            }

            public void onItemLoaded(MediaBrowser.MediaItem item) {
                ItemCallback.this.onItemLoaded(MediaItem.fromMediaItem(item));
            }

            public void onError(@NonNull String itemId) {
                ItemCallback.this.onError(itemId);
            }
        }
    }

    public static abstract class SubscriptionCallback {
        final MediaBrowser.SubscriptionCallback mSubscriptionCallbackFwk;
        final IBinder mToken = new Binder();
        WeakReference<Subscription> mSubscriptionRef;

        public SubscriptionCallback() {
            this.mSubscriptionCallbackFwk = Build.VERSION.SDK_INT >= 26 ? new SubscriptionCallbackApi26() : (Build.VERSION.SDK_INT >= 21 ? new SubscriptionCallbackApi21() : null);
        }

        public void onChildrenLoaded(@NonNull String parentId, @NonNull List<MediaItem> children) {
        }

        public void onChildrenLoaded(@NonNull String parentId, @NonNull List<MediaItem> children, @NonNull Bundle options) {
        }

        public void onError(@NonNull String parentId) {
        }

        public void onError(@NonNull String parentId, @NonNull Bundle options) {
        }

        void setSubscription(Subscription subscription) {
            this.mSubscriptionRef = new WeakReference<Subscription>(subscription);
        }

        @RequiresApi(value=26)
        private class SubscriptionCallbackApi26
        extends SubscriptionCallbackApi21 {
            SubscriptionCallbackApi26() {
            }

            public void onChildrenLoaded(@NonNull String parentId, @NonNull List<MediaBrowser.MediaItem> children, @NonNull Bundle options) {
                MediaSessionCompat.ensureClassLoader(options);
                SubscriptionCallback.this.onChildrenLoaded(parentId, MediaItem.fromMediaItemList(children), options);
            }

            public void onError(@NonNull String parentId, @NonNull Bundle options) {
                MediaSessionCompat.ensureClassLoader(options);
                SubscriptionCallback.this.onError(parentId, options);
            }
        }

        @RequiresApi(value=21)
        private class SubscriptionCallbackApi21
        extends MediaBrowser.SubscriptionCallback {
            SubscriptionCallbackApi21() {
            }

            public void onChildrenLoaded(@NonNull String parentId, List<MediaBrowser.MediaItem> children) {
                Subscription sub;
                Subscription subscription = sub = SubscriptionCallback.this.mSubscriptionRef == null ? null : (Subscription)SubscriptionCallback.this.mSubscriptionRef.get();
                if (sub == null) {
                    SubscriptionCallback.this.onChildrenLoaded(parentId, MediaItem.fromMediaItemList(children));
                } else {
                    List<MediaItem> itemList = MediaItem.fromMediaItemList(children);
                    List<SubscriptionCallback> callbacks = sub.getCallbacks();
                    List<Bundle> optionsList = sub.getOptionsList();
                    for (int i = 0; i < callbacks.size(); ++i) {
                        Bundle options = optionsList.get(i);
                        if (options == null) {
                            SubscriptionCallback.this.onChildrenLoaded(parentId, itemList);
                            continue;
                        }
                        SubscriptionCallback.this.onChildrenLoaded(parentId, this.applyOptions(itemList, options), options);
                    }
                }
            }

            public void onError(@NonNull String parentId) {
                SubscriptionCallback.this.onError(parentId);
            }

            List<MediaItem> applyOptions(List<MediaItem> list, Bundle options) {
                if (list == null) {
                    return null;
                }
                int page = options.getInt(MediaBrowserCompat.EXTRA_PAGE, -1);
                int pageSize = options.getInt(MediaBrowserCompat.EXTRA_PAGE_SIZE, -1);
                if (page == -1 && pageSize == -1) {
                    return list;
                }
                int fromIndex = pageSize * page;
                int toIndex = fromIndex + pageSize;
                if (page < 0 || pageSize < 1 || fromIndex >= list.size()) {
                    return Collections.emptyList();
                }
                if (toIndex > list.size()) {
                    toIndex = list.size();
                }
                return list.subList(fromIndex, toIndex);
            }
        }
    }

    public static class ConnectionCallback {
        final MediaBrowser.ConnectionCallback mConnectionCallbackFwk = Build.VERSION.SDK_INT >= 21 ? new ConnectionCallbackApi21() : null;
        ConnectionCallbackInternal mConnectionCallbackInternal;

        public void onConnected() {
        }

        public void onConnectionSuspended() {
        }

        public void onConnectionFailed() {
        }

        void setInternalConnectionCallback(ConnectionCallbackInternal connectionCallbackInternal) {
            this.mConnectionCallbackInternal = connectionCallbackInternal;
        }

        @RequiresApi(value=21)
        private class ConnectionCallbackApi21
        extends MediaBrowser.ConnectionCallback {
            ConnectionCallbackApi21() {
            }

            public void onConnected() {
                if (ConnectionCallback.this.mConnectionCallbackInternal != null) {
                    ConnectionCallback.this.mConnectionCallbackInternal.onConnected();
                }
                ConnectionCallback.this.onConnected();
            }

            public void onConnectionSuspended() {
                if (ConnectionCallback.this.mConnectionCallbackInternal != null) {
                    ConnectionCallback.this.mConnectionCallbackInternal.onConnectionSuspended();
                }
                ConnectionCallback.this.onConnectionSuspended();
            }

            public void onConnectionFailed() {
                if (ConnectionCallback.this.mConnectionCallbackInternal != null) {
                    ConnectionCallback.this.mConnectionCallbackInternal.onConnectionFailed();
                }
                ConnectionCallback.this.onConnectionFailed();
            }
        }

        static interface ConnectionCallbackInternal {
            public void onConnected();

            public void onConnectionSuspended();

            public void onConnectionFailed();
        }
    }

    @SuppressLint(value={"BanParcelableUsage"})
    public static class MediaItem
    implements Parcelable {
        private final int mFlags;
        private final MediaDescriptionCompat mDescription;
        public static final int FLAG_BROWSABLE = 1;
        public static final int FLAG_PLAYABLE = 2;
        public static final Parcelable.Creator<MediaItem> CREATOR = new Parcelable.Creator<MediaItem>(){

            public MediaItem createFromParcel(Parcel in) {
                return new MediaItem(in);
            }

            public MediaItem[] newArray(int size) {
                return new MediaItem[size];
            }
        };

        public static MediaItem fromMediaItem(Object itemObj) {
            if (itemObj == null || Build.VERSION.SDK_INT < 21) {
                return null;
            }
            MediaBrowser.MediaItem itemFwk = (MediaBrowser.MediaItem)itemObj;
            int flags = itemFwk.getFlags();
            MediaDescriptionCompat descriptionCompat = MediaDescriptionCompat.fromMediaDescription(itemFwk.getDescription());
            return new MediaItem(descriptionCompat, flags);
        }

        public static List<MediaItem> fromMediaItemList(List<?> itemList) {
            if (itemList == null || Build.VERSION.SDK_INT < 21) {
                return null;
            }
            ArrayList<MediaItem> items = new ArrayList<MediaItem>(itemList.size());
            for (Object itemObj : itemList) {
                items.add(MediaItem.fromMediaItem(itemObj));
            }
            return items;
        }

        public MediaItem(@NonNull MediaDescriptionCompat description, int flags) {
            if (description == null) {
                throw new IllegalArgumentException("description cannot be null");
            }
            if (TextUtils.isEmpty((CharSequence)description.getMediaId())) {
                throw new IllegalArgumentException("description must have a non-empty media id");
            }
            this.mFlags = flags;
            this.mDescription = description;
        }

        MediaItem(Parcel in) {
            this.mFlags = in.readInt();
            this.mDescription = (MediaDescriptionCompat)MediaDescriptionCompat.CREATOR.createFromParcel(in);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel out, int flags) {
            out.writeInt(this.mFlags);
            this.mDescription.writeToParcel(out, flags);
        }

        @NonNull
        public String toString() {
            StringBuilder sb = new StringBuilder("MediaItem{");
            sb.append("mFlags=").append(this.mFlags);
            sb.append(", mDescription=").append(this.mDescription);
            sb.append('}');
            return sb.toString();
        }

        public int getFlags() {
            return this.mFlags;
        }

        public boolean isBrowsable() {
            return (this.mFlags & 1) != 0;
        }

        public boolean isPlayable() {
            return (this.mFlags & 2) != 0;
        }

        @NonNull
        public MediaDescriptionCompat getDescription() {
            return this.mDescription;
        }

        @Nullable
        public String getMediaId() {
            return this.mDescription.getMediaId();
        }
    }
}

