/*
 * Decompiled with CFR 0.152.
 */
package androidx.media;

import android.media.AudioAttributes;
import android.media.AudioFocusRequest;
import android.media.AudioManager;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.core.util.ObjectsCompat;
import androidx.media.AudioAttributesCompat;

public class AudioFocusRequestCompat {
    static final AudioAttributesCompat FOCUS_DEFAULT_ATTR = new AudioAttributesCompat.Builder().setUsage(1).build();
    private final int mFocusGain;
    private final AudioManager.OnAudioFocusChangeListener mOnAudioFocusChangeListener;
    private final Handler mFocusChangeHandler;
    private final AudioAttributesCompat mAudioAttributesCompat;
    private final boolean mPauseOnDuck;
    private final Object mFrameworkAudioFocusRequest;

    AudioFocusRequestCompat(int focusGain, AudioManager.OnAudioFocusChangeListener onAudioFocusChangeListener, Handler focusChangeHandler, AudioAttributesCompat audioFocusRequestCompat, boolean pauseOnDuck) {
        this.mFocusGain = focusGain;
        this.mFocusChangeHandler = focusChangeHandler;
        this.mAudioAttributesCompat = audioFocusRequestCompat;
        this.mPauseOnDuck = pauseOnDuck;
        this.mOnAudioFocusChangeListener = Build.VERSION.SDK_INT < 26 && this.mFocusChangeHandler.getLooper() != Looper.getMainLooper() ? new OnAudioFocusChangeListenerHandlerCompat(onAudioFocusChangeListener, focusChangeHandler) : onAudioFocusChangeListener;
        this.mFrameworkAudioFocusRequest = Build.VERSION.SDK_INT >= 26 ? new AudioFocusRequest.Builder(this.mFocusGain).setAudioAttributes(this.getAudioAttributes()).setWillPauseWhenDucked(this.mPauseOnDuck).setOnAudioFocusChangeListener(this.mOnAudioFocusChangeListener, this.mFocusChangeHandler).build() : null;
    }

    public int getFocusGain() {
        return this.mFocusGain;
    }

    @NonNull
    public AudioAttributesCompat getAudioAttributesCompat() {
        return this.mAudioAttributesCompat;
    }

    public boolean willPauseWhenDucked() {
        return this.mPauseOnDuck;
    }

    @NonNull
    public AudioManager.OnAudioFocusChangeListener getOnAudioFocusChangeListener() {
        return this.mOnAudioFocusChangeListener;
    }

    @NonNull
    public Handler getFocusChangeHandler() {
        return this.mFocusChangeHandler;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AudioFocusRequestCompat)) {
            return false;
        }
        AudioFocusRequestCompat that = (AudioFocusRequestCompat)o;
        return this.mFocusGain == that.mFocusGain && this.mPauseOnDuck == that.mPauseOnDuck && ObjectsCompat.equals((Object)this.mOnAudioFocusChangeListener, (Object)that.mOnAudioFocusChangeListener) && ObjectsCompat.equals((Object)this.mFocusChangeHandler, (Object)that.mFocusChangeHandler) && ObjectsCompat.equals((Object)this.mAudioAttributesCompat, (Object)that.mAudioAttributesCompat);
    }

    public int hashCode() {
        return ObjectsCompat.hash((Object[])new Object[]{this.mFocusGain, this.mOnAudioFocusChangeListener, this.mFocusChangeHandler, this.mAudioAttributesCompat, this.mPauseOnDuck});
    }

    @RequiresApi(value=21)
    AudioAttributes getAudioAttributes() {
        return this.mAudioAttributesCompat != null ? (AudioAttributes)this.mAudioAttributesCompat.unwrap() : null;
    }

    @RequiresApi(value=26)
    AudioFocusRequest getAudioFocusRequest() {
        return (AudioFocusRequest)this.mFrameworkAudioFocusRequest;
    }

    private static class OnAudioFocusChangeListenerHandlerCompat
    implements Handler.Callback,
    AudioManager.OnAudioFocusChangeListener {
        private static final int FOCUS_CHANGE = 2782386;
        private final Handler mHandler;
        private final AudioManager.OnAudioFocusChangeListener mListener;

        OnAudioFocusChangeListenerHandlerCompat(@NonNull AudioManager.OnAudioFocusChangeListener listener, @NonNull Handler handler) {
            this.mListener = listener;
            this.mHandler = new Handler(handler.getLooper(), (Handler.Callback)this);
        }

        public void onAudioFocusChange(int focusChange) {
            this.mHandler.sendMessage(Message.obtain((Handler)this.mHandler, (int)2782386, (int)focusChange, (int)0));
        }

        public boolean handleMessage(Message message) {
            if (message.what == 2782386) {
                this.mListener.onAudioFocusChange(message.arg1);
                return true;
            }
            return false;
        }
    }

    public static final class Builder {
        private int mFocusGain;
        private AudioManager.OnAudioFocusChangeListener mOnAudioFocusChangeListener;
        private Handler mFocusChangeHandler;
        private AudioAttributesCompat mAudioAttributesCompat = FOCUS_DEFAULT_ATTR;
        private boolean mPauseOnDuck;

        public Builder(int focusGain) {
            this.setFocusGain(focusGain);
        }

        public Builder(@NonNull AudioFocusRequestCompat requestToCopy) {
            if (requestToCopy == null) {
                throw new IllegalArgumentException("AudioFocusRequestCompat to copy must not be null");
            }
            this.mFocusGain = requestToCopy.getFocusGain();
            this.mOnAudioFocusChangeListener = requestToCopy.getOnAudioFocusChangeListener();
            this.mFocusChangeHandler = requestToCopy.getFocusChangeHandler();
            this.mAudioAttributesCompat = requestToCopy.getAudioAttributesCompat();
            this.mPauseOnDuck = requestToCopy.willPauseWhenDucked();
        }

        @NonNull
        public Builder setFocusGain(int focusGain) {
            if (!Builder.isValidFocusGain(focusGain)) {
                throw new IllegalArgumentException("Illegal audio focus gain type " + focusGain);
            }
            if (Build.VERSION.SDK_INT < 19 && focusGain == 4) {
                focusGain = 2;
            }
            this.mFocusGain = focusGain;
            return this;
        }

        @NonNull
        public Builder setOnAudioFocusChangeListener(@NonNull AudioManager.OnAudioFocusChangeListener listener) {
            return this.setOnAudioFocusChangeListener(listener, new Handler(Looper.getMainLooper()));
        }

        @NonNull
        public Builder setOnAudioFocusChangeListener(@NonNull AudioManager.OnAudioFocusChangeListener listener, @NonNull Handler handler) {
            if (listener == null) {
                throw new IllegalArgumentException("OnAudioFocusChangeListener must not be null");
            }
            if (handler == null) {
                throw new IllegalArgumentException("Handler must not be null");
            }
            this.mOnAudioFocusChangeListener = listener;
            this.mFocusChangeHandler = handler;
            return this;
        }

        @NonNull
        public Builder setAudioAttributes(@NonNull AudioAttributesCompat attributes) {
            if (attributes == null) {
                throw new NullPointerException("Illegal null AudioAttributes");
            }
            this.mAudioAttributesCompat = attributes;
            return this;
        }

        @NonNull
        public Builder setWillPauseWhenDucked(boolean pauseOnDuck) {
            this.mPauseOnDuck = pauseOnDuck;
            return this;
        }

        public AudioFocusRequestCompat build() {
            if (this.mOnAudioFocusChangeListener == null) {
                throw new IllegalStateException("Can't build an AudioFocusRequestCompat instance without a listener");
            }
            return new AudioFocusRequestCompat(this.mFocusGain, this.mOnAudioFocusChangeListener, this.mFocusChangeHandler, this.mAudioAttributesCompat, this.mPauseOnDuck);
        }

        private static boolean isValidFocusGain(int focusGain) {
            switch (focusGain) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return true;
                }
            }
            return false;
        }
    }
}

