/*
 * Decompiled with CFR 0.152.
 */
package androidx.media;

import android.media.AudioManager;
import android.os.Build;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.media.AudioFocusRequestCompat;

public final class AudioManagerCompat {
    private static final String TAG = "AudioManCompat";
    public static final int AUDIOFOCUS_GAIN = 1;
    public static final int AUDIOFOCUS_GAIN_TRANSIENT = 2;
    public static final int AUDIOFOCUS_GAIN_TRANSIENT_MAY_DUCK = 3;
    public static final int AUDIOFOCUS_GAIN_TRANSIENT_EXCLUSIVE = 4;

    public static int requestAudioFocus(@NonNull AudioManager audioManager, @NonNull AudioFocusRequestCompat focusRequest) {
        if (audioManager == null) {
            throw new IllegalArgumentException("AudioManager must not be null");
        }
        if (focusRequest == null) {
            throw new IllegalArgumentException("AudioFocusRequestCompat must not be null");
        }
        if (Build.VERSION.SDK_INT >= 26) {
            return audioManager.requestAudioFocus(focusRequest.getAudioFocusRequest());
        }
        return audioManager.requestAudioFocus(focusRequest.getOnAudioFocusChangeListener(), focusRequest.getAudioAttributesCompat().getLegacyStreamType(), focusRequest.getFocusGain());
    }

    public static int abandonAudioFocusRequest(@NonNull AudioManager audioManager, @NonNull AudioFocusRequestCompat focusRequest) {
        if (audioManager == null) {
            throw new IllegalArgumentException("AudioManager must not be null");
        }
        if (focusRequest == null) {
            throw new IllegalArgumentException("AudioFocusRequestCompat must not be null");
        }
        if (Build.VERSION.SDK_INT >= 26) {
            return audioManager.abandonAudioFocusRequest(focusRequest.getAudioFocusRequest());
        }
        return audioManager.abandonAudioFocus(focusRequest.getOnAudioFocusChangeListener());
    }

    @IntRange(from=0L)
    public static int getStreamMaxVolume(@NonNull AudioManager audioManager, int streamType) {
        return audioManager.getStreamMaxVolume(streamType);
    }

    @IntRange(from=0L)
    public static int getStreamMinVolume(@NonNull AudioManager audioManager, int streamType) {
        if (Build.VERSION.SDK_INT >= 28) {
            return audioManager.getStreamMinVolume(streamType);
        }
        return 0;
    }

    private AudioManagerCompat() {
    }
}

