/*
 * Decompiled with CFR 0.152.
 */
package androidx.browser.browseractions;

import android.app.PendingIntent;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.browser.R;
import androidx.browser.browseractions.BrowserActionItem;
import androidx.browser.browseractions.BrowserActionsFallbackMenuAdapter;
import androidx.browser.browseractions.BrowserActionsFallbackMenuDialog;
import androidx.browser.browseractions.BrowserActionsFallbackMenuView;
import androidx.core.widget.TextViewCompat;
import java.util.ArrayList;
import java.util.List;

@Deprecated
class BrowserActionsFallbackMenuUi
implements AdapterView.OnItemClickListener {
    private static final String TAG = "BrowserActionskMenuUi";
    final Context mContext;
    final Uri mUri;
    private final List<BrowserActionItem> mMenuItems;
    @Nullable
    BrowserActionsFallMenuUiListener mMenuUiListener;
    @Nullable
    private BrowserActionsFallbackMenuDialog mBrowserActionsDialog;

    BrowserActionsFallbackMenuUi(@NonNull Context context, @NonNull Uri uri, @NonNull List<BrowserActionItem> customItems) {
        this.mContext = context;
        this.mUri = uri;
        this.mMenuItems = this.buildFallbackMenuItemList(customItems);
    }

    @VisibleForTesting
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    void setMenuUiListener(@Nullable BrowserActionsFallMenuUiListener menuUiListener) {
        this.mMenuUiListener = menuUiListener;
    }

    @NonNull
    private List<BrowserActionItem> buildFallbackMenuItemList(List<BrowserActionItem> customItems) {
        ArrayList<BrowserActionItem> fallbackMenuItems = new ArrayList<BrowserActionItem>();
        fallbackMenuItems.add(new BrowserActionItem(this.mContext.getString(R.string.fallback_menu_item_open_in_browser), this.buildOpenInBrowserAction()));
        fallbackMenuItems.add(new BrowserActionItem(this.mContext.getString(R.string.fallback_menu_item_copy_link), this.buildCopyAction()));
        fallbackMenuItems.add(new BrowserActionItem(this.mContext.getString(R.string.fallback_menu_item_share_link), this.buildShareAction()));
        fallbackMenuItems.addAll(customItems);
        return fallbackMenuItems;
    }

    private PendingIntent buildOpenInBrowserAction() {
        Intent intent = new Intent("android.intent.action.VIEW", this.mUri);
        return PendingIntent.getActivity((Context)this.mContext, (int)0, (Intent)intent, (int)0);
    }

    private PendingIntent buildShareAction() {
        Intent intent = new Intent("android.intent.action.SEND");
        intent.putExtra("android.intent.extra.TEXT", this.mUri.toString());
        intent.setType("text/plain");
        return PendingIntent.getActivity((Context)this.mContext, (int)0, (Intent)intent, (int)0);
    }

    private Runnable buildCopyAction() {
        return new Runnable(){

            @Override
            public void run() {
                ClipboardManager clipboardManager = (ClipboardManager)BrowserActionsFallbackMenuUi.this.mContext.getSystemService("clipboard");
                ClipData data = ClipData.newPlainText((CharSequence)"url", (CharSequence)BrowserActionsFallbackMenuUi.this.mUri.toString());
                clipboardManager.setPrimaryClip(data);
                String toastMsg = BrowserActionsFallbackMenuUi.this.mContext.getString(R.string.copy_toast_msg);
                Toast.makeText((Context)BrowserActionsFallbackMenuUi.this.mContext, (CharSequence)toastMsg, (int)0).show();
            }
        };
    }

    public void displayMenu() {
        final View view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.browser_actions_context_menu_page, null);
        this.mBrowserActionsDialog = new BrowserActionsFallbackMenuDialog(this.mContext, (View)this.initMenuView(view));
        this.mBrowserActionsDialog.setContentView(view);
        if (this.mMenuUiListener != null) {
            this.mBrowserActionsDialog.setOnShowListener(new DialogInterface.OnShowListener(){

                public void onShow(DialogInterface dialogInterface) {
                    if (BrowserActionsFallbackMenuUi.this.mMenuUiListener == null) {
                        Log.e((String)BrowserActionsFallbackMenuUi.TAG, (String)"Cannot trigger menu item listener, it is null");
                        return;
                    }
                    BrowserActionsFallbackMenuUi.this.mMenuUiListener.onMenuShown(view);
                }
            });
        }
        this.mBrowserActionsDialog.show();
    }

    private BrowserActionsFallbackMenuView initMenuView(View view) {
        BrowserActionsFallbackMenuView menuView = (BrowserActionsFallbackMenuView)view.findViewById(R.id.browser_actions_menu_view);
        final TextView urlTextView = (TextView)view.findViewById(R.id.browser_actions_header_text);
        urlTextView.setText((CharSequence)this.mUri.toString());
        urlTextView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (TextViewCompat.getMaxLines((TextView)urlTextView) == Integer.MAX_VALUE) {
                    urlTextView.setMaxLines(1);
                    urlTextView.setEllipsize(TextUtils.TruncateAt.END);
                } else {
                    urlTextView.setMaxLines(Integer.MAX_VALUE);
                    urlTextView.setEllipsize(null);
                }
            }
        });
        ListView menuListView = (ListView)view.findViewById(R.id.browser_actions_menu_items);
        BrowserActionsFallbackMenuAdapter adapter = new BrowserActionsFallbackMenuAdapter(this.mMenuItems, this.mContext);
        menuListView.setAdapter((ListAdapter)adapter);
        menuListView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        return menuView;
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        BrowserActionItem menuItem = this.mMenuItems.get(position);
        if (menuItem.getAction() != null) {
            try {
                menuItem.getAction().send();
            }
            catch (PendingIntent.CanceledException e) {
                Log.e((String)TAG, (String)"Failed to send custom item action", (Throwable)e);
            }
        } else if (menuItem.getRunnableAction() != null) {
            menuItem.getRunnableAction().run();
        }
        if (this.mBrowserActionsDialog == null) {
            Log.e((String)TAG, (String)"Cannot dismiss dialog, it has already been dismissed.");
            return;
        }
        this.mBrowserActionsDialog.dismiss();
    }

    @VisibleForTesting
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    static interface BrowserActionsFallMenuUiListener {
        public void onMenuShown(View var1);
    }
}

