/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.view;

import android.annotation.SuppressLint;
import android.app.UiModeManager;
import android.content.Context;
import android.graphics.Point;
import android.os.Build;
import android.text.TextUtils;
import android.view.Display;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.util.Preconditions;
import java.lang.reflect.Method;
import java.util.ArrayList;

public final class DisplayCompat {
    private static final int DISPLAY_SIZE_4K_WIDTH = 3840;
    private static final int DISPLAY_SIZE_4K_HEIGHT = 2160;

    private DisplayCompat() {
    }

    @NonNull
    @SuppressLint(value={"ArrayReturn"})
    public static ModeCompat[] getSupportedModes(@NonNull Context context, @NonNull Display display) {
        Point physicalDisplaySize = DisplayCompat.getPhysicalDisplaySize(context, display);
        if (Build.VERSION.SDK_INT >= 23) {
            Display.Mode[] supportedModes = display.getSupportedModes();
            ArrayList<ModeCompat> supportedModesCompat = new ArrayList<ModeCompat>(supportedModes.length);
            boolean nativeModeExists = false;
            for (int i = 0; i < supportedModes.length; ++i) {
                if (DisplayCompat.physicalSizeEquals(supportedModes[i], physicalDisplaySize)) {
                    supportedModesCompat.add(i, new ModeCompat(supportedModes[i], true));
                    nativeModeExists = true;
                    continue;
                }
                supportedModesCompat.add(i, new ModeCompat(supportedModes[i], false));
            }
            if (!nativeModeExists) {
                supportedModesCompat.add(new ModeCompat(physicalDisplaySize));
            }
            return supportedModesCompat.toArray(new ModeCompat[0]);
        }
        return new ModeCompat[]{new ModeCompat(physicalDisplaySize)};
    }

    private static Point parseDisplaySize(@NonNull String displaySize) throws NumberFormatException {
        String[] displaySizeParts = displaySize.trim().split("x", -1);
        if (displaySizeParts.length == 2) {
            int width = Integer.parseInt(displaySizeParts[0]);
            int height = Integer.parseInt(displaySizeParts[1]);
            if (width > 0 && height > 0) {
                return new Point(width, height);
            }
        }
        throw new NumberFormatException();
    }

    @Nullable
    private static String getSystemProperty(String name) {
        try {
            Class<?> systemProperties = Class.forName("android.os.SystemProperties");
            Method getMethod = systemProperties.getMethod("get", String.class);
            return (String)getMethod.invoke(systemProperties, name);
        }
        catch (Exception e) {
            return null;
        }
    }

    @RequiresApi(value=23)
    private static boolean physicalSizeEquals(Display.Mode mode, Point size) {
        return mode.getPhysicalWidth() == size.x && mode.getPhysicalHeight() == size.y || mode.getPhysicalWidth() == size.y && mode.getPhysicalHeight() == size.x;
    }

    private static boolean isTv(@NonNull Context context) {
        UiModeManager uiModeManager = (UiModeManager)context.getSystemService("uimode");
        return uiModeManager != null && uiModeManager.getCurrentModeType() == 4;
    }

    @Nullable
    private static Point parsePhysicalDisplaySizeFromSystemProperties(@NonNull String property, @NonNull Display display) {
        String displaySize;
        if (display.getDisplayId() == 0 && !TextUtils.isEmpty((CharSequence)(displaySize = DisplayCompat.getSystemProperty(property)))) {
            try {
                return DisplayCompat.parseDisplaySize(displaySize);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Point getPhysicalDisplaySize(@NonNull Context context, @NonNull Display display) {
        Point displaySize;
        Point point = displaySize = Build.VERSION.SDK_INT < 28 ? DisplayCompat.parsePhysicalDisplaySizeFromSystemProperties("sys.display-size", display) : DisplayCompat.parsePhysicalDisplaySizeFromSystemProperties("vendor.display-size", display);
        if (displaySize != null) {
            return displaySize;
        }
        if (DisplayCompat.isSonyBravia4kTv(context)) {
            return new Point(3840, 2160);
        }
        displaySize = new Point();
        if (Build.VERSION.SDK_INT >= 23) {
            Display.Mode mode = display.getMode();
            displaySize.x = mode.getPhysicalWidth();
            displaySize.y = mode.getPhysicalHeight();
        } else if (Build.VERSION.SDK_INT >= 17) {
            display.getRealSize(displaySize);
        } else {
            display.getSize(displaySize);
        }
        return displaySize;
    }

    private static boolean isSonyBravia4kTv(@NonNull Context context) {
        return DisplayCompat.isTv(context) && "Sony".equals(Build.MANUFACTURER) && Build.MODEL.startsWith("BRAVIA") && context.getPackageManager().hasSystemFeature("com.sony.dtv.hardware.panel.qfhd");
    }

    public static final class ModeCompat {
        private final Display.Mode mMode;
        private final Point mPhysicalDisplaySize;
        private final boolean mIsNative;

        ModeCompat(@NonNull Point physicalDisplaySize) {
            Preconditions.checkNotNull(physicalDisplaySize, "physicalDisplaySize == null");
            this.mIsNative = true;
            this.mPhysicalDisplaySize = physicalDisplaySize;
            this.mMode = null;
        }

        @RequiresApi(value=23)
        ModeCompat(@NonNull Display.Mode mode, boolean isNative) {
            Preconditions.checkNotNull(mode, "Display.Mode == null, can't wrap a null reference");
            this.mIsNative = isNative;
            this.mPhysicalDisplaySize = new Point(mode.getPhysicalWidth(), mode.getPhysicalHeight());
            this.mMode = mode;
        }

        public int getPhysicalWidth() {
            return this.mPhysicalDisplaySize.x;
        }

        public int getPhysicalHeight() {
            return this.mPhysicalDisplaySize.y;
        }

        @RequiresApi(value=23)
        @Nullable
        public Display.Mode toMode() {
            return this.mMode;
        }

        public boolean isNative() {
            return this.mIsNative;
        }
    }
}

