/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.view;

import android.graphics.Rect;
import android.os.Build;
import android.util.Log;
import android.view.WindowInsets;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.core.graphics.Insets;
import androidx.core.util.ObjectsCompat;
import androidx.core.util.Preconditions;
import androidx.core.view.DisplayCutoutCompat;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Objects;

public class WindowInsetsCompat {
    private static final String TAG = "WindowInsetsCompat";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static final WindowInsetsCompat CONSUMED = new Builder().build().consumeDisplayCutout().consumeStableInsets().consumeSystemWindowInsets();
    private final Impl mImpl;

    @RequiresApi(value=20)
    private WindowInsetsCompat(@NonNull WindowInsets insets) {
        this.mImpl = Build.VERSION.SDK_INT >= 29 ? new Impl29(this, insets) : (Build.VERSION.SDK_INT >= 28 ? new Impl28(this, insets) : (Build.VERSION.SDK_INT >= 21 ? new Impl21(this, insets) : (Build.VERSION.SDK_INT >= 20 ? new Impl20(this, insets) : new Impl(this))));
    }

    public WindowInsetsCompat(@Nullable WindowInsetsCompat src) {
        if (src != null) {
            Impl srcImpl = src.mImpl;
            this.mImpl = Build.VERSION.SDK_INT >= 29 && srcImpl instanceof Impl29 ? new Impl29(this, (Impl29)srcImpl) : (Build.VERSION.SDK_INT >= 28 && srcImpl instanceof Impl28 ? new Impl28(this, (Impl28)srcImpl) : (Build.VERSION.SDK_INT >= 21 && srcImpl instanceof Impl21 ? new Impl21(this, (Impl21)srcImpl) : (Build.VERSION.SDK_INT >= 20 && srcImpl instanceof Impl20 ? new Impl20(this, (Impl20)srcImpl) : new Impl(this))));
        } else {
            this.mImpl = new Impl(this);
        }
    }

    @NonNull
    @RequiresApi(value=20)
    public static WindowInsetsCompat toWindowInsetsCompat(@NonNull WindowInsets insets) {
        return new WindowInsetsCompat(Preconditions.checkNotNull(insets));
    }

    public int getSystemWindowInsetLeft() {
        return this.getSystemWindowInsets().left;
    }

    public int getSystemWindowInsetTop() {
        return this.getSystemWindowInsets().top;
    }

    public int getSystemWindowInsetRight() {
        return this.getSystemWindowInsets().right;
    }

    public int getSystemWindowInsetBottom() {
        return this.getSystemWindowInsets().bottom;
    }

    public boolean hasSystemWindowInsets() {
        return !this.getSystemWindowInsets().equals(Insets.NONE);
    }

    public boolean hasInsets() {
        return this.hasSystemWindowInsets() || this.hasStableInsets() || this.getDisplayCutout() != null || !this.getSystemGestureInsets().equals(Insets.NONE) || !this.getMandatorySystemGestureInsets().equals(Insets.NONE) || !this.getTappableElementInsets().equals(Insets.NONE);
    }

    public boolean isConsumed() {
        return this.mImpl.isConsumed();
    }

    public boolean isRound() {
        return this.mImpl.isRound();
    }

    @NonNull
    public WindowInsetsCompat consumeSystemWindowInsets() {
        return this.mImpl.consumeSystemWindowInsets();
    }

    @Deprecated
    @NonNull
    public WindowInsetsCompat replaceSystemWindowInsets(int left, int top, int right, int bottom) {
        return new Builder(this).setSystemWindowInsets(Insets.of(left, top, right, bottom)).build();
    }

    @Deprecated
    @NonNull
    public WindowInsetsCompat replaceSystemWindowInsets(@NonNull Rect systemWindowInsets) {
        return new Builder(this).setSystemWindowInsets(Insets.of(systemWindowInsets)).build();
    }

    public int getStableInsetTop() {
        return this.getStableInsets().top;
    }

    public int getStableInsetLeft() {
        return this.getStableInsets().left;
    }

    public int getStableInsetRight() {
        return this.getStableInsets().right;
    }

    public int getStableInsetBottom() {
        return this.getStableInsets().bottom;
    }

    public boolean hasStableInsets() {
        return !this.getStableInsets().equals(Insets.NONE);
    }

    @NonNull
    public WindowInsetsCompat consumeStableInsets() {
        return this.mImpl.consumeStableInsets();
    }

    @Nullable
    public DisplayCutoutCompat getDisplayCutout() {
        return this.mImpl.getDisplayCutout();
    }

    @NonNull
    public WindowInsetsCompat consumeDisplayCutout() {
        return this.mImpl.consumeDisplayCutout();
    }

    @NonNull
    public Insets getSystemWindowInsets() {
        return this.mImpl.getSystemWindowInsets();
    }

    @NonNull
    public Insets getStableInsets() {
        return this.mImpl.getStableInsets();
    }

    @NonNull
    public Insets getMandatorySystemGestureInsets() {
        return this.mImpl.getMandatorySystemGestureInsets();
    }

    @NonNull
    public Insets getTappableElementInsets() {
        return this.mImpl.getTappableElementInsets();
    }

    @NonNull
    public Insets getSystemGestureInsets() {
        return this.mImpl.getSystemGestureInsets();
    }

    @NonNull
    public WindowInsetsCompat inset(@NonNull Insets insets) {
        return this.inset(insets.left, insets.top, insets.right, insets.bottom);
    }

    @NonNull
    public WindowInsetsCompat inset(@IntRange(from=0L) int left, @IntRange(from=0L) int top, @IntRange(from=0L) int right, @IntRange(from=0L) int bottom) {
        return this.mImpl.inset(left, top, right, bottom);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WindowInsetsCompat)) {
            return false;
        }
        WindowInsetsCompat other = (WindowInsetsCompat)o;
        return ObjectsCompat.equals(this.mImpl, other.mImpl);
    }

    public int hashCode() {
        return this.mImpl == null ? 0 : this.mImpl.hashCode();
    }

    @Nullable
    @RequiresApi(value=20)
    public WindowInsets toWindowInsets() {
        return this.mImpl instanceof Impl20 ? ((Impl20)this.mImpl).mPlatformInsets : null;
    }

    static Insets insetInsets(Insets insets, int left, int top, int right, int bottom) {
        int newLeft = Math.max(0, insets.left - left);
        int newTop = Math.max(0, insets.top - top);
        int newRight = Math.max(0, insets.right - right);
        int newBottom = Math.max(0, insets.bottom - bottom);
        if (newLeft == left && newTop == top && newRight == right && newBottom == bottom) {
            return insets;
        }
        return Insets.of(newLeft, newTop, newRight, newBottom);
    }

    @RequiresApi(api=29)
    private static class BuilderImpl29
    extends BuilderImpl {
        final WindowInsets.Builder mPlatBuilder;

        BuilderImpl29() {
            this.mPlatBuilder = new WindowInsets.Builder();
        }

        BuilderImpl29(@NonNull WindowInsetsCompat insets) {
            WindowInsets platInsets = insets.toWindowInsets();
            this.mPlatBuilder = platInsets != null ? new WindowInsets.Builder(platInsets) : new WindowInsets.Builder();
        }

        @Override
        void setSystemWindowInsets(@NonNull Insets insets) {
            this.mPlatBuilder.setSystemWindowInsets(insets.toPlatformInsets());
        }

        @Override
        void setSystemGestureInsets(@NonNull Insets insets) {
            this.mPlatBuilder.setSystemGestureInsets(insets.toPlatformInsets());
        }

        @Override
        void setMandatorySystemGestureInsets(@NonNull Insets insets) {
            this.mPlatBuilder.setMandatorySystemGestureInsets(insets.toPlatformInsets());
        }

        @Override
        void setTappableElementInsets(@NonNull Insets insets) {
            this.mPlatBuilder.setTappableElementInsets(insets.toPlatformInsets());
        }

        @Override
        void setStableInsets(@NonNull Insets insets) {
            this.mPlatBuilder.setStableInsets(insets.toPlatformInsets());
        }

        @Override
        void setDisplayCutout(@Nullable DisplayCutoutCompat displayCutout) {
            this.mPlatBuilder.setDisplayCutout(displayCutout != null ? displayCutout.unwrap() : null);
        }

        @Override
        @NonNull
        WindowInsetsCompat build() {
            return WindowInsetsCompat.toWindowInsetsCompat(this.mPlatBuilder.build());
        }
    }

    @RequiresApi(api=20)
    private static class BuilderImpl20
    extends BuilderImpl {
        private static Field sConsumedField;
        private static boolean sConsumedFieldFetched;
        private static Constructor<WindowInsets> sConstructor;
        private static boolean sConstructorFetched;
        private WindowInsets mInsets;

        BuilderImpl20() {
            this.mInsets = BuilderImpl20.createWindowInsetsInstance();
        }

        BuilderImpl20(@NonNull WindowInsetsCompat insets) {
            this.mInsets = insets.toWindowInsets();
        }

        @Override
        void setSystemWindowInsets(@NonNull Insets insets) {
            if (this.mInsets != null) {
                this.mInsets = this.mInsets.replaceSystemWindowInsets(insets.left, insets.top, insets.right, insets.bottom);
            }
        }

        @Override
        @NonNull
        WindowInsetsCompat build() {
            return WindowInsetsCompat.toWindowInsetsCompat(this.mInsets);
        }

        @Nullable
        private static WindowInsets createWindowInsetsInstance() {
            if (!sConsumedFieldFetched) {
                try {
                    sConsumedField = WindowInsets.class.getDeclaredField("CONSUMED");
                }
                catch (ReflectiveOperationException e) {
                    Log.i((String)WindowInsetsCompat.TAG, (String)"Could not retrieve WindowInsets.CONSUMED field", (Throwable)e);
                }
                sConsumedFieldFetched = true;
            }
            if (sConsumedField != null) {
                try {
                    WindowInsets consumed = (WindowInsets)sConsumedField.get(null);
                    if (consumed != null) {
                        return new WindowInsets(consumed);
                    }
                }
                catch (ReflectiveOperationException e) {
                    Log.i((String)WindowInsetsCompat.TAG, (String)"Could not get value from WindowInsets.CONSUMED field", (Throwable)e);
                }
            }
            if (!sConstructorFetched) {
                try {
                    sConstructor = WindowInsets.class.getConstructor(Rect.class);
                }
                catch (ReflectiveOperationException e) {
                    Log.i((String)WindowInsetsCompat.TAG, (String)"Could not retrieve WindowInsets(Rect) constructor", (Throwable)e);
                }
                sConstructorFetched = true;
            }
            if (sConstructor != null) {
                try {
                    return sConstructor.newInstance(new Rect());
                }
                catch (ReflectiveOperationException e) {
                    Log.i((String)WindowInsetsCompat.TAG, (String)"Could not invoke WindowInsets(Rect) constructor", (Throwable)e);
                }
            }
            return null;
        }

        static {
            sConsumedFieldFetched = false;
            sConstructorFetched = false;
        }
    }

    private static class BuilderImpl {
        private final WindowInsetsCompat mInsets;

        BuilderImpl() {
            this(new WindowInsetsCompat((WindowInsetsCompat)null));
        }

        BuilderImpl(@NonNull WindowInsetsCompat insets) {
            this.mInsets = insets;
        }

        void setSystemWindowInsets(@NonNull Insets insets) {
        }

        void setSystemGestureInsets(@NonNull Insets insets) {
        }

        void setMandatorySystemGestureInsets(@NonNull Insets insets) {
        }

        void setTappableElementInsets(@NonNull Insets insets) {
        }

        void setStableInsets(@NonNull Insets insets) {
        }

        void setDisplayCutout(@Nullable DisplayCutoutCompat displayCutout) {
        }

        @NonNull
        WindowInsetsCompat build() {
            return this.mInsets;
        }
    }

    public static final class Builder {
        private final BuilderImpl mImpl;

        public Builder() {
            this.mImpl = Build.VERSION.SDK_INT >= 29 ? new BuilderImpl29() : (Build.VERSION.SDK_INT >= 20 ? new BuilderImpl20() : new BuilderImpl());
        }

        public Builder(@NonNull WindowInsetsCompat insets) {
            this.mImpl = Build.VERSION.SDK_INT >= 29 ? new BuilderImpl29(insets) : (Build.VERSION.SDK_INT >= 20 ? new BuilderImpl20(insets) : new BuilderImpl(insets));
        }

        @NonNull
        public Builder setSystemWindowInsets(@NonNull Insets insets) {
            this.mImpl.setSystemWindowInsets(insets);
            return this;
        }

        @NonNull
        public Builder setSystemGestureInsets(@NonNull Insets insets) {
            this.mImpl.setSystemGestureInsets(insets);
            return this;
        }

        @NonNull
        public Builder setMandatorySystemGestureInsets(@NonNull Insets insets) {
            this.mImpl.setMandatorySystemGestureInsets(insets);
            return this;
        }

        @NonNull
        public Builder setTappableElementInsets(@NonNull Insets insets) {
            this.mImpl.setTappableElementInsets(insets);
            return this;
        }

        @NonNull
        public Builder setStableInsets(@NonNull Insets insets) {
            this.mImpl.setStableInsets(insets);
            return this;
        }

        @NonNull
        public Builder setDisplayCutout(@Nullable DisplayCutoutCompat displayCutout) {
            this.mImpl.setDisplayCutout(displayCutout);
            return this;
        }

        @NonNull
        public WindowInsetsCompat build() {
            return this.mImpl.build();
        }
    }

    @RequiresApi(value=29)
    private static class Impl29
    extends Impl28 {
        private Insets mSystemGestureInsets = null;
        private Insets mMandatorySystemGestureInsets = null;
        private Insets mTappableElementInsets = null;

        Impl29(@NonNull WindowInsetsCompat host, @NonNull WindowInsets insets) {
            super(host, insets);
        }

        Impl29(@NonNull WindowInsetsCompat host, @NonNull Impl29 other) {
            super(host, other);
        }

        @Override
        @NonNull
        Insets getSystemGestureInsets() {
            if (this.mSystemGestureInsets == null) {
                this.mSystemGestureInsets = Insets.toCompatInsets(this.mPlatformInsets.getSystemGestureInsets());
            }
            return this.mSystemGestureInsets;
        }

        @Override
        @NonNull
        Insets getMandatorySystemGestureInsets() {
            if (this.mMandatorySystemGestureInsets == null) {
                this.mMandatorySystemGestureInsets = Insets.toCompatInsets(this.mPlatformInsets.getMandatorySystemGestureInsets());
            }
            return this.mMandatorySystemGestureInsets;
        }

        @Override
        @NonNull
        Insets getTappableElementInsets() {
            if (this.mTappableElementInsets == null) {
                this.mTappableElementInsets = Insets.toCompatInsets(this.mPlatformInsets.getTappableElementInsets());
            }
            return this.mTappableElementInsets;
        }

        @Override
        @NonNull
        WindowInsetsCompat inset(int left, int top, int right, int bottom) {
            return WindowInsetsCompat.toWindowInsetsCompat(this.mPlatformInsets.inset(left, top, right, bottom));
        }
    }

    @RequiresApi(value=28)
    private static class Impl28
    extends Impl21 {
        Impl28(@NonNull WindowInsetsCompat host, @NonNull WindowInsets insets) {
            super(host, insets);
        }

        Impl28(@NonNull WindowInsetsCompat host, @NonNull Impl28 other) {
            super(host, other);
        }

        @Override
        @Nullable
        DisplayCutoutCompat getDisplayCutout() {
            return DisplayCutoutCompat.wrap(this.mPlatformInsets.getDisplayCutout());
        }

        @Override
        @NonNull
        WindowInsetsCompat consumeDisplayCutout() {
            return WindowInsetsCompat.toWindowInsetsCompat(this.mPlatformInsets.consumeDisplayCutout());
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Impl28)) {
                return false;
            }
            Impl28 otherImpl28 = (Impl28)o;
            return Objects.equals(this.mPlatformInsets, otherImpl28.mPlatformInsets);
        }

        @Override
        public int hashCode() {
            return this.mPlatformInsets.hashCode();
        }
    }

    @RequiresApi(value=21)
    private static class Impl21
    extends Impl20 {
        private Insets mStableInsets = null;

        Impl21(@NonNull WindowInsetsCompat host, @NonNull WindowInsets insets) {
            super(host, insets);
        }

        Impl21(@NonNull WindowInsetsCompat host, @NonNull Impl21 other) {
            super(host, other);
        }

        @Override
        boolean isConsumed() {
            return this.mPlatformInsets.isConsumed();
        }

        @Override
        @NonNull
        WindowInsetsCompat consumeStableInsets() {
            return WindowInsetsCompat.toWindowInsetsCompat(this.mPlatformInsets.consumeStableInsets());
        }

        @Override
        @NonNull
        WindowInsetsCompat consumeSystemWindowInsets() {
            return WindowInsetsCompat.toWindowInsetsCompat(this.mPlatformInsets.consumeSystemWindowInsets());
        }

        @Override
        @NonNull
        final Insets getStableInsets() {
            if (this.mStableInsets == null) {
                this.mStableInsets = Insets.of(this.mPlatformInsets.getStableInsetLeft(), this.mPlatformInsets.getStableInsetTop(), this.mPlatformInsets.getStableInsetRight(), this.mPlatformInsets.getStableInsetBottom());
            }
            return this.mStableInsets;
        }
    }

    @RequiresApi(value=20)
    private static class Impl20
    extends Impl {
        @NonNull
        final WindowInsets mPlatformInsets;
        private Insets mSystemWindowInsets = null;

        Impl20(@NonNull WindowInsetsCompat host, @NonNull WindowInsets insets) {
            super(host);
            this.mPlatformInsets = insets;
        }

        Impl20(@NonNull WindowInsetsCompat host, @NonNull Impl20 other) {
            this(host, new WindowInsets(other.mPlatformInsets));
        }

        @Override
        boolean isRound() {
            return this.mPlatformInsets.isRound();
        }

        @Override
        @NonNull
        final Insets getSystemWindowInsets() {
            if (this.mSystemWindowInsets == null) {
                this.mSystemWindowInsets = Insets.of(this.mPlatformInsets.getSystemWindowInsetLeft(), this.mPlatformInsets.getSystemWindowInsetTop(), this.mPlatformInsets.getSystemWindowInsetRight(), this.mPlatformInsets.getSystemWindowInsetBottom());
            }
            return this.mSystemWindowInsets;
        }

        @Override
        @NonNull
        WindowInsetsCompat inset(int left, int top, int right, int bottom) {
            Builder b = new Builder(WindowInsetsCompat.toWindowInsetsCompat(this.mPlatformInsets));
            b.setSystemWindowInsets(WindowInsetsCompat.insetInsets(this.getSystemWindowInsets(), left, top, right, bottom));
            b.setStableInsets(WindowInsetsCompat.insetInsets(this.getStableInsets(), left, top, right, bottom));
            return b.build();
        }
    }

    private static class Impl {
        final WindowInsetsCompat mHost;

        Impl(@NonNull WindowInsetsCompat host) {
            this.mHost = host;
        }

        boolean isRound() {
            return false;
        }

        boolean isConsumed() {
            return false;
        }

        @NonNull
        WindowInsetsCompat consumeSystemWindowInsets() {
            return this.mHost;
        }

        @NonNull
        WindowInsetsCompat consumeStableInsets() {
            return this.mHost;
        }

        @Nullable
        DisplayCutoutCompat getDisplayCutout() {
            return null;
        }

        @NonNull
        WindowInsetsCompat consumeDisplayCutout() {
            return this.mHost;
        }

        @NonNull
        Insets getSystemWindowInsets() {
            return Insets.NONE;
        }

        @NonNull
        Insets getStableInsets() {
            return Insets.NONE;
        }

        @NonNull
        Insets getSystemGestureInsets() {
            return this.getSystemWindowInsets();
        }

        @NonNull
        Insets getMandatorySystemGestureInsets() {
            return this.getSystemWindowInsets();
        }

        @NonNull
        Insets getTappableElementInsets() {
            return this.getSystemWindowInsets();
        }

        @NonNull
        WindowInsetsCompat inset(int left, int top, int right, int bottom) {
            return CONSUMED;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Impl)) {
                return false;
            }
            Impl impl = (Impl)o;
            return this.isRound() == impl.isRound() && this.isConsumed() == impl.isConsumed() && ObjectsCompat.equals(this.getSystemWindowInsets(), impl.getSystemWindowInsets()) && ObjectsCompat.equals(this.getStableInsets(), impl.getStableInsets()) && ObjectsCompat.equals(this.getDisplayCutout(), impl.getDisplayCutout());
        }

        public int hashCode() {
            return ObjectsCompat.hash(this.isRound(), this.isConsumed(), this.getSystemWindowInsets(), this.getStableInsets(), this.getDisplayCutout());
        }
    }
}

