/*
 * Decompiled with CFR 0.152.
 */
package androidx.fragment.app;

import android.animation.Animator;
import android.animation.AnimatorInflater;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.content.res.Resources;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.AnimationUtils;
import android.view.animation.Transformation;
import androidx.annotation.AnimRes;
import androidx.annotation.NonNull;
import androidx.core.os.CancellationSignal;
import androidx.core.view.OneShotPreDrawListener;
import androidx.fragment.R;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentContainer;
import androidx.fragment.app.FragmentTransition;

class FragmentAnim {
    private FragmentAnim() {
    }

    static AnimationOrAnimator loadAnimation(@NonNull Context context, @NonNull FragmentContainer fragmentContainer, @NonNull Fragment fragment, boolean enter) {
        int transit;
        block17: {
            transit = fragment.getNextTransition();
            int nextAnim = fragment.getNextAnim();
            fragment.setNextAnim(0);
            View container = fragmentContainer.onFindViewById(fragment.mContainerId);
            if (container != null && container.getTag(R.id.visible_removing_fragment_view_tag) != null) {
                container.setTag(R.id.visible_removing_fragment_view_tag, null);
            }
            if (fragment.mContainer != null && fragment.mContainer.getLayoutTransition() != null) {
                return null;
            }
            Animation animation = fragment.onCreateAnimation(transit, enter, nextAnim);
            if (animation != null) {
                return new AnimationOrAnimator(animation);
            }
            Animator animator = fragment.onCreateAnimator(transit, enter, nextAnim);
            if (animator != null) {
                return new AnimationOrAnimator(animator);
            }
            if (nextAnim != 0) {
                String dir = context.getResources().getResourceTypeName(nextAnim);
                boolean isAnim = "anim".equals(dir);
                boolean successfulLoad = false;
                if (isAnim) {
                    try {
                        animation = AnimationUtils.loadAnimation((Context)context, (int)nextAnim);
                        if (animation != null) {
                            return new AnimationOrAnimator(animation);
                        }
                        successfulLoad = true;
                    }
                    catch (Resources.NotFoundException e) {
                        throw e;
                    }
                    catch (RuntimeException e) {
                        // empty catch block
                    }
                }
                if (!successfulLoad) {
                    try {
                        animator = AnimatorInflater.loadAnimator((Context)context, (int)nextAnim);
                        if (animator != null) {
                            return new AnimationOrAnimator(animator);
                        }
                    }
                    catch (RuntimeException e) {
                        if (isAnim) {
                            throw e;
                        }
                        animation = AnimationUtils.loadAnimation((Context)context, (int)nextAnim);
                        if (animation == null) break block17;
                        return new AnimationOrAnimator(animation);
                    }
                }
            }
        }
        if (transit == 0) {
            return null;
        }
        int animResourceId = FragmentAnim.transitToAnimResourceId(transit, enter);
        if (animResourceId < 0) {
            return null;
        }
        return new AnimationOrAnimator(AnimationUtils.loadAnimation((Context)context, (int)animResourceId));
    }

    static void animateRemoveFragment(final @NonNull Fragment fragment, @NonNull AnimationOrAnimator anim2, final @NonNull FragmentTransition.Callback callback) {
        final View viewToAnimate = fragment.mView;
        final ViewGroup container = fragment.mContainer;
        container.startViewTransition(viewToAnimate);
        final CancellationSignal signal = new CancellationSignal();
        signal.setOnCancelListener(new CancellationSignal.OnCancelListener(){

            public void onCancel() {
                if (fragment.getAnimatingAway() != null) {
                    View v = fragment.getAnimatingAway();
                    fragment.setAnimatingAway(null);
                    v.clearAnimation();
                }
                fragment.setAnimator(null);
            }
        });
        callback.onStart(fragment, signal);
        if (anim2.animation != null) {
            EndViewTransitionAnimation animation = new EndViewTransitionAnimation(anim2.animation, container, viewToAnimate);
            fragment.setAnimatingAway(fragment.mView);
            animation.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    container.post(new Runnable(){

                        @Override
                        public void run() {
                            if (fragment.getAnimatingAway() != null) {
                                fragment.setAnimatingAway(null);
                                callback.onComplete(fragment, signal);
                            }
                        }
                    });
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
            fragment.mView.startAnimation((Animation)animation);
        } else {
            Animator animator = anim2.animator;
            fragment.setAnimator(anim2.animator);
            animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator anim2) {
                    container.endViewTransition(viewToAnimate);
                    Animator animator = fragment.getAnimator();
                    fragment.setAnimator(null);
                    if (animator != null && container.indexOfChild(viewToAnimate) < 0) {
                        callback.onComplete(fragment, signal);
                    }
                }
            });
            animator.setTarget((Object)fragment.mView);
            animator.start();
        }
    }

    @AnimRes
    private static int transitToAnimResourceId(int transit, boolean enter) {
        int animAttr = -1;
        switch (transit) {
            case 4097: {
                animAttr = enter ? R.anim.fragment_open_enter : R.anim.fragment_open_exit;
                break;
            }
            case 8194: {
                animAttr = enter ? R.anim.fragment_close_enter : R.anim.fragment_close_exit;
                break;
            }
            case 4099: {
                animAttr = enter ? R.anim.fragment_fade_enter : R.anim.fragment_fade_exit;
            }
        }
        return animAttr;
    }

    private static class EndViewTransitionAnimation
    extends AnimationSet
    implements Runnable {
        private final ViewGroup mParent;
        private final View mChild;
        private boolean mEnded;
        private boolean mTransitionEnded;
        private boolean mAnimating = true;

        EndViewTransitionAnimation(@NonNull Animation animation, @NonNull ViewGroup parent, @NonNull View child) {
            super(false);
            this.mParent = parent;
            this.mChild = child;
            this.addAnimation(animation);
            this.mParent.post((Runnable)this);
        }

        public boolean getTransformation(long currentTime, @NonNull Transformation t) {
            this.mAnimating = true;
            if (this.mEnded) {
                return !this.mTransitionEnded;
            }
            boolean more = super.getTransformation(currentTime, t);
            if (!more) {
                this.mEnded = true;
                OneShotPreDrawListener.add((View)this.mParent, (Runnable)this);
            }
            return true;
        }

        public boolean getTransformation(long currentTime, @NonNull Transformation outTransformation, float scale) {
            this.mAnimating = true;
            if (this.mEnded) {
                return !this.mTransitionEnded;
            }
            boolean more = super.getTransformation(currentTime, outTransformation, scale);
            if (!more) {
                this.mEnded = true;
                OneShotPreDrawListener.add((View)this.mParent, (Runnable)this);
            }
            return true;
        }

        @Override
        public void run() {
            if (!this.mEnded && this.mAnimating) {
                this.mAnimating = false;
                this.mParent.post((Runnable)this);
            } else {
                this.mParent.endViewTransition(this.mChild);
                this.mTransitionEnded = true;
            }
        }
    }

    static class AnimationOrAnimator {
        public final Animation animation;
        public final Animator animator;

        AnimationOrAnimator(Animation animation) {
            this.animation = animation;
            this.animator = null;
            if (animation == null) {
                throw new IllegalStateException("Animation cannot be null");
            }
        }

        AnimationOrAnimator(Animator animator) {
            this.animation = null;
            this.animator = animator;
            if (animator == null) {
                throw new IllegalStateException("Animator cannot be null");
            }
        }
    }
}

