/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.badge;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.google.android.material.badge.BadgeDrawable;
import com.google.android.material.internal.ParcelableSparseArray;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class BadgeUtils {
    public static final boolean USE_COMPAT_PARENT = Build.VERSION.SDK_INT < 18;

    private BadgeUtils() {
    }

    public static void updateBadgeBounds(@NonNull Rect rect, float centerX, float centerY, float halfWidth, float halfHeight) {
        rect.set((int)(centerX - halfWidth), (int)(centerY - halfHeight), (int)(centerX + halfWidth), (int)(centerY + halfHeight));
    }

    public static void attachBadgeDrawable(@NonNull BadgeDrawable badgeDrawable, @NonNull View anchor, @NonNull FrameLayout compatBadgeParent) {
        BadgeUtils.setBadgeDrawableBounds(badgeDrawable, anchor, compatBadgeParent);
        if (USE_COMPAT_PARENT) {
            compatBadgeParent.setForeground((Drawable)badgeDrawable);
        } else {
            anchor.getOverlay().add((Drawable)badgeDrawable);
        }
    }

    public static void detachBadgeDrawable(@Nullable BadgeDrawable badgeDrawable, @NonNull View anchor, @NonNull FrameLayout compatBadgeParent) {
        if (badgeDrawable == null) {
            return;
        }
        if (USE_COMPAT_PARENT) {
            compatBadgeParent.setForeground(null);
        } else {
            anchor.getOverlay().remove((Drawable)badgeDrawable);
        }
    }

    public static void setBadgeDrawableBounds(@NonNull BadgeDrawable badgeDrawable, @NonNull View anchor, @NonNull FrameLayout compatBadgeParent) {
        Rect badgeBounds = new Rect();
        FrameLayout badgeParent = USE_COMPAT_PARENT ? compatBadgeParent : anchor;
        badgeParent.getDrawingRect(badgeBounds);
        badgeDrawable.setBounds(badgeBounds);
        badgeDrawable.updateBadgeCoordinates(anchor, (ViewGroup)compatBadgeParent);
    }

    @NonNull
    public static ParcelableSparseArray createParcelableBadgeStates(@NonNull SparseArray<BadgeDrawable> badgeDrawables) {
        ParcelableSparseArray badgeStates = new ParcelableSparseArray();
        for (int i = 0; i < badgeDrawables.size(); ++i) {
            int key = badgeDrawables.keyAt(i);
            BadgeDrawable badgeDrawable = (BadgeDrawable)badgeDrawables.valueAt(i);
            if (badgeDrawable == null) {
                throw new IllegalArgumentException("badgeDrawable cannot be null");
            }
            badgeStates.put(key, badgeDrawable.getSavedState());
        }
        return badgeStates;
    }

    @NonNull
    public static SparseArray<BadgeDrawable> createBadgeDrawablesFromSavedStates(Context context, @NonNull ParcelableSparseArray badgeStates) {
        SparseArray badgeDrawables = new SparseArray(badgeStates.size());
        for (int i = 0; i < badgeStates.size(); ++i) {
            int key = badgeStates.keyAt(i);
            BadgeDrawable.SavedState savedState = (BadgeDrawable.SavedState)badgeStates.valueAt(i);
            if (savedState == null) {
                throw new IllegalArgumentException("BadgeDrawable's savedState cannot be null");
            }
            BadgeDrawable badgeDrawable = BadgeDrawable.createFromSavedState(context, savedState);
            badgeDrawables.put(key, (Object)badgeDrawable);
        }
        return badgeDrawables;
    }
}

