/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.bottomnavigation;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.StyleRes;
import androidx.appcompat.view.menu.MenuItemImpl;
import androidx.appcompat.view.menu.MenuView;
import androidx.appcompat.widget.TooltipCompat;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.view.PointerIconCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.core.widget.TextViewCompat;
import com.google.android.material.R;
import com.google.android.material.badge.BadgeDrawable;
import com.google.android.material.badge.BadgeUtils;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class BottomNavigationItemView
extends FrameLayout
implements MenuView.ItemView {
    public static final int INVALID_ITEM_POSITION = -1;
    private static final int[] CHECKED_STATE_SET = new int[]{0x10100A0};
    private final int defaultMargin;
    private float shiftAmount;
    private float scaleUpFactor;
    private float scaleDownFactor;
    private int labelVisibilityMode;
    private boolean isShifting;
    private ImageView icon;
    private final TextView smallLabel;
    private final TextView largeLabel;
    private int itemPosition = -1;
    @Nullable
    private MenuItemImpl itemData;
    @Nullable
    private ColorStateList iconTint;
    @Nullable
    private Drawable originalIconDrawable;
    @Nullable
    private Drawable wrappedIconDrawable;
    @Nullable
    private BadgeDrawable badgeDrawable;

    public BottomNavigationItemView(@NonNull Context context) {
        this(context, null);
    }

    public BottomNavigationItemView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BottomNavigationItemView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        Resources res = this.getResources();
        LayoutInflater.from((Context)context).inflate(R.layout.design_bottom_navigation_item, (ViewGroup)this, true);
        this.setBackgroundResource(R.drawable.design_bottom_navigation_item_background);
        this.defaultMargin = res.getDimensionPixelSize(R.dimen.design_bottom_navigation_margin);
        this.icon = (ImageView)this.findViewById(R.id.icon);
        this.smallLabel = (TextView)this.findViewById(R.id.smallLabel);
        this.largeLabel = (TextView)this.findViewById(R.id.largeLabel);
        ViewCompat.setImportantForAccessibility((View)this.smallLabel, (int)2);
        ViewCompat.setImportantForAccessibility((View)this.largeLabel, (int)2);
        this.setFocusable(true);
        this.calculateTextScaleFactors(this.smallLabel.getTextSize(), this.largeLabel.getTextSize());
        if (this.icon != null) {
            this.icon.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

                public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                    if (BottomNavigationItemView.this.icon.getVisibility() == 0) {
                        BottomNavigationItemView.this.tryUpdateBadgeBounds((View)BottomNavigationItemView.this.icon);
                    }
                }
            });
        }
    }

    public void initialize(@NonNull MenuItemImpl itemData, int menuType) {
        this.itemData = itemData;
        this.setCheckable(itemData.isCheckable());
        this.setChecked(itemData.isChecked());
        this.setEnabled(itemData.isEnabled());
        this.setIcon(itemData.getIcon());
        this.setTitle(itemData.getTitle());
        this.setId(itemData.getItemId());
        if (!TextUtils.isEmpty((CharSequence)itemData.getContentDescription())) {
            this.setContentDescription(itemData.getContentDescription());
        }
        CharSequence tooltipText = !TextUtils.isEmpty((CharSequence)itemData.getTooltipText()) ? itemData.getTooltipText() : itemData.getTitle();
        TooltipCompat.setTooltipText((View)this, (CharSequence)tooltipText);
        this.setVisibility(itemData.isVisible() ? 0 : 8);
    }

    public void setItemPosition(int position) {
        this.itemPosition = position;
    }

    public int getItemPosition() {
        return this.itemPosition;
    }

    public void setShifting(boolean shifting) {
        if (this.isShifting != shifting) {
            boolean initialized;
            this.isShifting = shifting;
            boolean bl = initialized = this.itemData != null;
            if (initialized) {
                this.setChecked(this.itemData.isChecked());
            }
        }
    }

    public void setLabelVisibilityMode(int mode) {
        if (this.labelVisibilityMode != mode) {
            boolean initialized;
            this.labelVisibilityMode = mode;
            boolean bl = initialized = this.itemData != null;
            if (initialized) {
                this.setChecked(this.itemData.isChecked());
            }
        }
    }

    public MenuItemImpl getItemData() {
        return this.itemData;
    }

    public void setTitle(CharSequence title) {
        this.smallLabel.setText(title);
        this.largeLabel.setText(title);
        if (this.itemData == null || TextUtils.isEmpty((CharSequence)this.itemData.getContentDescription())) {
            this.setContentDescription(title);
        }
        CharSequence tooltipText = this.itemData == null || TextUtils.isEmpty((CharSequence)this.itemData.getTooltipText()) ? title : this.itemData.getTooltipText();
        TooltipCompat.setTooltipText((View)this, (CharSequence)tooltipText);
    }

    public void setCheckable(boolean checkable) {
        this.refreshDrawableState();
    }

    public void setChecked(boolean checked) {
        this.largeLabel.setPivotX((float)(this.largeLabel.getWidth() / 2));
        this.largeLabel.setPivotY((float)this.largeLabel.getBaseline());
        this.smallLabel.setPivotX((float)(this.smallLabel.getWidth() / 2));
        this.smallLabel.setPivotY((float)this.smallLabel.getBaseline());
        switch (this.labelVisibilityMode) {
            case -1: {
                if (this.isShifting) {
                    if (checked) {
                        this.setViewLayoutParams((View)this.icon, this.defaultMargin, 49);
                        this.setViewValues((View)this.largeLabel, 1.0f, 1.0f, 0);
                    } else {
                        this.setViewLayoutParams((View)this.icon, this.defaultMargin, 17);
                        this.setViewValues((View)this.largeLabel, 0.5f, 0.5f, 4);
                    }
                    this.smallLabel.setVisibility(4);
                    break;
                }
                if (checked) {
                    this.setViewLayoutParams((View)this.icon, (int)((float)this.defaultMargin + this.shiftAmount), 49);
                    this.setViewValues((View)this.largeLabel, 1.0f, 1.0f, 0);
                    this.setViewValues((View)this.smallLabel, this.scaleUpFactor, this.scaleUpFactor, 4);
                    break;
                }
                this.setViewLayoutParams((View)this.icon, this.defaultMargin, 49);
                this.setViewValues((View)this.largeLabel, this.scaleDownFactor, this.scaleDownFactor, 4);
                this.setViewValues((View)this.smallLabel, 1.0f, 1.0f, 0);
                break;
            }
            case 0: {
                if (checked) {
                    this.setViewLayoutParams((View)this.icon, this.defaultMargin, 49);
                    this.setViewValues((View)this.largeLabel, 1.0f, 1.0f, 0);
                } else {
                    this.setViewLayoutParams((View)this.icon, this.defaultMargin, 17);
                    this.setViewValues((View)this.largeLabel, 0.5f, 0.5f, 4);
                }
                this.smallLabel.setVisibility(4);
                break;
            }
            case 1: {
                if (checked) {
                    this.setViewLayoutParams((View)this.icon, (int)((float)this.defaultMargin + this.shiftAmount), 49);
                    this.setViewValues((View)this.largeLabel, 1.0f, 1.0f, 0);
                    this.setViewValues((View)this.smallLabel, this.scaleUpFactor, this.scaleUpFactor, 4);
                    break;
                }
                this.setViewLayoutParams((View)this.icon, this.defaultMargin, 49);
                this.setViewValues((View)this.largeLabel, this.scaleDownFactor, this.scaleDownFactor, 4);
                this.setViewValues((View)this.smallLabel, 1.0f, 1.0f, 0);
                break;
            }
            case 2: {
                this.setViewLayoutParams((View)this.icon, this.defaultMargin, 17);
                this.largeLabel.setVisibility(8);
                this.smallLabel.setVisibility(8);
                break;
            }
        }
        this.refreshDrawableState();
        this.setSelected(checked);
    }

    public void onInitializeAccessibilityNodeInfo(@NonNull AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        if (this.badgeDrawable != null && this.badgeDrawable.isVisible()) {
            CharSequence customContentDescription = this.itemData.getTitle();
            if (!TextUtils.isEmpty((CharSequence)this.itemData.getContentDescription())) {
                customContentDescription = this.itemData.getContentDescription();
            }
            info.setContentDescription((CharSequence)(customContentDescription + ", " + this.badgeDrawable.getContentDescription()));
        }
        AccessibilityNodeInfoCompat infoCompat = AccessibilityNodeInfoCompat.wrap((AccessibilityNodeInfo)info);
        infoCompat.setCollectionItemInfo((Object)AccessibilityNodeInfoCompat.CollectionItemInfoCompat.obtain((int)0, (int)1, (int)this.getItemPosition(), (int)1, (boolean)false, (boolean)this.isSelected()));
        if (this.isSelected()) {
            infoCompat.setClickable(false);
            infoCompat.removeAction(AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_CLICK);
        }
        infoCompat.setRoleDescription((CharSequence)this.getResources().getString(R.string.item_view_role_description));
    }

    private void setViewLayoutParams(@NonNull View view, int topMargin, int gravity) {
        FrameLayout.LayoutParams viewParams = (FrameLayout.LayoutParams)view.getLayoutParams();
        viewParams.topMargin = topMargin;
        viewParams.gravity = gravity;
        view.setLayoutParams((ViewGroup.LayoutParams)viewParams);
    }

    private void setViewValues(@NonNull View view, float scaleX, float scaleY, int visibility) {
        view.setScaleX(scaleX);
        view.setScaleY(scaleY);
        view.setVisibility(visibility);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.smallLabel.setEnabled(enabled);
        this.largeLabel.setEnabled(enabled);
        this.icon.setEnabled(enabled);
        if (enabled) {
            ViewCompat.setPointerIcon((View)this, (PointerIconCompat)PointerIconCompat.getSystemIcon((Context)this.getContext(), (int)1002));
        } else {
            ViewCompat.setPointerIcon((View)this, null);
        }
    }

    public int[] onCreateDrawableState(int extraSpace) {
        int[] drawableState = super.onCreateDrawableState(extraSpace + 1);
        if (this.itemData != null && this.itemData.isCheckable() && this.itemData.isChecked()) {
            BottomNavigationItemView.mergeDrawableStates((int[])drawableState, (int[])CHECKED_STATE_SET);
        }
        return drawableState;
    }

    public void setShortcut(boolean showShortcut, char shortcutKey) {
    }

    public void setIcon(@Nullable Drawable iconDrawable) {
        if (iconDrawable == this.originalIconDrawable) {
            return;
        }
        this.originalIconDrawable = iconDrawable;
        if (iconDrawable != null) {
            Drawable.ConstantState state = iconDrawable.getConstantState();
            this.wrappedIconDrawable = iconDrawable = DrawableCompat.wrap((Drawable)(state == null ? iconDrawable : state.newDrawable())).mutate();
            if (this.iconTint != null) {
                DrawableCompat.setTintList((Drawable)this.wrappedIconDrawable, (ColorStateList)this.iconTint);
            }
        }
        this.icon.setImageDrawable(iconDrawable);
    }

    public boolean prefersCondensedTitle() {
        return false;
    }

    public boolean showsIcon() {
        return true;
    }

    public void setIconTintList(ColorStateList tint) {
        this.iconTint = tint;
        if (this.itemData != null && this.wrappedIconDrawable != null) {
            DrawableCompat.setTintList((Drawable)this.wrappedIconDrawable, (ColorStateList)this.iconTint);
            this.wrappedIconDrawable.invalidateSelf();
        }
    }

    public void setIconSize(int iconSize) {
        FrameLayout.LayoutParams iconParams = (FrameLayout.LayoutParams)this.icon.getLayoutParams();
        iconParams.width = iconSize;
        iconParams.height = iconSize;
        this.icon.setLayoutParams((ViewGroup.LayoutParams)iconParams);
    }

    public void setTextAppearanceInactive(@StyleRes int inactiveTextAppearance) {
        TextViewCompat.setTextAppearance((TextView)this.smallLabel, (int)inactiveTextAppearance);
        this.calculateTextScaleFactors(this.smallLabel.getTextSize(), this.largeLabel.getTextSize());
    }

    public void setTextAppearanceActive(@StyleRes int activeTextAppearance) {
        TextViewCompat.setTextAppearance((TextView)this.largeLabel, (int)activeTextAppearance);
        this.calculateTextScaleFactors(this.smallLabel.getTextSize(), this.largeLabel.getTextSize());
    }

    public void setTextColor(@Nullable ColorStateList color2) {
        if (color2 != null) {
            this.smallLabel.setTextColor(color2);
            this.largeLabel.setTextColor(color2);
        }
    }

    private void calculateTextScaleFactors(float smallLabelSize, float largeLabelSize) {
        this.shiftAmount = smallLabelSize - largeLabelSize;
        this.scaleUpFactor = 1.0f * largeLabelSize / smallLabelSize;
        this.scaleDownFactor = 1.0f * smallLabelSize / largeLabelSize;
    }

    public void setItemBackground(int background) {
        Drawable backgroundDrawable = background == 0 ? null : ContextCompat.getDrawable((Context)this.getContext(), (int)background);
        this.setItemBackground(backgroundDrawable);
    }

    public void setItemBackground(@Nullable Drawable background) {
        if (background != null && background.getConstantState() != null) {
            background = background.getConstantState().newDrawable().mutate();
        }
        ViewCompat.setBackground((View)this, (Drawable)background);
    }

    void setBadge(@NonNull BadgeDrawable badgeDrawable) {
        this.badgeDrawable = badgeDrawable;
        if (this.icon != null) {
            this.tryAttachBadgeToAnchor((View)this.icon);
        }
    }

    @Nullable
    BadgeDrawable getBadge() {
        return this.badgeDrawable;
    }

    void removeBadge() {
        this.tryRemoveBadgeFromAnchor((View)this.icon);
    }

    private boolean hasBadge() {
        return this.badgeDrawable != null;
    }

    private void tryUpdateBadgeBounds(View anchorView) {
        if (!this.hasBadge()) {
            return;
        }
        BadgeUtils.setBadgeDrawableBounds(this.badgeDrawable, anchorView, this.getCustomParentForBadge(anchorView));
    }

    private void tryAttachBadgeToAnchor(@Nullable View anchorView) {
        if (!this.hasBadge()) {
            return;
        }
        if (anchorView != null) {
            this.setClipChildren(false);
            this.setClipToPadding(false);
            BadgeUtils.attachBadgeDrawable(this.badgeDrawable, anchorView, this.getCustomParentForBadge(anchorView));
        }
    }

    private void tryRemoveBadgeFromAnchor(@Nullable View anchorView) {
        if (!this.hasBadge()) {
            return;
        }
        if (anchorView != null) {
            this.setClipChildren(true);
            this.setClipToPadding(true);
            BadgeUtils.detachBadgeDrawable(this.badgeDrawable, anchorView, this.getCustomParentForBadge(anchorView));
        }
        this.badgeDrawable = null;
    }

    @Nullable
    private FrameLayout getCustomParentForBadge(View anchorView) {
        if (anchorView == this.icon) {
            return BadgeUtils.USE_COMPAT_PARENT ? (FrameLayout)this.icon.getParent() : null;
        }
        return null;
    }
}

