/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.button;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.Button;
import android.widget.Checkable;
import android.widget.CompoundButton;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.appcompat.widget.AppCompatButton;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.view.ViewCompat;
import androidx.core.widget.TextViewCompat;
import androidx.customview.view.AbsSavedState;
import com.google.android.material.R;
import com.google.android.material.button.MaterialButtonHelper;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.internal.ViewUtils;
import com.google.android.material.resources.MaterialResources;
import com.google.android.material.shape.MaterialShapeUtils;
import com.google.android.material.shape.ShapeAppearanceModel;
import com.google.android.material.shape.Shapeable;
import com.google.android.material.theme.overlay.MaterialThemeOverlay;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.LinkedHashSet;

public class MaterialButton
extends AppCompatButton
implements Checkable,
Shapeable {
    private static final int[] CHECKABLE_STATE_SET = new int[]{16842911};
    private static final int[] CHECKED_STATE_SET = new int[]{0x10100A0};
    public static final int ICON_GRAVITY_START = 1;
    public static final int ICON_GRAVITY_TEXT_START = 2;
    public static final int ICON_GRAVITY_END = 3;
    public static final int ICON_GRAVITY_TEXT_END = 4;
    private static final String LOG_TAG = "MaterialButton";
    private static final int DEF_STYLE_RES = R.style.Widget_MaterialComponents_Button;
    @NonNull
    private final MaterialButtonHelper materialButtonHelper;
    @NonNull
    private final LinkedHashSet<OnCheckedChangeListener> onCheckedChangeListeners = new LinkedHashSet();
    @Nullable
    private OnPressedChangeListener onPressedChangeListenerInternal;
    @Nullable
    private PorterDuff.Mode iconTintMode;
    @Nullable
    private ColorStateList iconTint;
    @Nullable
    private Drawable icon;
    @Px
    private int iconSize;
    @Px
    private int iconLeft;
    @Px
    private int iconPadding;
    private boolean checked = false;
    private boolean broadcasting = false;
    private int iconGravity;

    public MaterialButton(@NonNull Context context) {
        this(context, null);
    }

    public MaterialButton(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.materialButtonStyle);
    }

    public MaterialButton(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(MaterialThemeOverlay.wrap(context, attrs, defStyleAttr, DEF_STYLE_RES), attrs, defStyleAttr);
        context = this.getContext();
        TypedArray attributes = ThemeEnforcement.obtainStyledAttributes(context, attrs, R.styleable.MaterialButton, defStyleAttr, DEF_STYLE_RES, new int[0]);
        this.iconPadding = attributes.getDimensionPixelSize(R.styleable.MaterialButton_iconPadding, 0);
        this.iconTintMode = ViewUtils.parseTintMode(attributes.getInt(R.styleable.MaterialButton_iconTintMode, -1), PorterDuff.Mode.SRC_IN);
        this.iconTint = MaterialResources.getColorStateList(this.getContext(), attributes, R.styleable.MaterialButton_iconTint);
        this.icon = MaterialResources.getDrawable(this.getContext(), attributes, R.styleable.MaterialButton_icon);
        this.iconGravity = attributes.getInteger(R.styleable.MaterialButton_iconGravity, 1);
        this.iconSize = attributes.getDimensionPixelSize(R.styleable.MaterialButton_iconSize, 0);
        ShapeAppearanceModel shapeAppearanceModel = ShapeAppearanceModel.builder(context, attrs, defStyleAttr, DEF_STYLE_RES).build();
        this.materialButtonHelper = new MaterialButtonHelper(this, shapeAppearanceModel);
        this.materialButtonHelper.loadFromAttributes(attributes);
        attributes.recycle();
        this.setCompoundDrawablePadding(this.iconPadding);
        this.updateIcon(this.icon != null);
    }

    @NonNull
    private String getA11yClassName() {
        return (this.isCheckable() ? CompoundButton.class : Button.class).getName();
    }

    public void onInitializeAccessibilityNodeInfo(@NonNull AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName((CharSequence)this.getA11yClassName());
        info.setCheckable(this.isCheckable());
        info.setChecked(this.isChecked());
        info.setClickable(this.isClickable());
    }

    public void onInitializeAccessibilityEvent(@NonNull AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName((CharSequence)this.getA11yClassName());
        accessibilityEvent.setChecked(this.isChecked());
    }

    @NonNull
    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState savedState = new SavedState(superState);
        savedState.checked = this.checked;
        return savedState;
    }

    public void onRestoreInstanceState(@Nullable Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.setChecked(savedState.checked);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setSupportBackgroundTintList(@Nullable ColorStateList tint) {
        if (this.isUsingOriginalBackground()) {
            this.materialButtonHelper.setSupportBackgroundTintList(tint);
        } else {
            super.setSupportBackgroundTintList(tint);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public ColorStateList getSupportBackgroundTintList() {
        if (this.isUsingOriginalBackground()) {
            return this.materialButtonHelper.getSupportBackgroundTintList();
        }
        return super.getSupportBackgroundTintList();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setSupportBackgroundTintMode(@Nullable PorterDuff.Mode tintMode) {
        if (this.isUsingOriginalBackground()) {
            this.materialButtonHelper.setSupportBackgroundTintMode(tintMode);
        } else {
            super.setSupportBackgroundTintMode(tintMode);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public PorterDuff.Mode getSupportBackgroundTintMode() {
        if (this.isUsingOriginalBackground()) {
            return this.materialButtonHelper.getSupportBackgroundTintMode();
        }
        return super.getSupportBackgroundTintMode();
    }

    public void setBackgroundTintList(@Nullable ColorStateList tintList) {
        this.setSupportBackgroundTintList(tintList);
    }

    @Nullable
    public ColorStateList getBackgroundTintList() {
        return this.getSupportBackgroundTintList();
    }

    public void setBackgroundTintMode(@Nullable PorterDuff.Mode tintMode) {
        this.setSupportBackgroundTintMode(tintMode);
    }

    @Nullable
    public PorterDuff.Mode getBackgroundTintMode() {
        return this.getSupportBackgroundTintMode();
    }

    public void setBackgroundColor(@ColorInt int color2) {
        if (this.isUsingOriginalBackground()) {
            this.materialButtonHelper.setBackgroundColor(color2);
        } else {
            super.setBackgroundColor(color2);
        }
    }

    public void setBackground(@NonNull Drawable background) {
        this.setBackgroundDrawable(background);
    }

    public void setBackgroundResource(@DrawableRes int backgroundResourceId) {
        Drawable background = null;
        if (backgroundResourceId != 0) {
            background = AppCompatResources.getDrawable((Context)this.getContext(), (int)backgroundResourceId);
        }
        this.setBackgroundDrawable(background);
    }

    public void setBackgroundDrawable(@NonNull Drawable background) {
        if (this.isUsingOriginalBackground()) {
            if (background != this.getBackground()) {
                Log.w((String)LOG_TAG, (String)"Do not set the background; MaterialButton manages its own background drawable.");
                this.materialButtonHelper.setBackgroundOverwritten();
                super.setBackgroundDrawable(background);
            } else {
                this.getBackground().setState(background.getState());
            }
        } else {
            super.setBackgroundDrawable(background);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (Build.VERSION.SDK_INT == 21 && this.materialButtonHelper != null) {
            this.materialButtonHelper.updateMaskBounds(bottom - top, right - left);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.updateIconPosition();
    }

    protected void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
        super.onTextChanged(charSequence, i, i1, i2);
        this.updateIconPosition();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.isUsingOriginalBackground()) {
            MaterialShapeUtils.setParentAbsoluteElevation((View)this, this.materialButtonHelper.getMaterialShapeDrawable());
        }
    }

    @RequiresApi(value=21)
    public void setElevation(float elevation) {
        super.setElevation(elevation);
        if (this.isUsingOriginalBackground()) {
            this.materialButtonHelper.getMaterialShapeDrawable().setElevation(elevation);
        }
    }

    private void updateIconPosition() {
        if (this.icon == null || this.getLayout() == null) {
            return;
        }
        if (this.iconGravity == 1 || this.iconGravity == 3) {
            this.iconLeft = 0;
            this.updateIcon(false);
            return;
        }
        TextPaint textPaint = this.getPaint();
        String buttonText = this.getText().toString();
        if (this.getTransformationMethod() != null) {
            buttonText = this.getTransformationMethod().getTransformation((CharSequence)buttonText, (View)this).toString();
        }
        int textWidth = Math.min((int)textPaint.measureText(buttonText), this.getLayout().getEllipsizedWidth());
        int localIconSize = this.iconSize == 0 ? this.icon.getIntrinsicWidth() : this.iconSize;
        int newIconLeft = (this.getMeasuredWidth() - textWidth - ViewCompat.getPaddingEnd((View)this) - localIconSize - this.iconPadding - ViewCompat.getPaddingStart((View)this)) / 2;
        if (this.isLayoutRTL() != (this.iconGravity == 4)) {
            newIconLeft = -newIconLeft;
        }
        if (this.iconLeft != newIconLeft) {
            this.iconLeft = newIconLeft;
            this.updateIcon(false);
        }
    }

    private boolean isLayoutRTL() {
        return ViewCompat.getLayoutDirection((View)this) == 1;
    }

    void setInternalBackground(Drawable background) {
        super.setBackgroundDrawable(background);
    }

    public void setIconPadding(@Px int iconPadding) {
        if (this.iconPadding != iconPadding) {
            this.iconPadding = iconPadding;
            this.setCompoundDrawablePadding(iconPadding);
        }
    }

    @Px
    public int getIconPadding() {
        return this.iconPadding;
    }

    public void setIconSize(@Px int iconSize) {
        if (iconSize < 0) {
            throw new IllegalArgumentException("iconSize cannot be less than 0");
        }
        if (this.iconSize != iconSize) {
            this.iconSize = iconSize;
            this.updateIcon(true);
        }
    }

    @Px
    public int getIconSize() {
        return this.iconSize;
    }

    public void setIcon(@Nullable Drawable icon) {
        if (this.icon != icon) {
            this.icon = icon;
            this.updateIcon(true);
        }
    }

    public void setIconResource(@DrawableRes int iconResourceId) {
        Drawable icon = null;
        if (iconResourceId != 0) {
            icon = AppCompatResources.getDrawable((Context)this.getContext(), (int)iconResourceId);
        }
        this.setIcon(icon);
    }

    public Drawable getIcon() {
        return this.icon;
    }

    public void setIconTint(@Nullable ColorStateList iconTint) {
        if (this.iconTint != iconTint) {
            this.iconTint = iconTint;
            this.updateIcon(false);
        }
    }

    public void setIconTintResource(@ColorRes int iconTintResourceId) {
        this.setIconTint(AppCompatResources.getColorStateList((Context)this.getContext(), (int)iconTintResourceId));
    }

    public ColorStateList getIconTint() {
        return this.iconTint;
    }

    public void setIconTintMode(PorterDuff.Mode iconTintMode) {
        if (this.iconTintMode != iconTintMode) {
            this.iconTintMode = iconTintMode;
            this.updateIcon(false);
        }
    }

    public PorterDuff.Mode getIconTintMode() {
        return this.iconTintMode;
    }

    private void updateIcon(boolean needsIconUpdate) {
        boolean hasIconChanged;
        boolean isIconStart;
        if (this.icon != null) {
            this.icon = DrawableCompat.wrap((Drawable)this.icon).mutate();
            DrawableCompat.setTintList((Drawable)this.icon, (ColorStateList)this.iconTint);
            if (this.iconTintMode != null) {
                DrawableCompat.setTintMode((Drawable)this.icon, (PorterDuff.Mode)this.iconTintMode);
            }
            int width = this.iconSize != 0 ? this.iconSize : this.icon.getIntrinsicWidth();
            int height = this.iconSize != 0 ? this.iconSize : this.icon.getIntrinsicHeight();
            this.icon.setBounds(this.iconLeft, 0, this.iconLeft + width, height);
        }
        boolean bl = isIconStart = this.iconGravity == 1 || this.iconGravity == 2;
        if (needsIconUpdate) {
            this.resetIconDrawable(isIconStart);
            return;
        }
        Drawable[] existingDrawables = TextViewCompat.getCompoundDrawablesRelative((TextView)this);
        Drawable drawableStart = existingDrawables[0];
        Drawable drawableEnd = existingDrawables[2];
        boolean bl2 = hasIconChanged = isIconStart && drawableStart != this.icon || !isIconStart && drawableEnd != this.icon;
        if (hasIconChanged) {
            this.resetIconDrawable(isIconStart);
        }
    }

    private void resetIconDrawable(boolean isIconStart) {
        if (isIconStart) {
            TextViewCompat.setCompoundDrawablesRelative((TextView)this, (Drawable)this.icon, null, null, null);
        } else {
            TextViewCompat.setCompoundDrawablesRelative((TextView)this, null, null, (Drawable)this.icon, null);
        }
    }

    public void setRippleColor(@Nullable ColorStateList rippleColor) {
        if (this.isUsingOriginalBackground()) {
            this.materialButtonHelper.setRippleColor(rippleColor);
        }
    }

    public void setRippleColorResource(@ColorRes int rippleColorResourceId) {
        if (this.isUsingOriginalBackground()) {
            this.setRippleColor(AppCompatResources.getColorStateList((Context)this.getContext(), (int)rippleColorResourceId));
        }
    }

    @Nullable
    public ColorStateList getRippleColor() {
        return this.isUsingOriginalBackground() ? this.materialButtonHelper.getRippleColor() : null;
    }

    public void setStrokeColor(@Nullable ColorStateList strokeColor) {
        if (this.isUsingOriginalBackground()) {
            this.materialButtonHelper.setStrokeColor(strokeColor);
        }
    }

    public void setStrokeColorResource(@ColorRes int strokeColorResourceId) {
        if (this.isUsingOriginalBackground()) {
            this.setStrokeColor(AppCompatResources.getColorStateList((Context)this.getContext(), (int)strokeColorResourceId));
        }
    }

    public ColorStateList getStrokeColor() {
        return this.isUsingOriginalBackground() ? this.materialButtonHelper.getStrokeColor() : null;
    }

    public void setStrokeWidth(@Px int strokeWidth) {
        if (this.isUsingOriginalBackground()) {
            this.materialButtonHelper.setStrokeWidth(strokeWidth);
        }
    }

    public void setStrokeWidthResource(@DimenRes int strokeWidthResourceId) {
        if (this.isUsingOriginalBackground()) {
            this.setStrokeWidth(this.getResources().getDimensionPixelSize(strokeWidthResourceId));
        }
    }

    @Px
    public int getStrokeWidth() {
        return this.isUsingOriginalBackground() ? this.materialButtonHelper.getStrokeWidth() : 0;
    }

    public void setCornerRadius(@Px int cornerRadius) {
        if (this.isUsingOriginalBackground()) {
            this.materialButtonHelper.setCornerRadius(cornerRadius);
        }
    }

    public void setCornerRadiusResource(@DimenRes int cornerRadiusResourceId) {
        if (this.isUsingOriginalBackground()) {
            this.setCornerRadius(this.getResources().getDimensionPixelSize(cornerRadiusResourceId));
        }
    }

    @Px
    public int getCornerRadius() {
        return this.isUsingOriginalBackground() ? this.materialButtonHelper.getCornerRadius() : 0;
    }

    public int getIconGravity() {
        return this.iconGravity;
    }

    public void setIconGravity(int iconGravity) {
        if (this.iconGravity != iconGravity) {
            this.iconGravity = iconGravity;
            this.updateIconPosition();
        }
    }

    protected int[] onCreateDrawableState(int extraSpace) {
        int[] drawableState = super.onCreateDrawableState(extraSpace + 2);
        if (this.isCheckable()) {
            MaterialButton.mergeDrawableStates((int[])drawableState, (int[])CHECKABLE_STATE_SET);
        }
        if (this.isChecked()) {
            MaterialButton.mergeDrawableStates((int[])drawableState, (int[])CHECKED_STATE_SET);
        }
        return drawableState;
    }

    public void addOnCheckedChangeListener(@NonNull OnCheckedChangeListener listener) {
        this.onCheckedChangeListeners.add(listener);
    }

    public void removeOnCheckedChangeListener(@NonNull OnCheckedChangeListener listener) {
        this.onCheckedChangeListeners.remove(listener);
    }

    public void clearOnCheckedChangeListeners() {
        this.onCheckedChangeListeners.clear();
    }

    public void setChecked(boolean checked) {
        if (this.isCheckable() && this.isEnabled() && this.checked != checked) {
            this.checked = checked;
            this.refreshDrawableState();
            if (this.broadcasting) {
                return;
            }
            this.broadcasting = true;
            for (OnCheckedChangeListener listener : this.onCheckedChangeListeners) {
                listener.onCheckedChanged(this, this.checked);
            }
            this.broadcasting = false;
        }
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void toggle() {
        this.setChecked(!this.checked);
    }

    public boolean performClick() {
        this.toggle();
        return super.performClick();
    }

    public boolean isCheckable() {
        return this.materialButtonHelper != null && this.materialButtonHelper.isCheckable();
    }

    public void setCheckable(boolean checkable) {
        if (this.isUsingOriginalBackground()) {
            this.materialButtonHelper.setCheckable(checkable);
        }
    }

    @Override
    public void setShapeAppearanceModel(@NonNull ShapeAppearanceModel shapeAppearanceModel) {
        if (!this.isUsingOriginalBackground()) {
            throw new IllegalStateException("Attempted to set ShapeAppearanceModel on a MaterialButton which has an overwritten background.");
        }
        this.materialButtonHelper.setShapeAppearanceModel(shapeAppearanceModel);
    }

    @Override
    @NonNull
    public ShapeAppearanceModel getShapeAppearanceModel() {
        if (this.isUsingOriginalBackground()) {
            return this.materialButtonHelper.getShapeAppearanceModel();
        }
        throw new IllegalStateException("Attempted to get ShapeAppearanceModel from a MaterialButton which has an overwritten background.");
    }

    void setOnPressedChangeListenerInternal(@Nullable OnPressedChangeListener listener) {
        this.onPressedChangeListenerInternal = listener;
    }

    public void setPressed(boolean pressed) {
        if (this.onPressedChangeListenerInternal != null) {
            this.onPressedChangeListenerInternal.onPressedChanged(this, pressed);
        }
        super.setPressed(pressed);
    }

    private boolean isUsingOriginalBackground() {
        return this.materialButtonHelper != null && !this.materialButtonHelper.isBackgroundOverwritten();
    }

    void setShouldDrawSurfaceColorStroke(boolean shouldDrawSurfaceColorStroke) {
        if (this.isUsingOriginalBackground()) {
            this.materialButtonHelper.setShouldDrawSurfaceColorStroke(shouldDrawSurfaceColorStroke);
        }
    }

    static class SavedState
    extends AbsSavedState {
        boolean checked;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.ClassLoaderCreator<SavedState>(){

            @NonNull
            public SavedState createFromParcel(@NonNull Parcel in, ClassLoader loader) {
                return new SavedState(in, loader);
            }

            @NonNull
            public SavedState createFromParcel(@NonNull Parcel in) {
                return new SavedState(in, null);
            }

            @NonNull
            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable superState) {
            super(superState);
        }

        public SavedState(@NonNull Parcel source, ClassLoader loader) {
            super(source, loader);
            if (loader == null) {
                loader = ((Object)((Object)this)).getClass().getClassLoader();
            }
            this.readFromParcel(source);
        }

        public void writeToParcel(@NonNull Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.checked ? 1 : 0);
        }

        private void readFromParcel(@NonNull Parcel in) {
            this.checked = in.readInt() == 1;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IconGravity {
    }

    static interface OnPressedChangeListener {
        public void onPressedChanged(MaterialButton var1, boolean var2);
    }

    public static interface OnCheckedChangeListener {
        public void onCheckedChanged(MaterialButton var1, boolean var2);
    }
}

