/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.card;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.InsetDrawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.Dimension;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.StyleRes;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.view.ViewCompat;
import com.google.android.material.R;
import com.google.android.material.card.MaterialCardView;
import com.google.android.material.color.MaterialColors;
import com.google.android.material.resources.MaterialResources;
import com.google.android.material.ripple.RippleUtils;
import com.google.android.material.shape.CornerTreatment;
import com.google.android.material.shape.CutCornerTreatment;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.RoundedCornerTreatment;
import com.google.android.material.shape.ShapeAppearanceModel;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
class MaterialCardViewHelper {
    private static final int[] CHECKED_STATE_SET = new int[]{0x10100A0};
    private static final int DEFAULT_STROKE_VALUE = -1;
    private static final double COS_45 = Math.cos(Math.toRadians(45.0));
    private static final float CARD_VIEW_SHADOW_MULTIPLIER = 1.5f;
    private static final int CHECKED_ICON_LAYER_INDEX = 2;
    @NonNull
    private final MaterialCardView materialCardView;
    @NonNull
    private final Rect userContentPadding = new Rect();
    @NonNull
    private final MaterialShapeDrawable bgDrawable;
    @NonNull
    private final MaterialShapeDrawable foregroundContentDrawable;
    @Dimension
    private final int checkedIconMargin;
    @Dimension
    private final int checkedIconSize;
    @Dimension
    private int strokeWidth;
    @Nullable
    private Drawable fgDrawable;
    @Nullable
    private Drawable checkedIcon;
    @Nullable
    private ColorStateList rippleColor;
    @Nullable
    private ColorStateList checkedIconTint;
    @Nullable
    private ShapeAppearanceModel shapeAppearanceModel;
    @Nullable
    private ColorStateList strokeColor;
    @Nullable
    private Drawable rippleDrawable;
    @Nullable
    private LayerDrawable clickableForegroundDrawable;
    @Nullable
    private MaterialShapeDrawable compatRippleDrawable;
    @Nullable
    private MaterialShapeDrawable foregroundShapeDrawable;
    private boolean isBackgroundOverwritten = false;
    private boolean checkable;

    public MaterialCardViewHelper(@NonNull MaterialCardView card, AttributeSet attrs, int defStyleAttr, @StyleRes int defStyleRes) {
        this.materialCardView = card;
        this.bgDrawable = new MaterialShapeDrawable(card.getContext(), attrs, defStyleAttr, defStyleRes);
        this.bgDrawable.initializeElevationOverlay(card.getContext());
        this.bgDrawable.setShadowColor(-12303292);
        ShapeAppearanceModel.Builder shapeAppearanceModelBuilder = this.bgDrawable.getShapeAppearanceModel().toBuilder();
        TypedArray cardViewAttributes = card.getContext().obtainStyledAttributes(attrs, R.styleable.CardView, defStyleAttr, R.style.CardView);
        if (cardViewAttributes.hasValue(R.styleable.CardView_cardCornerRadius)) {
            shapeAppearanceModelBuilder.setAllCornerSizes(cardViewAttributes.getDimension(R.styleable.CardView_cardCornerRadius, 0.0f));
        }
        this.foregroundContentDrawable = new MaterialShapeDrawable();
        this.setShapeAppearanceModel(shapeAppearanceModelBuilder.build());
        Resources resources = card.getResources();
        this.checkedIconMargin = resources.getDimensionPixelSize(R.dimen.mtrl_card_checked_icon_margin);
        this.checkedIconSize = resources.getDimensionPixelSize(R.dimen.mtrl_card_checked_icon_size);
        cardViewAttributes.recycle();
    }

    void loadFromAttributes(@NonNull TypedArray attributes) {
        this.strokeColor = MaterialResources.getColorStateList(this.materialCardView.getContext(), attributes, R.styleable.MaterialCardView_strokeColor);
        if (this.strokeColor == null) {
            this.strokeColor = ColorStateList.valueOf((int)-1);
        }
        this.strokeWidth = attributes.getDimensionPixelSize(R.styleable.MaterialCardView_strokeWidth, 0);
        this.checkable = attributes.getBoolean(R.styleable.MaterialCardView_android_checkable, false);
        this.materialCardView.setLongClickable(this.checkable);
        this.checkedIconTint = MaterialResources.getColorStateList(this.materialCardView.getContext(), attributes, R.styleable.MaterialCardView_checkedIconTint);
        this.setCheckedIcon(MaterialResources.getDrawable(this.materialCardView.getContext(), attributes, R.styleable.MaterialCardView_checkedIcon));
        this.rippleColor = MaterialResources.getColorStateList(this.materialCardView.getContext(), attributes, R.styleable.MaterialCardView_rippleColor);
        if (this.rippleColor == null) {
            this.rippleColor = ColorStateList.valueOf((int)MaterialColors.getColor((View)this.materialCardView, R.attr.colorControlHighlight));
        }
        ColorStateList foregroundColor = MaterialResources.getColorStateList(this.materialCardView.getContext(), attributes, R.styleable.MaterialCardView_cardForegroundColor);
        this.setCardForegroundColor(foregroundColor);
        this.updateRippleColor();
        this.updateElevation();
        this.updateStroke();
        this.materialCardView.setBackgroundInternal(this.insetDrawable(this.bgDrawable));
        this.fgDrawable = this.materialCardView.isClickable() ? this.getClickableForeground() : this.foregroundContentDrawable;
        this.materialCardView.setForeground(this.insetDrawable(this.fgDrawable));
    }

    boolean isBackgroundOverwritten() {
        return this.isBackgroundOverwritten;
    }

    void setBackgroundOverwritten(boolean isBackgroundOverwritten) {
        this.isBackgroundOverwritten = isBackgroundOverwritten;
    }

    void setStrokeColor(ColorStateList strokeColor) {
        if (this.strokeColor == strokeColor) {
            return;
        }
        this.strokeColor = strokeColor;
        this.updateStroke();
    }

    @ColorInt
    int getStrokeColor() {
        return this.strokeColor == null ? -1 : this.strokeColor.getDefaultColor();
    }

    @Nullable
    ColorStateList getStrokeColorStateList() {
        return this.strokeColor;
    }

    void setStrokeWidth(@Dimension int strokeWidth) {
        if (strokeWidth == this.strokeWidth) {
            return;
        }
        this.strokeWidth = strokeWidth;
        this.updateStroke();
    }

    @Dimension
    int getStrokeWidth() {
        return this.strokeWidth;
    }

    @NonNull
    MaterialShapeDrawable getBackground() {
        return this.bgDrawable;
    }

    void setCardBackgroundColor(ColorStateList color2) {
        this.bgDrawable.setFillColor(color2);
    }

    ColorStateList getCardBackgroundColor() {
        return this.bgDrawable.getFillColor();
    }

    void setCardForegroundColor(@Nullable ColorStateList foregroundColor) {
        this.foregroundContentDrawable.setFillColor(foregroundColor == null ? ColorStateList.valueOf((int)0) : foregroundColor);
    }

    ColorStateList getCardForegroundColor() {
        return this.foregroundContentDrawable.getFillColor();
    }

    void setUserContentPadding(int left, int top, int right, int bottom) {
        this.userContentPadding.set(left, top, right, bottom);
        this.updateContentPadding();
    }

    @NonNull
    Rect getUserContentPadding() {
        return this.userContentPadding;
    }

    void updateClickable() {
        Drawable previousFgDrawable = this.fgDrawable;
        Object object = this.fgDrawable = this.materialCardView.isClickable() ? this.getClickableForeground() : this.foregroundContentDrawable;
        if (previousFgDrawable != this.fgDrawable) {
            this.updateInsetForeground(this.fgDrawable);
        }
    }

    void setCornerRadius(float cornerRadius) {
        this.setShapeAppearanceModel(this.shapeAppearanceModel.withCornerSize(cornerRadius));
        this.fgDrawable.invalidateSelf();
        if (this.shouldAddCornerPaddingOutsideCardBackground() || this.shouldAddCornerPaddingInsideCardBackground()) {
            this.updateContentPadding();
        }
        if (this.shouldAddCornerPaddingOutsideCardBackground()) {
            this.updateInsets();
        }
    }

    float getCornerRadius() {
        return this.bgDrawable.getTopLeftCornerResolvedSize();
    }

    void setProgress(@FloatRange(from=0.0, to=1.0) float progress) {
        this.bgDrawable.setInterpolation(progress);
        if (this.foregroundContentDrawable != null) {
            this.foregroundContentDrawable.setInterpolation(progress);
        }
        if (this.foregroundShapeDrawable != null) {
            this.foregroundShapeDrawable.setInterpolation(progress);
        }
    }

    @FloatRange(from=0.0, to=1.0)
    float getProgress() {
        return this.bgDrawable.getInterpolation();
    }

    void updateElevation() {
        this.bgDrawable.setElevation(this.materialCardView.getCardElevation());
    }

    void updateInsets() {
        if (!this.isBackgroundOverwritten()) {
            this.materialCardView.setBackgroundInternal(this.insetDrawable(this.bgDrawable));
        }
        this.materialCardView.setForeground(this.insetDrawable(this.fgDrawable));
    }

    void updateStroke() {
        this.foregroundContentDrawable.setStroke((float)this.strokeWidth, this.strokeColor);
    }

    void updateContentPadding() {
        boolean includeCornerPadding = this.shouldAddCornerPaddingInsideCardBackground() || this.shouldAddCornerPaddingOutsideCardBackground();
        int contentPaddingOffset = (int)((includeCornerPadding ? this.calculateActualCornerPadding() : 0.0f) - this.getParentCardViewCalculatedCornerPadding());
        this.materialCardView.setAncestorContentPadding(this.userContentPadding.left + contentPaddingOffset, this.userContentPadding.top + contentPaddingOffset, this.userContentPadding.right + contentPaddingOffset, this.userContentPadding.bottom + contentPaddingOffset);
    }

    void setCheckable(boolean checkable) {
        this.checkable = checkable;
    }

    boolean isCheckable() {
        return this.checkable;
    }

    void setRippleColor(@Nullable ColorStateList rippleColor) {
        this.rippleColor = rippleColor;
        this.updateRippleColor();
    }

    void setCheckedIconTint(@Nullable ColorStateList checkedIconTint) {
        this.checkedIconTint = checkedIconTint;
        if (this.checkedIcon != null) {
            DrawableCompat.setTintList((Drawable)this.checkedIcon, (ColorStateList)checkedIconTint);
        }
    }

    @Nullable
    ColorStateList getCheckedIconTint() {
        return this.checkedIconTint;
    }

    @Nullable
    ColorStateList getRippleColor() {
        return this.rippleColor;
    }

    @Nullable
    Drawable getCheckedIcon() {
        return this.checkedIcon;
    }

    void setCheckedIcon(@Nullable Drawable checkedIcon) {
        this.checkedIcon = checkedIcon;
        if (checkedIcon != null) {
            this.checkedIcon = DrawableCompat.wrap((Drawable)checkedIcon.mutate());
            DrawableCompat.setTintList((Drawable)this.checkedIcon, (ColorStateList)this.checkedIconTint);
        }
        if (this.clickableForegroundDrawable != null) {
            Drawable checkedLayer = this.createCheckedIconLayer();
            this.clickableForegroundDrawable.setDrawableByLayerId(R.id.mtrl_card_checked_layer_id, checkedLayer);
        }
    }

    void onMeasure(int measuredWidth, int measuredHeight) {
        if (this.clickableForegroundDrawable != null) {
            boolean isPreLollipop;
            int left = measuredWidth - this.checkedIconMargin - this.checkedIconSize;
            int bottom = measuredHeight - this.checkedIconMargin - this.checkedIconSize;
            boolean bl = isPreLollipop = Build.VERSION.SDK_INT < 21;
            if (isPreLollipop || this.materialCardView.getUseCompatPadding()) {
                bottom -= (int)Math.ceil(2.0f * this.calculateVerticalBackgroundPadding());
                left -= (int)Math.ceil(2.0f * this.calculateHorizontalBackgroundPadding());
            }
            int right = this.checkedIconMargin;
            if (ViewCompat.getLayoutDirection((View)this.materialCardView) == 1) {
                int tmp = right;
                right = left;
                left = tmp;
            }
            this.clickableForegroundDrawable.setLayerInset(2, left, this.checkedIconMargin, right, bottom);
        }
    }

    @RequiresApi(api=23)
    void forceRippleRedraw() {
        if (this.rippleDrawable != null) {
            Rect bounds = this.rippleDrawable.getBounds();
            int bottom = bounds.bottom;
            this.rippleDrawable.setBounds(bounds.left, bounds.top, bounds.right, bottom - 1);
            this.rippleDrawable.setBounds(bounds.left, bounds.top, bounds.right, bottom);
        }
    }

    void setShapeAppearanceModel(@NonNull ShapeAppearanceModel shapeAppearanceModel) {
        this.shapeAppearanceModel = shapeAppearanceModel;
        this.bgDrawable.setShapeAppearanceModel(shapeAppearanceModel);
        this.bgDrawable.setShadowBitmapDrawingEnable(!this.bgDrawable.isRoundRect());
        if (this.foregroundContentDrawable != null) {
            this.foregroundContentDrawable.setShapeAppearanceModel(shapeAppearanceModel);
        }
        if (this.foregroundShapeDrawable != null) {
            this.foregroundShapeDrawable.setShapeAppearanceModel(shapeAppearanceModel);
        }
        if (this.compatRippleDrawable != null) {
            this.compatRippleDrawable.setShapeAppearanceModel(shapeAppearanceModel);
        }
    }

    ShapeAppearanceModel getShapeAppearanceModel() {
        return this.shapeAppearanceModel;
    }

    private void updateInsetForeground(Drawable insetForeground) {
        if (Build.VERSION.SDK_INT >= 23 && this.materialCardView.getForeground() instanceof InsetDrawable) {
            ((InsetDrawable)this.materialCardView.getForeground()).setDrawable(insetForeground);
        } else {
            this.materialCardView.setForeground(this.insetDrawable(insetForeground));
        }
    }

    @NonNull
    private Drawable insetDrawable(Drawable originalDrawable) {
        boolean isPreLollipop;
        int insetVertical = 0;
        int insetHorizontal = 0;
        boolean bl = isPreLollipop = Build.VERSION.SDK_INT < 21;
        if (isPreLollipop || this.materialCardView.getUseCompatPadding()) {
            insetVertical = (int)Math.ceil(this.calculateVerticalBackgroundPadding());
            insetHorizontal = (int)Math.ceil(this.calculateHorizontalBackgroundPadding());
        }
        return new InsetDrawable(originalDrawable, insetHorizontal, insetVertical, insetHorizontal, insetVertical){

            public boolean getPadding(Rect padding) {
                return false;
            }

            public int getMinimumWidth() {
                return -1;
            }

            public int getMinimumHeight() {
                return -1;
            }
        };
    }

    private float calculateVerticalBackgroundPadding() {
        return this.materialCardView.getMaxCardElevation() * 1.5f + (this.shouldAddCornerPaddingOutsideCardBackground() ? this.calculateActualCornerPadding() : 0.0f);
    }

    private float calculateHorizontalBackgroundPadding() {
        return this.materialCardView.getMaxCardElevation() + (this.shouldAddCornerPaddingOutsideCardBackground() ? this.calculateActualCornerPadding() : 0.0f);
    }

    private boolean canClipToOutline() {
        return Build.VERSION.SDK_INT >= 21 && this.bgDrawable.isRoundRect();
    }

    private float getParentCardViewCalculatedCornerPadding() {
        if (this.materialCardView.getPreventCornerOverlap() && (Build.VERSION.SDK_INT < 21 || this.materialCardView.getUseCompatPadding())) {
            return (float)((1.0 - COS_45) * (double)this.materialCardView.getCardViewRadius());
        }
        return 0.0f;
    }

    private boolean shouldAddCornerPaddingInsideCardBackground() {
        return this.materialCardView.getPreventCornerOverlap() && !this.canClipToOutline();
    }

    private boolean shouldAddCornerPaddingOutsideCardBackground() {
        return this.materialCardView.getPreventCornerOverlap() && this.canClipToOutline() && this.materialCardView.getUseCompatPadding();
    }

    private float calculateActualCornerPadding() {
        return Math.max(Math.max(this.calculateCornerPaddingForCornerTreatment(this.shapeAppearanceModel.getTopLeftCorner(), this.bgDrawable.getTopLeftCornerResolvedSize()), this.calculateCornerPaddingForCornerTreatment(this.shapeAppearanceModel.getTopRightCorner(), this.bgDrawable.getTopRightCornerResolvedSize())), Math.max(this.calculateCornerPaddingForCornerTreatment(this.shapeAppearanceModel.getBottomRightCorner(), this.bgDrawable.getBottomRightCornerResolvedSize()), this.calculateCornerPaddingForCornerTreatment(this.shapeAppearanceModel.getBottomLeftCorner(), this.bgDrawable.getBottomLeftCornerResolvedSize())));
    }

    private float calculateCornerPaddingForCornerTreatment(CornerTreatment treatment, float size) {
        if (treatment instanceof RoundedCornerTreatment) {
            return (float)((1.0 - COS_45) * (double)size);
        }
        if (treatment instanceof CutCornerTreatment) {
            return size / 2.0f;
        }
        return 0.0f;
    }

    @NonNull
    private Drawable getClickableForeground() {
        if (this.rippleDrawable == null) {
            this.rippleDrawable = this.createForegroundRippleDrawable();
        }
        if (this.clickableForegroundDrawable == null) {
            Drawable checkedLayer = this.createCheckedIconLayer();
            this.clickableForegroundDrawable = new LayerDrawable(new Drawable[]{this.rippleDrawable, this.foregroundContentDrawable, checkedLayer});
            this.clickableForegroundDrawable.setId(2, R.id.mtrl_card_checked_layer_id);
        }
        return this.clickableForegroundDrawable;
    }

    @NonNull
    private Drawable createForegroundRippleDrawable() {
        if (RippleUtils.USE_FRAMEWORK_RIPPLE) {
            this.foregroundShapeDrawable = this.createForegroundShapeDrawable();
            return new RippleDrawable(this.rippleColor, null, (Drawable)this.foregroundShapeDrawable);
        }
        return this.createCompatRippleDrawable();
    }

    @NonNull
    private Drawable createCompatRippleDrawable() {
        StateListDrawable rippleDrawable = new StateListDrawable();
        this.compatRippleDrawable = this.createForegroundShapeDrawable();
        this.compatRippleDrawable.setFillColor(this.rippleColor);
        rippleDrawable.addState(new int[]{16842919}, (Drawable)this.compatRippleDrawable);
        return rippleDrawable;
    }

    private void updateRippleColor() {
        if (RippleUtils.USE_FRAMEWORK_RIPPLE && this.rippleDrawable != null) {
            ((RippleDrawable)this.rippleDrawable).setColor(this.rippleColor);
        } else if (this.compatRippleDrawable != null) {
            this.compatRippleDrawable.setFillColor(this.rippleColor);
        }
    }

    @NonNull
    private Drawable createCheckedIconLayer() {
        StateListDrawable checkedLayer = new StateListDrawable();
        if (this.checkedIcon != null) {
            checkedLayer.addState(CHECKED_STATE_SET, this.checkedIcon);
        }
        return checkedLayer;
    }

    @NonNull
    private MaterialShapeDrawable createForegroundShapeDrawable() {
        return new MaterialShapeDrawable(this.shapeAppearanceModel);
    }
}

