/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.color;

import android.content.Context;
import android.graphics.Color;
import android.util.TypedValue;
import android.view.View;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.core.graphics.ColorUtils;
import com.google.android.material.resources.MaterialAttributes;

public class MaterialColors {
    public static final float ALPHA_FULL = 1.0f;
    public static final float ALPHA_MEDIUM = 0.54f;
    public static final float ALPHA_DISABLED = 0.38f;
    public static final float ALPHA_LOW = 0.32f;
    public static final float ALPHA_DISABLED_LOW = 0.12f;

    private MaterialColors() {
    }

    @ColorInt
    public static int getColor(@NonNull View view, @AttrRes int colorAttributeResId) {
        return MaterialAttributes.resolveOrThrow(view, colorAttributeResId);
    }

    @ColorInt
    public static int getColor(Context context, @AttrRes int colorAttributeResId, String errorMessageComponent) {
        return MaterialAttributes.resolveOrThrow(context, colorAttributeResId, errorMessageComponent);
    }

    @ColorInt
    public static int getColor(@NonNull View view, @AttrRes int colorAttributeResId, @ColorInt int defaultValue) {
        return MaterialColors.getColor(view.getContext(), colorAttributeResId, defaultValue);
    }

    @ColorInt
    public static int getColor(@NonNull Context context, @AttrRes int colorAttributeResId, @ColorInt int defaultValue) {
        TypedValue typedValue = MaterialAttributes.resolve(context, colorAttributeResId);
        if (typedValue != null) {
            return typedValue.data;
        }
        return defaultValue;
    }

    @ColorInt
    public static int layer(@NonNull View view, @AttrRes int backgroundColorAttributeResId, @AttrRes int overlayColorAttributeResId) {
        return MaterialColors.layer(view, backgroundColorAttributeResId, overlayColorAttributeResId, 1.0f);
    }

    @ColorInt
    public static int layer(@NonNull View view, @AttrRes int backgroundColorAttributeResId, @AttrRes int overlayColorAttributeResId, @FloatRange(from=0.0, to=1.0) float overlayAlpha) {
        int backgroundColor = MaterialColors.getColor(view, backgroundColorAttributeResId);
        int overlayColor = MaterialColors.getColor(view, overlayColorAttributeResId);
        return MaterialColors.layer(backgroundColor, overlayColor, overlayAlpha);
    }

    @ColorInt
    public static int layer(@ColorInt int backgroundColor, @ColorInt int overlayColor, @FloatRange(from=0.0, to=1.0) float overlayAlpha) {
        int computedAlpha = Math.round((float)Color.alpha((int)overlayColor) * overlayAlpha);
        int computedOverlayColor = ColorUtils.setAlphaComponent((int)overlayColor, (int)computedAlpha);
        return MaterialColors.layer(backgroundColor, computedOverlayColor);
    }

    @ColorInt
    public static int layer(@ColorInt int backgroundColor, @ColorInt int overlayColor) {
        return ColorUtils.compositeColors((int)overlayColor, (int)backgroundColor);
    }

    @ColorInt
    public static int compositeARGBWithAlpha(@ColorInt int originalARGB, @IntRange(from=0L, to=255L) int alpha) {
        alpha = Color.alpha((int)originalARGB) * alpha / 255;
        return ColorUtils.setAlphaComponent((int)originalARGB, (int)alpha);
    }
}

