/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.datepicker;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import com.google.android.material.datepicker.DateValidatorPointForward;
import com.google.android.material.datepicker.MaterialDatePicker;
import com.google.android.material.datepicker.Month;
import com.google.android.material.datepicker.UtcDates;
import java.util.Arrays;

public final class CalendarConstraints
implements Parcelable {
    @NonNull
    private final Month start;
    @NonNull
    private final Month end;
    @NonNull
    private final Month openAt;
    private final DateValidator validator;
    private final int yearSpan;
    private final int monthSpan;
    public static final Parcelable.Creator<CalendarConstraints> CREATOR = new Parcelable.Creator<CalendarConstraints>(){

        @NonNull
        public CalendarConstraints createFromParcel(@NonNull Parcel source) {
            Month start = (Month)source.readParcelable(Month.class.getClassLoader());
            Month end = (Month)source.readParcelable(Month.class.getClassLoader());
            Month openAt = (Month)source.readParcelable(Month.class.getClassLoader());
            DateValidator validator = (DateValidator)source.readParcelable(DateValidator.class.getClassLoader());
            return new CalendarConstraints(start, end, openAt, validator);
        }

        @NonNull
        public CalendarConstraints[] newArray(int size) {
            return new CalendarConstraints[size];
        }
    };

    private CalendarConstraints(@NonNull Month start, @NonNull Month end, @NonNull Month openAt, DateValidator validator) {
        this.start = start;
        this.end = end;
        this.openAt = openAt;
        this.validator = validator;
        if (start.compareTo(openAt) > 0) {
            throw new IllegalArgumentException("start Month cannot be after current Month");
        }
        if (openAt.compareTo(end) > 0) {
            throw new IllegalArgumentException("current Month cannot be after end Month");
        }
        this.monthSpan = start.monthsUntil(end) + 1;
        this.yearSpan = end.year - start.year + 1;
    }

    boolean isWithinBounds(long date) {
        return this.start.getDay(1) <= date && date <= this.end.getDay(this.end.daysInMonth);
    }

    public DateValidator getDateValidator() {
        return this.validator;
    }

    @NonNull
    Month getStart() {
        return this.start;
    }

    @NonNull
    Month getEnd() {
        return this.end;
    }

    @NonNull
    Month getOpenAt() {
        return this.openAt;
    }

    int getMonthSpan() {
        return this.monthSpan;
    }

    int getYearSpan() {
        return this.yearSpan;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CalendarConstraints)) {
            return false;
        }
        CalendarConstraints that = (CalendarConstraints)o;
        return this.start.equals(that.start) && this.end.equals(that.end) && this.openAt.equals(that.openAt) && this.validator.equals(that.validator);
    }

    public int hashCode() {
        Object[] hashedFields = new Object[]{this.start, this.end, this.openAt, this.validator};
        return Arrays.hashCode(hashedFields);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable((Parcelable)this.start, 0);
        dest.writeParcelable((Parcelable)this.end, 0);
        dest.writeParcelable((Parcelable)this.openAt, 0);
        dest.writeParcelable((Parcelable)this.validator, 0);
    }

    Month clamp(Month month) {
        if (month.compareTo(this.start) < 0) {
            return this.start;
        }
        if (month.compareTo(this.end) > 0) {
            return this.end;
        }
        return month;
    }

    public static final class Builder {
        static final long DEFAULT_START = UtcDates.canonicalYearMonthDay(Month.create((int)1900, (int)0).timeInMillis);
        static final long DEFAULT_END = UtcDates.canonicalYearMonthDay(Month.create((int)2100, (int)11).timeInMillis);
        private static final String DEEP_COPY_VALIDATOR_KEY = "DEEP_COPY_VALIDATOR_KEY";
        private long start = DEFAULT_START;
        private long end = DEFAULT_END;
        private Long openAt;
        private DateValidator validator = DateValidatorPointForward.from(Long.MIN_VALUE);

        public Builder() {
        }

        Builder(@NonNull CalendarConstraints clone) {
            this.start = ((CalendarConstraints)clone).start.timeInMillis;
            this.end = ((CalendarConstraints)clone).end.timeInMillis;
            this.openAt = ((CalendarConstraints)clone).openAt.timeInMillis;
            this.validator = clone.validator;
        }

        @NonNull
        public Builder setStart(long month) {
            this.start = month;
            return this;
        }

        @NonNull
        public Builder setEnd(long month) {
            this.end = month;
            return this;
        }

        @NonNull
        public Builder setOpenAt(long month) {
            this.openAt = month;
            return this;
        }

        @NonNull
        public Builder setValidator(DateValidator validator) {
            this.validator = validator;
            return this;
        }

        @NonNull
        public CalendarConstraints build() {
            if (this.openAt == null) {
                long today = MaterialDatePicker.thisMonthInUtcMilliseconds();
                this.openAt = this.start <= today && today <= this.end ? today : this.start;
            }
            Bundle deepCopyBundle = new Bundle();
            deepCopyBundle.putParcelable(DEEP_COPY_VALIDATOR_KEY, (Parcelable)this.validator);
            return new CalendarConstraints(Month.create(this.start), Month.create(this.end), Month.create(this.openAt), (DateValidator)deepCopyBundle.getParcelable(DEEP_COPY_VALIDATOR_KEY));
        }
    }

    public static interface DateValidator
    extends Parcelable {
        public boolean isValid(long var1);
    }
}

