/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.datepicker;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import com.google.android.material.datepicker.CalendarConstraints;
import java.util.ArrayList;
import java.util.List;

public final class CompositeDateValidator
implements CalendarConstraints.DateValidator {
    @NonNull
    private final List<CalendarConstraints.DateValidator> validators;
    public static final Parcelable.Creator<CompositeDateValidator> CREATOR = new Parcelable.Creator<CompositeDateValidator>(){

        @NonNull
        public CompositeDateValidator createFromParcel(@NonNull Parcel source) {
            ArrayList validators = source.readArrayList(CalendarConstraints.DateValidator.class.getClassLoader());
            return new CompositeDateValidator((List)Preconditions.checkNotNull((Object)validators));
        }

        @NonNull
        public CompositeDateValidator[] newArray(int size) {
            return new CompositeDateValidator[size];
        }
    };

    private CompositeDateValidator(@NonNull List<CalendarConstraints.DateValidator> validators) {
        this.validators = validators;
    }

    @NonNull
    public static CalendarConstraints.DateValidator allOf(@NonNull List<CalendarConstraints.DateValidator> validators) {
        return new CompositeDateValidator(validators);
    }

    @Override
    public boolean isValid(long date) {
        for (CalendarConstraints.DateValidator validator : this.validators) {
            if (validator == null || validator.isValid(date)) continue;
            return false;
        }
        return true;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeList(this.validators);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompositeDateValidator)) {
            return false;
        }
        CompositeDateValidator that = (CompositeDateValidator)o;
        return this.validators.equals(that.validators);
    }

    public int hashCode() {
        return this.validators.hashCode();
    }
}

