/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.datepicker;

import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.material.R;
import com.google.android.material.datepicker.CalendarConstraints;
import com.google.android.material.datepicker.DateStrings;
import com.google.android.material.datepicker.UtcDates;
import com.google.android.material.textfield.TextInputLayout;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;

abstract class DateFormatTextWatcher
implements TextWatcher {
    private final String formatHint;
    private final DateFormat dateFormat;
    @NonNull
    private final TextInputLayout textInputLayout;
    private final CalendarConstraints constraints;
    private final String outOfRange;

    DateFormatTextWatcher(String formatHint, DateFormat dateFormat, @NonNull TextInputLayout textInputLayout, CalendarConstraints constraints) {
        this.formatHint = formatHint;
        this.dateFormat = dateFormat;
        this.textInputLayout = textInputLayout;
        this.constraints = constraints;
        this.outOfRange = textInputLayout.getContext().getString(R.string.mtrl_picker_out_of_range);
    }

    abstract void onValidDate(@Nullable Long var1);

    void onInvalidDate() {
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(@NonNull CharSequence s, int start, int before, int count) {
        if (TextUtils.isEmpty((CharSequence)s)) {
            this.textInputLayout.setError(null);
            this.onValidDate(null);
            return;
        }
        try {
            Date date = this.dateFormat.parse(s.toString());
            this.textInputLayout.setError(null);
            long milliseconds = date.getTime();
            if (this.constraints.getDateValidator().isValid(milliseconds) && this.constraints.isWithinBounds(milliseconds)) {
                this.onValidDate(date.getTime());
            } else {
                this.textInputLayout.setError(String.format(this.outOfRange, DateStrings.getDateString(milliseconds)));
                this.onInvalidDate();
            }
        }
        catch (ParseException e) {
            String invalidFormat = this.textInputLayout.getContext().getString(R.string.mtrl_picker_invalid_format);
            String useLine = String.format(this.textInputLayout.getContext().getString(R.string.mtrl_picker_invalid_format_use), this.formatHint);
            String exampleLine = String.format(this.textInputLayout.getContext().getString(R.string.mtrl_picker_invalid_format_example), this.dateFormat.format(new Date(UtcDates.getTodayCalendar().getTimeInMillis())));
            this.textInputLayout.setError(invalidFormat + "\n" + useLine + "\n" + exampleLine);
            this.onInvalidDate();
        }
    }

    public void afterTextChanged(Editable s) {
    }
}

