/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.datepicker;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.View;
import android.widget.GridView;
import android.widget.ListAdapter;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Pair;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import com.google.android.material.R;
import com.google.android.material.datepicker.CalendarStyle;
import com.google.android.material.datepicker.DateSelector;
import com.google.android.material.datepicker.MaterialDatePicker;
import com.google.android.material.datepicker.MonthAdapter;
import com.google.android.material.datepicker.UtcDates;
import java.util.Calendar;

final class MaterialCalendarGridView
extends GridView {
    private final Calendar dayCompute = UtcDates.getUtcCalendar();

    public MaterialCalendarGridView(Context context) {
        this(context, null);
    }

    public MaterialCalendarGridView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MaterialCalendarGridView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (MaterialDatePicker.isFullscreen(this.getContext())) {
            this.setNextFocusLeftId(R.id.cancel_button);
            this.setNextFocusRightId(R.id.confirm_button);
        }
        ViewCompat.setAccessibilityDelegate((View)this, (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(){

            public void onInitializeAccessibilityNodeInfo(View view, @NonNull AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
                super.onInitializeAccessibilityNodeInfo(view, accessibilityNodeInfoCompat);
                accessibilityNodeInfoCompat.setCollectionInfo(null);
            }
        });
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.getAdapter().notifyDataSetChanged();
    }

    public void setSelection(int position) {
        if (position < this.getAdapter().firstPositionInMonth()) {
            super.setSelection(this.getAdapter().firstPositionInMonth());
        } else {
            super.setSelection(position);
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        boolean result = super.onKeyDown(keyCode, event);
        if (!result) {
            return false;
        }
        if (this.getSelectedItemPosition() == -1 || this.getSelectedItemPosition() >= this.getAdapter().firstPositionInMonth()) {
            return true;
        }
        if (19 == keyCode) {
            this.setSelection(this.getAdapter().firstPositionInMonth());
            return true;
        }
        return false;
    }

    @NonNull
    public MonthAdapter getAdapter() {
        return (MonthAdapter)super.getAdapter();
    }

    public final void setAdapter(ListAdapter adapter) {
        if (!(adapter instanceof MonthAdapter)) {
            throw new IllegalArgumentException(String.format("%1$s must have its Adapter set to a %2$s", MaterialCalendarGridView.class.getCanonicalName(), MonthAdapter.class.getCanonicalName()));
        }
        super.setAdapter(adapter);
    }

    protected final void onDraw(@NonNull Canvas canvas) {
        super.onDraw(canvas);
        MonthAdapter monthAdapter = this.getAdapter();
        DateSelector<?> dateSelector = monthAdapter.dateSelector;
        CalendarStyle calendarStyle = monthAdapter.calendarStyle;
        Long firstOfMonth = monthAdapter.getItem(monthAdapter.firstPositionInMonth());
        Long lastOfMonth = monthAdapter.getItem(monthAdapter.lastPositionInMonth());
        for (Pair<Long, Long> range : dateSelector.getSelectedRanges()) {
            int rangeHighlightEnd;
            int lastHighlightPosition;
            int rangeHighlightStart;
            int firstHighlightPosition;
            if (range.first == null || range.second == null) continue;
            long startItem = (Long)range.first;
            long endItem = (Long)range.second;
            if (MaterialCalendarGridView.skipMonth(firstOfMonth, lastOfMonth, startItem, endItem)) {
                return;
            }
            if (startItem < firstOfMonth) {
                firstHighlightPosition = monthAdapter.firstPositionInMonth();
                rangeHighlightStart = monthAdapter.isFirstInRow(firstHighlightPosition) ? 0 : this.getChildAt(firstHighlightPosition - 1).getRight();
            } else {
                this.dayCompute.setTimeInMillis(startItem);
                firstHighlightPosition = monthAdapter.dayToPosition(this.dayCompute.get(5));
                rangeHighlightStart = MaterialCalendarGridView.horizontalMidPoint(this.getChildAt(firstHighlightPosition));
            }
            if (endItem > lastOfMonth) {
                lastHighlightPosition = Math.min(monthAdapter.lastPositionInMonth(), this.getChildCount() - 1);
                rangeHighlightEnd = monthAdapter.isLastInRow(lastHighlightPosition) ? this.getWidth() : this.getChildAt(lastHighlightPosition).getRight();
            } else {
                this.dayCompute.setTimeInMillis(endItem);
                lastHighlightPosition = monthAdapter.dayToPosition(this.dayCompute.get(5));
                rangeHighlightEnd = MaterialCalendarGridView.horizontalMidPoint(this.getChildAt(lastHighlightPosition));
            }
            int firstRow = (int)monthAdapter.getItemId(firstHighlightPosition);
            int lastRow = (int)monthAdapter.getItemId(lastHighlightPosition);
            for (int row = firstRow; row <= lastRow; ++row) {
                int firstPositionInRow = row * this.getNumColumns();
                int lastPositionInRow = firstPositionInRow + this.getNumColumns() - 1;
                View firstView = this.getChildAt(firstPositionInRow);
                int top = firstView.getTop() + calendarStyle.day.getTopInset();
                int bottom = firstView.getBottom() - calendarStyle.day.getBottomInset();
                int left = firstPositionInRow > firstHighlightPosition ? 0 : rangeHighlightStart;
                int right = lastHighlightPosition > lastPositionInRow ? this.getWidth() : rangeHighlightEnd;
                canvas.drawRect((float)left, (float)top, (float)right, (float)bottom, calendarStyle.rangeFill);
            }
        }
    }

    protected void onFocusChanged(boolean gainFocus, int direction, Rect previouslyFocusedRect) {
        if (gainFocus) {
            this.gainFocus(direction, previouslyFocusedRect);
        } else {
            super.onFocusChanged(false, direction, previouslyFocusedRect);
        }
    }

    private void gainFocus(int direction, Rect previouslyFocusedRect) {
        if (direction == 33) {
            this.setSelection(this.getAdapter().lastPositionInMonth());
        } else if (direction == 130) {
            this.setSelection(this.getAdapter().firstPositionInMonth());
        } else {
            super.onFocusChanged(true, direction, previouslyFocusedRect);
        }
    }

    private static boolean skipMonth(@Nullable Long firstOfMonth, @Nullable Long lastOfMonth, @Nullable Long startDay, @Nullable Long endDay) {
        if (firstOfMonth == null || lastOfMonth == null || startDay == null || endDay == null) {
            return true;
        }
        return startDay > lastOfMonth || endDay < firstOfMonth;
    }

    private static int horizontalMidPoint(@NonNull View view) {
        return view.getLeft() + view.getWidth() / 2;
    }
}

