/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.datepicker;

import android.os.Bundle;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.google.android.material.datepicker.CalendarConstraints;
import com.google.android.material.datepicker.DateSelector;
import com.google.android.material.datepicker.OnSelectionChangedListener;
import com.google.android.material.datepicker.PickerFragment;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class MaterialTextInputPicker<S>
extends PickerFragment<S> {
    private static final String DATE_SELECTOR_KEY = "DATE_SELECTOR_KEY";
    private static final String CALENDAR_CONSTRAINTS_KEY = "CALENDAR_CONSTRAINTS_KEY";
    @Nullable
    private DateSelector<S> dateSelector;
    @Nullable
    private CalendarConstraints calendarConstraints;

    @NonNull
    static <T> MaterialTextInputPicker<T> newInstance(@NonNull DateSelector<T> dateSelector, @NonNull CalendarConstraints calendarConstraints) {
        MaterialTextInputPicker materialCalendar = new MaterialTextInputPicker();
        Bundle args = new Bundle();
        args.putParcelable(DATE_SELECTOR_KEY, dateSelector);
        args.putParcelable(CALENDAR_CONSTRAINTS_KEY, (Parcelable)calendarConstraints);
        materialCalendar.setArguments(args);
        return materialCalendar;
    }

    public void onSaveInstanceState(@NonNull Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putParcelable(DATE_SELECTOR_KEY, this.dateSelector);
        bundle.putParcelable(CALENDAR_CONSTRAINTS_KEY, (Parcelable)this.calendarConstraints);
    }

    public void onCreate(@Nullable Bundle bundle) {
        super.onCreate(bundle);
        Bundle activeBundle = bundle == null ? this.getArguments() : bundle;
        this.dateSelector = (DateSelector)activeBundle.getParcelable(DATE_SELECTOR_KEY);
        this.calendarConstraints = (CalendarConstraints)activeBundle.getParcelable(CALENDAR_CONSTRAINTS_KEY);
    }

    @NonNull
    public View onCreateView(@NonNull LayoutInflater layoutInflater, @Nullable ViewGroup viewGroup, @Nullable Bundle bundle) {
        return this.dateSelector.onCreateTextInputView(layoutInflater, viewGroup, bundle, this.calendarConstraints, new OnSelectionChangedListener<S>(){

            @Override
            public void onSelectionChanged(S selection) {
                for (OnSelectionChangedListener listener : MaterialTextInputPicker.this.onSelectionChangedListeners) {
                    listener.onSelectionChanged(selection);
                }
            }

            @Override
            void onIncompleteSelectionChanged() {
                for (OnSelectionChangedListener listener : MaterialTextInputPicker.this.onSelectionChangedListeners) {
                    listener.onIncompleteSelectionChanged();
                }
            }
        });
    }

    @Override
    @NonNull
    public DateSelector<S> getDateSelector() {
        if (this.dateSelector == null) {
            throw new IllegalStateException("dateSelector should not be null. Use MaterialTextInputPicker#newInstance() to create this fragment with a DateSelector, and call this method after the fragment has been created.");
        }
        return this.dateSelector;
    }
}

