/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.datepicker;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.material.R;
import com.google.android.material.datepicker.CalendarConstraints;
import com.google.android.material.datepicker.CalendarStyle;
import com.google.android.material.datepicker.DateSelector;
import com.google.android.material.datepicker.DateStrings;
import com.google.android.material.datepicker.Month;
import com.google.android.material.datepicker.UtcDates;

class MonthAdapter
extends BaseAdapter {
    static final int MAXIMUM_WEEKS = UtcDates.getUtcCalendar().getMaximum(4);
    final Month month;
    final DateSelector<?> dateSelector;
    CalendarStyle calendarStyle;
    final CalendarConstraints calendarConstraints;

    MonthAdapter(Month month, DateSelector<?> dateSelector, CalendarConstraints calendarConstraints) {
        this.month = month;
        this.dateSelector = dateSelector;
        this.calendarConstraints = calendarConstraints;
    }

    public boolean hasStableIds() {
        return true;
    }

    @Nullable
    public Long getItem(int position) {
        if (position < this.month.daysFromStartOfWeekToFirstOfMonth() || position > this.lastPositionInMonth()) {
            return null;
        }
        return this.month.getDay(this.positionToDay(position));
    }

    public long getItemId(int position) {
        return position / this.month.daysInWeek;
    }

    public int getCount() {
        return this.month.daysInMonth + this.firstPositionInMonth();
    }

    @NonNull
    public TextView getView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
        int offsetPosition;
        this.initializeStyles(parent.getContext());
        TextView day = (TextView)convertView;
        if (convertView == null) {
            LayoutInflater layoutInflater = LayoutInflater.from((Context)parent.getContext());
            day = (TextView)layoutInflater.inflate(R.layout.mtrl_calendar_day, parent, false);
        }
        if ((offsetPosition = position - this.firstPositionInMonth()) < 0 || offsetPosition >= this.month.daysInMonth) {
            day.setVisibility(8);
            day.setEnabled(false);
        } else {
            int dayNumber = offsetPosition + 1;
            day.setTag((Object)this.month);
            day.setText((CharSequence)String.valueOf(dayNumber));
            long dayInMillis = this.month.getDay(dayNumber);
            if (this.month.year == Month.current().year) {
                day.setContentDescription((CharSequence)DateStrings.getMonthDayOfWeekDay(dayInMillis));
            } else {
                day.setContentDescription((CharSequence)DateStrings.getYearMonthDayOfWeekDay(dayInMillis));
            }
            day.setVisibility(0);
            day.setEnabled(true);
        }
        Long date = this.getItem(position);
        if (date == null) {
            return day;
        }
        if (this.calendarConstraints.getDateValidator().isValid(date)) {
            day.setEnabled(true);
            for (long selectedDay : this.dateSelector.getSelectedDays()) {
                if (UtcDates.canonicalYearMonthDay(date) != UtcDates.canonicalYearMonthDay(selectedDay)) continue;
                this.calendarStyle.selectedDay.styleItem(day);
                return day;
            }
            if (UtcDates.getTodayCalendar().getTimeInMillis() == date.longValue()) {
                this.calendarStyle.todayDay.styleItem(day);
                return day;
            }
            this.calendarStyle.day.styleItem(day);
            return day;
        }
        day.setEnabled(false);
        this.calendarStyle.invalidDay.styleItem(day);
        return day;
    }

    private void initializeStyles(Context context) {
        if (this.calendarStyle == null) {
            this.calendarStyle = new CalendarStyle(context);
        }
    }

    int firstPositionInMonth() {
        return this.month.daysFromStartOfWeekToFirstOfMonth();
    }

    int lastPositionInMonth() {
        return this.month.daysFromStartOfWeekToFirstOfMonth() + this.month.daysInMonth - 1;
    }

    int positionToDay(int position) {
        return position - this.month.daysFromStartOfWeekToFirstOfMonth() + 1;
    }

    int dayToPosition(int day) {
        int offsetFromFirst = day - 1;
        return this.firstPositionInMonth() + offsetFromFirst;
    }

    boolean withinMonth(int position) {
        return position >= this.firstPositionInMonth() && position <= this.lastPositionInMonth();
    }

    boolean isFirstInRow(int position) {
        return position % this.month.daysInWeek == 0;
    }

    boolean isLastInRow(int position) {
        return (position + 1) % this.month.daysInWeek == 0;
    }
}

