/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.floatingactionbutton;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.content.Context;
import android.view.View;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Preconditions;
import com.google.android.material.animation.AnimatorSetCompat;
import com.google.android.material.animation.MotionSpec;
import com.google.android.material.floatingactionbutton.AnimatorTracker;
import com.google.android.material.floatingactionbutton.ExtendedFloatingActionButton;
import com.google.android.material.floatingactionbutton.MotionStrategy;
import java.util.ArrayList;
import java.util.List;

abstract class BaseMotionStrategy
implements MotionStrategy {
    private final Context context;
    @NonNull
    private final ExtendedFloatingActionButton fab;
    private final ArrayList<Animator.AnimatorListener> listeners = new ArrayList();
    private final AnimatorTracker tracker;
    @Nullable
    private MotionSpec defaultMotionSpec;
    @Nullable
    private MotionSpec motionSpec;

    BaseMotionStrategy(@NonNull ExtendedFloatingActionButton fab, AnimatorTracker tracker) {
        this.fab = fab;
        this.context = fab.getContext();
        this.tracker = tracker;
    }

    @Override
    public final void setMotionSpec(@Nullable MotionSpec motionSpec) {
        this.motionSpec = motionSpec;
    }

    @Override
    public final MotionSpec getCurrentMotionSpec() {
        if (this.motionSpec != null) {
            return this.motionSpec;
        }
        if (this.defaultMotionSpec == null) {
            this.defaultMotionSpec = MotionSpec.createFromResource(this.context, this.getDefaultMotionSpecResource());
        }
        return (MotionSpec)Preconditions.checkNotNull((Object)this.defaultMotionSpec);
    }

    @Override
    public final void addAnimationListener(@NonNull Animator.AnimatorListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public final void removeAnimationListener(@NonNull Animator.AnimatorListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    @NonNull
    public final List<Animator.AnimatorListener> getListeners() {
        return this.listeners;
    }

    @Override
    @Nullable
    public MotionSpec getMotionSpec() {
        return this.motionSpec;
    }

    @Override
    @CallSuper
    public void onAnimationStart(Animator animator2) {
        this.tracker.onNextAnimationStart(animator2);
    }

    @Override
    @CallSuper
    public void onAnimationEnd() {
        this.tracker.clear();
    }

    @Override
    @CallSuper
    public void onAnimationCancel() {
        this.tracker.clear();
    }

    @Override
    public AnimatorSet createAnimator() {
        return this.createAnimator(this.getCurrentMotionSpec());
    }

    @NonNull
    AnimatorSet createAnimator(@NonNull MotionSpec spec) {
        ArrayList<Animator> animators = new ArrayList<Animator>();
        if (spec.hasPropertyValues("opacity")) {
            animators.add((Animator)spec.getAnimator("opacity", this.fab, View.ALPHA));
        }
        if (spec.hasPropertyValues("scale")) {
            animators.add((Animator)spec.getAnimator("scale", this.fab, View.SCALE_Y));
            animators.add((Animator)spec.getAnimator("scale", this.fab, View.SCALE_X));
        }
        if (spec.hasPropertyValues("width")) {
            animators.add((Animator)spec.getAnimator("width", this.fab, ExtendedFloatingActionButton.WIDTH));
        }
        if (spec.hasPropertyValues("height")) {
            animators.add((Animator)spec.getAnimator("height", this.fab, ExtendedFloatingActionButton.HEIGHT));
        }
        AnimatorSet set = new AnimatorSet();
        AnimatorSetCompat.playTogether(set, animators);
        return set;
    }
}

