/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.slider;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.material.R;
import com.google.android.material.slider.BaseOnChangeListener;
import com.google.android.material.slider.BaseOnSliderTouchListener;
import com.google.android.material.slider.BaseSlider;
import java.util.ArrayList;
import java.util.List;

public class RangeSlider
extends BaseSlider<RangeSlider, OnChangeListener, OnSliderTouchListener> {
    public RangeSlider(@NonNull Context context) {
        this(context, null);
    }

    public RangeSlider(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.sliderStyle);
    }

    public RangeSlider(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.obtainStyledAttributes(attrs, new int[]{R.attr.values});
        if (a.hasValue(0)) {
            int valuesId = a.getResourceId(0, 0);
            TypedArray values = a.getResources().obtainTypedArray(valuesId);
            this.setValues(RangeSlider.convertToFloat(values));
        }
        a.recycle();
    }

    @Override
    public void setValues(Float ... values) {
        super.setValues(values);
    }

    @Override
    public void setValues(@NonNull List<Float> values) {
        super.setValues(values);
    }

    @Override
    @NonNull
    public List<Float> getValues() {
        return super.getValues();
    }

    private static List<Float> convertToFloat(TypedArray values) {
        ArrayList<Float> ret = new ArrayList<Float>();
        for (int i = 0; i < values.length(); ++i) {
            ret.add(Float.valueOf(values.getFloat(i, -1.0f)));
        }
        return ret;
    }

    public static interface OnSliderTouchListener
    extends BaseOnSliderTouchListener<RangeSlider> {
    }

    public static interface OnChangeListener
    extends BaseOnChangeListener<RangeSlider> {
    }
}

