/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.textfield;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.MotionEvent;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.widget.AutoCompleteTextView;
import android.widget.EditText;
import android.widget.Spinner;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import com.google.android.material.R;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.color.MaterialColors;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.ShapeAppearanceModel;
import com.google.android.material.textfield.EndIconDelegate;
import com.google.android.material.textfield.TextInputLayout;

class DropdownMenuEndIconDelegate
extends EndIconDelegate {
    private static final boolean IS_LOLLIPOP = Build.VERSION.SDK_INT >= 21;
    private static final int ANIMATION_FADE_OUT_DURATION = 50;
    private static final int ANIMATION_FADE_IN_DURATION = 67;
    private final TextWatcher exposedDropdownEndIconTextWatcher = new TextWatcher(){

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
        }

        public void afterTextChanged(Editable s) {
            final AutoCompleteTextView editText = DropdownMenuEndIconDelegate.this.castAutoCompleteTextViewOrThrow(DropdownMenuEndIconDelegate.this.textInputLayout.getEditText());
            editText.post(new Runnable(){

                @Override
                public void run() {
                    boolean isPopupShowing = editText.isPopupShowing();
                    DropdownMenuEndIconDelegate.this.setEndIconChecked(isPopupShowing);
                    DropdownMenuEndIconDelegate.this.dropdownPopupDirty = isPopupShowing;
                }
            });
        }
    };
    private final View.OnFocusChangeListener onFocusChangeListener = new View.OnFocusChangeListener(){

        public void onFocusChange(View v, boolean hasFocus) {
            DropdownMenuEndIconDelegate.this.textInputLayout.setEndIconActivated(hasFocus);
            if (!hasFocus) {
                DropdownMenuEndIconDelegate.this.setEndIconChecked(false);
                DropdownMenuEndIconDelegate.this.dropdownPopupDirty = false;
            }
        }
    };
    private final TextInputLayout.AccessibilityDelegate accessibilityDelegate = new TextInputLayout.AccessibilityDelegate(this.textInputLayout){

        @Override
        public void onInitializeAccessibilityNodeInfo(View host, @NonNull AccessibilityNodeInfoCompat info) {
            super.onInitializeAccessibilityNodeInfo(host, info);
            if (DropdownMenuEndIconDelegate.this.textInputLayout.getEditText().getKeyListener() == null) {
                info.setClassName((CharSequence)Spinner.class.getName());
            }
            if (info.isShowingHintText()) {
                info.setHintText(null);
            }
        }

        public void onPopulateAccessibilityEvent(View host, @NonNull AccessibilityEvent event) {
            super.onPopulateAccessibilityEvent(host, event);
            AutoCompleteTextView editText = DropdownMenuEndIconDelegate.this.castAutoCompleteTextViewOrThrow(DropdownMenuEndIconDelegate.this.textInputLayout.getEditText());
            if (event.getEventType() == 1 && DropdownMenuEndIconDelegate.this.accessibilityManager.isTouchExplorationEnabled()) {
                DropdownMenuEndIconDelegate.this.showHideDropdown(editText);
            }
        }
    };
    private final TextInputLayout.OnEditTextAttachedListener dropdownMenuOnEditTextAttachedListener = new TextInputLayout.OnEditTextAttachedListener(){

        @Override
        public void onEditTextAttached(@NonNull TextInputLayout textInputLayout) {
            AutoCompleteTextView autoCompleteTextView = DropdownMenuEndIconDelegate.this.castAutoCompleteTextViewOrThrow(textInputLayout.getEditText());
            DropdownMenuEndIconDelegate.this.setPopupBackground(autoCompleteTextView);
            DropdownMenuEndIconDelegate.this.addRippleEffect(autoCompleteTextView);
            DropdownMenuEndIconDelegate.this.setUpDropdownShowHideBehavior(autoCompleteTextView);
            autoCompleteTextView.setThreshold(0);
            autoCompleteTextView.removeTextChangedListener(DropdownMenuEndIconDelegate.this.exposedDropdownEndIconTextWatcher);
            autoCompleteTextView.addTextChangedListener(DropdownMenuEndIconDelegate.this.exposedDropdownEndIconTextWatcher);
            textInputLayout.setEndIconCheckable(true);
            textInputLayout.setErrorIconDrawable(null);
            textInputLayout.setTextInputAccessibilityDelegate(DropdownMenuEndIconDelegate.this.accessibilityDelegate);
            textInputLayout.setEndIconVisible(true);
        }
    };
    @SuppressLint(value={"ClickableViewAccessibility"})
    private final TextInputLayout.OnEndIconChangedListener endIconChangedListener = new TextInputLayout.OnEndIconChangedListener(){

        @Override
        public void onEndIconChanged(@NonNull TextInputLayout textInputLayout, int previousIcon) {
            AutoCompleteTextView editText = (AutoCompleteTextView)textInputLayout.getEditText();
            if (editText != null && previousIcon == 3) {
                editText.removeTextChangedListener(DropdownMenuEndIconDelegate.this.exposedDropdownEndIconTextWatcher);
                if (editText.getOnFocusChangeListener() == DropdownMenuEndIconDelegate.this.onFocusChangeListener) {
                    editText.setOnFocusChangeListener(null);
                }
                editText.setOnTouchListener(null);
                if (IS_LOLLIPOP) {
                    editText.setOnDismissListener(null);
                }
            }
        }
    };
    private boolean dropdownPopupDirty = false;
    private boolean isEndIconChecked = false;
    private long dropdownPopupActivatedAt = Long.MAX_VALUE;
    private StateListDrawable filledPopupBackground;
    private MaterialShapeDrawable outlinedPopupBackground;
    @Nullable
    private AccessibilityManager accessibilityManager;
    private ValueAnimator fadeOutAnim;
    private ValueAnimator fadeInAnim;

    DropdownMenuEndIconDelegate(@NonNull TextInputLayout textInputLayout) {
        super(textInputLayout);
    }

    @Override
    void initialize() {
        float popupCornerRadius = this.context.getResources().getDimensionPixelOffset(R.dimen.mtrl_shape_corner_size_small_component);
        float exposedDropdownPopupElevation = this.context.getResources().getDimensionPixelOffset(R.dimen.mtrl_exposed_dropdown_menu_popup_elevation);
        int exposedDropdownPopupVerticalPadding = this.context.getResources().getDimensionPixelOffset(R.dimen.mtrl_exposed_dropdown_menu_popup_vertical_padding);
        MaterialShapeDrawable roundedCornersPopupBackground = this.getPopUpMaterialShapeDrawable(popupCornerRadius, popupCornerRadius, exposedDropdownPopupElevation, exposedDropdownPopupVerticalPadding);
        MaterialShapeDrawable roundedBottomCornersPopupBackground = this.getPopUpMaterialShapeDrawable(0.0f, popupCornerRadius, exposedDropdownPopupElevation, exposedDropdownPopupVerticalPadding);
        this.outlinedPopupBackground = roundedCornersPopupBackground;
        this.filledPopupBackground = new StateListDrawable();
        this.filledPopupBackground.addState(new int[]{0x10100AA}, (Drawable)roundedCornersPopupBackground);
        this.filledPopupBackground.addState(new int[0], (Drawable)roundedBottomCornersPopupBackground);
        int drawableResId = IS_LOLLIPOP ? R.drawable.mtrl_dropdown_arrow : R.drawable.mtrl_ic_arrow_drop_down;
        this.textInputLayout.setEndIconDrawable(AppCompatResources.getDrawable((Context)this.context, (int)drawableResId));
        this.textInputLayout.setEndIconContentDescription(this.textInputLayout.getResources().getText(R.string.exposed_dropdown_menu_content_description));
        this.textInputLayout.setEndIconOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AutoCompleteTextView editText = (AutoCompleteTextView)DropdownMenuEndIconDelegate.this.textInputLayout.getEditText();
                DropdownMenuEndIconDelegate.this.showHideDropdown(editText);
            }
        });
        this.textInputLayout.addOnEditTextAttachedListener(this.dropdownMenuOnEditTextAttachedListener);
        this.textInputLayout.addOnEndIconChangedListener(this.endIconChangedListener);
        this.initAnimators();
        ViewCompat.setImportantForAccessibility((View)this.endIconView, (int)2);
        this.accessibilityManager = (AccessibilityManager)this.context.getSystemService("accessibility");
    }

    @Override
    boolean shouldTintIconOnError() {
        return true;
    }

    @Override
    boolean isBoxBackgroundModeSupported(int boxBackgroundMode) {
        return boxBackgroundMode != 0;
    }

    private void showHideDropdown(@Nullable AutoCompleteTextView editText) {
        if (editText == null) {
            return;
        }
        if (this.isDropdownPopupActive()) {
            this.dropdownPopupDirty = false;
        }
        if (!this.dropdownPopupDirty) {
            if (IS_LOLLIPOP) {
                this.setEndIconChecked(!this.isEndIconChecked);
            } else {
                this.isEndIconChecked = !this.isEndIconChecked;
                this.endIconView.toggle();
            }
            if (this.isEndIconChecked) {
                editText.requestFocus();
                editText.showDropDown();
            } else {
                editText.dismissDropDown();
            }
        } else {
            this.dropdownPopupDirty = false;
        }
    }

    private void setPopupBackground(@NonNull AutoCompleteTextView editText) {
        if (IS_LOLLIPOP) {
            int boxBackgroundMode = this.textInputLayout.getBoxBackgroundMode();
            if (boxBackgroundMode == 2) {
                editText.setDropDownBackgroundDrawable((Drawable)this.outlinedPopupBackground);
            } else if (boxBackgroundMode == 1) {
                editText.setDropDownBackgroundDrawable((Drawable)this.filledPopupBackground);
            }
        }
    }

    private void addRippleEffect(@NonNull AutoCompleteTextView editText) {
        if (editText.getKeyListener() != null) {
            return;
        }
        int boxBackgroundMode = this.textInputLayout.getBoxBackgroundMode();
        MaterialShapeDrawable boxBackground = this.textInputLayout.getBoxBackground();
        int rippleColor = MaterialColors.getColor((View)editText, R.attr.colorControlHighlight);
        int[][] states = new int[][]{{16842919}, new int[0]};
        if (boxBackgroundMode == 2) {
            this.addRippleEffectOnOutlinedLayout(editText, rippleColor, states, boxBackground);
        } else if (boxBackgroundMode == 1) {
            this.addRippleEffectOnFilledLayout(editText, rippleColor, states, boxBackground);
        }
    }

    private void addRippleEffectOnOutlinedLayout(@NonNull AutoCompleteTextView editText, int rippleColor, int[][] states, @NonNull MaterialShapeDrawable boxBackground) {
        LayerDrawable editTextBackground;
        int surfaceColor = MaterialColors.getColor((View)editText, R.attr.colorSurface);
        MaterialShapeDrawable rippleBackground = new MaterialShapeDrawable(boxBackground.getShapeAppearanceModel());
        int pressedBackgroundColor = MaterialColors.layer(rippleColor, surfaceColor, 0.1f);
        int[] rippleBackgroundColors = new int[]{pressedBackgroundColor, 0};
        rippleBackground.setFillColor(new ColorStateList(states, rippleBackgroundColors));
        if (IS_LOLLIPOP) {
            rippleBackground.setTint(surfaceColor);
            int[] colors = new int[]{pressedBackgroundColor, surfaceColor};
            ColorStateList rippleColorStateList = new ColorStateList(states, colors);
            MaterialShapeDrawable mask = new MaterialShapeDrawable(boxBackground.getShapeAppearanceModel());
            mask.setTint(-1);
            RippleDrawable rippleDrawable = new RippleDrawable(rippleColorStateList, (Drawable)rippleBackground, (Drawable)mask);
            Drawable[] layers = new Drawable[]{rippleDrawable, boxBackground};
            editTextBackground = new LayerDrawable(layers);
        } else {
            Drawable[] layers = new Drawable[]{rippleBackground, boxBackground};
            editTextBackground = new LayerDrawable(layers);
        }
        ViewCompat.setBackground((View)editText, (Drawable)editTextBackground);
    }

    private void addRippleEffectOnFilledLayout(@NonNull AutoCompleteTextView editText, int rippleColor, int[][] states, @NonNull MaterialShapeDrawable boxBackground) {
        int boxBackgroundColor = this.textInputLayout.getBoxBackgroundColor();
        int pressedBackgroundColor = MaterialColors.layer(rippleColor, boxBackgroundColor, 0.1f);
        int[] colors = new int[]{pressedBackgroundColor, boxBackgroundColor};
        if (IS_LOLLIPOP) {
            ColorStateList rippleColorStateList = new ColorStateList(states, colors);
            RippleDrawable editTextBackground = new RippleDrawable(rippleColorStateList, (Drawable)boxBackground, (Drawable)boxBackground);
            ViewCompat.setBackground((View)editText, (Drawable)editTextBackground);
        } else {
            MaterialShapeDrawable rippleBackground = new MaterialShapeDrawable(boxBackground.getShapeAppearanceModel());
            rippleBackground.setFillColor(new ColorStateList(states, colors));
            Drawable[] layers = new Drawable[]{boxBackground, rippleBackground};
            LayerDrawable editTextBackground = new LayerDrawable(layers);
            int start = ViewCompat.getPaddingStart((View)editText);
            int top = editText.getPaddingTop();
            int end = ViewCompat.getPaddingEnd((View)editText);
            int bottom = editText.getPaddingBottom();
            ViewCompat.setBackground((View)editText, (Drawable)editTextBackground);
            ViewCompat.setPaddingRelative((View)editText, (int)start, (int)top, (int)end, (int)bottom);
        }
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    private void setUpDropdownShowHideBehavior(final @NonNull AutoCompleteTextView editText) {
        editText.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(@NonNull View v, @NonNull MotionEvent event) {
                if (event.getAction() == 1) {
                    if (DropdownMenuEndIconDelegate.this.isDropdownPopupActive()) {
                        DropdownMenuEndIconDelegate.this.dropdownPopupDirty = false;
                    }
                    DropdownMenuEndIconDelegate.this.showHideDropdown(editText);
                }
                return false;
            }
        });
        editText.setOnFocusChangeListener(this.onFocusChangeListener);
        if (IS_LOLLIPOP) {
            editText.setOnDismissListener(new AutoCompleteTextView.OnDismissListener(){

                public void onDismiss() {
                    DropdownMenuEndIconDelegate.this.dropdownPopupDirty = true;
                    DropdownMenuEndIconDelegate.this.dropdownPopupActivatedAt = System.currentTimeMillis();
                    DropdownMenuEndIconDelegate.this.setEndIconChecked(false);
                }
            });
        }
    }

    private MaterialShapeDrawable getPopUpMaterialShapeDrawable(float topCornerRadius, float bottomCornerRadius, float elevation, int verticalPadding) {
        ShapeAppearanceModel shapeAppearanceModel = ShapeAppearanceModel.builder().setTopLeftCornerSize(topCornerRadius).setTopRightCornerSize(topCornerRadius).setBottomLeftCornerSize(bottomCornerRadius).setBottomRightCornerSize(bottomCornerRadius).build();
        MaterialShapeDrawable popupDrawable = MaterialShapeDrawable.createWithElevationOverlay(this.context, elevation);
        popupDrawable.setShapeAppearanceModel(shapeAppearanceModel);
        popupDrawable.setPadding(0, verticalPadding, 0, verticalPadding);
        return popupDrawable;
    }

    private boolean isDropdownPopupActive() {
        long activeFor = System.currentTimeMillis() - this.dropdownPopupActivatedAt;
        return activeFor < 0L || activeFor > 300L;
    }

    @NonNull
    private AutoCompleteTextView castAutoCompleteTextViewOrThrow(EditText editText) {
        if (!(editText instanceof AutoCompleteTextView)) {
            throw new RuntimeException("EditText needs to be an AutoCompleteTextView if an Exposed Dropdown Menu is being used.");
        }
        return (AutoCompleteTextView)editText;
    }

    private void setEndIconChecked(boolean checked) {
        if (this.isEndIconChecked != checked) {
            this.isEndIconChecked = checked;
            this.fadeInAnim.cancel();
            this.fadeOutAnim.start();
        }
    }

    private void initAnimators() {
        this.fadeInAnim = this.getAlphaAnimator(67, 0.0f, 1.0f);
        this.fadeOutAnim = this.getAlphaAnimator(50, 1.0f, 0.0f);
        this.fadeOutAnim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                DropdownMenuEndIconDelegate.this.endIconView.setChecked(DropdownMenuEndIconDelegate.this.isEndIconChecked);
                DropdownMenuEndIconDelegate.this.fadeInAnim.start();
            }
        });
    }

    private ValueAnimator getAlphaAnimator(int duration, float ... values) {
        ValueAnimator animator2 = ValueAnimator.ofFloat((float[])values);
        animator2.setInterpolator(AnimationUtils.LINEAR_INTERPOLATOR);
        animator2.setDuration((long)duration);
        animator2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(@NonNull ValueAnimator animation) {
                float alpha = ((Float)animation.getAnimatedValue()).floatValue();
                DropdownMenuEndIconDelegate.this.endIconView.setAlpha(alpha);
            }
        });
        return animator2;
    }
}

