/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.textfield;

import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStructure;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.StringRes;
import androidx.annotation.StyleRes;
import androidx.annotation.VisibleForTesting;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.appcompat.widget.AppCompatDrawableManager;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.appcompat.widget.DrawableUtils;
import androidx.appcompat.widget.TintTypedArray;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.text.BidiFormatter;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.MarginLayoutParamsCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.core.widget.TextViewCompat;
import androidx.customview.view.AbsSavedState;
import com.google.android.material.R;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.color.MaterialColors;
import com.google.android.material.internal.CheckableImageButton;
import com.google.android.material.internal.CollapsingTextHelper;
import com.google.android.material.internal.DescendantOffsetUtils;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.internal.ViewUtils;
import com.google.android.material.resources.MaterialResources;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.ShapeAppearanceModel;
import com.google.android.material.textfield.ClearTextEndIconDelegate;
import com.google.android.material.textfield.CustomEndIconDelegate;
import com.google.android.material.textfield.CutoutDrawable;
import com.google.android.material.textfield.DropdownMenuEndIconDelegate;
import com.google.android.material.textfield.EndIconDelegate;
import com.google.android.material.textfield.IndicatorViewController;
import com.google.android.material.textfield.NoEndIconDelegate;
import com.google.android.material.textfield.PasswordToggleEndIconDelegate;
import com.google.android.material.textfield.TextInputEditText;
import com.google.android.material.theme.overlay.MaterialThemeOverlay;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.LinkedHashSet;

public class TextInputLayout
extends LinearLayout {
    private static final int DEF_STYLE_RES = R.style.Widget_Design_TextInputLayout;
    private static final int LABEL_SCALE_ANIMATION_DURATION = 167;
    private static final int INVALID_MAX_LENGTH = -1;
    private static final String LOG_TAG = "TextInputLayout";
    @NonNull
    private final FrameLayout inputFrame;
    @NonNull
    private final LinearLayout startLayout;
    @NonNull
    private final LinearLayout endLayout;
    @NonNull
    private final FrameLayout endIconFrame;
    EditText editText;
    private CharSequence originalHint;
    private final IndicatorViewController indicatorViewController = new IndicatorViewController(this);
    boolean counterEnabled;
    private int counterMaxLength;
    private boolean counterOverflowed;
    @Nullable
    private TextView counterView;
    private int counterOverflowTextAppearance;
    private int counterTextAppearance;
    private CharSequence placeholderText;
    private boolean placeholderEnabled;
    private TextView placeholderTextView;
    @Nullable
    private ColorStateList placeholderTextColor;
    private int placeholderTextAppearance;
    @Nullable
    private ColorStateList counterTextColor;
    @Nullable
    private ColorStateList counterOverflowTextColor;
    @Nullable
    private CharSequence prefixText;
    @NonNull
    private final TextView prefixTextView;
    @Nullable
    private CharSequence suffixText;
    @NonNull
    private final TextView suffixTextView;
    private boolean hintEnabled;
    private CharSequence hint;
    private boolean isProvidingHint;
    @Nullable
    private MaterialShapeDrawable boxBackground;
    @Nullable
    private MaterialShapeDrawable boxUnderline;
    @NonNull
    private ShapeAppearanceModel shapeAppearanceModel;
    private final int boxLabelCutoutPaddingPx;
    private int boxBackgroundMode;
    private final int boxCollapsedPaddingTopPx;
    private int boxStrokeWidthPx;
    private int boxStrokeWidthDefaultPx;
    private int boxStrokeWidthFocusedPx;
    @ColorInt
    private int boxStrokeColor;
    @ColorInt
    private int boxBackgroundColor;
    public static final int BOX_BACKGROUND_NONE = 0;
    public static final int BOX_BACKGROUND_FILLED = 1;
    public static final int BOX_BACKGROUND_OUTLINE = 2;
    private final Rect tmpRect = new Rect();
    private final Rect tmpBoundsRect = new Rect();
    private final RectF tmpRectF = new RectF();
    private Typeface typeface;
    @NonNull
    private final CheckableImageButton startIconView;
    private ColorStateList startIconTintList;
    private boolean hasStartIconTintList;
    private PorterDuff.Mode startIconTintMode;
    private boolean hasStartIconTintMode;
    @Nullable
    private Drawable startDummyDrawable;
    private int startDummyDrawableWidth;
    private View.OnLongClickListener startIconOnLongClickListener;
    public static final int END_ICON_CUSTOM = -1;
    public static final int END_ICON_NONE = 0;
    public static final int END_ICON_PASSWORD_TOGGLE = 1;
    public static final int END_ICON_CLEAR_TEXT = 2;
    public static final int END_ICON_DROPDOWN_MENU = 3;
    private final LinkedHashSet<OnEditTextAttachedListener> editTextAttachedListeners = new LinkedHashSet();
    private int endIconMode = 0;
    private final SparseArray<EndIconDelegate> endIconDelegates = new SparseArray();
    @NonNull
    private final CheckableImageButton endIconView;
    private final LinkedHashSet<OnEndIconChangedListener> endIconChangedListeners = new LinkedHashSet();
    private ColorStateList endIconTintList;
    private boolean hasEndIconTintList;
    private PorterDuff.Mode endIconTintMode;
    private boolean hasEndIconTintMode;
    @Nullable
    private Drawable endDummyDrawable;
    private int endDummyDrawableWidth;
    private Drawable originalEditTextEndDrawable;
    private View.OnLongClickListener endIconOnLongClickListener;
    private View.OnLongClickListener errorIconOnLongClickListener;
    @NonNull
    private final CheckableImageButton errorIconView;
    private ColorStateList errorIconTintList;
    private ColorStateList defaultHintTextColor;
    private ColorStateList focusedTextColor;
    @ColorInt
    private int defaultStrokeColor;
    @ColorInt
    private int hoveredStrokeColor;
    @ColorInt
    private int focusedStrokeColor;
    private ColorStateList strokeErrorColor;
    @ColorInt
    private int defaultFilledBackgroundColor;
    @ColorInt
    private int disabledFilledBackgroundColor;
    @ColorInt
    private int focusedFilledBackgroundColor;
    @ColorInt
    private int hoveredFilledBackgroundColor;
    @ColorInt
    private int disabledColor;
    private boolean hintExpanded;
    final CollapsingTextHelper collapsingTextHelper = new CollapsingTextHelper((View)this);
    private boolean hintAnimationEnabled;
    private ValueAnimator animator;
    private boolean inDrawableStateChanged;
    private boolean restoringSavedState;

    public TextInputLayout(@NonNull Context context) {
        this(context, null);
    }

    public TextInputLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.textInputStyle);
    }

    public TextInputLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(MaterialThemeOverlay.wrap(context, attrs, defStyleAttr, DEF_STYLE_RES), attrs, defStyleAttr);
        int hintAppearance;
        context = this.getContext();
        this.setOrientation(1);
        this.setWillNotDraw(false);
        this.setAddStatesFromChildren(true);
        this.inputFrame = new FrameLayout(context);
        this.inputFrame.setAddStatesFromChildren(true);
        this.addView((View)this.inputFrame);
        this.startLayout = new LinearLayout(context);
        this.startLayout.setOrientation(0);
        this.startLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -1, 0x800003));
        this.inputFrame.addView((View)this.startLayout);
        this.endLayout = new LinearLayout(context);
        this.endLayout.setOrientation(0);
        this.endLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -1, 0x800005));
        this.inputFrame.addView((View)this.endLayout);
        this.endIconFrame = new FrameLayout(context);
        this.endIconFrame.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -1));
        this.collapsingTextHelper.setTextSizeInterpolator(AnimationUtils.LINEAR_INTERPOLATOR);
        this.collapsingTextHelper.setPositionInterpolator(AnimationUtils.LINEAR_INTERPOLATOR);
        this.collapsingTextHelper.setCollapsedTextGravity(0x800033);
        TintTypedArray a = ThemeEnforcement.obtainTintedStyledAttributes(context, attrs, R.styleable.TextInputLayout, defStyleAttr, DEF_STYLE_RES, R.styleable.TextInputLayout_counterTextAppearance, R.styleable.TextInputLayout_counterOverflowTextAppearance, R.styleable.TextInputLayout_errorTextAppearance, R.styleable.TextInputLayout_helperTextTextAppearance, R.styleable.TextInputLayout_hintTextAppearance);
        this.hintEnabled = a.getBoolean(R.styleable.TextInputLayout_hintEnabled, true);
        this.setHint(a.getText(R.styleable.TextInputLayout_android_hint));
        this.hintAnimationEnabled = a.getBoolean(R.styleable.TextInputLayout_hintAnimationEnabled, true);
        this.shapeAppearanceModel = ShapeAppearanceModel.builder(context, attrs, defStyleAttr, DEF_STYLE_RES).build();
        this.boxLabelCutoutPaddingPx = context.getResources().getDimensionPixelOffset(R.dimen.mtrl_textinput_box_label_cutout_padding);
        this.boxCollapsedPaddingTopPx = a.getDimensionPixelOffset(R.styleable.TextInputLayout_boxCollapsedPaddingTop, 0);
        this.boxStrokeWidthDefaultPx = a.getDimensionPixelSize(R.styleable.TextInputLayout_boxStrokeWidth, context.getResources().getDimensionPixelSize(R.dimen.mtrl_textinput_box_stroke_width_default));
        this.boxStrokeWidthFocusedPx = a.getDimensionPixelSize(R.styleable.TextInputLayout_boxStrokeWidthFocused, context.getResources().getDimensionPixelSize(R.dimen.mtrl_textinput_box_stroke_width_focused));
        this.boxStrokeWidthPx = this.boxStrokeWidthDefaultPx;
        float boxCornerRadiusTopStart = a.getDimension(R.styleable.TextInputLayout_boxCornerRadiusTopStart, -1.0f);
        float boxCornerRadiusTopEnd = a.getDimension(R.styleable.TextInputLayout_boxCornerRadiusTopEnd, -1.0f);
        float boxCornerRadiusBottomEnd = a.getDimension(R.styleable.TextInputLayout_boxCornerRadiusBottomEnd, -1.0f);
        float boxCornerRadiusBottomStart = a.getDimension(R.styleable.TextInputLayout_boxCornerRadiusBottomStart, -1.0f);
        ShapeAppearanceModel.Builder shapeBuilder = this.shapeAppearanceModel.toBuilder();
        if (boxCornerRadiusTopStart >= 0.0f) {
            shapeBuilder.setTopLeftCornerSize(boxCornerRadiusTopStart);
        }
        if (boxCornerRadiusTopEnd >= 0.0f) {
            shapeBuilder.setTopRightCornerSize(boxCornerRadiusTopEnd);
        }
        if (boxCornerRadiusBottomEnd >= 0.0f) {
            shapeBuilder.setBottomRightCornerSize(boxCornerRadiusBottomEnd);
        }
        if (boxCornerRadiusBottomStart >= 0.0f) {
            shapeBuilder.setBottomLeftCornerSize(boxCornerRadiusBottomStart);
        }
        this.shapeAppearanceModel = shapeBuilder.build();
        ColorStateList filledBackgroundColorStateList = MaterialResources.getColorStateList(context, a, R.styleable.TextInputLayout_boxBackgroundColor);
        if (filledBackgroundColorStateList != null) {
            this.boxBackgroundColor = this.defaultFilledBackgroundColor = filledBackgroundColorStateList.getDefaultColor();
            if (filledBackgroundColorStateList.isStateful()) {
                this.disabledFilledBackgroundColor = filledBackgroundColorStateList.getColorForState(new int[]{-16842910}, -1);
                this.focusedFilledBackgroundColor = filledBackgroundColorStateList.getColorForState(new int[]{16842908, 16842910}, -1);
                this.hoveredFilledBackgroundColor = filledBackgroundColorStateList.getColorForState(new int[]{16843623, 16842910}, -1);
            } else {
                this.focusedFilledBackgroundColor = this.defaultFilledBackgroundColor;
                ColorStateList mtrlFilledBackgroundColorStateList = AppCompatResources.getColorStateList((Context)context, (int)R.color.mtrl_filled_background_color);
                this.disabledFilledBackgroundColor = mtrlFilledBackgroundColorStateList.getColorForState(new int[]{-16842910}, -1);
                this.hoveredFilledBackgroundColor = mtrlFilledBackgroundColorStateList.getColorForState(new int[]{16843623}, -1);
            }
        } else {
            this.boxBackgroundColor = 0;
            this.defaultFilledBackgroundColor = 0;
            this.disabledFilledBackgroundColor = 0;
            this.focusedFilledBackgroundColor = 0;
            this.hoveredFilledBackgroundColor = 0;
        }
        if (a.hasValue(R.styleable.TextInputLayout_android_textColorHint)) {
            this.defaultHintTextColor = this.focusedTextColor = a.getColorStateList(R.styleable.TextInputLayout_android_textColorHint);
        }
        ColorStateList boxStrokeColorStateList = MaterialResources.getColorStateList(context, a, R.styleable.TextInputLayout_boxStrokeColor);
        this.focusedStrokeColor = a.getColor(R.styleable.TextInputLayout_boxStrokeColor, 0);
        this.defaultStrokeColor = ContextCompat.getColor((Context)context, (int)R.color.mtrl_textinput_default_box_stroke_color);
        this.disabledColor = ContextCompat.getColor((Context)context, (int)R.color.mtrl_textinput_disabled_color);
        this.hoveredStrokeColor = ContextCompat.getColor((Context)context, (int)R.color.mtrl_textinput_hovered_box_stroke_color);
        if (boxStrokeColorStateList != null) {
            this.setBoxStrokeColorStateList(boxStrokeColorStateList);
        }
        if (a.hasValue(R.styleable.TextInputLayout_boxStrokeErrorColor)) {
            this.setBoxStrokeErrorColor(MaterialResources.getColorStateList(context, a, R.styleable.TextInputLayout_boxStrokeErrorColor));
        }
        if ((hintAppearance = a.getResourceId(R.styleable.TextInputLayout_hintTextAppearance, -1)) != -1) {
            this.setHintTextAppearance(a.getResourceId(R.styleable.TextInputLayout_hintTextAppearance, 0));
        }
        int errorTextAppearance = a.getResourceId(R.styleable.TextInputLayout_errorTextAppearance, 0);
        CharSequence errorContentDescription = a.getText(R.styleable.TextInputLayout_errorContentDescription);
        boolean errorEnabled = a.getBoolean(R.styleable.TextInputLayout_errorEnabled, false);
        this.errorIconView = (CheckableImageButton)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.design_text_input_end_icon, (ViewGroup)this.endLayout, false);
        this.errorIconView.setVisibility(8);
        if (a.hasValue(R.styleable.TextInputLayout_errorIconDrawable)) {
            this.setErrorIconDrawable(a.getDrawable(R.styleable.TextInputLayout_errorIconDrawable));
        }
        if (a.hasValue(R.styleable.TextInputLayout_errorIconTint)) {
            this.setErrorIconTintList(MaterialResources.getColorStateList(context, a, R.styleable.TextInputLayout_errorIconTint));
        }
        if (a.hasValue(R.styleable.TextInputLayout_errorIconTintMode)) {
            this.setErrorIconTintMode(ViewUtils.parseTintMode(a.getInt(R.styleable.TextInputLayout_errorIconTintMode, -1), null));
        }
        this.errorIconView.setContentDescription(this.getResources().getText(R.string.error_icon_content_description));
        ViewCompat.setImportantForAccessibility((View)this.errorIconView, (int)2);
        this.errorIconView.setClickable(false);
        this.errorIconView.setPressable(false);
        this.errorIconView.setFocusable(false);
        int helperTextTextAppearance = a.getResourceId(R.styleable.TextInputLayout_helperTextTextAppearance, 0);
        boolean helperTextEnabled = a.getBoolean(R.styleable.TextInputLayout_helperTextEnabled, false);
        CharSequence helperText = a.getText(R.styleable.TextInputLayout_helperText);
        int placeholderTextAppearance = a.getResourceId(R.styleable.TextInputLayout_placeholderTextAppearance, 0);
        CharSequence placeholderText = a.getText(R.styleable.TextInputLayout_placeholderText);
        int prefixTextAppearance = a.getResourceId(R.styleable.TextInputLayout_prefixTextAppearance, 0);
        CharSequence prefixText = a.getText(R.styleable.TextInputLayout_prefixText);
        int suffixTextAppearance = a.getResourceId(R.styleable.TextInputLayout_suffixTextAppearance, 0);
        CharSequence suffixText = a.getText(R.styleable.TextInputLayout_suffixText);
        boolean counterEnabled = a.getBoolean(R.styleable.TextInputLayout_counterEnabled, false);
        this.setCounterMaxLength(a.getInt(R.styleable.TextInputLayout_counterMaxLength, -1));
        this.counterTextAppearance = a.getResourceId(R.styleable.TextInputLayout_counterTextAppearance, 0);
        this.counterOverflowTextAppearance = a.getResourceId(R.styleable.TextInputLayout_counterOverflowTextAppearance, 0);
        this.startIconView = (CheckableImageButton)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.design_text_input_start_icon, (ViewGroup)this.startLayout, false);
        this.startIconView.setVisibility(8);
        this.setStartIconOnClickListener(null);
        this.setStartIconOnLongClickListener(null);
        if (a.hasValue(R.styleable.TextInputLayout_startIconDrawable)) {
            this.setStartIconDrawable(a.getDrawable(R.styleable.TextInputLayout_startIconDrawable));
            if (a.hasValue(R.styleable.TextInputLayout_startIconContentDescription)) {
                this.setStartIconContentDescription(a.getText(R.styleable.TextInputLayout_startIconContentDescription));
            }
            this.setStartIconCheckable(a.getBoolean(R.styleable.TextInputLayout_startIconCheckable, true));
        }
        if (a.hasValue(R.styleable.TextInputLayout_startIconTint)) {
            this.setStartIconTintList(MaterialResources.getColorStateList(context, a, R.styleable.TextInputLayout_startIconTint));
        }
        if (a.hasValue(R.styleable.TextInputLayout_startIconTintMode)) {
            this.setStartIconTintMode(ViewUtils.parseTintMode(a.getInt(R.styleable.TextInputLayout_startIconTintMode, -1), null));
        }
        this.setBoxBackgroundMode(a.getInt(R.styleable.TextInputLayout_boxBackgroundMode, 0));
        this.endIconView = (CheckableImageButton)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.design_text_input_end_icon, (ViewGroup)this.endIconFrame, false);
        this.endIconFrame.addView((View)this.endIconView);
        this.endIconView.setVisibility(8);
        this.endIconDelegates.append(-1, (Object)new CustomEndIconDelegate(this));
        this.endIconDelegates.append(0, (Object)new NoEndIconDelegate(this));
        this.endIconDelegates.append(1, (Object)new PasswordToggleEndIconDelegate(this));
        this.endIconDelegates.append(2, (Object)new ClearTextEndIconDelegate(this));
        this.endIconDelegates.append(3, (Object)new DropdownMenuEndIconDelegate(this));
        if (a.hasValue(R.styleable.TextInputLayout_endIconMode)) {
            this.setEndIconMode(a.getInt(R.styleable.TextInputLayout_endIconMode, 0));
            if (a.hasValue(R.styleable.TextInputLayout_endIconDrawable)) {
                this.setEndIconDrawable(a.getDrawable(R.styleable.TextInputLayout_endIconDrawable));
            }
            if (a.hasValue(R.styleable.TextInputLayout_endIconContentDescription)) {
                this.setEndIconContentDescription(a.getText(R.styleable.TextInputLayout_endIconContentDescription));
            }
            this.setEndIconCheckable(a.getBoolean(R.styleable.TextInputLayout_endIconCheckable, true));
        } else if (a.hasValue(R.styleable.TextInputLayout_passwordToggleEnabled)) {
            boolean passwordToggleEnabled = a.getBoolean(R.styleable.TextInputLayout_passwordToggleEnabled, false);
            this.setEndIconMode(passwordToggleEnabled ? 1 : 0);
            this.setEndIconDrawable(a.getDrawable(R.styleable.TextInputLayout_passwordToggleDrawable));
            this.setEndIconContentDescription(a.getText(R.styleable.TextInputLayout_passwordToggleContentDescription));
            if (a.hasValue(R.styleable.TextInputLayout_passwordToggleTint)) {
                this.setEndIconTintList(MaterialResources.getColorStateList(context, a, R.styleable.TextInputLayout_passwordToggleTint));
            }
            if (a.hasValue(R.styleable.TextInputLayout_passwordToggleTintMode)) {
                this.setEndIconTintMode(ViewUtils.parseTintMode(a.getInt(R.styleable.TextInputLayout_passwordToggleTintMode, -1), null));
            }
        }
        if (!a.hasValue(R.styleable.TextInputLayout_passwordToggleEnabled)) {
            if (a.hasValue(R.styleable.TextInputLayout_endIconTint)) {
                this.setEndIconTintList(MaterialResources.getColorStateList(context, a, R.styleable.TextInputLayout_endIconTint));
            }
            if (a.hasValue(R.styleable.TextInputLayout_endIconTintMode)) {
                this.setEndIconTintMode(ViewUtils.parseTintMode(a.getInt(R.styleable.TextInputLayout_endIconTintMode, -1), null));
            }
        }
        this.prefixTextView = new AppCompatTextView(context);
        this.prefixTextView.setId(R.id.textinput_prefix_text);
        this.prefixTextView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        ViewCompat.setAccessibilityLiveRegion((View)this.prefixTextView, (int)1);
        this.startLayout.addView((View)this.startIconView);
        this.startLayout.addView((View)this.prefixTextView);
        this.suffixTextView = new AppCompatTextView(context);
        this.suffixTextView.setId(R.id.textinput_suffix_text);
        this.suffixTextView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 80));
        ViewCompat.setAccessibilityLiveRegion((View)this.suffixTextView, (int)1);
        this.endLayout.addView((View)this.suffixTextView);
        this.endLayout.addView((View)this.errorIconView);
        this.endLayout.addView((View)this.endIconFrame);
        this.setHelperTextEnabled(helperTextEnabled);
        this.setHelperText(helperText);
        this.setHelperTextTextAppearance(helperTextTextAppearance);
        this.setErrorEnabled(errorEnabled);
        this.setErrorTextAppearance(errorTextAppearance);
        this.setErrorContentDescription(errorContentDescription);
        this.setCounterTextAppearance(this.counterTextAppearance);
        this.setCounterOverflowTextAppearance(this.counterOverflowTextAppearance);
        this.setPlaceholderText(placeholderText);
        this.setPlaceholderTextAppearance(placeholderTextAppearance);
        this.setPrefixText(prefixText);
        this.setPrefixTextAppearance(prefixTextAppearance);
        this.setSuffixText(suffixText);
        this.setSuffixTextAppearance(suffixTextAppearance);
        if (a.hasValue(R.styleable.TextInputLayout_errorTextColor)) {
            this.setErrorTextColor(a.getColorStateList(R.styleable.TextInputLayout_errorTextColor));
        }
        if (a.hasValue(R.styleable.TextInputLayout_helperTextTextColor)) {
            this.setHelperTextColor(a.getColorStateList(R.styleable.TextInputLayout_helperTextTextColor));
        }
        if (a.hasValue(R.styleable.TextInputLayout_hintTextColor)) {
            this.setHintTextColor(a.getColorStateList(R.styleable.TextInputLayout_hintTextColor));
        }
        if (a.hasValue(R.styleable.TextInputLayout_counterTextColor)) {
            this.setCounterTextColor(a.getColorStateList(R.styleable.TextInputLayout_counterTextColor));
        }
        if (a.hasValue(R.styleable.TextInputLayout_counterOverflowTextColor)) {
            this.setCounterOverflowTextColor(a.getColorStateList(R.styleable.TextInputLayout_counterOverflowTextColor));
        }
        if (a.hasValue(R.styleable.TextInputLayout_placeholderTextColor)) {
            this.setPlaceholderTextColor(a.getColorStateList(R.styleable.TextInputLayout_placeholderTextColor));
        }
        if (a.hasValue(R.styleable.TextInputLayout_prefixTextColor)) {
            this.setPrefixTextColor(a.getColorStateList(R.styleable.TextInputLayout_prefixTextColor));
        }
        if (a.hasValue(R.styleable.TextInputLayout_suffixTextColor)) {
            this.setSuffixTextColor(a.getColorStateList(R.styleable.TextInputLayout_suffixTextColor));
        }
        this.setCounterEnabled(counterEnabled);
        this.setEnabled(a.getBoolean(R.styleable.TextInputLayout_android_enabled, true));
        a.recycle();
        ViewCompat.setImportantForAccessibility((View)this, (int)2);
    }

    public void addView(@NonNull View child, int index, @NonNull ViewGroup.LayoutParams params) {
        if (child instanceof EditText) {
            FrameLayout.LayoutParams flp = new FrameLayout.LayoutParams(params);
            flp.gravity = 0x10 | flp.gravity & 0xFFFFFF8F;
            this.inputFrame.addView(child, (ViewGroup.LayoutParams)flp);
            this.inputFrame.setLayoutParams(params);
            this.updateInputLayoutMargins();
            this.setEditText((EditText)child);
        } else {
            super.addView(child, index, params);
        }
    }

    @NonNull
    MaterialShapeDrawable getBoxBackground() {
        if (this.boxBackgroundMode == 1 || this.boxBackgroundMode == 2) {
            return this.boxBackground;
        }
        throw new IllegalStateException();
    }

    public void setBoxBackgroundMode(int boxBackgroundMode) {
        if (boxBackgroundMode == this.boxBackgroundMode) {
            return;
        }
        this.boxBackgroundMode = boxBackgroundMode;
        if (this.editText != null) {
            this.onApplyBoxBackgroundMode();
        }
    }

    public int getBoxBackgroundMode() {
        return this.boxBackgroundMode;
    }

    private void onApplyBoxBackgroundMode() {
        this.assignBoxBackgroundByMode();
        this.setEditTextBoxBackground();
        this.updateTextInputBoxState();
        if (this.boxBackgroundMode != 0) {
            this.updateInputLayoutMargins();
        }
    }

    private void assignBoxBackgroundByMode() {
        switch (this.boxBackgroundMode) {
            case 1: {
                this.boxBackground = new MaterialShapeDrawable(this.shapeAppearanceModel);
                this.boxUnderline = new MaterialShapeDrawable();
                break;
            }
            case 2: {
                this.boxBackground = this.hintEnabled && !(this.boxBackground instanceof CutoutDrawable) ? new CutoutDrawable(this.shapeAppearanceModel) : new MaterialShapeDrawable(this.shapeAppearanceModel);
                this.boxUnderline = null;
                break;
            }
            case 0: {
                this.boxBackground = null;
                this.boxUnderline = null;
                break;
            }
            default: {
                throw new IllegalArgumentException(this.boxBackgroundMode + " is illegal; only @BoxBackgroundMode constants are supported.");
            }
        }
    }

    private void setEditTextBoxBackground() {
        if (this.shouldUseEditTextBackgroundForBoxBackground()) {
            ViewCompat.setBackground((View)this.editText, (Drawable)this.boxBackground);
        }
    }

    private boolean shouldUseEditTextBackgroundForBoxBackground() {
        return this.editText != null && this.boxBackground != null && this.editText.getBackground() == null && this.boxBackgroundMode != 0;
    }

    public void setBoxStrokeWidthResource(@DimenRes int boxStrokeWidthResId) {
        this.setBoxStrokeWidth(this.getResources().getDimensionPixelSize(boxStrokeWidthResId));
    }

    public void setBoxStrokeWidth(int boxStrokeWidth) {
        this.boxStrokeWidthDefaultPx = boxStrokeWidth;
        this.updateTextInputBoxState();
    }

    public int getBoxStrokeWidth() {
        return this.boxStrokeWidthDefaultPx;
    }

    public void setBoxStrokeWidthFocusedResource(@DimenRes int boxStrokeWidthFocusedResId) {
        this.setBoxStrokeWidthFocused(this.getResources().getDimensionPixelSize(boxStrokeWidthFocusedResId));
    }

    public void setBoxStrokeWidthFocused(int boxStrokeWidthFocused) {
        this.boxStrokeWidthFocusedPx = boxStrokeWidthFocused;
        this.updateTextInputBoxState();
    }

    public int getBoxStrokeWidthFocused() {
        return this.boxStrokeWidthFocusedPx;
    }

    public void setBoxStrokeColor(@ColorInt int boxStrokeColor) {
        if (this.focusedStrokeColor != boxStrokeColor) {
            this.focusedStrokeColor = boxStrokeColor;
            this.updateTextInputBoxState();
        }
    }

    public int getBoxStrokeColor() {
        return this.focusedStrokeColor;
    }

    public void setBoxStrokeColorStateList(@NonNull ColorStateList boxStrokeColorStateList) {
        if (boxStrokeColorStateList.isStateful()) {
            this.defaultStrokeColor = boxStrokeColorStateList.getDefaultColor();
            this.disabledColor = boxStrokeColorStateList.getColorForState(new int[]{-16842910}, -1);
            this.hoveredStrokeColor = boxStrokeColorStateList.getColorForState(new int[]{16843623, 16842910}, -1);
            this.focusedStrokeColor = boxStrokeColorStateList.getColorForState(new int[]{16842908, 16842910}, -1);
        } else if (this.focusedStrokeColor != boxStrokeColorStateList.getDefaultColor()) {
            this.focusedStrokeColor = boxStrokeColorStateList.getDefaultColor();
        }
        this.updateTextInputBoxState();
    }

    public void setBoxStrokeErrorColor(@Nullable ColorStateList strokeErrorColor) {
        if (this.strokeErrorColor != strokeErrorColor) {
            this.strokeErrorColor = strokeErrorColor;
            this.updateTextInputBoxState();
        }
    }

    @Nullable
    public ColorStateList getBoxStrokeErrorColor() {
        return this.strokeErrorColor;
    }

    public void setBoxBackgroundColorResource(@ColorRes int boxBackgroundColorId) {
        this.setBoxBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)boxBackgroundColorId));
    }

    public void setBoxBackgroundColor(@ColorInt int boxBackgroundColor) {
        if (this.boxBackgroundColor != boxBackgroundColor) {
            this.boxBackgroundColor = boxBackgroundColor;
            this.defaultFilledBackgroundColor = boxBackgroundColor;
            this.focusedFilledBackgroundColor = boxBackgroundColor;
            this.hoveredFilledBackgroundColor = boxBackgroundColor;
            this.applyBoxAttributes();
        }
    }

    public void setBoxBackgroundColorStateList(@NonNull ColorStateList boxBackgroundColorStateList) {
        this.boxBackgroundColor = this.defaultFilledBackgroundColor = boxBackgroundColorStateList.getDefaultColor();
        this.disabledFilledBackgroundColor = boxBackgroundColorStateList.getColorForState(new int[]{-16842910}, -1);
        this.focusedFilledBackgroundColor = boxBackgroundColorStateList.getColorForState(new int[]{16842908, 16842910}, -1);
        this.hoveredFilledBackgroundColor = boxBackgroundColorStateList.getColorForState(new int[]{16843623, 16842910}, -1);
        this.applyBoxAttributes();
    }

    public int getBoxBackgroundColor() {
        return this.boxBackgroundColor;
    }

    public void setBoxCornerRadiiResources(@DimenRes int boxCornerRadiusTopStartId, @DimenRes int boxCornerRadiusTopEndId, @DimenRes int boxCornerRadiusBottomEndId, @DimenRes int boxCornerRadiusBottomStartId) {
        this.setBoxCornerRadii(this.getContext().getResources().getDimension(boxCornerRadiusTopStartId), this.getContext().getResources().getDimension(boxCornerRadiusTopEndId), this.getContext().getResources().getDimension(boxCornerRadiusBottomStartId), this.getContext().getResources().getDimension(boxCornerRadiusBottomEndId));
    }

    public void setBoxCornerRadii(float boxCornerRadiusTopStart, float boxCornerRadiusTopEnd, float boxCornerRadiusBottomStart, float boxCornerRadiusBottomEnd) {
        if (this.boxBackground == null || this.boxBackground.getTopLeftCornerResolvedSize() != boxCornerRadiusTopStart || this.boxBackground.getTopRightCornerResolvedSize() != boxCornerRadiusTopEnd || this.boxBackground.getBottomRightCornerResolvedSize() != boxCornerRadiusBottomEnd || this.boxBackground.getBottomLeftCornerResolvedSize() != boxCornerRadiusBottomStart) {
            this.shapeAppearanceModel = this.shapeAppearanceModel.toBuilder().setTopLeftCornerSize(boxCornerRadiusTopStart).setTopRightCornerSize(boxCornerRadiusTopEnd).setBottomRightCornerSize(boxCornerRadiusBottomEnd).setBottomLeftCornerSize(boxCornerRadiusBottomStart).build();
            this.applyBoxAttributes();
        }
    }

    public float getBoxCornerRadiusTopStart() {
        return this.boxBackground.getTopLeftCornerResolvedSize();
    }

    public float getBoxCornerRadiusTopEnd() {
        return this.boxBackground.getTopRightCornerResolvedSize();
    }

    public float getBoxCornerRadiusBottomEnd() {
        return this.boxBackground.getBottomLeftCornerResolvedSize();
    }

    public float getBoxCornerRadiusBottomStart() {
        return this.boxBackground.getBottomRightCornerResolvedSize();
    }

    public void setTypeface(@Nullable Typeface typeface) {
        if (typeface != this.typeface) {
            this.typeface = typeface;
            this.collapsingTextHelper.setTypefaces(typeface);
            this.indicatorViewController.setTypefaces(typeface);
            if (this.counterView != null) {
                this.counterView.setTypeface(typeface);
            }
        }
    }

    @Nullable
    public Typeface getTypeface() {
        return this.typeface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchProvideAutofillStructure(@NonNull ViewStructure structure, int flags) {
        if (this.originalHint == null || this.editText == null) {
            super.dispatchProvideAutofillStructure(structure, flags);
            return;
        }
        boolean wasProvidingHint = this.isProvidingHint;
        this.isProvidingHint = false;
        CharSequence hint = this.editText.getHint();
        this.editText.setHint(this.originalHint);
        try {
            super.dispatchProvideAutofillStructure(structure, flags);
        }
        finally {
            this.editText.setHint(hint);
            this.isProvidingHint = wasProvidingHint;
        }
    }

    private void setEditText(EditText editText) {
        if (this.editText != null) {
            throw new IllegalArgumentException("We already have an EditText, can only have one");
        }
        if (this.endIconMode != 3 && !(editText instanceof TextInputEditText)) {
            Log.i((String)LOG_TAG, (String)"EditText added is not a TextInputEditText. Please switch to using that class instead.");
        }
        this.editText = editText;
        this.onApplyBoxBackgroundMode();
        this.setTextInputAccessibilityDelegate(new AccessibilityDelegate(this));
        this.collapsingTextHelper.setTypefaces(this.editText.getTypeface());
        this.collapsingTextHelper.setExpandedTextSize(this.editText.getTextSize());
        int editTextGravity = this.editText.getGravity();
        this.collapsingTextHelper.setCollapsedTextGravity(0x30 | editTextGravity & 0xFFFFFF8F);
        this.collapsingTextHelper.setExpandedTextGravity(editTextGravity);
        this.editText.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(@NonNull Editable s) {
                TextInputLayout.this.updateLabelState(!TextInputLayout.this.restoringSavedState);
                if (TextInputLayout.this.counterEnabled) {
                    TextInputLayout.this.updateCounter(s.length());
                }
                if (TextInputLayout.this.placeholderEnabled) {
                    TextInputLayout.this.updatePlaceholderText(s.length());
                }
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }
        });
        if (this.defaultHintTextColor == null) {
            this.defaultHintTextColor = this.editText.getHintTextColors();
        }
        if (this.hintEnabled) {
            if (TextUtils.isEmpty((CharSequence)this.hint)) {
                this.originalHint = this.editText.getHint();
                this.setHint(this.originalHint);
                this.editText.setHint(null);
            }
            this.isProvidingHint = true;
        }
        if (this.counterView != null) {
            this.updateCounter(this.editText.getText().length());
        }
        this.updateEditTextBackground();
        this.indicatorViewController.adjustIndicatorPadding();
        this.startLayout.bringToFront();
        this.endLayout.bringToFront();
        this.endIconFrame.bringToFront();
        this.errorIconView.bringToFront();
        this.dispatchOnEditTextAttached();
        this.updatePrefixTextViewPadding();
        this.updateSuffixTextViewPadding();
        if (!this.isEnabled()) {
            editText.setEnabled(false);
        }
        this.updateLabelState(false, true);
    }

    private void updateInputLayoutMargins() {
        if (this.boxBackgroundMode != 1) {
            LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.inputFrame.getLayoutParams();
            int newTopMargin = this.calculateLabelMarginTop();
            if (newTopMargin != lp.topMargin) {
                lp.topMargin = newTopMargin;
                this.inputFrame.requestLayout();
            }
        }
    }

    public int getBaseline() {
        if (this.editText != null) {
            return this.editText.getBaseline() + this.getPaddingTop() + this.calculateLabelMarginTop();
        }
        return super.getBaseline();
    }

    void updateLabelState(boolean animate) {
        this.updateLabelState(animate, false);
    }

    private void updateLabelState(boolean animate, boolean force) {
        boolean isEnabled = this.isEnabled();
        boolean hasText = this.editText != null && !TextUtils.isEmpty((CharSequence)this.editText.getText());
        boolean hasFocus = this.editText != null && this.editText.hasFocus();
        boolean errorShouldBeShown = this.indicatorViewController.errorShouldBeShown();
        if (this.defaultHintTextColor != null) {
            this.collapsingTextHelper.setCollapsedTextColor(this.defaultHintTextColor);
            this.collapsingTextHelper.setExpandedTextColor(this.defaultHintTextColor);
        }
        if (!isEnabled) {
            int disabledHintColor = this.defaultHintTextColor != null ? this.defaultHintTextColor.getColorForState(new int[]{-16842910}, this.disabledColor) : this.disabledColor;
            this.collapsingTextHelper.setCollapsedTextColor(ColorStateList.valueOf((int)disabledHintColor));
            this.collapsingTextHelper.setExpandedTextColor(ColorStateList.valueOf((int)disabledHintColor));
        } else if (errorShouldBeShown) {
            this.collapsingTextHelper.setCollapsedTextColor(this.indicatorViewController.getErrorViewTextColors());
        } else if (this.counterOverflowed && this.counterView != null) {
            this.collapsingTextHelper.setCollapsedTextColor(this.counterView.getTextColors());
        } else if (hasFocus && this.focusedTextColor != null) {
            this.collapsingTextHelper.setCollapsedTextColor(this.focusedTextColor);
        }
        if (hasText || this.isEnabled() && (hasFocus || errorShouldBeShown)) {
            if (force || this.hintExpanded) {
                this.collapseHint(animate);
            }
        } else if (force || !this.hintExpanded) {
            this.expandHint(animate);
        }
    }

    @Nullable
    public EditText getEditText() {
        return this.editText;
    }

    public void setHint(@Nullable CharSequence hint) {
        if (this.hintEnabled) {
            this.setHintInternal(hint);
            this.sendAccessibilityEvent(2048);
        }
    }

    private void setHintInternal(CharSequence hint) {
        if (!TextUtils.equals((CharSequence)hint, (CharSequence)this.hint)) {
            this.hint = hint;
            this.collapsingTextHelper.setText(hint);
            if (!this.hintExpanded) {
                this.openCutout();
            }
        }
    }

    @Nullable
    public CharSequence getHint() {
        return this.hintEnabled ? this.hint : null;
    }

    public void setHintEnabled(boolean enabled) {
        if (enabled != this.hintEnabled) {
            this.hintEnabled = enabled;
            if (!this.hintEnabled) {
                this.isProvidingHint = false;
                if (!TextUtils.isEmpty((CharSequence)this.hint) && TextUtils.isEmpty((CharSequence)this.editText.getHint())) {
                    this.editText.setHint(this.hint);
                }
                this.setHintInternal(null);
            } else {
                CharSequence editTextHint = this.editText.getHint();
                if (!TextUtils.isEmpty((CharSequence)editTextHint)) {
                    if (TextUtils.isEmpty((CharSequence)this.hint)) {
                        this.setHint(editTextHint);
                    }
                    this.editText.setHint(null);
                }
                this.isProvidingHint = true;
            }
            if (this.editText != null) {
                this.updateInputLayoutMargins();
            }
        }
    }

    public boolean isHintEnabled() {
        return this.hintEnabled;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public boolean isProvidingHint() {
        return this.isProvidingHint;
    }

    public void setHintTextAppearance(@StyleRes int resId) {
        this.collapsingTextHelper.setCollapsedTextAppearance(resId);
        this.focusedTextColor = this.collapsingTextHelper.getCollapsedTextColor();
        if (this.editText != null) {
            this.updateLabelState(false);
            this.updateInputLayoutMargins();
        }
    }

    public void setHintTextColor(@Nullable ColorStateList hintTextColor) {
        if (this.focusedTextColor != hintTextColor) {
            if (this.defaultHintTextColor == null) {
                this.collapsingTextHelper.setCollapsedTextColor(hintTextColor);
            }
            this.focusedTextColor = hintTextColor;
            if (this.editText != null) {
                this.updateLabelState(false);
            }
        }
    }

    @Nullable
    public ColorStateList getHintTextColor() {
        return this.focusedTextColor;
    }

    public void setDefaultHintTextColor(@Nullable ColorStateList textColor) {
        this.defaultHintTextColor = textColor;
        this.focusedTextColor = textColor;
        if (this.editText != null) {
            this.updateLabelState(false);
        }
    }

    @Nullable
    public ColorStateList getDefaultHintTextColor() {
        return this.defaultHintTextColor;
    }

    public void setErrorEnabled(boolean enabled) {
        this.indicatorViewController.setErrorEnabled(enabled);
    }

    public void setErrorTextAppearance(@StyleRes int errorTextAppearance) {
        this.indicatorViewController.setErrorTextAppearance(errorTextAppearance);
    }

    public void setErrorTextColor(@Nullable ColorStateList errorTextColor) {
        this.indicatorViewController.setErrorViewTextColor(errorTextColor);
    }

    @ColorInt
    public int getErrorCurrentTextColors() {
        return this.indicatorViewController.getErrorViewCurrentTextColor();
    }

    public void setHelperTextTextAppearance(@StyleRes int helperTextTextAppearance) {
        this.indicatorViewController.setHelperTextAppearance(helperTextTextAppearance);
    }

    public void setHelperTextColor(@Nullable ColorStateList helperTextColor) {
        this.indicatorViewController.setHelperTextViewTextColor(helperTextColor);
    }

    public boolean isErrorEnabled() {
        return this.indicatorViewController.isErrorEnabled();
    }

    public void setHelperTextEnabled(boolean enabled) {
        this.indicatorViewController.setHelperTextEnabled(enabled);
    }

    public void setHelperText(@Nullable CharSequence helperText) {
        if (TextUtils.isEmpty((CharSequence)helperText)) {
            if (this.isHelperTextEnabled()) {
                this.setHelperTextEnabled(false);
            }
        } else {
            if (!this.isHelperTextEnabled()) {
                this.setHelperTextEnabled(true);
            }
            this.indicatorViewController.showHelper(helperText);
        }
    }

    public boolean isHelperTextEnabled() {
        return this.indicatorViewController.isHelperTextEnabled();
    }

    @ColorInt
    public int getHelperTextCurrentTextColor() {
        return this.indicatorViewController.getHelperTextViewCurrentTextColor();
    }

    public void setErrorContentDescription(@Nullable CharSequence errorContentDecription) {
        this.indicatorViewController.setErrorContentDescription(errorContentDecription);
    }

    @Nullable
    public CharSequence getErrorContentDescription() {
        return this.indicatorViewController.getErrorContentDescription();
    }

    public void setError(@Nullable CharSequence errorText) {
        if (!this.indicatorViewController.isErrorEnabled()) {
            if (TextUtils.isEmpty((CharSequence)errorText)) {
                return;
            }
            this.setErrorEnabled(true);
        }
        if (!TextUtils.isEmpty((CharSequence)errorText)) {
            this.indicatorViewController.showError(errorText);
        } else {
            this.indicatorViewController.hideError();
        }
    }

    public void setErrorIconDrawable(@DrawableRes int resId) {
        this.setErrorIconDrawable(resId != 0 ? AppCompatResources.getDrawable((Context)this.getContext(), (int)resId) : null);
    }

    public void setErrorIconDrawable(@Nullable Drawable errorIconDrawable) {
        this.errorIconView.setImageDrawable(errorIconDrawable);
        this.setErrorIconVisible(errorIconDrawable != null && this.indicatorViewController.isErrorEnabled());
    }

    @Nullable
    public Drawable getErrorIconDrawable() {
        return this.errorIconView.getDrawable();
    }

    public void setErrorIconTintList(@Nullable ColorStateList errorIconTintList) {
        this.errorIconTintList = errorIconTintList;
        Drawable icon = this.errorIconView.getDrawable();
        if (icon != null) {
            icon = DrawableCompat.wrap((Drawable)icon).mutate();
            DrawableCompat.setTintList((Drawable)icon, (ColorStateList)errorIconTintList);
        }
        if (this.errorIconView.getDrawable() != icon) {
            this.errorIconView.setImageDrawable(icon);
        }
    }

    public void setErrorIconTintMode(@Nullable PorterDuff.Mode errorIconTintMode) {
        Drawable icon = this.errorIconView.getDrawable();
        if (icon != null) {
            icon = DrawableCompat.wrap((Drawable)icon).mutate();
            DrawableCompat.setTintMode((Drawable)icon, (PorterDuff.Mode)errorIconTintMode);
        }
        if (this.errorIconView.getDrawable() != icon) {
            this.errorIconView.setImageDrawable(icon);
        }
    }

    public void setCounterEnabled(boolean enabled) {
        if (this.counterEnabled != enabled) {
            if (enabled) {
                this.counterView = new AppCompatTextView(this.getContext());
                this.counterView.setId(R.id.textinput_counter);
                if (this.typeface != null) {
                    this.counterView.setTypeface(this.typeface);
                }
                this.counterView.setMaxLines(1);
                this.indicatorViewController.addIndicator(this.counterView, 2);
                MarginLayoutParamsCompat.setMarginStart((ViewGroup.MarginLayoutParams)((ViewGroup.MarginLayoutParams)this.counterView.getLayoutParams()), (int)this.getResources().getDimensionPixelOffset(R.dimen.mtrl_textinput_counter_margin_start));
                this.updateCounterTextAppearanceAndColor();
                this.updateCounter();
            } else {
                this.indicatorViewController.removeIndicator(this.counterView, 2);
                this.counterView = null;
            }
            this.counterEnabled = enabled;
        }
    }

    public void setCounterTextAppearance(int counterTextAppearance) {
        if (this.counterTextAppearance != counterTextAppearance) {
            this.counterTextAppearance = counterTextAppearance;
            this.updateCounterTextAppearanceAndColor();
        }
    }

    public void setCounterTextColor(@Nullable ColorStateList counterTextColor) {
        if (this.counterTextColor != counterTextColor) {
            this.counterTextColor = counterTextColor;
            this.updateCounterTextAppearanceAndColor();
        }
    }

    @Nullable
    public ColorStateList getCounterTextColor() {
        return this.counterTextColor;
    }

    public void setCounterOverflowTextAppearance(int counterOverflowTextAppearance) {
        if (this.counterOverflowTextAppearance != counterOverflowTextAppearance) {
            this.counterOverflowTextAppearance = counterOverflowTextAppearance;
            this.updateCounterTextAppearanceAndColor();
        }
    }

    public void setCounterOverflowTextColor(@Nullable ColorStateList counterOverflowTextColor) {
        if (this.counterOverflowTextColor != counterOverflowTextColor) {
            this.counterOverflowTextColor = counterOverflowTextColor;
            this.updateCounterTextAppearanceAndColor();
        }
    }

    @Nullable
    public ColorStateList getCounterOverflowTextColor() {
        return this.counterTextColor;
    }

    public boolean isCounterEnabled() {
        return this.counterEnabled;
    }

    public void setCounterMaxLength(int maxLength) {
        if (this.counterMaxLength != maxLength) {
            this.counterMaxLength = maxLength > 0 ? maxLength : -1;
            if (this.counterEnabled) {
                this.updateCounter();
            }
        }
    }

    private void updateCounter() {
        if (this.counterView != null) {
            this.updateCounter(this.editText == null ? 0 : this.editText.getText().length());
        }
    }

    void updateCounter(int length) {
        boolean wasCounterOverflowed = this.counterOverflowed;
        if (this.counterMaxLength == -1) {
            this.counterView.setText((CharSequence)String.valueOf(length));
            this.counterView.setContentDescription(null);
            this.counterOverflowed = false;
        } else {
            this.counterOverflowed = length > this.counterMaxLength;
            TextInputLayout.updateCounterContentDescription(this.getContext(), this.counterView, length, this.counterMaxLength, this.counterOverflowed);
            if (wasCounterOverflowed != this.counterOverflowed) {
                this.updateCounterTextAppearanceAndColor();
            }
            BidiFormatter bidiFormatter = BidiFormatter.getInstance();
            this.counterView.setText((CharSequence)bidiFormatter.unicodeWrap(this.getContext().getString(R.string.character_counter_pattern, new Object[]{length, this.counterMaxLength})));
        }
        if (this.editText != null && wasCounterOverflowed != this.counterOverflowed) {
            this.updateLabelState(false);
            this.updateTextInputBoxState();
            this.updateEditTextBackground();
        }
    }

    private static void updateCounterContentDescription(@NonNull Context context, @NonNull TextView counterView, int length, int counterMaxLength, boolean counterOverflowed) {
        counterView.setContentDescription((CharSequence)context.getString(counterOverflowed ? R.string.character_counter_overflowed_content_description : R.string.character_counter_content_description, new Object[]{length, counterMaxLength}));
    }

    public void setPlaceholderText(@Nullable CharSequence placeholderText) {
        if (this.placeholderEnabled && TextUtils.isEmpty((CharSequence)placeholderText)) {
            this.setPlaceholderTextEnabled(false);
        } else {
            if (!this.placeholderEnabled) {
                this.setPlaceholderTextEnabled(true);
            }
            this.placeholderText = placeholderText;
        }
        this.updatePlaceholderText();
    }

    @Nullable
    public CharSequence getPlaceholderText() {
        return this.placeholderEnabled ? this.placeholderText : null;
    }

    private void setPlaceholderTextEnabled(boolean placeholderEnabled) {
        if (this.placeholderEnabled == placeholderEnabled) {
            return;
        }
        if (placeholderEnabled) {
            this.placeholderTextView = new AppCompatTextView(this.getContext());
            this.placeholderTextView.setId(R.id.textinput_placeholder);
            ViewCompat.setAccessibilityLiveRegion((View)this.placeholderTextView, (int)1);
            this.setPlaceholderTextAppearance(this.placeholderTextAppearance);
            this.setPlaceholderTextColor(this.placeholderTextColor);
            this.addPlaceholderTextView();
        } else {
            this.removePlaceholderTextView();
            this.placeholderTextView = null;
        }
        this.placeholderEnabled = placeholderEnabled;
    }

    private void updatePlaceholderText() {
        this.updatePlaceholderText(this.editText == null ? 0 : this.editText.getText().length());
    }

    private void updatePlaceholderText(int inputTextLength) {
        if (inputTextLength == 0 && !this.hintExpanded) {
            this.showPlaceholderText();
        } else {
            this.hidePlaceholderText();
        }
    }

    private void showPlaceholderText() {
        if (this.placeholderTextView != null && this.placeholderEnabled) {
            this.placeholderTextView.setText(this.placeholderText);
            this.placeholderTextView.setVisibility(0);
            this.placeholderTextView.bringToFront();
        }
    }

    private void hidePlaceholderText() {
        if (this.placeholderTextView != null && this.placeholderEnabled) {
            this.placeholderTextView.setText(null);
            this.placeholderTextView.setVisibility(4);
        }
    }

    private void addPlaceholderTextView() {
        if (this.placeholderTextView != null) {
            this.inputFrame.addView((View)this.placeholderTextView);
            this.placeholderTextView.setVisibility(0);
        }
    }

    private void removePlaceholderTextView() {
        if (this.placeholderTextView != null) {
            this.placeholderTextView.setVisibility(8);
        }
    }

    public void setPlaceholderTextColor(@Nullable ColorStateList placeholderTextColor) {
        if (this.placeholderTextColor != placeholderTextColor) {
            this.placeholderTextColor = placeholderTextColor;
            if (this.placeholderTextView != null && placeholderTextColor != null) {
                this.placeholderTextView.setTextColor(placeholderTextColor);
            }
        }
    }

    @Nullable
    public ColorStateList getPlaceholderTextColor() {
        return this.placeholderTextColor;
    }

    public void setPlaceholderTextAppearance(@StyleRes int placeholderTextAppearance) {
        this.placeholderTextAppearance = placeholderTextAppearance;
        if (this.placeholderTextView != null) {
            TextViewCompat.setTextAppearance((TextView)this.placeholderTextView, (int)placeholderTextAppearance);
        }
    }

    @StyleRes
    public int getPlaceholderTextAppearance() {
        return this.placeholderTextAppearance;
    }

    public void setPrefixText(@Nullable CharSequence prefixText) {
        this.prefixText = TextUtils.isEmpty((CharSequence)prefixText) ? null : prefixText;
        this.prefixTextView.setText(prefixText);
        this.updatePrefixTextVisibility();
    }

    @Nullable
    public CharSequence getPrefixText() {
        return this.prefixText;
    }

    @NonNull
    public TextView getPrefixTextView() {
        return this.prefixTextView;
    }

    private void updatePrefixTextVisibility() {
        this.prefixTextView.setVisibility(this.prefixText != null && !this.isHintExpanded() ? 0 : 8);
        this.updateDummyDrawables();
    }

    public void setPrefixTextColor(@NonNull ColorStateList prefixTextColor) {
        this.prefixTextView.setTextColor(prefixTextColor);
    }

    @Nullable
    public ColorStateList getPrefixTextColor() {
        return this.prefixTextView.getTextColors();
    }

    public void setPrefixTextAppearance(@StyleRes int prefixTextAppearance) {
        TextViewCompat.setTextAppearance((TextView)this.prefixTextView, (int)prefixTextAppearance);
    }

    private void updatePrefixTextViewPadding() {
        if (this.editText == null) {
            return;
        }
        int startPadding = this.isStartIconVisible() ? 0 : ViewCompat.getPaddingStart((View)this.editText);
        ViewCompat.setPaddingRelative((View)this.prefixTextView, (int)startPadding, (int)this.editText.getCompoundPaddingTop(), (int)0, (int)this.editText.getCompoundPaddingBottom());
    }

    public void setSuffixText(@Nullable CharSequence suffixText) {
        this.suffixText = TextUtils.isEmpty((CharSequence)suffixText) ? null : suffixText;
        this.suffixTextView.setText(suffixText);
        this.updateSuffixTextVisibility();
    }

    @Nullable
    public CharSequence getSuffixText() {
        return this.suffixText;
    }

    @NonNull
    public TextView getSuffixTextView() {
        return this.suffixTextView;
    }

    private void updateSuffixTextVisibility() {
        int oldSuffixVisibility = this.suffixTextView.getVisibility();
        boolean visible = this.suffixText != null && !this.isHintExpanded();
        this.suffixTextView.setVisibility(visible ? 0 : 8);
        if (oldSuffixVisibility != this.suffixTextView.getVisibility()) {
            this.getEndIconDelegate().onSuffixVisibilityChanged(visible);
        }
        this.updateDummyDrawables();
    }

    public void setSuffixTextColor(@NonNull ColorStateList suffixTextColor) {
        this.suffixTextView.setTextColor(suffixTextColor);
    }

    @Nullable
    public ColorStateList getSuffixTextColor() {
        return this.suffixTextView.getTextColors();
    }

    public void setSuffixTextAppearance(@StyleRes int suffixTextAppearance) {
        TextViewCompat.setTextAppearance((TextView)this.suffixTextView, (int)suffixTextAppearance);
    }

    private void updateSuffixTextViewPadding() {
        if (this.editText == null) {
            return;
        }
        int endPadding = this.isEndIconVisible() || this.isErrorIconVisible() ? 0 : ViewCompat.getPaddingEnd((View)this.editText);
        ViewCompat.setPaddingRelative((View)this.suffixTextView, (int)0, (int)this.editText.getPaddingTop(), (int)endPadding, (int)this.editText.getPaddingBottom());
    }

    public void setEnabled(boolean enabled) {
        TextInputLayout.recursiveSetEnabled((ViewGroup)this, enabled);
        super.setEnabled(enabled);
    }

    private static void recursiveSetEnabled(@NonNull ViewGroup vg, boolean enabled) {
        int count = vg.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = vg.getChildAt(i);
            child.setEnabled(enabled);
            if (!(child instanceof ViewGroup)) continue;
            TextInputLayout.recursiveSetEnabled((ViewGroup)child, enabled);
        }
    }

    public int getCounterMaxLength() {
        return this.counterMaxLength;
    }

    @Nullable
    CharSequence getCounterOverflowDescription() {
        if (this.counterEnabled && this.counterOverflowed && this.counterView != null) {
            return this.counterView.getContentDescription();
        }
        return null;
    }

    private void updateCounterTextAppearanceAndColor() {
        if (this.counterView != null) {
            this.setTextAppearanceCompatWithErrorFallback(this.counterView, this.counterOverflowed ? this.counterOverflowTextAppearance : this.counterTextAppearance);
            if (!this.counterOverflowed && this.counterTextColor != null) {
                this.counterView.setTextColor(this.counterTextColor);
            }
            if (this.counterOverflowed && this.counterOverflowTextColor != null) {
                this.counterView.setTextColor(this.counterOverflowTextColor);
            }
        }
    }

    void setTextAppearanceCompatWithErrorFallback(@NonNull TextView textView, @StyleRes int textAppearance) {
        boolean useDefaultColor = false;
        try {
            TextViewCompat.setTextAppearance((TextView)textView, (int)textAppearance);
            if (Build.VERSION.SDK_INT >= 23 && textView.getTextColors().getDefaultColor() == -65281) {
                useDefaultColor = true;
            }
        }
        catch (Exception e) {
            useDefaultColor = true;
        }
        if (useDefaultColor) {
            TextViewCompat.setTextAppearance((TextView)textView, (int)R.style.TextAppearance_AppCompat_Caption);
            textView.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.design_error));
        }
    }

    private int calculateLabelMarginTop() {
        if (!this.hintEnabled) {
            return 0;
        }
        switch (this.boxBackgroundMode) {
            case 2: {
                return (int)(this.collapsingTextHelper.getCollapsedTextHeight() / 2.0f);
            }
            case 0: 
            case 1: {
                return (int)this.collapsingTextHelper.getCollapsedTextHeight();
            }
        }
        return 0;
    }

    @NonNull
    private Rect calculateCollapsedTextBounds(@NonNull Rect rect) {
        if (this.editText == null) {
            throw new IllegalStateException();
        }
        Rect bounds = this.tmpBoundsRect;
        boolean isRtl = ViewCompat.getLayoutDirection((View)this) == 1;
        bounds.bottom = rect.bottom;
        switch (this.boxBackgroundMode) {
            case 2: {
                bounds.left = rect.left + this.editText.getPaddingLeft();
                bounds.top = rect.top - this.calculateLabelMarginTop();
                bounds.right = rect.right - this.editText.getPaddingRight();
                return bounds;
            }
            case 1: {
                bounds.left = this.getLabelLeftBoundAlightWithPrefix(rect.left, isRtl);
                bounds.top = rect.top + this.boxCollapsedPaddingTopPx;
                bounds.right = this.getLabelRightBoundAlignedWithSuffix(rect.right, isRtl);
                return bounds;
            }
        }
        bounds.left = this.getLabelLeftBoundAlightWithPrefix(rect.left, isRtl);
        bounds.top = this.getPaddingTop();
        bounds.right = this.getLabelRightBoundAlignedWithSuffix(rect.right, isRtl);
        return bounds;
    }

    private int getLabelLeftBoundAlightWithPrefix(int rectLeft, boolean isRtl) {
        int left = rectLeft + this.editText.getCompoundPaddingLeft();
        if (this.prefixText != null && !isRtl) {
            left = left - this.prefixTextView.getMeasuredWidth() + this.prefixTextView.getPaddingLeft();
        }
        return left;
    }

    private int getLabelRightBoundAlignedWithSuffix(int rectRight, boolean isRtl) {
        int right = rectRight - this.editText.getCompoundPaddingRight();
        if (this.prefixText != null && isRtl) {
            right += this.prefixTextView.getMeasuredWidth() - this.prefixTextView.getPaddingRight();
        }
        return right;
    }

    @NonNull
    private Rect calculateExpandedTextBounds(@NonNull Rect rect) {
        if (this.editText == null) {
            throw new IllegalStateException();
        }
        Rect bounds = this.tmpBoundsRect;
        float labelHeight = this.collapsingTextHelper.getExpandedTextHeight();
        bounds.left = rect.left + this.editText.getCompoundPaddingLeft();
        bounds.top = this.calculateExpandedLabelTop(rect, labelHeight);
        bounds.right = rect.right - this.editText.getCompoundPaddingRight();
        bounds.bottom = this.calculateExpandedLabelBottom(rect, bounds, labelHeight);
        return bounds;
    }

    private int calculateExpandedLabelTop(@NonNull Rect rect, float labelHeight) {
        if (this.isSingleLineFilledTextField()) {
            return (int)((float)rect.centerY() - labelHeight / 2.0f);
        }
        return rect.top + this.editText.getCompoundPaddingTop();
    }

    private int calculateExpandedLabelBottom(@NonNull Rect rect, @NonNull Rect bounds, float labelHeight) {
        if (this.isSingleLineFilledTextField()) {
            return (int)((float)bounds.top + labelHeight);
        }
        return rect.bottom - this.editText.getCompoundPaddingBottom();
    }

    private boolean isSingleLineFilledTextField() {
        return this.boxBackgroundMode == 1 && (Build.VERSION.SDK_INT < 16 || this.editText.getMinLines() <= 1);
    }

    private int calculateBoxBackgroundColor() {
        int backgroundColor = this.boxBackgroundColor;
        if (this.boxBackgroundMode == 1) {
            int surfaceLayerColor = MaterialColors.getColor((View)this, R.attr.colorSurface, 0);
            backgroundColor = MaterialColors.layer(surfaceLayerColor, this.boxBackgroundColor);
        }
        return backgroundColor;
    }

    private void applyBoxAttributes() {
        if (this.boxBackground == null) {
            return;
        }
        this.boxBackground.setShapeAppearanceModel(this.shapeAppearanceModel);
        if (this.canDrawOutlineStroke()) {
            this.boxBackground.setStroke((float)this.boxStrokeWidthPx, this.boxStrokeColor);
        }
        this.boxBackgroundColor = this.calculateBoxBackgroundColor();
        this.boxBackground.setFillColor(ColorStateList.valueOf((int)this.boxBackgroundColor));
        if (this.endIconMode == 3) {
            this.editText.getBackground().invalidateSelf();
        }
        this.applyBoxUnderlineAttributes();
        this.invalidate();
    }

    private void applyBoxUnderlineAttributes() {
        if (this.boxUnderline == null) {
            return;
        }
        if (this.canDrawStroke()) {
            this.boxUnderline.setFillColor(ColorStateList.valueOf((int)this.boxStrokeColor));
        }
        this.invalidate();
    }

    private boolean canDrawOutlineStroke() {
        return this.boxBackgroundMode == 2 && this.canDrawStroke();
    }

    private boolean canDrawStroke() {
        return this.boxStrokeWidthPx > -1 && this.boxStrokeColor != 0;
    }

    void updateEditTextBackground() {
        if (this.editText == null || this.boxBackgroundMode != 0) {
            return;
        }
        Drawable editTextBackground = this.editText.getBackground();
        if (editTextBackground == null) {
            return;
        }
        if (DrawableUtils.canSafelyMutateDrawable((Drawable)editTextBackground)) {
            editTextBackground = editTextBackground.mutate();
        }
        if (this.indicatorViewController.errorShouldBeShown()) {
            editTextBackground.setColorFilter((ColorFilter)AppCompatDrawableManager.getPorterDuffColorFilter((int)this.indicatorViewController.getErrorViewCurrentTextColor(), (PorterDuff.Mode)PorterDuff.Mode.SRC_IN));
        } else if (this.counterOverflowed && this.counterView != null) {
            editTextBackground.setColorFilter((ColorFilter)AppCompatDrawableManager.getPorterDuffColorFilter((int)this.counterView.getCurrentTextColor(), (PorterDuff.Mode)PorterDuff.Mode.SRC_IN));
        } else {
            DrawableCompat.clearColorFilter((Drawable)editTextBackground);
            this.editText.refreshDrawableState();
        }
    }

    @Nullable
    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        if (this.indicatorViewController.errorShouldBeShown()) {
            ss.error = this.getError();
        }
        ss.isEndIconChecked = this.hasEndIcon() && this.endIconView.isChecked();
        return ss;
    }

    protected void onRestoreInstanceState(@Nullable Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setError(ss.error);
        if (ss.isEndIconChecked) {
            this.endIconView.post(new Runnable(){

                @Override
                public void run() {
                    TextInputLayout.this.endIconView.performClick();
                    TextInputLayout.this.endIconView.jumpDrawablesToCurrentState();
                }
            });
        }
        this.requestLayout();
    }

    protected void dispatchRestoreInstanceState(@NonNull SparseArray<Parcelable> container) {
        this.restoringSavedState = true;
        super.dispatchRestoreInstanceState(container);
        this.restoringSavedState = false;
    }

    @Nullable
    public CharSequence getError() {
        return this.indicatorViewController.isErrorEnabled() ? this.indicatorViewController.getErrorText() : null;
    }

    @Nullable
    public CharSequence getHelperText() {
        return this.indicatorViewController.isHelperTextEnabled() ? this.indicatorViewController.getHelperText() : null;
    }

    public boolean isHintAnimationEnabled() {
        return this.hintAnimationEnabled;
    }

    public void setHintAnimationEnabled(boolean enabled) {
        this.hintAnimationEnabled = enabled;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        boolean updatedHeight = this.updateEditTextHeightBasedOnIcon();
        boolean updatedIcon = this.updateDummyDrawables();
        if (updatedHeight || updatedIcon) {
            this.editText.post(new Runnable(){

                @Override
                public void run() {
                    TextInputLayout.this.editText.requestLayout();
                }
            });
        }
        this.updatePlaceholderMeasurementsBasedOnEditText();
        this.updatePrefixTextViewPadding();
        this.updateSuffixTextViewPadding();
    }

    private boolean updateEditTextHeightBasedOnIcon() {
        if (this.editText == null) {
            return false;
        }
        int maxIconHeight = Math.max(this.endLayout.getMeasuredHeight(), this.startLayout.getMeasuredHeight());
        if (this.editText.getMeasuredHeight() < maxIconHeight) {
            this.editText.setMinimumHeight(maxIconHeight);
            return true;
        }
        return false;
    }

    private void updatePlaceholderMeasurementsBasedOnEditText() {
        if (this.placeholderTextView != null && this.editText != null) {
            int editTextGravity = this.editText.getGravity();
            this.placeholderTextView.setGravity(editTextGravity);
            this.placeholderTextView.setPadding(this.editText.getCompoundPaddingLeft(), this.editText.getCompoundPaddingTop(), this.editText.getCompoundPaddingRight(), this.editText.getCompoundPaddingBottom());
        }
    }

    public void setStartIconDrawable(@DrawableRes int resId) {
        this.setStartIconDrawable(resId != 0 ? AppCompatResources.getDrawable((Context)this.getContext(), (int)resId) : null);
    }

    public void setStartIconDrawable(@Nullable Drawable startIconDrawable) {
        this.startIconView.setImageDrawable(startIconDrawable);
        if (startIconDrawable != null) {
            this.setStartIconVisible(true);
            this.applyStartIconTint();
        } else {
            this.setStartIconVisible(false);
            this.setStartIconOnClickListener(null);
            this.setStartIconOnLongClickListener(null);
            this.setStartIconContentDescription(null);
        }
    }

    @Nullable
    public Drawable getStartIconDrawable() {
        return this.startIconView.getDrawable();
    }

    public void setStartIconOnClickListener(@Nullable View.OnClickListener startIconOnClickListener) {
        TextInputLayout.setIconOnClickListener(this.startIconView, startIconOnClickListener, this.startIconOnLongClickListener);
    }

    public void setStartIconOnLongClickListener(@Nullable View.OnLongClickListener startIconOnLongClickListener) {
        this.startIconOnLongClickListener = startIconOnLongClickListener;
        TextInputLayout.setIconOnLongClickListener(this.startIconView, startIconOnLongClickListener);
    }

    public void setStartIconVisible(boolean visible) {
        if (this.isStartIconVisible() != visible) {
            this.startIconView.setVisibility(visible ? 0 : 8);
            this.updatePrefixTextViewPadding();
            this.updateDummyDrawables();
        }
    }

    public boolean isStartIconVisible() {
        return this.startIconView.getVisibility() == 0;
    }

    public void setStartIconCheckable(boolean startIconCheckable) {
        this.startIconView.setCheckable(startIconCheckable);
    }

    public boolean isStartIconCheckable() {
        return this.startIconView.isCheckable();
    }

    public void setStartIconContentDescription(@StringRes int resId) {
        this.setStartIconContentDescription(resId != 0 ? this.getResources().getText(resId) : null);
    }

    public void setStartIconContentDescription(@Nullable CharSequence startIconContentDescription) {
        if (this.getStartIconContentDescription() != startIconContentDescription) {
            this.startIconView.setContentDescription(startIconContentDescription);
        }
    }

    @Nullable
    public CharSequence getStartIconContentDescription() {
        return this.startIconView.getContentDescription();
    }

    public void setStartIconTintList(@Nullable ColorStateList startIconTintList) {
        if (this.startIconTintList != startIconTintList) {
            this.startIconTintList = startIconTintList;
            this.hasStartIconTintList = true;
            this.applyStartIconTint();
        }
    }

    public void setStartIconTintMode(@Nullable PorterDuff.Mode startIconTintMode) {
        if (this.startIconTintMode != startIconTintMode) {
            this.startIconTintMode = startIconTintMode;
            this.hasStartIconTintMode = true;
            this.applyStartIconTint();
        }
    }

    public void setEndIconMode(int endIconMode) {
        int previousEndIconMode = this.endIconMode;
        this.endIconMode = endIconMode;
        this.dispatchOnEndIconChanged(previousEndIconMode);
        this.setEndIconVisible(endIconMode != 0);
        if (!this.getEndIconDelegate().isBoxBackgroundModeSupported(this.boxBackgroundMode)) {
            throw new IllegalStateException("The current box background mode " + this.boxBackgroundMode + " is not supported by the end icon mode " + endIconMode);
        }
        this.getEndIconDelegate().initialize();
        this.applyEndIconTint();
    }

    public int getEndIconMode() {
        return this.endIconMode;
    }

    public void setEndIconOnClickListener(@Nullable View.OnClickListener endIconOnClickListener) {
        TextInputLayout.setIconOnClickListener(this.endIconView, endIconOnClickListener, this.endIconOnLongClickListener);
    }

    public void setErrorIconOnClickListener(@Nullable View.OnClickListener errorIconOnClickListener) {
        TextInputLayout.setIconOnClickListener(this.errorIconView, errorIconOnClickListener, this.errorIconOnLongClickListener);
    }

    public void setEndIconOnLongClickListener(@Nullable View.OnLongClickListener endIconOnLongClickListener) {
        this.endIconOnLongClickListener = endIconOnLongClickListener;
        TextInputLayout.setIconOnLongClickListener(this.endIconView, endIconOnLongClickListener);
    }

    public void setErrorIconOnLongClickListener(@Nullable View.OnLongClickListener errorIconOnLongClickListener) {
        this.errorIconOnLongClickListener = errorIconOnLongClickListener;
        TextInputLayout.setIconOnLongClickListener(this.errorIconView, errorIconOnLongClickListener);
    }

    public void setEndIconVisible(boolean visible) {
        if (this.isEndIconVisible() != visible) {
            this.endIconView.setVisibility(visible ? 0 : 8);
            this.updateSuffixTextViewPadding();
            this.updateDummyDrawables();
        }
    }

    public boolean isEndIconVisible() {
        return this.endIconFrame.getVisibility() == 0 && this.endIconView.getVisibility() == 0;
    }

    public void setEndIconActivated(boolean endIconActivated) {
        this.endIconView.setActivated(endIconActivated);
    }

    public void setEndIconCheckable(boolean endIconCheckable) {
        this.endIconView.setCheckable(endIconCheckable);
    }

    public boolean isEndIconCheckable() {
        return this.endIconView.isCheckable();
    }

    public void setEndIconDrawable(@DrawableRes int resId) {
        this.setEndIconDrawable(resId != 0 ? AppCompatResources.getDrawable((Context)this.getContext(), (int)resId) : null);
    }

    public void setEndIconDrawable(@Nullable Drawable endIconDrawable) {
        this.endIconView.setImageDrawable(endIconDrawable);
    }

    @Nullable
    public Drawable getEndIconDrawable() {
        return this.endIconView.getDrawable();
    }

    public void setEndIconContentDescription(@StringRes int resId) {
        this.setEndIconContentDescription(resId != 0 ? this.getResources().getText(resId) : null);
    }

    public void setEndIconContentDescription(@Nullable CharSequence endIconContentDescription) {
        if (this.getEndIconContentDescription() != endIconContentDescription) {
            this.endIconView.setContentDescription(endIconContentDescription);
        }
    }

    @Nullable
    public CharSequence getEndIconContentDescription() {
        return this.endIconView.getContentDescription();
    }

    public void setEndIconTintList(@Nullable ColorStateList endIconTintList) {
        if (this.endIconTintList != endIconTintList) {
            this.endIconTintList = endIconTintList;
            this.hasEndIconTintList = true;
            this.applyEndIconTint();
        }
    }

    public void setEndIconTintMode(@Nullable PorterDuff.Mode endIconTintMode) {
        if (this.endIconTintMode != endIconTintMode) {
            this.endIconTintMode = endIconTintMode;
            this.hasEndIconTintMode = true;
            this.applyEndIconTint();
        }
    }

    public void addOnEndIconChangedListener(@NonNull OnEndIconChangedListener listener) {
        this.endIconChangedListeners.add(listener);
    }

    public void removeOnEndIconChangedListener(@NonNull OnEndIconChangedListener listener) {
        this.endIconChangedListeners.remove(listener);
    }

    public void clearOnEndIconChangedListeners() {
        this.endIconChangedListeners.clear();
    }

    public void addOnEditTextAttachedListener(@NonNull OnEditTextAttachedListener listener) {
        this.editTextAttachedListeners.add(listener);
        if (this.editText != null) {
            listener.onEditTextAttached(this);
        }
    }

    public void removeOnEditTextAttachedListener(@NonNull OnEditTextAttachedListener listener) {
        this.editTextAttachedListeners.remove(listener);
    }

    public void clearOnEditTextAttachedListeners() {
        this.editTextAttachedListeners.clear();
    }

    @Deprecated
    public void setPasswordVisibilityToggleDrawable(@DrawableRes int resId) {
        this.setPasswordVisibilityToggleDrawable(resId != 0 ? AppCompatResources.getDrawable((Context)this.getContext(), (int)resId) : null);
    }

    @Deprecated
    public void setPasswordVisibilityToggleDrawable(@Nullable Drawable icon) {
        this.endIconView.setImageDrawable(icon);
    }

    @Deprecated
    public void setPasswordVisibilityToggleContentDescription(@StringRes int resId) {
        this.setPasswordVisibilityToggleContentDescription(resId != 0 ? this.getResources().getText(resId) : null);
    }

    @Deprecated
    public void setPasswordVisibilityToggleContentDescription(@Nullable CharSequence description) {
        this.endIconView.setContentDescription(description);
    }

    @Deprecated
    @Nullable
    public Drawable getPasswordVisibilityToggleDrawable() {
        return this.endIconView.getDrawable();
    }

    @Deprecated
    @Nullable
    public CharSequence getPasswordVisibilityToggleContentDescription() {
        return this.endIconView.getContentDescription();
    }

    @Deprecated
    public boolean isPasswordVisibilityToggleEnabled() {
        return this.endIconMode == 1;
    }

    @Deprecated
    public void setPasswordVisibilityToggleEnabled(boolean enabled) {
        if (enabled && this.endIconMode != 1) {
            this.setEndIconMode(1);
        } else if (!enabled) {
            this.setEndIconMode(0);
        }
    }

    @Deprecated
    public void setPasswordVisibilityToggleTintList(@Nullable ColorStateList tintList) {
        this.endIconTintList = tintList;
        this.hasEndIconTintList = true;
        this.applyEndIconTint();
    }

    @Deprecated
    public void setPasswordVisibilityToggleTintMode(@Nullable PorterDuff.Mode mode) {
        this.endIconTintMode = mode;
        this.hasEndIconTintMode = true;
        this.applyEndIconTint();
    }

    @Deprecated
    public void passwordVisibilityToggleRequested(boolean shouldSkipAnimations) {
        if (this.endIconMode == 1) {
            this.endIconView.performClick();
            if (shouldSkipAnimations) {
                this.endIconView.jumpDrawablesToCurrentState();
            }
        }
    }

    public void setTextInputAccessibilityDelegate(@Nullable AccessibilityDelegate delegate) {
        if (this.editText != null) {
            ViewCompat.setAccessibilityDelegate((View)this.editText, (AccessibilityDelegateCompat)delegate);
        }
    }

    @NonNull
    CheckableImageButton getEndIconView() {
        return this.endIconView;
    }

    private EndIconDelegate getEndIconDelegate() {
        EndIconDelegate endIconDelegate = (EndIconDelegate)this.endIconDelegates.get(this.endIconMode);
        return endIconDelegate != null ? endIconDelegate : (EndIconDelegate)this.endIconDelegates.get(0);
    }

    private void dispatchOnEditTextAttached() {
        for (OnEditTextAttachedListener listener : this.editTextAttachedListeners) {
            listener.onEditTextAttached(this);
        }
    }

    private void applyStartIconTint() {
        this.applyIconTint(this.startIconView, this.hasStartIconTintList, this.startIconTintList, this.hasStartIconTintMode, this.startIconTintMode);
    }

    private boolean hasEndIcon() {
        return this.endIconMode != 0;
    }

    private void dispatchOnEndIconChanged(int previousIcon) {
        for (OnEndIconChangedListener listener : this.endIconChangedListeners) {
            listener.onEndIconChanged(this, previousIcon);
        }
    }

    private void tintEndIconOnError(boolean tintEndIconOnError) {
        if (tintEndIconOnError && this.getEndIconDrawable() != null) {
            Drawable endIconDrawable = DrawableCompat.wrap((Drawable)this.getEndIconDrawable()).mutate();
            DrawableCompat.setTint((Drawable)endIconDrawable, (int)this.indicatorViewController.getErrorViewCurrentTextColor());
            this.endIconView.setImageDrawable(endIconDrawable);
        } else {
            this.applyEndIconTint();
        }
    }

    private void applyEndIconTint() {
        this.applyIconTint(this.endIconView, this.hasEndIconTintList, this.endIconTintList, this.hasEndIconTintMode, this.endIconTintMode);
    }

    private boolean updateDummyDrawables() {
        int right;
        if (this.editText == null) {
            return false;
        }
        boolean updatedIcon = false;
        if (this.shouldUpdateStartDummyDrawable()) {
            Drawable[] compounds;
            right = this.startLayout.getMeasuredWidth() - this.editText.getPaddingLeft();
            if (this.startDummyDrawable == null || this.startDummyDrawableWidth != right) {
                this.startDummyDrawable = new ColorDrawable();
                this.startDummyDrawableWidth = right;
                this.startDummyDrawable.setBounds(0, 0, this.startDummyDrawableWidth, 1);
            }
            if ((compounds = TextViewCompat.getCompoundDrawablesRelative((TextView)this.editText))[0] != this.startDummyDrawable) {
                TextViewCompat.setCompoundDrawablesRelative((TextView)this.editText, (Drawable)this.startDummyDrawable, (Drawable)compounds[1], (Drawable)compounds[2], (Drawable)compounds[3]);
                updatedIcon = true;
            }
        } else if (this.startDummyDrawable != null) {
            Drawable[] compounds = TextViewCompat.getCompoundDrawablesRelative((TextView)this.editText);
            TextViewCompat.setCompoundDrawablesRelative((TextView)this.editText, null, (Drawable)compounds[1], (Drawable)compounds[2], (Drawable)compounds[3]);
            this.startDummyDrawable = null;
            updatedIcon = true;
        }
        if (this.shouldUpdateEndDummyDrawable()) {
            right = this.suffixTextView.getMeasuredWidth() - this.editText.getPaddingRight();
            CheckableImageButton iconView = this.getEndIconToUpdateDummyDrawable();
            if (iconView != null) {
                right = right + iconView.getMeasuredWidth() + MarginLayoutParamsCompat.getMarginStart((ViewGroup.MarginLayoutParams)((ViewGroup.MarginLayoutParams)iconView.getLayoutParams()));
            }
            Drawable[] compounds = TextViewCompat.getCompoundDrawablesRelative((TextView)this.editText);
            if (this.endDummyDrawable != null && this.endDummyDrawableWidth != right) {
                this.endDummyDrawableWidth = right;
                this.endDummyDrawable.setBounds(0, 0, this.endDummyDrawableWidth, 1);
                TextViewCompat.setCompoundDrawablesRelative((TextView)this.editText, (Drawable)compounds[0], (Drawable)compounds[1], (Drawable)this.endDummyDrawable, (Drawable)compounds[3]);
                updatedIcon = true;
            } else {
                if (this.endDummyDrawable == null) {
                    this.endDummyDrawable = new ColorDrawable();
                    this.endDummyDrawableWidth = right;
                    this.endDummyDrawable.setBounds(0, 0, this.endDummyDrawableWidth, 1);
                }
                if (compounds[2] != this.endDummyDrawable) {
                    this.originalEditTextEndDrawable = compounds[2];
                    TextViewCompat.setCompoundDrawablesRelative((TextView)this.editText, (Drawable)compounds[0], (Drawable)compounds[1], (Drawable)this.endDummyDrawable, (Drawable)compounds[3]);
                    updatedIcon = true;
                }
            }
        } else if (this.endDummyDrawable != null) {
            Drawable[] compounds = TextViewCompat.getCompoundDrawablesRelative((TextView)this.editText);
            if (compounds[2] == this.endDummyDrawable) {
                TextViewCompat.setCompoundDrawablesRelative((TextView)this.editText, (Drawable)compounds[0], (Drawable)compounds[1], (Drawable)this.originalEditTextEndDrawable, (Drawable)compounds[3]);
                updatedIcon = true;
            }
            this.endDummyDrawable = null;
        }
        return updatedIcon;
    }

    private boolean shouldUpdateStartDummyDrawable() {
        return (this.getStartIconDrawable() != null || this.prefixText != null) && this.startLayout.getMeasuredWidth() > 0;
    }

    private boolean shouldUpdateEndDummyDrawable() {
        return (this.errorIconView.getVisibility() == 0 || this.hasEndIcon() && this.isEndIconVisible() || this.suffixText != null) && this.endLayout.getMeasuredWidth() > 0;
    }

    @Nullable
    private CheckableImageButton getEndIconToUpdateDummyDrawable() {
        if (this.errorIconView.getVisibility() == 0) {
            return this.errorIconView;
        }
        if (this.hasEndIcon() && this.isEndIconVisible()) {
            return this.endIconView;
        }
        return null;
    }

    private void applyIconTint(@NonNull CheckableImageButton iconView, boolean hasIconTintList, ColorStateList iconTintList, boolean hasIconTintMode, PorterDuff.Mode iconTintMode) {
        Drawable icon = iconView.getDrawable();
        if (icon != null && (hasIconTintList || hasIconTintMode)) {
            icon = DrawableCompat.wrap((Drawable)icon).mutate();
            if (hasIconTintList) {
                DrawableCompat.setTintList((Drawable)icon, (ColorStateList)iconTintList);
            }
            if (hasIconTintMode) {
                DrawableCompat.setTintMode((Drawable)icon, (PorterDuff.Mode)iconTintMode);
            }
        }
        if (iconView.getDrawable() != icon) {
            iconView.setImageDrawable(icon);
        }
    }

    private static void setIconOnClickListener(@NonNull CheckableImageButton iconView, @Nullable View.OnClickListener onClickListener, @Nullable View.OnLongClickListener onLongClickListener) {
        iconView.setOnClickListener(onClickListener);
        TextInputLayout.setIconClickable(iconView, onLongClickListener);
    }

    private static void setIconOnLongClickListener(@NonNull CheckableImageButton iconView, @Nullable View.OnLongClickListener onLongClickListener) {
        iconView.setOnLongClickListener(onLongClickListener);
        TextInputLayout.setIconClickable(iconView, onLongClickListener);
    }

    private static void setIconClickable(@NonNull CheckableImageButton iconView, @Nullable View.OnLongClickListener onLongClickListener) {
        boolean iconClickable = ViewCompat.hasOnClickListeners((View)iconView);
        boolean iconLongClickable = onLongClickListener != null;
        boolean iconFocusable = iconClickable || iconLongClickable;
        iconView.setFocusable(iconFocusable);
        iconView.setClickable(iconClickable);
        iconView.setPressable(iconClickable);
        iconView.setLongClickable(iconLongClickable);
        ViewCompat.setImportantForAccessibility((View)iconView, (int)(iconFocusable ? 1 : 2));
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.editText != null) {
            Rect rect = this.tmpRect;
            DescendantOffsetUtils.getDescendantRect((ViewGroup)this, (View)this.editText, rect);
            this.updateBoxUnderlineBounds(rect);
            if (this.hintEnabled) {
                this.collapsingTextHelper.setExpandedTextSize(this.editText.getTextSize());
                int editTextGravity = this.editText.getGravity();
                this.collapsingTextHelper.setCollapsedTextGravity(0x30 | editTextGravity & 0xFFFFFF8F);
                this.collapsingTextHelper.setExpandedTextGravity(editTextGravity);
                this.collapsingTextHelper.setCollapsedBounds(this.calculateCollapsedTextBounds(rect));
                this.collapsingTextHelper.setExpandedBounds(this.calculateExpandedTextBounds(rect));
                this.collapsingTextHelper.recalculate();
                if (this.cutoutEnabled() && !this.hintExpanded) {
                    this.openCutout();
                }
            }
        }
    }

    private void updateBoxUnderlineBounds(@NonNull Rect bounds) {
        if (this.boxUnderline != null) {
            int top = bounds.bottom - this.boxStrokeWidthFocusedPx;
            this.boxUnderline.setBounds(bounds.left, top, bounds.right, bounds.bottom);
        }
    }

    public void draw(@NonNull Canvas canvas) {
        super.draw(canvas);
        this.drawHint(canvas);
        this.drawBoxUnderline(canvas);
    }

    private void drawHint(@NonNull Canvas canvas) {
        if (this.hintEnabled) {
            this.collapsingTextHelper.draw(canvas);
        }
    }

    private void drawBoxUnderline(Canvas canvas) {
        if (this.boxUnderline != null) {
            Rect underlineBounds = this.boxUnderline.getBounds();
            underlineBounds.top = underlineBounds.bottom - this.boxStrokeWidthPx;
            this.boxUnderline.draw(canvas);
        }
    }

    private void collapseHint(boolean animate) {
        if (this.animator != null && this.animator.isRunning()) {
            this.animator.cancel();
        }
        if (animate && this.hintAnimationEnabled) {
            this.animateToExpansionFraction(1.0f);
        } else {
            this.collapsingTextHelper.setExpansionFraction(1.0f);
        }
        this.hintExpanded = false;
        if (this.cutoutEnabled()) {
            this.openCutout();
        }
        this.updatePlaceholderText();
        this.updatePrefixTextVisibility();
        this.updateSuffixTextVisibility();
    }

    private boolean cutoutEnabled() {
        return this.hintEnabled && !TextUtils.isEmpty((CharSequence)this.hint) && this.boxBackground instanceof CutoutDrawable;
    }

    private void openCutout() {
        if (!this.cutoutEnabled()) {
            return;
        }
        RectF cutoutBounds = this.tmpRectF;
        this.collapsingTextHelper.getCollapsedTextActualBounds(cutoutBounds, this.editText.getWidth(), this.editText.getGravity());
        this.applyCutoutPadding(cutoutBounds);
        cutoutBounds.offset((float)(-this.getPaddingLeft()), (float)(-this.getPaddingTop()));
        ((CutoutDrawable)this.boxBackground).setCutout(cutoutBounds);
    }

    private void closeCutout() {
        if (this.cutoutEnabled()) {
            ((CutoutDrawable)this.boxBackground).removeCutout();
        }
    }

    private void applyCutoutPadding(@NonNull RectF cutoutBounds) {
        cutoutBounds.left -= (float)this.boxLabelCutoutPaddingPx;
        cutoutBounds.top -= (float)this.boxLabelCutoutPaddingPx;
        cutoutBounds.right += (float)this.boxLabelCutoutPaddingPx;
        cutoutBounds.bottom += (float)this.boxLabelCutoutPaddingPx;
    }

    @VisibleForTesting
    boolean cutoutIsOpen() {
        return this.cutoutEnabled() && ((CutoutDrawable)this.boxBackground).hasCutout();
    }

    protected void drawableStateChanged() {
        if (this.inDrawableStateChanged) {
            return;
        }
        this.inDrawableStateChanged = true;
        super.drawableStateChanged();
        int[] state = this.getDrawableState();
        boolean changed = false;
        if (this.collapsingTextHelper != null) {
            changed |= this.collapsingTextHelper.setState(state);
        }
        if (this.editText != null) {
            this.updateLabelState(ViewCompat.isLaidOut((View)this) && this.isEnabled());
        }
        this.updateEditTextBackground();
        this.updateTextInputBoxState();
        if (changed) {
            this.invalidate();
        }
        this.inDrawableStateChanged = false;
    }

    void updateTextInputBoxState() {
        boolean isHovered;
        if (this.boxBackground == null || this.boxBackgroundMode == 0) {
            return;
        }
        boolean hasFocus = this.isFocused() || this.editText != null && this.editText.hasFocus();
        boolean bl = isHovered = this.isHovered() || this.editText != null && this.editText.isHovered();
        if (!this.isEnabled()) {
            this.boxStrokeColor = this.disabledColor;
        } else if (this.indicatorViewController.errorShouldBeShown()) {
            if (this.strokeErrorColor != null) {
                this.updateStrokeErrorColor(hasFocus, isHovered);
            } else {
                this.boxStrokeColor = this.indicatorViewController.getErrorViewCurrentTextColor();
            }
        } else if (this.counterOverflowed && this.counterView != null) {
            if (this.strokeErrorColor != null) {
                this.updateStrokeErrorColor(hasFocus, isHovered);
            } else {
                this.boxStrokeColor = this.counterView.getCurrentTextColor();
            }
        } else {
            this.boxStrokeColor = hasFocus ? this.focusedStrokeColor : (isHovered ? this.hoveredStrokeColor : this.defaultStrokeColor);
        }
        this.setErrorIconVisible(this.getErrorIconDrawable() != null && this.indicatorViewController.isErrorEnabled() && this.indicatorViewController.errorShouldBeShown());
        this.updateIconColorOnState(this.errorIconView, this.errorIconTintList);
        this.updateIconColorOnState(this.startIconView, this.startIconTintList);
        this.updateIconColorOnState(this.endIconView, this.endIconTintList);
        if (this.getEndIconDelegate().shouldTintIconOnError()) {
            this.tintEndIconOnError(this.indicatorViewController.errorShouldBeShown());
        }
        this.boxStrokeWidthPx = hasFocus && this.isEnabled() ? this.boxStrokeWidthFocusedPx : this.boxStrokeWidthDefaultPx;
        if (this.boxBackgroundMode == 1) {
            this.boxBackgroundColor = !this.isEnabled() ? this.disabledFilledBackgroundColor : (isHovered && !hasFocus ? this.hoveredFilledBackgroundColor : (hasFocus ? this.focusedFilledBackgroundColor : this.defaultFilledBackgroundColor));
        }
        this.applyBoxAttributes();
    }

    private void updateStrokeErrorColor(boolean hasFocus, boolean isHovered) {
        int defaultStrokeErrorColor = this.strokeErrorColor.getDefaultColor();
        int hoveredStrokeErrorColor = this.strokeErrorColor.getColorForState(new int[]{16843623, 16842910}, defaultStrokeErrorColor);
        int focusedStrokeErrorColor = this.strokeErrorColor.getColorForState(new int[]{16843518, 16842910}, defaultStrokeErrorColor);
        this.boxStrokeColor = hasFocus ? focusedStrokeErrorColor : (isHovered ? hoveredStrokeErrorColor : defaultStrokeErrorColor);
    }

    private void setErrorIconVisible(boolean errorIconVisible) {
        this.errorIconView.setVisibility(errorIconVisible ? 0 : 8);
        this.endIconFrame.setVisibility(errorIconVisible ? 8 : 0);
        this.updateSuffixTextViewPadding();
        if (!this.hasEndIcon()) {
            this.updateDummyDrawables();
        }
    }

    private boolean isErrorIconVisible() {
        return this.errorIconView.getVisibility() == 0;
    }

    private void updateIconColorOnState(CheckableImageButton iconView, ColorStateList colorStateList) {
        Drawable icon = iconView.getDrawable();
        if (iconView.getDrawable() == null || colorStateList == null || !colorStateList.isStateful()) {
            return;
        }
        int color2 = colorStateList.getColorForState(this.getDrawableState(), colorStateList.getDefaultColor());
        icon = DrawableCompat.wrap((Drawable)icon).mutate();
        DrawableCompat.setTintList((Drawable)icon, (ColorStateList)ColorStateList.valueOf((int)color2));
        iconView.setImageDrawable(icon);
    }

    private void expandHint(boolean animate) {
        if (this.animator != null && this.animator.isRunning()) {
            this.animator.cancel();
        }
        if (animate && this.hintAnimationEnabled) {
            this.animateToExpansionFraction(0.0f);
        } else {
            this.collapsingTextHelper.setExpansionFraction(0.0f);
        }
        if (this.cutoutEnabled() && ((CutoutDrawable)this.boxBackground).hasCutout()) {
            this.closeCutout();
        }
        this.hintExpanded = true;
        this.hidePlaceholderText();
        this.updatePrefixTextVisibility();
        this.updateSuffixTextVisibility();
    }

    @VisibleForTesting
    void animateToExpansionFraction(float target) {
        if (this.collapsingTextHelper.getExpansionFraction() == target) {
            return;
        }
        if (this.animator == null) {
            this.animator = new ValueAnimator();
            this.animator.setInterpolator(AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR);
            this.animator.setDuration(167L);
            this.animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(@NonNull ValueAnimator animator2) {
                    TextInputLayout.this.collapsingTextHelper.setExpansionFraction(((Float)animator2.getAnimatedValue()).floatValue());
                }
            });
        }
        this.animator.setFloatValues(new float[]{this.collapsingTextHelper.getExpansionFraction(), target});
        this.animator.start();
    }

    @VisibleForTesting
    final boolean isHintExpanded() {
        return this.hintExpanded;
    }

    @VisibleForTesting
    final boolean isHelperTextDisplayed() {
        return this.indicatorViewController.helperTextIsDisplayed();
    }

    @VisibleForTesting
    final int getHintCurrentCollapsedTextColor() {
        return this.collapsingTextHelper.getCurrentCollapsedTextColor();
    }

    @VisibleForTesting
    final float getHintCollapsedTextHeight() {
        return this.collapsingTextHelper.getCollapsedTextHeight();
    }

    @VisibleForTesting
    final int getErrorTextCurrentColor() {
        return this.indicatorViewController.getErrorViewCurrentTextColor();
    }

    public static class AccessibilityDelegate
    extends AccessibilityDelegateCompat {
        private final TextInputLayout layout;

        public AccessibilityDelegate(@NonNull TextInputLayout layout2) {
            this.layout = layout2;
        }

        public void onInitializeAccessibilityNodeInfo(@NonNull View host, @NonNull AccessibilityNodeInfoCompat info) {
            super.onInitializeAccessibilityNodeInfo(host, info);
            EditText editText = this.layout.getEditText();
            Editable inputText = editText != null ? editText.getText() : null;
            CharSequence hintText = this.layout.getHint();
            CharSequence helperText = this.layout.getHelperText();
            CharSequence errorText = this.layout.getError();
            int maxCharLimit = this.layout.getCounterMaxLength();
            CharSequence counterOverflowDesc = this.layout.getCounterOverflowDescription();
            boolean showingText = !TextUtils.isEmpty((CharSequence)inputText);
            boolean hasHint = !TextUtils.isEmpty((CharSequence)hintText);
            boolean hasHelperText = !TextUtils.isEmpty((CharSequence)helperText);
            boolean showingError = !TextUtils.isEmpty((CharSequence)errorText);
            boolean contentInvalid = showingError || !TextUtils.isEmpty((CharSequence)counterOverflowDesc);
            String hint = hasHint ? hintText.toString() : "";
            hint = hint + ((showingError || hasHelperText) && !TextUtils.isEmpty((CharSequence)hint) ? ", " : "");
            hint = hint + (showingError ? errorText : (hasHelperText ? helperText : ""));
            if (showingText) {
                info.setText((CharSequence)inputText);
            } else if (!TextUtils.isEmpty((CharSequence)hint)) {
                info.setText((CharSequence)hint);
            }
            if (!TextUtils.isEmpty((CharSequence)hint)) {
                if (Build.VERSION.SDK_INT >= 26) {
                    info.setHintText((CharSequence)hint);
                } else {
                    String text = showingText ? inputText + ", " + hint : hint;
                    info.setText((CharSequence)text);
                }
                info.setShowingHintText(!showingText);
            }
            info.setMaxTextLength(inputText != null && inputText.length() == maxCharLimit ? maxCharLimit : -1);
            if (contentInvalid) {
                info.setError(showingError ? errorText : counterOverflowDesc);
            }
        }
    }

    static class SavedState
    extends AbsSavedState {
        @Nullable
        CharSequence error;
        boolean isEndIconChecked;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.ClassLoaderCreator<SavedState>(){

            @NonNull
            public SavedState createFromParcel(@NonNull Parcel in, ClassLoader loader) {
                return new SavedState(in, loader);
            }

            @Nullable
            public SavedState createFromParcel(@NonNull Parcel in) {
                return new SavedState(in, null);
            }

            @NonNull
            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        SavedState(@NonNull Parcel source, ClassLoader loader) {
            super(source, loader);
            this.error = (CharSequence)TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(source);
            this.isEndIconChecked = source.readInt() == 1;
        }

        public void writeToParcel(@NonNull Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            TextUtils.writeToParcel((CharSequence)this.error, (Parcel)dest, (int)flags);
            dest.writeInt(this.isEndIconChecked ? 1 : 0);
        }

        @NonNull
        public String toString() {
            return "TextInputLayout.SavedState{" + Integer.toHexString(System.identityHashCode((Object)this)) + " error=" + this.error + "}";
        }
    }

    public static interface OnEndIconChangedListener {
        public void onEndIconChanged(@NonNull TextInputLayout var1, int var2);
    }

    public static interface OnEditTextAttachedListener {
        public void onEditTextAttached(@NonNull TextInputLayout var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface EndIconMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BoxBackgroundMode {
    }
}

