/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.transition;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.material.transition.VisibilityAnimatorProvider;

public final class ScaleProvider
implements VisibilityAnimatorProvider {
    private float outgoingStartScale = 1.0f;
    private float outgoingEndScale = 1.1f;
    private float incomingStartScale = 0.8f;
    private float incomingEndScale = 1.0f;
    private boolean growing;
    private boolean scaleOnDisappear = true;

    public ScaleProvider() {
        this(true);
    }

    public ScaleProvider(boolean growing) {
        this.growing = growing;
    }

    public boolean isGrowing() {
        return this.growing;
    }

    public void setGrowing(boolean growing) {
        this.growing = growing;
    }

    public boolean isScaleOnDisappear() {
        return this.scaleOnDisappear;
    }

    public void setScaleOnDisappear(boolean scaleOnDisappear) {
        this.scaleOnDisappear = scaleOnDisappear;
    }

    public float getOutgoingStartScale() {
        return this.outgoingStartScale;
    }

    public void setOutgoingStartScale(float outgoingStartScale) {
        this.outgoingStartScale = outgoingStartScale;
    }

    public float getOutgoingEndScale() {
        return this.outgoingEndScale;
    }

    public void setOutgoingEndScale(float outgoingEndScale) {
        this.outgoingEndScale = outgoingEndScale;
    }

    public float getIncomingStartScale() {
        return this.incomingStartScale;
    }

    public void setIncomingStartScale(float incomingStartScale) {
        this.incomingStartScale = incomingStartScale;
    }

    public float getIncomingEndScale() {
        return this.incomingEndScale;
    }

    public void setIncomingEndScale(float incomingEndScale) {
        this.incomingEndScale = incomingEndScale;
    }

    @Override
    @Nullable
    public Animator createAppear(@NonNull ViewGroup sceneRoot, @NonNull View view) {
        if (this.growing) {
            return ScaleProvider.createScaleAnimator(view, this.incomingStartScale, this.incomingEndScale);
        }
        return ScaleProvider.createScaleAnimator(view, this.outgoingEndScale, this.outgoingStartScale);
    }

    @Override
    @Nullable
    public Animator createDisappear(@NonNull ViewGroup sceneRoot, @NonNull View view) {
        if (!this.scaleOnDisappear) {
            return null;
        }
        if (this.growing) {
            return ScaleProvider.createScaleAnimator(view, this.outgoingStartScale, this.outgoingEndScale);
        }
        return ScaleProvider.createScaleAnimator(view, this.incomingEndScale, this.incomingStartScale);
    }

    private static Animator createScaleAnimator(View view, float startScale, float endScale) {
        return ObjectAnimator.ofPropertyValuesHolder((Object)view, (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((Property)View.SCALE_X, (float[])new float[]{startScale, endScale}), PropertyValuesHolder.ofFloat((Property)View.SCALE_Y, (float[])new float[]{startScale, endScale})});
    }
}

