/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.transition;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.content.Context;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.annotation.RestrictTo;
import androidx.core.view.ViewCompat;
import com.google.android.material.R;
import com.google.android.material.transition.VisibilityAnimatorProvider;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class SlideDistanceProvider
implements VisibilityAnimatorProvider {
    private static final int DEFAULT_DISTANCE = -1;
    private int slideEdge;
    @Px
    private int slideDistance = -1;

    public SlideDistanceProvider(int slideEdge) {
        this.slideEdge = slideEdge;
    }

    public int getSlideEdge() {
        return this.slideEdge;
    }

    public void setSlideEdge(int slideEdge) {
        this.slideEdge = slideEdge;
    }

    @Px
    public int getSlideDistance() {
        return this.slideDistance;
    }

    public void setSlideDistance(@Px int slideDistance) {
        if (slideDistance < 0) {
            throw new IllegalArgumentException("Slide distance must be positive. If attempting to reverse the direction of the slide, use setSlideEdge(int) instead.");
        }
        this.slideDistance = slideDistance;
    }

    @Override
    @Nullable
    public Animator createAppear(@NonNull ViewGroup sceneRoot, @NonNull View view) {
        return SlideDistanceProvider.createTranslationAppearAnimator((View)sceneRoot, view, this.slideEdge, this.getSlideDistanceOrDefault(view.getContext()));
    }

    @Override
    @Nullable
    public Animator createDisappear(@NonNull ViewGroup sceneRoot, @NonNull View view) {
        return SlideDistanceProvider.createTranslationDisappearAnimator((View)sceneRoot, view, this.slideEdge, this.getSlideDistanceOrDefault(view.getContext()));
    }

    private int getSlideDistanceOrDefault(Context context) {
        if (this.slideDistance != -1) {
            return this.slideDistance;
        }
        return context.getResources().getDimensionPixelSize(R.dimen.mtrl_transition_shared_axis_slide_distance);
    }

    private static Animator createTranslationAppearAnimator(View sceneRoot, View view, int slideEdge, @Px int slideDistance) {
        switch (slideEdge) {
            case 3: {
                return SlideDistanceProvider.createTranslationXAnimator(view, slideDistance, 0.0f);
            }
            case 48: {
                return SlideDistanceProvider.createTranslationYAnimator(view, -slideDistance, 0.0f);
            }
            case 5: {
                return SlideDistanceProvider.createTranslationXAnimator(view, -slideDistance, 0.0f);
            }
            case 80: {
                return SlideDistanceProvider.createTranslationYAnimator(view, slideDistance, 0.0f);
            }
            case 0x800003: {
                return SlideDistanceProvider.createTranslationXAnimator(view, SlideDistanceProvider.isRtl(sceneRoot) ? (float)slideDistance : (float)(-slideDistance), 0.0f);
            }
            case 0x800005: {
                return SlideDistanceProvider.createTranslationXAnimator(view, SlideDistanceProvider.isRtl(sceneRoot) ? (float)(-slideDistance) : (float)slideDistance, 0.0f);
            }
        }
        throw new IllegalArgumentException("Invalid slide direction: " + slideEdge);
    }

    private static Animator createTranslationDisappearAnimator(View sceneRoot, View view, int slideEdge, @Px int slideDistance) {
        switch (slideEdge) {
            case 3: {
                return SlideDistanceProvider.createTranslationXAnimator(view, 0.0f, -slideDistance);
            }
            case 48: {
                return SlideDistanceProvider.createTranslationYAnimator(view, 0.0f, slideDistance);
            }
            case 5: {
                return SlideDistanceProvider.createTranslationXAnimator(view, 0.0f, slideDistance);
            }
            case 80: {
                return SlideDistanceProvider.createTranslationYAnimator(view, 0.0f, -slideDistance);
            }
            case 0x800003: {
                return SlideDistanceProvider.createTranslationXAnimator(view, 0.0f, SlideDistanceProvider.isRtl(sceneRoot) ? (float)(-slideDistance) : (float)slideDistance);
            }
            case 0x800005: {
                return SlideDistanceProvider.createTranslationXAnimator(view, 0.0f, SlideDistanceProvider.isRtl(sceneRoot) ? (float)slideDistance : (float)(-slideDistance));
            }
        }
        throw new IllegalArgumentException("Invalid slide direction: " + slideEdge);
    }

    private static Animator createTranslationXAnimator(View view, float startTranslation, float endTranslation) {
        return ObjectAnimator.ofPropertyValuesHolder((Object)view, (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((Property)View.TRANSLATION_X, (float[])new float[]{startTranslation, endTranslation})});
    }

    private static Animator createTranslationYAnimator(View view, float startTranslation, float endTranslation) {
        return ObjectAnimator.ofPropertyValuesHolder((Object)view, (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((Property)View.TRANSLATION_Y, (float[])new float[]{startTranslation, endTranslation})});
    }

    private static boolean isRtl(View view) {
        return ViewCompat.getLayoutDirection((View)view) == 1;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface GravityFlag {
    }
}

