/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.transition.platform;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.transition.TransitionValues;
import android.transition.Visibility;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.animation.AnimatorSetCompat;
import com.google.android.material.transition.platform.VisibilityAnimatorProvider;
import java.util.ArrayList;

@RequiresApi(value=21)
abstract class MaterialVisibility<P extends VisibilityAnimatorProvider>
extends Visibility {
    private final P primaryAnimatorProvider;
    @Nullable
    private VisibilityAnimatorProvider secondaryAnimatorProvider;

    protected MaterialVisibility(P primaryAnimatorProvider, @Nullable VisibilityAnimatorProvider secondaryAnimatorProvider) {
        this.primaryAnimatorProvider = primaryAnimatorProvider;
        this.secondaryAnimatorProvider = secondaryAnimatorProvider;
        this.setInterpolator(AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR);
    }

    @NonNull
    public P getPrimaryAnimatorProvider() {
        return this.primaryAnimatorProvider;
    }

    @Nullable
    public VisibilityAnimatorProvider getSecondaryAnimatorProvider() {
        return this.secondaryAnimatorProvider;
    }

    public void setSecondaryAnimatorProvider(@Nullable VisibilityAnimatorProvider secondaryAnimatorProvider) {
        this.secondaryAnimatorProvider = secondaryAnimatorProvider;
    }

    public Animator onAppear(ViewGroup sceneRoot, View view, TransitionValues startValues, TransitionValues endValues) {
        return this.createAnimator(sceneRoot, view, true);
    }

    public Animator onDisappear(ViewGroup sceneRoot, View view, TransitionValues startValues, TransitionValues endValues) {
        return this.createAnimator(sceneRoot, view, false);
    }

    private Animator createAnimator(ViewGroup sceneRoot, View view, boolean appearing) {
        Animator primaryAnimator;
        AnimatorSet set = new AnimatorSet();
        ArrayList<Animator> animators = new ArrayList<Animator>();
        Animator animator2 = primaryAnimator = appearing ? this.primaryAnimatorProvider.createAppear(sceneRoot, view) : this.primaryAnimatorProvider.createDisappear(sceneRoot, view);
        if (primaryAnimator != null) {
            animators.add(primaryAnimator);
        }
        if (this.secondaryAnimatorProvider != null) {
            Animator secondaryAnimator;
            Animator animator3 = secondaryAnimator = appearing ? this.secondaryAnimatorProvider.createAppear(sceneRoot, view) : this.secondaryAnimatorProvider.createDisappear(sceneRoot, view);
            if (secondaryAnimator != null) {
                animators.add(secondaryAnimator);
            }
        }
        AnimatorSetCompat.playTogether(set, animators);
        return set;
    }
}

