/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media;

import android.annotation.SuppressLint;
import android.media.Rating;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.RestrictTo;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@SuppressLint(value={"BanParcelableUsage"})
public final class RatingCompat
implements Parcelable {
    private static final String TAG = "Rating";
    public static final int RATING_NONE = 0;
    public static final int RATING_HEART = 1;
    public static final int RATING_THUMB_UP_DOWN = 2;
    public static final int RATING_3_STARS = 3;
    public static final int RATING_4_STARS = 4;
    public static final int RATING_5_STARS = 5;
    public static final int RATING_PERCENTAGE = 6;
    private static final float RATING_NOT_RATED = -1.0f;
    private final int mRatingStyle;
    private final float mRatingValue;
    private Object mRatingObj;
    public static final Parcelable.Creator<RatingCompat> CREATOR = new Parcelable.Creator<RatingCompat>(){

        public RatingCompat createFromParcel(Parcel p) {
            return new RatingCompat(p.readInt(), p.readFloat());
        }

        public RatingCompat[] newArray(int size) {
            return new RatingCompat[size];
        }
    };

    RatingCompat(int ratingStyle, float rating) {
        this.mRatingStyle = ratingStyle;
        this.mRatingValue = rating;
    }

    public String toString() {
        return "Rating:style=" + this.mRatingStyle + " rating=" + (this.mRatingValue < 0.0f ? "unrated" : String.valueOf(this.mRatingValue));
    }

    public int describeContents() {
        return this.mRatingStyle;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mRatingStyle);
        dest.writeFloat(this.mRatingValue);
    }

    public static RatingCompat newUnratedRating(int ratingStyle) {
        switch (ratingStyle) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return new RatingCompat(ratingStyle, -1.0f);
            }
        }
        return null;
    }

    public static RatingCompat newHeartRating(boolean hasHeart) {
        return new RatingCompat(1, hasHeart ? 1.0f : 0.0f);
    }

    public static RatingCompat newThumbRating(boolean thumbIsUp) {
        return new RatingCompat(2, thumbIsUp ? 1.0f : 0.0f);
    }

    public static RatingCompat newStarRating(int starRatingStyle, float starRating) {
        float maxRating = -1.0f;
        switch (starRatingStyle) {
            case 3: {
                maxRating = 3.0f;
                break;
            }
            case 4: {
                maxRating = 4.0f;
                break;
            }
            case 5: {
                maxRating = 5.0f;
                break;
            }
            default: {
                Log.e((String)TAG, (String)("Invalid rating style (" + starRatingStyle + ") for a star rating"));
                return null;
            }
        }
        if (starRating < 0.0f || starRating > maxRating) {
            Log.e((String)TAG, (String)"Trying to set out of range star-based rating");
            return null;
        }
        return new RatingCompat(starRatingStyle, starRating);
    }

    public static RatingCompat newPercentageRating(float percent) {
        if (percent < 0.0f || percent > 100.0f) {
            Log.e((String)TAG, (String)"Invalid percentage-based rating value");
            return null;
        }
        return new RatingCompat(6, percent);
    }

    public boolean isRated() {
        return this.mRatingValue >= 0.0f;
    }

    public int getRatingStyle() {
        return this.mRatingStyle;
    }

    public boolean hasHeart() {
        if (this.mRatingStyle != 1) {
            return false;
        }
        return this.mRatingValue == 1.0f;
    }

    public boolean isThumbUp() {
        if (this.mRatingStyle != 2) {
            return false;
        }
        return this.mRatingValue == 1.0f;
    }

    public float getStarRating() {
        switch (this.mRatingStyle) {
            case 3: 
            case 4: 
            case 5: {
                if (!this.isRated()) break;
                return this.mRatingValue;
            }
        }
        return -1.0f;
    }

    public float getPercentRating() {
        if (this.mRatingStyle != 6 || !this.isRated()) {
            return -1.0f;
        }
        return this.mRatingValue;
    }

    public static RatingCompat fromRating(Object ratingObj) {
        block6: {
            RatingCompat rating;
            block8: {
                int ratingStyle;
                block7: {
                    if (ratingObj == null || Build.VERSION.SDK_INT < 19) break block6;
                    ratingStyle = ((Rating)ratingObj).getRatingStyle();
                    if (!((Rating)ratingObj).isRated()) break block7;
                    switch (ratingStyle) {
                        case 1: {
                            rating = RatingCompat.newHeartRating(((Rating)ratingObj).hasHeart());
                            break block8;
                        }
                        case 2: {
                            rating = RatingCompat.newThumbRating(((Rating)ratingObj).isThumbUp());
                            break block8;
                        }
                        case 3: 
                        case 4: 
                        case 5: {
                            rating = RatingCompat.newStarRating(ratingStyle, ((Rating)ratingObj).getStarRating());
                            break block8;
                        }
                        case 6: {
                            rating = RatingCompat.newPercentageRating(((Rating)ratingObj).getPercentRating());
                            break block8;
                        }
                        default: {
                            return null;
                        }
                    }
                }
                rating = RatingCompat.newUnratedRating(ratingStyle);
            }
            rating.mRatingObj = ratingObj;
            return rating;
        }
        return null;
    }

    public Object getRating() {
        block6: {
            block7: {
                if (this.mRatingObj != null || Build.VERSION.SDK_INT < 19) break block6;
                if (!this.isRated()) break block7;
                switch (this.mRatingStyle) {
                    case 1: {
                        this.mRatingObj = Rating.newHeartRating((boolean)this.hasHeart());
                        break block6;
                    }
                    case 2: {
                        this.mRatingObj = Rating.newThumbRating((boolean)this.isThumbUp());
                        break block6;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        this.mRatingObj = Rating.newStarRating((int)this.mRatingStyle, (float)this.getStarRating());
                        break block6;
                    }
                    case 6: {
                        this.mRatingObj = Rating.newPercentageRating((float)this.getPercentRating());
                        break block6;
                    }
                    default: {
                        return null;
                    }
                }
            }
            this.mRatingObj = Rating.newUnratedRating((int)this.mRatingStyle);
        }
        return this.mRatingObj;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static @interface StarStyle {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static @interface Style {
    }
}

