/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media.session;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.media.MediaMetadata;
import android.media.Rating;
import android.media.session.MediaController;
import android.media.session.MediaSession;
import android.media.session.PlaybackState;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.support.v4.media.MediaDescriptionCompat;
import android.support.v4.media.MediaMetadataCompat;
import android.support.v4.media.RatingCompat;
import android.support.v4.media.session.IMediaControllerCallback;
import android.support.v4.media.session.IMediaSession;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v4.media.session.ParcelableVolumeInfo;
import android.support.v4.media.session.PlaybackStateCompat;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.core.app.BundleCompat;
import androidx.media.AudioAttributesCompat;
import androidx.media.R;
import androidx.versionedparcelable.ParcelUtils;
import androidx.versionedparcelable.VersionedParcelable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public final class MediaControllerCompat {
    static final String TAG = "MediaControllerCompat";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final String COMMAND_GET_EXTRA_BINDER = "android.support.v4.media.session.command.GET_EXTRA_BINDER";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final String COMMAND_ADD_QUEUE_ITEM = "android.support.v4.media.session.command.ADD_QUEUE_ITEM";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final String COMMAND_ADD_QUEUE_ITEM_AT = "android.support.v4.media.session.command.ADD_QUEUE_ITEM_AT";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final String COMMAND_REMOVE_QUEUE_ITEM = "android.support.v4.media.session.command.REMOVE_QUEUE_ITEM";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final String COMMAND_REMOVE_QUEUE_ITEM_AT = "android.support.v4.media.session.command.REMOVE_QUEUE_ITEM_AT";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final String COMMAND_ARGUMENT_MEDIA_DESCRIPTION = "android.support.v4.media.session.command.ARGUMENT_MEDIA_DESCRIPTION";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final String COMMAND_ARGUMENT_INDEX = "android.support.v4.media.session.command.ARGUMENT_INDEX";
    private final MediaControllerImpl mImpl;
    private final MediaSessionCompat.Token mToken;
    private final ConcurrentHashMap<Callback, Boolean> mRegisteredCallbacks = new ConcurrentHashMap();

    public static void setMediaController(@NonNull Activity activity, MediaControllerCompat mediaController) {
        activity.getWindow().getDecorView().setTag(R.id.media_controller_compat_view_tag, (Object)mediaController);
        if (Build.VERSION.SDK_INT >= 21) {
            MediaController controllerFwk = null;
            if (mediaController != null) {
                Object sessionTokenObj = mediaController.getSessionToken().getToken();
                controllerFwk = new MediaController((Context)activity, (MediaSession.Token)sessionTokenObj);
            }
            activity.setMediaController(controllerFwk);
        }
    }

    public static MediaControllerCompat getMediaController(@NonNull Activity activity) {
        Object tag = activity.getWindow().getDecorView().getTag(R.id.media_controller_compat_view_tag);
        if (tag instanceof MediaControllerCompat) {
            return (MediaControllerCompat)tag;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            MediaController controllerFwk = activity.getMediaController();
            if (controllerFwk == null) {
                return null;
            }
            MediaSession.Token sessionTokenFwk = controllerFwk.getSessionToken();
            return new MediaControllerCompat((Context)activity, MediaSessionCompat.Token.fromToken(sessionTokenFwk));
        }
        return null;
    }

    static void validateCustomAction(String action, Bundle args) {
        if (action == null) {
            return;
        }
        switch (action) {
            case "android.support.v4.media.session.action.FOLLOW": 
            case "android.support.v4.media.session.action.UNFOLLOW": {
                if (args != null && args.containsKey("android.support.v4.media.session.ARGUMENT_MEDIA_ATTRIBUTE")) break;
                throw new IllegalArgumentException("An extra field android.support.v4.media.session.ARGUMENT_MEDIA_ATTRIBUTE is required for this action " + action + ".");
            }
        }
    }

    public MediaControllerCompat(Context context, @NonNull MediaSessionCompat session) {
        if (session == null) {
            throw new IllegalArgumentException("session must not be null");
        }
        this.mToken = session.getSessionToken();
        this.mImpl = Build.VERSION.SDK_INT >= 21 ? new MediaControllerImplApi21(context, this.mToken) : new MediaControllerImplBase(this.mToken);
    }

    public MediaControllerCompat(Context context, @NonNull MediaSessionCompat.Token sessionToken) {
        if (sessionToken == null) {
            throw new IllegalArgumentException("sessionToken must not be null");
        }
        this.mToken = sessionToken;
        this.mImpl = Build.VERSION.SDK_INT >= 21 ? new MediaControllerImplApi21(context, sessionToken) : new MediaControllerImplBase(sessionToken);
    }

    public TransportControls getTransportControls() {
        return this.mImpl.getTransportControls();
    }

    public boolean dispatchMediaButtonEvent(KeyEvent keyEvent) {
        if (keyEvent == null) {
            throw new IllegalArgumentException("KeyEvent may not be null");
        }
        return this.mImpl.dispatchMediaButtonEvent(keyEvent);
    }

    public PlaybackStateCompat getPlaybackState() {
        return this.mImpl.getPlaybackState();
    }

    public MediaMetadataCompat getMetadata() {
        return this.mImpl.getMetadata();
    }

    public List<MediaSessionCompat.QueueItem> getQueue() {
        return this.mImpl.getQueue();
    }

    public void addQueueItem(MediaDescriptionCompat description) {
        this.mImpl.addQueueItem(description);
    }

    public void addQueueItem(MediaDescriptionCompat description, int index) {
        this.mImpl.addQueueItem(description, index);
    }

    public void removeQueueItem(MediaDescriptionCompat description) {
        this.mImpl.removeQueueItem(description);
    }

    @Deprecated
    public void removeQueueItemAt(int index) {
        MediaSessionCompat.QueueItem item;
        List<MediaSessionCompat.QueueItem> queue = this.getQueue();
        if (queue != null && index >= 0 && index < queue.size() && (item = queue.get(index)) != null) {
            this.removeQueueItem(item.getDescription());
        }
    }

    public CharSequence getQueueTitle() {
        return this.mImpl.getQueueTitle();
    }

    public Bundle getExtras() {
        return this.mImpl.getExtras();
    }

    public int getRatingType() {
        return this.mImpl.getRatingType();
    }

    public boolean isCaptioningEnabled() {
        return this.mImpl.isCaptioningEnabled();
    }

    public int getRepeatMode() {
        return this.mImpl.getRepeatMode();
    }

    public int getShuffleMode() {
        return this.mImpl.getShuffleMode();
    }

    public long getFlags() {
        return this.mImpl.getFlags();
    }

    public PlaybackInfo getPlaybackInfo() {
        return this.mImpl.getPlaybackInfo();
    }

    public PendingIntent getSessionActivity() {
        return this.mImpl.getSessionActivity();
    }

    public MediaSessionCompat.Token getSessionToken() {
        return this.mToken;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @Nullable
    public VersionedParcelable getSession2Token() {
        return this.mToken.getSession2Token();
    }

    public void setVolumeTo(int value, int flags) {
        this.mImpl.setVolumeTo(value, flags);
    }

    public void adjustVolume(int direction, int flags) {
        this.mImpl.adjustVolume(direction, flags);
    }

    public void registerCallback(@NonNull Callback callback) {
        this.registerCallback(callback, null);
    }

    public void registerCallback(@NonNull Callback callback, Handler handler) {
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        if (this.mRegisteredCallbacks.putIfAbsent(callback, true) != null) {
            Log.w((String)TAG, (String)"the callback has already been registered");
            return;
        }
        if (handler == null) {
            handler = new Handler();
        }
        callback.setHandler(handler);
        this.mImpl.registerCallback(callback, handler);
    }

    public void unregisterCallback(@NonNull Callback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        if (this.mRegisteredCallbacks.remove(callback) == null) {
            Log.w((String)TAG, (String)"the callback has never been registered");
            return;
        }
        try {
            this.mImpl.unregisterCallback(callback);
        }
        finally {
            callback.setHandler(null);
        }
    }

    public void sendCommand(@NonNull String command, @Nullable Bundle params, @Nullable ResultReceiver cb) {
        if (TextUtils.isEmpty((CharSequence)command)) {
            throw new IllegalArgumentException("command must neither be null nor empty");
        }
        this.mImpl.sendCommand(command, params, cb);
    }

    public boolean isSessionReady() {
        return this.mImpl.isSessionReady();
    }

    public String getPackageName() {
        return this.mImpl.getPackageName();
    }

    @NonNull
    public Bundle getSessionInfo() {
        return this.mImpl.getSessionInfo();
    }

    public Object getMediaController() {
        return this.mImpl.getMediaController();
    }

    @RequiresApi(value=21)
    static class TransportControlsApi21
    extends TransportControls {
        protected final MediaController.TransportControls mControlsFwk;

        TransportControlsApi21(MediaController.TransportControls controlsFwk) {
            this.mControlsFwk = controlsFwk;
        }

        @Override
        public void prepare() {
            if (Build.VERSION.SDK_INT >= 24) {
                this.mControlsFwk.prepare();
                return;
            }
            this.sendCustomAction("android.support.v4.media.session.action.PREPARE", null);
        }

        @Override
        public void prepareFromMediaId(String mediaId, Bundle extras) {
            if (Build.VERSION.SDK_INT >= 24) {
                this.mControlsFwk.prepareFromMediaId(mediaId, extras);
                return;
            }
            Bundle bundle = new Bundle();
            bundle.putString("android.support.v4.media.session.action.ARGUMENT_MEDIA_ID", mediaId);
            bundle.putBundle("android.support.v4.media.session.action.ARGUMENT_EXTRAS", extras);
            this.sendCustomAction("android.support.v4.media.session.action.PREPARE_FROM_MEDIA_ID", bundle);
        }

        @Override
        public void prepareFromSearch(String query, Bundle extras) {
            if (Build.VERSION.SDK_INT >= 24) {
                this.mControlsFwk.prepareFromSearch(query, extras);
                return;
            }
            Bundle bundle = new Bundle();
            bundle.putString("android.support.v4.media.session.action.ARGUMENT_QUERY", query);
            bundle.putBundle("android.support.v4.media.session.action.ARGUMENT_EXTRAS", extras);
            this.sendCustomAction("android.support.v4.media.session.action.PREPARE_FROM_SEARCH", bundle);
        }

        @Override
        public void prepareFromUri(Uri uri, Bundle extras) {
            if (Build.VERSION.SDK_INT >= 24) {
                this.mControlsFwk.prepareFromUri(uri, extras);
                return;
            }
            Bundle bundle = new Bundle();
            bundle.putParcelable("android.support.v4.media.session.action.ARGUMENT_URI", (Parcelable)uri);
            bundle.putBundle("android.support.v4.media.session.action.ARGUMENT_EXTRAS", extras);
            this.sendCustomAction("android.support.v4.media.session.action.PREPARE_FROM_URI", bundle);
        }

        @Override
        public void play() {
            this.mControlsFwk.play();
        }

        @Override
        public void pause() {
            this.mControlsFwk.pause();
        }

        @Override
        public void stop() {
            this.mControlsFwk.stop();
        }

        @Override
        public void seekTo(long pos) {
            this.mControlsFwk.seekTo(pos);
        }

        @Override
        public void fastForward() {
            this.mControlsFwk.fastForward();
        }

        @Override
        public void rewind() {
            this.mControlsFwk.rewind();
        }

        @Override
        public void skipToNext() {
            this.mControlsFwk.skipToNext();
        }

        @Override
        public void skipToPrevious() {
            this.mControlsFwk.skipToPrevious();
        }

        @Override
        public void setRating(RatingCompat rating) {
            this.mControlsFwk.setRating(rating != null ? (Rating)rating.getRating() : null);
        }

        @Override
        public void setRating(RatingCompat rating, Bundle extras) {
            Bundle bundle = new Bundle();
            bundle.putParcelable("android.support.v4.media.session.action.ARGUMENT_RATING", (Parcelable)rating);
            bundle.putBundle("android.support.v4.media.session.action.ARGUMENT_EXTRAS", extras);
            this.sendCustomAction("android.support.v4.media.session.action.SET_RATING", bundle);
        }

        @Override
        public void setPlaybackSpeed(float speed) {
            if (speed == 0.0f) {
                throw new IllegalArgumentException("speed must not be zero");
            }
            if (Build.VERSION.SDK_INT >= 29) {
                this.mControlsFwk.setPlaybackSpeed(speed);
                return;
            }
            Bundle bundle = new Bundle();
            bundle.putFloat("android.support.v4.media.session.action.ARGUMENT_PLAYBACK_SPEED", speed);
            this.sendCustomAction("android.support.v4.media.session.action.SET_PLAYBACK_SPEED", bundle);
        }

        @Override
        public void setCaptioningEnabled(boolean enabled) {
            Bundle bundle = new Bundle();
            bundle.putBoolean("android.support.v4.media.session.action.ARGUMENT_CAPTIONING_ENABLED", enabled);
            this.sendCustomAction("android.support.v4.media.session.action.SET_CAPTIONING_ENABLED", bundle);
        }

        @Override
        public void setRepeatMode(int repeatMode) {
            Bundle bundle = new Bundle();
            bundle.putInt("android.support.v4.media.session.action.ARGUMENT_REPEAT_MODE", repeatMode);
            this.sendCustomAction("android.support.v4.media.session.action.SET_REPEAT_MODE", bundle);
        }

        @Override
        public void setShuffleMode(int shuffleMode) {
            Bundle bundle = new Bundle();
            bundle.putInt("android.support.v4.media.session.action.ARGUMENT_SHUFFLE_MODE", shuffleMode);
            this.sendCustomAction("android.support.v4.media.session.action.SET_SHUFFLE_MODE", bundle);
        }

        @Override
        public void playFromMediaId(String mediaId, Bundle extras) {
            this.mControlsFwk.playFromMediaId(mediaId, extras);
        }

        @Override
        public void playFromSearch(String query, Bundle extras) {
            this.mControlsFwk.playFromSearch(query, extras);
        }

        @Override
        public void playFromUri(Uri uri, Bundle extras) {
            if (Build.VERSION.SDK_INT >= 23) {
                this.mControlsFwk.playFromUri(uri, extras);
                return;
            }
            if (uri == null || Uri.EMPTY.equals((Object)uri)) {
                throw new IllegalArgumentException("You must specify a non-empty Uri for playFromUri.");
            }
            Bundle bundle = new Bundle();
            bundle.putParcelable("android.support.v4.media.session.action.ARGUMENT_URI", (Parcelable)uri);
            bundle.putBundle("android.support.v4.media.session.action.ARGUMENT_EXTRAS", extras);
            this.sendCustomAction("android.support.v4.media.session.action.PLAY_FROM_URI", bundle);
        }

        @Override
        public void skipToQueueItem(long id2) {
            this.mControlsFwk.skipToQueueItem(id2);
        }

        @Override
        public void sendCustomAction(PlaybackStateCompat.CustomAction customAction, Bundle args) {
            MediaControllerCompat.validateCustomAction(customAction.getAction(), args);
            this.mControlsFwk.sendCustomAction(customAction.getAction(), args);
        }

        @Override
        public void sendCustomAction(String action, Bundle args) {
            MediaControllerCompat.validateCustomAction(action, args);
            this.mControlsFwk.sendCustomAction(action, args);
        }
    }

    @RequiresApi(value=21)
    static class MediaControllerImplApi21
    implements MediaControllerImpl {
        protected final MediaController mControllerFwk;
        final Object mLock = new Object();
        @GuardedBy(value="mLock")
        private final List<Callback> mPendingCallbacks = new ArrayList<Callback>();
        private HashMap<Callback, ExtraCallback> mCallbackMap = new HashMap();
        private Bundle mSessionInfo;
        final MediaSessionCompat.Token mSessionToken;

        MediaControllerImplApi21(Context context, MediaSessionCompat.Token sessionToken) {
            this.mSessionToken = sessionToken;
            this.mControllerFwk = new MediaController(context, (MediaSession.Token)this.mSessionToken.getToken());
            if (this.mSessionToken.getExtraBinder() == null) {
                this.requestExtraBinder();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void registerCallback(Callback callback, Handler handler) {
            this.mControllerFwk.registerCallback(callback.mCallbackFwk, handler);
            Object object = this.mLock;
            synchronized (object) {
                if (this.mSessionToken.getExtraBinder() != null) {
                    ExtraCallback extraCallback = new ExtraCallback(callback);
                    this.mCallbackMap.put(callback, extraCallback);
                    callback.mIControllerCallback = extraCallback;
                    try {
                        this.mSessionToken.getExtraBinder().registerCallbackListener(extraCallback);
                        callback.postToHandler(13, null, null);
                    }
                    catch (RemoteException e) {
                        Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in registerCallback.", (Throwable)e);
                    }
                } else {
                    callback.mIControllerCallback = null;
                    this.mPendingCallbacks.add(callback);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void unregisterCallback(Callback callback) {
            this.mControllerFwk.unregisterCallback(callback.mCallbackFwk);
            Object object = this.mLock;
            synchronized (object) {
                if (this.mSessionToken.getExtraBinder() != null) {
                    try {
                        ExtraCallback extraCallback = this.mCallbackMap.remove(callback);
                        if (extraCallback != null) {
                            callback.mIControllerCallback = null;
                            this.mSessionToken.getExtraBinder().unregisterCallbackListener(extraCallback);
                        }
                    }
                    catch (RemoteException e) {
                        Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in unregisterCallback.", (Throwable)e);
                    }
                } else {
                    this.mPendingCallbacks.remove(callback);
                }
            }
        }

        @Override
        public boolean dispatchMediaButtonEvent(KeyEvent event) {
            return this.mControllerFwk.dispatchMediaButtonEvent(event);
        }

        @Override
        public TransportControls getTransportControls() {
            return new TransportControlsApi21(this.mControllerFwk.getTransportControls());
        }

        @Override
        public PlaybackStateCompat getPlaybackState() {
            PlaybackState stateFwk;
            if (this.mSessionToken.getExtraBinder() != null) {
                try {
                    return this.mSessionToken.getExtraBinder().getPlaybackState();
                }
                catch (RemoteException e) {
                    Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in getPlaybackState.", (Throwable)e);
                }
            }
            return (stateFwk = this.mControllerFwk.getPlaybackState()) != null ? PlaybackStateCompat.fromPlaybackState(stateFwk) : null;
        }

        @Override
        public MediaMetadataCompat getMetadata() {
            MediaMetadata metadataFwk = this.mControllerFwk.getMetadata();
            return metadataFwk != null ? MediaMetadataCompat.fromMediaMetadata(metadataFwk) : null;
        }

        @Override
        public List<MediaSessionCompat.QueueItem> getQueue() {
            List queueFwks = this.mControllerFwk.getQueue();
            return queueFwks != null ? MediaSessionCompat.QueueItem.fromQueueItemList(queueFwks) : null;
        }

        @Override
        public void addQueueItem(MediaDescriptionCompat description) {
            long flags = this.getFlags();
            if ((flags & 4L) == 0L) {
                throw new UnsupportedOperationException("This session doesn't support queue management operations");
            }
            Bundle params = new Bundle();
            params.putParcelable(MediaControllerCompat.COMMAND_ARGUMENT_MEDIA_DESCRIPTION, (Parcelable)description);
            this.sendCommand(MediaControllerCompat.COMMAND_ADD_QUEUE_ITEM, params, null);
        }

        @Override
        public void addQueueItem(MediaDescriptionCompat description, int index) {
            long flags = this.getFlags();
            if ((flags & 4L) == 0L) {
                throw new UnsupportedOperationException("This session doesn't support queue management operations");
            }
            Bundle params = new Bundle();
            params.putParcelable(MediaControllerCompat.COMMAND_ARGUMENT_MEDIA_DESCRIPTION, (Parcelable)description);
            params.putInt(MediaControllerCompat.COMMAND_ARGUMENT_INDEX, index);
            this.sendCommand(MediaControllerCompat.COMMAND_ADD_QUEUE_ITEM_AT, params, null);
        }

        @Override
        public void removeQueueItem(MediaDescriptionCompat description) {
            long flags = this.getFlags();
            if ((flags & 4L) == 0L) {
                throw new UnsupportedOperationException("This session doesn't support queue management operations");
            }
            Bundle params = new Bundle();
            params.putParcelable(MediaControllerCompat.COMMAND_ARGUMENT_MEDIA_DESCRIPTION, (Parcelable)description);
            this.sendCommand(MediaControllerCompat.COMMAND_REMOVE_QUEUE_ITEM, params, null);
        }

        @Override
        public CharSequence getQueueTitle() {
            return this.mControllerFwk.getQueueTitle();
        }

        @Override
        public Bundle getExtras() {
            return this.mControllerFwk.getExtras();
        }

        @Override
        public int getRatingType() {
            if (Build.VERSION.SDK_INT < 22 && this.mSessionToken.getExtraBinder() != null) {
                try {
                    return this.mSessionToken.getExtraBinder().getRatingType();
                }
                catch (RemoteException e) {
                    Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in getRatingType.", (Throwable)e);
                }
            }
            return this.mControllerFwk.getRatingType();
        }

        @Override
        public boolean isCaptioningEnabled() {
            if (this.mSessionToken.getExtraBinder() != null) {
                try {
                    return this.mSessionToken.getExtraBinder().isCaptioningEnabled();
                }
                catch (RemoteException e) {
                    Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in isCaptioningEnabled.", (Throwable)e);
                }
            }
            return false;
        }

        @Override
        public int getRepeatMode() {
            if (this.mSessionToken.getExtraBinder() != null) {
                try {
                    return this.mSessionToken.getExtraBinder().getRepeatMode();
                }
                catch (RemoteException e) {
                    Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in getRepeatMode.", (Throwable)e);
                }
            }
            return -1;
        }

        @Override
        public int getShuffleMode() {
            if (this.mSessionToken.getExtraBinder() != null) {
                try {
                    return this.mSessionToken.getExtraBinder().getShuffleMode();
                }
                catch (RemoteException e) {
                    Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in getShuffleMode.", (Throwable)e);
                }
            }
            return -1;
        }

        @Override
        public long getFlags() {
            return this.mControllerFwk.getFlags();
        }

        @Override
        public PlaybackInfo getPlaybackInfo() {
            MediaController.PlaybackInfo volumeInfoFwk = this.mControllerFwk.getPlaybackInfo();
            return volumeInfoFwk != null ? new PlaybackInfo(volumeInfoFwk.getPlaybackType(), AudioAttributesCompat.wrap(volumeInfoFwk.getAudioAttributes()), volumeInfoFwk.getVolumeControl(), volumeInfoFwk.getMaxVolume(), volumeInfoFwk.getCurrentVolume()) : null;
        }

        @Override
        public PendingIntent getSessionActivity() {
            return this.mControllerFwk.getSessionActivity();
        }

        @Override
        public void setVolumeTo(int value, int flags) {
            this.mControllerFwk.setVolumeTo(value, flags);
        }

        @Override
        public void adjustVolume(int direction, int flags) {
            this.mControllerFwk.adjustVolume(direction, flags);
        }

        @Override
        public void sendCommand(String command, Bundle params, ResultReceiver cb) {
            this.mControllerFwk.sendCommand(command, params, cb);
        }

        @Override
        public boolean isSessionReady() {
            return this.mSessionToken.getExtraBinder() != null;
        }

        @Override
        public String getPackageName() {
            return this.mControllerFwk.getPackageName();
        }

        @Override
        public Bundle getSessionInfo() {
            if (this.mSessionInfo != null) {
                return new Bundle(this.mSessionInfo);
            }
            if (Build.VERSION.SDK_INT >= 29) {
                this.mSessionInfo = this.mControllerFwk.getSessionInfo();
            } else if (this.mSessionToken.getExtraBinder() != null) {
                try {
                    this.mSessionInfo = this.mSessionToken.getExtraBinder().getSessionInfo();
                }
                catch (RemoteException e) {
                    Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in getSessionInfo.", (Throwable)e);
                    this.mSessionInfo = Bundle.EMPTY;
                }
            }
            this.mSessionInfo = MediaSessionCompat.unparcelWithClassLoader(this.mSessionInfo);
            return this.mSessionInfo == null ? Bundle.EMPTY : new Bundle(this.mSessionInfo);
        }

        @Override
        public Object getMediaController() {
            return this.mControllerFwk;
        }

        private void requestExtraBinder() {
            this.sendCommand(MediaControllerCompat.COMMAND_GET_EXTRA_BINDER, null, new ExtraBinderRequestResultReceiver(this));
        }

        @GuardedBy(value="mLock")
        void processPendingCallbacksLocked() {
            if (this.mSessionToken.getExtraBinder() == null) {
                return;
            }
            for (Callback callback : this.mPendingCallbacks) {
                ExtraCallback extraCallback = new ExtraCallback(callback);
                this.mCallbackMap.put(callback, extraCallback);
                callback.mIControllerCallback = extraCallback;
                try {
                    this.mSessionToken.getExtraBinder().registerCallbackListener(extraCallback);
                }
                catch (RemoteException e) {
                    Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in registerCallback.", (Throwable)e);
                    break;
                }
                callback.postToHandler(13, null, null);
            }
            this.mPendingCallbacks.clear();
        }

        private static class ExtraCallback
        extends Callback.StubCompat {
            ExtraCallback(Callback callback) {
                super(callback);
            }

            @Override
            public void onSessionDestroyed() throws RemoteException {
                throw new AssertionError();
            }

            @Override
            public void onMetadataChanged(MediaMetadataCompat metadata) throws RemoteException {
                throw new AssertionError();
            }

            @Override
            public void onQueueChanged(List<MediaSessionCompat.QueueItem> queue) throws RemoteException {
                throw new AssertionError();
            }

            @Override
            public void onQueueTitleChanged(CharSequence title) throws RemoteException {
                throw new AssertionError();
            }

            @Override
            public void onExtrasChanged(Bundle extras) throws RemoteException {
                throw new AssertionError();
            }

            @Override
            public void onVolumeInfoChanged(ParcelableVolumeInfo info) throws RemoteException {
                throw new AssertionError();
            }
        }

        private static class ExtraBinderRequestResultReceiver
        extends ResultReceiver {
            private WeakReference<MediaControllerImplApi21> mMediaControllerImpl;

            ExtraBinderRequestResultReceiver(MediaControllerImplApi21 mediaControllerImpl) {
                super(null);
                this.mMediaControllerImpl = new WeakReference<MediaControllerImplApi21>(mediaControllerImpl);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onReceiveResult(int resultCode, Bundle resultData) {
                MediaControllerImplApi21 mediaControllerImpl = (MediaControllerImplApi21)this.mMediaControllerImpl.get();
                if (mediaControllerImpl == null || resultData == null) {
                    return;
                }
                Object object = mediaControllerImpl.mLock;
                synchronized (object) {
                    mediaControllerImpl.mSessionToken.setExtraBinder(IMediaSession.Stub.asInterface(BundleCompat.getBinder((Bundle)resultData, (String)"android.support.v4.media.session.EXTRA_BINDER")));
                    mediaControllerImpl.mSessionToken.setSession2Token(ParcelUtils.getVersionedParcelable((Bundle)resultData, (String)"android.support.v4.media.session.SESSION_TOKEN2"));
                    mediaControllerImpl.processPendingCallbacksLocked();
                }
            }
        }
    }

    static class TransportControlsBase
    extends TransportControls {
        private IMediaSession mBinder;

        public TransportControlsBase(IMediaSession binder) {
            this.mBinder = binder;
        }

        @Override
        public void prepare() {
            try {
                this.mBinder.prepare();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in prepare.", (Throwable)e);
            }
        }

        @Override
        public void prepareFromMediaId(String mediaId, Bundle extras) {
            try {
                this.mBinder.prepareFromMediaId(mediaId, extras);
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in prepareFromMediaId.", (Throwable)e);
            }
        }

        @Override
        public void prepareFromSearch(String query, Bundle extras) {
            try {
                this.mBinder.prepareFromSearch(query, extras);
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in prepareFromSearch.", (Throwable)e);
            }
        }

        @Override
        public void prepareFromUri(Uri uri, Bundle extras) {
            try {
                this.mBinder.prepareFromUri(uri, extras);
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in prepareFromUri.", (Throwable)e);
            }
        }

        @Override
        public void play() {
            try {
                this.mBinder.play();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in play.", (Throwable)e);
            }
        }

        @Override
        public void playFromMediaId(String mediaId, Bundle extras) {
            try {
                this.mBinder.playFromMediaId(mediaId, extras);
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in playFromMediaId.", (Throwable)e);
            }
        }

        @Override
        public void playFromSearch(String query, Bundle extras) {
            try {
                this.mBinder.playFromSearch(query, extras);
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in playFromSearch.", (Throwable)e);
            }
        }

        @Override
        public void playFromUri(Uri uri, Bundle extras) {
            try {
                this.mBinder.playFromUri(uri, extras);
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in playFromUri.", (Throwable)e);
            }
        }

        @Override
        public void skipToQueueItem(long id2) {
            try {
                this.mBinder.skipToQueueItem(id2);
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in skipToQueueItem.", (Throwable)e);
            }
        }

        @Override
        public void pause() {
            try {
                this.mBinder.pause();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in pause.", (Throwable)e);
            }
        }

        @Override
        public void stop() {
            try {
                this.mBinder.stop();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in stop.", (Throwable)e);
            }
        }

        @Override
        public void seekTo(long pos) {
            try {
                this.mBinder.seekTo(pos);
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in seekTo.", (Throwable)e);
            }
        }

        @Override
        public void fastForward() {
            try {
                this.mBinder.fastForward();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in fastForward.", (Throwable)e);
            }
        }

        @Override
        public void skipToNext() {
            try {
                this.mBinder.next();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in skipToNext.", (Throwable)e);
            }
        }

        @Override
        public void rewind() {
            try {
                this.mBinder.rewind();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in rewind.", (Throwable)e);
            }
        }

        @Override
        public void skipToPrevious() {
            try {
                this.mBinder.previous();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in skipToPrevious.", (Throwable)e);
            }
        }

        @Override
        public void setRating(RatingCompat rating) {
            try {
                this.mBinder.rate(rating);
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in setRating.", (Throwable)e);
            }
        }

        @Override
        public void setRating(RatingCompat rating, Bundle extras) {
            try {
                this.mBinder.rateWithExtras(rating, extras);
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in setRating.", (Throwable)e);
            }
        }

        @Override
        public void setPlaybackSpeed(float speed) {
            if (speed == 0.0f) {
                throw new IllegalArgumentException("speed must not be zero");
            }
            try {
                this.mBinder.setPlaybackSpeed(speed);
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in setPlaybackSpeed.", (Throwable)e);
            }
        }

        @Override
        public void setCaptioningEnabled(boolean enabled) {
            try {
                this.mBinder.setCaptioningEnabled(enabled);
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in setCaptioningEnabled.", (Throwable)e);
            }
        }

        @Override
        public void setRepeatMode(int repeatMode) {
            try {
                this.mBinder.setRepeatMode(repeatMode);
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in setRepeatMode.", (Throwable)e);
            }
        }

        @Override
        public void setShuffleMode(int shuffleMode) {
            try {
                this.mBinder.setShuffleMode(shuffleMode);
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in setShuffleMode.", (Throwable)e);
            }
        }

        @Override
        public void sendCustomAction(PlaybackStateCompat.CustomAction customAction, Bundle args) {
            this.sendCustomAction(customAction.getAction(), args);
        }

        @Override
        public void sendCustomAction(String action, Bundle args) {
            MediaControllerCompat.validateCustomAction(action, args);
            try {
                this.mBinder.sendCustomAction(action, args);
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in sendCustomAction.", (Throwable)e);
            }
        }
    }

    static class MediaControllerImplBase
    implements MediaControllerImpl {
        private IMediaSession mBinder;
        private TransportControls mTransportControls;
        private Bundle mSessionInfo;

        MediaControllerImplBase(MediaSessionCompat.Token token) {
            this.mBinder = IMediaSession.Stub.asInterface((IBinder)token.getToken());
        }

        @Override
        public void registerCallback(Callback callback, Handler handler) {
            if (callback == null) {
                throw new IllegalArgumentException("callback may not be null.");
            }
            try {
                this.mBinder.asBinder().linkToDeath((IBinder.DeathRecipient)callback, 0);
                this.mBinder.registerCallbackListener(callback.mIControllerCallback);
                callback.postToHandler(13, null, null);
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in registerCallback.", (Throwable)e);
                callback.postToHandler(8, null, null);
            }
        }

        @Override
        public void unregisterCallback(Callback callback) {
            if (callback == null) {
                throw new IllegalArgumentException("callback may not be null.");
            }
            try {
                this.mBinder.unregisterCallbackListener(callback.mIControllerCallback);
                this.mBinder.asBinder().unlinkToDeath((IBinder.DeathRecipient)callback, 0);
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in unregisterCallback.", (Throwable)e);
            }
        }

        @Override
        public boolean dispatchMediaButtonEvent(KeyEvent event) {
            if (event == null) {
                throw new IllegalArgumentException("event may not be null.");
            }
            try {
                this.mBinder.sendMediaButton(event);
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in dispatchMediaButtonEvent.", (Throwable)e);
            }
            return false;
        }

        @Override
        public TransportControls getTransportControls() {
            if (this.mTransportControls == null) {
                this.mTransportControls = new TransportControlsBase(this.mBinder);
            }
            return this.mTransportControls;
        }

        @Override
        public PlaybackStateCompat getPlaybackState() {
            try {
                return this.mBinder.getPlaybackState();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in getPlaybackState.", (Throwable)e);
                return null;
            }
        }

        @Override
        public MediaMetadataCompat getMetadata() {
            try {
                return this.mBinder.getMetadata();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in getMetadata.", (Throwable)e);
                return null;
            }
        }

        @Override
        public List<MediaSessionCompat.QueueItem> getQueue() {
            try {
                return this.mBinder.getQueue();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in getQueue.", (Throwable)e);
                return null;
            }
        }

        @Override
        public void addQueueItem(MediaDescriptionCompat description) {
            try {
                long flags = this.mBinder.getFlags();
                if ((flags & 4L) == 0L) {
                    throw new UnsupportedOperationException("This session doesn't support queue management operations");
                }
                this.mBinder.addQueueItem(description);
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in addQueueItem.", (Throwable)e);
            }
        }

        @Override
        public void addQueueItem(MediaDescriptionCompat description, int index) {
            try {
                long flags = this.mBinder.getFlags();
                if ((flags & 4L) == 0L) {
                    throw new UnsupportedOperationException("This session doesn't support queue management operations");
                }
                this.mBinder.addQueueItemAt(description, index);
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in addQueueItemAt.", (Throwable)e);
            }
        }

        @Override
        public void removeQueueItem(MediaDescriptionCompat description) {
            try {
                long flags = this.mBinder.getFlags();
                if ((flags & 4L) == 0L) {
                    throw new UnsupportedOperationException("This session doesn't support queue management operations");
                }
                this.mBinder.removeQueueItem(description);
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in removeQueueItem.", (Throwable)e);
            }
        }

        @Override
        public CharSequence getQueueTitle() {
            try {
                return this.mBinder.getQueueTitle();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in getQueueTitle.", (Throwable)e);
                return null;
            }
        }

        @Override
        public Bundle getExtras() {
            try {
                return this.mBinder.getExtras();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in getExtras.", (Throwable)e);
                return null;
            }
        }

        @Override
        public int getRatingType() {
            try {
                return this.mBinder.getRatingType();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in getRatingType.", (Throwable)e);
                return 0;
            }
        }

        @Override
        public boolean isCaptioningEnabled() {
            try {
                return this.mBinder.isCaptioningEnabled();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in isCaptioningEnabled.", (Throwable)e);
                return false;
            }
        }

        @Override
        public int getRepeatMode() {
            try {
                return this.mBinder.getRepeatMode();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in getRepeatMode.", (Throwable)e);
                return -1;
            }
        }

        @Override
        public int getShuffleMode() {
            try {
                return this.mBinder.getShuffleMode();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in getShuffleMode.", (Throwable)e);
                return -1;
            }
        }

        @Override
        public long getFlags() {
            try {
                return this.mBinder.getFlags();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in getFlags.", (Throwable)e);
                return 0L;
            }
        }

        @Override
        public PlaybackInfo getPlaybackInfo() {
            try {
                ParcelableVolumeInfo info = this.mBinder.getVolumeAttributes();
                PlaybackInfo pi = new PlaybackInfo(info.volumeType, info.audioStream, info.controlType, info.maxVolume, info.currentVolume);
                return pi;
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in getPlaybackInfo.", (Throwable)e);
                return null;
            }
        }

        @Override
        public PendingIntent getSessionActivity() {
            try {
                return this.mBinder.getLaunchPendingIntent();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in getSessionActivity.", (Throwable)e);
                return null;
            }
        }

        @Override
        public void setVolumeTo(int value, int flags) {
            try {
                this.mBinder.setVolumeTo(value, flags, null);
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in setVolumeTo.", (Throwable)e);
            }
        }

        @Override
        public void adjustVolume(int direction, int flags) {
            try {
                this.mBinder.adjustVolume(direction, flags, null);
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in adjustVolume.", (Throwable)e);
            }
        }

        @Override
        public void sendCommand(String command, Bundle params, ResultReceiver cb) {
            try {
                this.mBinder.sendCommand(command, params, cb == null ? null : new MediaSessionCompat.ResultReceiverWrapper(cb));
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in sendCommand.", (Throwable)e);
            }
        }

        @Override
        public boolean isSessionReady() {
            return true;
        }

        @Override
        public String getPackageName() {
            try {
                return this.mBinder.getPackageName();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in getPackageName.", (Throwable)e);
                return null;
            }
        }

        @Override
        public Bundle getSessionInfo() {
            try {
                this.mSessionInfo = this.mBinder.getSessionInfo();
            }
            catch (RemoteException e) {
                Log.d((String)MediaControllerCompat.TAG, (String)"Dead object in getSessionInfo.", (Throwable)e);
            }
            this.mSessionInfo = MediaSessionCompat.unparcelWithClassLoader(this.mSessionInfo);
            return this.mSessionInfo == null ? Bundle.EMPTY : new Bundle(this.mSessionInfo);
        }

        @Override
        public Object getMediaController() {
            return null;
        }
    }

    static interface MediaControllerImpl {
        public void registerCallback(Callback var1, Handler var2);

        public void unregisterCallback(Callback var1);

        public boolean dispatchMediaButtonEvent(KeyEvent var1);

        public TransportControls getTransportControls();

        public PlaybackStateCompat getPlaybackState();

        public MediaMetadataCompat getMetadata();

        public List<MediaSessionCompat.QueueItem> getQueue();

        public void addQueueItem(MediaDescriptionCompat var1);

        public void addQueueItem(MediaDescriptionCompat var1, int var2);

        public void removeQueueItem(MediaDescriptionCompat var1);

        public CharSequence getQueueTitle();

        public Bundle getExtras();

        public int getRatingType();

        public boolean isCaptioningEnabled();

        public int getRepeatMode();

        public int getShuffleMode();

        public long getFlags();

        public PlaybackInfo getPlaybackInfo();

        public PendingIntent getSessionActivity();

        public void setVolumeTo(int var1, int var2);

        public void adjustVolume(int var1, int var2);

        public void sendCommand(String var1, Bundle var2, ResultReceiver var3);

        public boolean isSessionReady();

        public String getPackageName();

        public Bundle getSessionInfo();

        public Object getMediaController();
    }

    public static final class PlaybackInfo {
        public static final int PLAYBACK_TYPE_LOCAL = 1;
        public static final int PLAYBACK_TYPE_REMOTE = 2;
        private final int mPlaybackType;
        private final AudioAttributesCompat mAudioAttrsCompat;
        private final int mVolumeControl;
        private final int mMaxVolume;
        private final int mCurrentVolume;

        PlaybackInfo(int type, int stream, int control, int max, int current) {
            this(type, new AudioAttributesCompat.Builder().setLegacyStreamType(stream).build(), control, max, current);
        }

        PlaybackInfo(int type, @NonNull AudioAttributesCompat attrsCompat, int control, int max, int current) {
            this.mPlaybackType = type;
            this.mAudioAttrsCompat = attrsCompat;
            this.mVolumeControl = control;
            this.mMaxVolume = max;
            this.mCurrentVolume = current;
        }

        public int getPlaybackType() {
            return this.mPlaybackType;
        }

        @Deprecated
        public int getAudioStream() {
            return this.mAudioAttrsCompat.getLegacyStreamType();
        }

        @NonNull
        public AudioAttributesCompat getAudioAttributes() {
            return this.mAudioAttrsCompat;
        }

        public int getVolumeControl() {
            return this.mVolumeControl;
        }

        public int getMaxVolume() {
            return this.mMaxVolume;
        }

        public int getCurrentVolume() {
            return this.mCurrentVolume;
        }
    }

    public static abstract class TransportControls {
        public static final String EXTRA_LEGACY_STREAM_TYPE = "android.media.session.extra.LEGACY_STREAM_TYPE";

        TransportControls() {
        }

        public abstract void prepare();

        public abstract void prepareFromMediaId(String var1, Bundle var2);

        public abstract void prepareFromSearch(String var1, Bundle var2);

        public abstract void prepareFromUri(Uri var1, Bundle var2);

        public abstract void play();

        public abstract void playFromMediaId(String var1, Bundle var2);

        public abstract void playFromSearch(String var1, Bundle var2);

        public abstract void playFromUri(Uri var1, Bundle var2);

        public abstract void skipToQueueItem(long var1);

        public abstract void pause();

        public abstract void stop();

        public abstract void seekTo(long var1);

        public abstract void fastForward();

        public abstract void skipToNext();

        public abstract void rewind();

        public abstract void skipToPrevious();

        public abstract void setRating(RatingCompat var1);

        public abstract void setRating(RatingCompat var1, Bundle var2);

        public void setPlaybackSpeed(float speed) {
        }

        public abstract void setCaptioningEnabled(boolean var1);

        public abstract void setRepeatMode(int var1);

        public abstract void setShuffleMode(int var1);

        public abstract void sendCustomAction(PlaybackStateCompat.CustomAction var1, Bundle var2);

        public abstract void sendCustomAction(String var1, Bundle var2);
    }

    public static abstract class Callback
    implements IBinder.DeathRecipient {
        final MediaController.Callback mCallbackFwk;
        MessageHandler mHandler;
        IMediaControllerCallback mIControllerCallback;

        public Callback() {
            if (Build.VERSION.SDK_INT >= 21) {
                this.mCallbackFwk = new MediaControllerCallbackApi21(this);
            } else {
                this.mCallbackFwk = null;
                this.mIControllerCallback = new StubCompat(this);
            }
        }

        public void onSessionReady() {
        }

        public void onSessionDestroyed() {
        }

        public void onSessionEvent(String event, Bundle extras) {
        }

        public void onPlaybackStateChanged(PlaybackStateCompat state) {
        }

        public void onMetadataChanged(MediaMetadataCompat metadata) {
        }

        public void onQueueChanged(List<MediaSessionCompat.QueueItem> queue) {
        }

        public void onQueueTitleChanged(CharSequence title) {
        }

        public void onExtrasChanged(Bundle extras) {
        }

        public void onAudioInfoChanged(PlaybackInfo info) {
        }

        public void onCaptioningEnabledChanged(boolean enabled) {
        }

        public void onRepeatModeChanged(int repeatMode) {
        }

        public void onShuffleModeChanged(int shuffleMode) {
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
        public IMediaControllerCallback getIControllerCallback() {
            return this.mIControllerCallback;
        }

        public void binderDied() {
            this.postToHandler(8, null, null);
        }

        void setHandler(Handler handler) {
            if (handler == null) {
                if (this.mHandler != null) {
                    this.mHandler.mRegistered = false;
                    this.mHandler.removeCallbacksAndMessages(null);
                    this.mHandler = null;
                }
            } else {
                this.mHandler = new MessageHandler(handler.getLooper());
                this.mHandler.mRegistered = true;
            }
        }

        void postToHandler(int what, Object obj, Bundle data) {
            if (this.mHandler != null) {
                Message msg = this.mHandler.obtainMessage(what, obj);
                msg.setData(data);
                msg.sendToTarget();
            }
        }

        private class MessageHandler
        extends Handler {
            private static final int MSG_EVENT = 1;
            private static final int MSG_UPDATE_PLAYBACK_STATE = 2;
            private static final int MSG_UPDATE_METADATA = 3;
            private static final int MSG_UPDATE_VOLUME = 4;
            private static final int MSG_UPDATE_QUEUE = 5;
            private static final int MSG_UPDATE_QUEUE_TITLE = 6;
            private static final int MSG_UPDATE_EXTRAS = 7;
            private static final int MSG_DESTROYED = 8;
            private static final int MSG_UPDATE_REPEAT_MODE = 9;
            private static final int MSG_UPDATE_CAPTIONING_ENABLED = 11;
            private static final int MSG_UPDATE_SHUFFLE_MODE = 12;
            private static final int MSG_SESSION_READY = 13;
            boolean mRegistered;

            MessageHandler(Looper looper) {
                super(looper);
                this.mRegistered = false;
            }

            public void handleMessage(Message msg) {
                if (!this.mRegistered) {
                    return;
                }
                switch (msg.what) {
                    case 1: {
                        Bundle extras = msg.getData();
                        MediaSessionCompat.ensureClassLoader(extras);
                        Callback.this.onSessionEvent((String)msg.obj, extras);
                        break;
                    }
                    case 2: {
                        Callback.this.onPlaybackStateChanged((PlaybackStateCompat)msg.obj);
                        break;
                    }
                    case 3: {
                        Callback.this.onMetadataChanged((MediaMetadataCompat)msg.obj);
                        break;
                    }
                    case 5: {
                        Callback.this.onQueueChanged((List)msg.obj);
                        break;
                    }
                    case 6: {
                        Callback.this.onQueueTitleChanged((CharSequence)msg.obj);
                        break;
                    }
                    case 11: {
                        Callback.this.onCaptioningEnabledChanged((Boolean)msg.obj);
                        break;
                    }
                    case 9: {
                        Callback.this.onRepeatModeChanged((Integer)msg.obj);
                        break;
                    }
                    case 12: {
                        Callback.this.onShuffleModeChanged((Integer)msg.obj);
                        break;
                    }
                    case 7: {
                        Bundle extras = (Bundle)msg.obj;
                        MediaSessionCompat.ensureClassLoader(extras);
                        Callback.this.onExtrasChanged(extras);
                        break;
                    }
                    case 4: {
                        Callback.this.onAudioInfoChanged((PlaybackInfo)msg.obj);
                        break;
                    }
                    case 8: {
                        Callback.this.onSessionDestroyed();
                        break;
                    }
                    case 13: {
                        Callback.this.onSessionReady();
                    }
                }
            }
        }

        private static class StubCompat
        extends IMediaControllerCallback.Stub {
            private final WeakReference<Callback> mCallback;

            StubCompat(Callback callback) {
                this.mCallback = new WeakReference<Callback>(callback);
            }

            @Override
            public void onEvent(String event, Bundle extras) throws RemoteException {
                Callback callback = (Callback)this.mCallback.get();
                if (callback != null) {
                    callback.postToHandler(1, event, extras);
                }
            }

            @Override
            public void onSessionDestroyed() throws RemoteException {
                Callback callback = (Callback)this.mCallback.get();
                if (callback != null) {
                    callback.postToHandler(8, null, null);
                }
            }

            @Override
            public void onPlaybackStateChanged(PlaybackStateCompat state) throws RemoteException {
                Callback callback = (Callback)this.mCallback.get();
                if (callback != null) {
                    callback.postToHandler(2, state, null);
                }
            }

            @Override
            public void onMetadataChanged(MediaMetadataCompat metadata) throws RemoteException {
                Callback callback = (Callback)this.mCallback.get();
                if (callback != null) {
                    callback.postToHandler(3, metadata, null);
                }
            }

            @Override
            public void onQueueChanged(List<MediaSessionCompat.QueueItem> queue) throws RemoteException {
                Callback callback = (Callback)this.mCallback.get();
                if (callback != null) {
                    callback.postToHandler(5, queue, null);
                }
            }

            @Override
            public void onQueueTitleChanged(CharSequence title) throws RemoteException {
                Callback callback = (Callback)this.mCallback.get();
                if (callback != null) {
                    callback.postToHandler(6, title, null);
                }
            }

            @Override
            public void onCaptioningEnabledChanged(boolean enabled) throws RemoteException {
                Callback callback = (Callback)this.mCallback.get();
                if (callback != null) {
                    callback.postToHandler(11, enabled, null);
                }
            }

            @Override
            public void onRepeatModeChanged(int repeatMode) throws RemoteException {
                Callback callback = (Callback)this.mCallback.get();
                if (callback != null) {
                    callback.postToHandler(9, repeatMode, null);
                }
            }

            @Override
            public void onShuffleModeChangedRemoved(boolean enabled) throws RemoteException {
            }

            @Override
            public void onShuffleModeChanged(int shuffleMode) throws RemoteException {
                Callback callback = (Callback)this.mCallback.get();
                if (callback != null) {
                    callback.postToHandler(12, shuffleMode, null);
                }
            }

            @Override
            public void onExtrasChanged(Bundle extras) throws RemoteException {
                Callback callback = (Callback)this.mCallback.get();
                if (callback != null) {
                    callback.postToHandler(7, extras, null);
                }
            }

            @Override
            public void onVolumeInfoChanged(ParcelableVolumeInfo info) throws RemoteException {
                Callback callback = (Callback)this.mCallback.get();
                if (callback != null) {
                    PlaybackInfo pi = null;
                    if (info != null) {
                        pi = new PlaybackInfo(info.volumeType, info.audioStream, info.controlType, info.maxVolume, info.currentVolume);
                    }
                    callback.postToHandler(4, pi, null);
                }
            }

            @Override
            public void onSessionReady() throws RemoteException {
                Callback callback = (Callback)this.mCallback.get();
                if (callback != null) {
                    callback.postToHandler(13, null, null);
                }
            }
        }

        @RequiresApi(value=21)
        private static class MediaControllerCallbackApi21
        extends MediaController.Callback {
            private final WeakReference<Callback> mCallback;

            MediaControllerCallbackApi21(Callback callback) {
                this.mCallback = new WeakReference<Callback>(callback);
            }

            public void onSessionDestroyed() {
                Callback callback = (Callback)this.mCallback.get();
                if (callback != null) {
                    callback.onSessionDestroyed();
                }
            }

            public void onSessionEvent(String event, Bundle extras) {
                MediaSessionCompat.ensureClassLoader(extras);
                Callback callback = (Callback)this.mCallback.get();
                if (callback != null && (callback.mIControllerCallback == null || Build.VERSION.SDK_INT >= 23)) {
                    callback.onSessionEvent(event, extras);
                }
            }

            public void onPlaybackStateChanged(PlaybackState stateObj) {
                Callback callback = (Callback)this.mCallback.get();
                if (callback != null && callback.mIControllerCallback == null) {
                    callback.onPlaybackStateChanged(PlaybackStateCompat.fromPlaybackState(stateObj));
                }
            }

            public void onMetadataChanged(MediaMetadata metadataObj) {
                Callback callback = (Callback)this.mCallback.get();
                if (callback != null) {
                    callback.onMetadataChanged(MediaMetadataCompat.fromMediaMetadata(metadataObj));
                }
            }

            public void onQueueChanged(List<MediaSession.QueueItem> queue) {
                Callback callback = (Callback)this.mCallback.get();
                if (callback != null) {
                    callback.onQueueChanged(MediaSessionCompat.QueueItem.fromQueueItemList(queue));
                }
            }

            public void onQueueTitleChanged(CharSequence title) {
                Callback callback = (Callback)this.mCallback.get();
                if (callback != null) {
                    callback.onQueueTitleChanged(title);
                }
            }

            public void onExtrasChanged(Bundle extras) {
                MediaSessionCompat.ensureClassLoader(extras);
                Callback callback = (Callback)this.mCallback.get();
                if (callback != null) {
                    callback.onExtrasChanged(extras);
                }
            }

            public void onAudioInfoChanged(MediaController.PlaybackInfo info) {
                Callback callback = (Callback)this.mCallback.get();
                if (callback != null) {
                    callback.onAudioInfoChanged(new PlaybackInfo(info.getPlaybackType(), AudioAttributesCompat.wrap(info.getAudioAttributes()), info.getVolumeControl(), info.getMaxVolume(), info.getCurrentVolume()));
                }
            }
        }
    }
}

