/*
 * Decompiled with CFR 0.152.
 */
package androidx.media;

import android.annotation.SuppressLint;
import android.media.AudioAttributes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.media.AudioAttributesCompat;
import androidx.media.AudioAttributesImpl;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
@RequiresApi(value=21)
public class AudioAttributesImplApi21
implements AudioAttributesImpl {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public AudioAttributes mAudioAttributes;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public int mLegacyStreamType = -1;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public AudioAttributesImplApi21() {
    }

    AudioAttributesImplApi21(AudioAttributes audioAttributes) {
        this(audioAttributes, -1);
    }

    AudioAttributesImplApi21(AudioAttributes audioAttributes, int explicitLegacyStream) {
        this.mAudioAttributes = audioAttributes;
        this.mLegacyStreamType = explicitLegacyStream;
    }

    @Override
    @Nullable
    public Object getAudioAttributes() {
        return this.mAudioAttributes;
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public int getVolumeControlStream() {
        return AudioAttributesCompat.toVolumeStreamType(true, this.getFlags(), this.getUsage());
    }

    @Override
    public int getLegacyStreamType() {
        if (this.mLegacyStreamType != -1) {
            return this.mLegacyStreamType;
        }
        return AudioAttributesCompat.toVolumeStreamType(false, this.getFlags(), this.getUsage());
    }

    @Override
    public int getRawLegacyStreamType() {
        return this.mLegacyStreamType;
    }

    @Override
    public int getContentType() {
        return this.mAudioAttributes.getContentType();
    }

    @Override
    public int getUsage() {
        return this.mAudioAttributes.getUsage();
    }

    @Override
    public int getFlags() {
        return this.mAudioAttributes.getFlags();
    }

    public int hashCode() {
        return this.mAudioAttributes.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof AudioAttributesImplApi21)) {
            return false;
        }
        AudioAttributesImplApi21 that = (AudioAttributesImplApi21)o;
        return this.mAudioAttributes.equals((Object)that.mAudioAttributes);
    }

    @NonNull
    public String toString() {
        return "AudioAttributesCompat: audioattributes=" + this.mAudioAttributes;
    }

    static class Builder
    implements AudioAttributesImpl.Builder {
        final AudioAttributes.Builder mFwkBuilder;

        Builder() {
            this.mFwkBuilder = new AudioAttributes.Builder();
        }

        Builder(Object aa) {
            this.mFwkBuilder = new AudioAttributes.Builder((AudioAttributes)aa);
        }

        @Override
        @NonNull
        public AudioAttributesImpl build() {
            return new AudioAttributesImplApi21(this.mFwkBuilder.build());
        }

        @Override
        @NonNull
        public Builder setUsage(int usage) {
            if (usage == 16) {
                usage = 12;
            }
            this.mFwkBuilder.setUsage(usage);
            return this;
        }

        @Override
        @NonNull
        public Builder setContentType(int contentType) {
            this.mFwkBuilder.setContentType(contentType);
            return this;
        }

        @Override
        @NonNull
        public Builder setFlags(int flags) {
            this.mFwkBuilder.setFlags(flags);
            return this;
        }

        @Override
        @NonNull
        public Builder setLegacyStreamType(int streamType) {
            this.mFwkBuilder.setLegacyStreamType(streamType);
            return this;
        }
    }
}

